/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.tasks.scala;

import java.util.concurrent.Callable;
import org.gradle.internal.impldep.com.google.common.cache.Cache;
import org.gradle.internal.impldep.com.google.common.cache.CacheBuilder;
import org.gradle.internal.impldep.com.google.common.cache.RemovalListener;
import org.gradle.internal.impldep.com.google.common.cache.RemovalNotification;

public class GuavaBackedClassLoaderCache<K>
implements AutoCloseable {
    private final Cache<K, ClassLoader> cache;

    public GuavaBackedClassLoaderCache(int maxSize) {
        this.cache = CacheBuilder.newBuilder().maximumSize((long)maxSize).removalListener(new RemovalListener<K, ClassLoader>(){

            public void onRemoval(RemovalNotification<K, ClassLoader> notification) {
                ClassLoader value = (ClassLoader)notification.getValue();
                if (value instanceof AutoCloseable) {
                    try {
                        ((AutoCloseable)((Object)value)).close();
                    }
                    catch (Exception ex) {
                        throw new RuntimeException("Failed to close classloader", ex);
                    }
                }
            }
        }).build();
    }

    public ClassLoader get(K key, Callable<ClassLoader> loader) throws Exception {
        return (ClassLoader)this.cache.get(key, loader);
    }

    public void clear() {
        this.cache.invalidateAll();
    }

    @Override
    public void close() {
        this.cache.invalidateAll();
    }
}

