/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.project;

import org.gradle.api.Project;
import org.gradle.api.internal.project.ProjectInternal;
import org.gradle.api.internal.project.ProjectState;
import org.gradle.internal.impldep.com.google.common.primitives.Ints;

public class ProjectOrderingUtil {
    public static int compare(Project left, Project right) {
        return ProjectOrderingUtil.compare(ProjectOrderingUtil.owner(left), ProjectOrderingUtil.owner(right));
    }

    public static int compare(ProjectState left, ProjectState right) {
        int depthCompare = ProjectOrderingUtil.depthCompare(left, right);
        if (depthCompare == 0) {
            return left.getProjectPath().compareTo(right.getProjectPath());
        }
        return depthCompare;
    }

    public static int depthCompare(Project left, Project right) {
        return ProjectOrderingUtil.depthCompare(ProjectOrderingUtil.owner(left), ProjectOrderingUtil.owner(right));
    }

    public static int depthCompare(ProjectState left, ProjectState right) {
        return Ints.compare((int)left.getDepth(), (int)right.getDepth());
    }

    private static ProjectState owner(Project project) {
        if (!(project instanceof ProjectInternal)) {
            throw new IllegalArgumentException("Unexpected Project implementation");
        }
        return ((ProjectInternal)project).getOwner();
    }
}

