/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.file.archive.impl;

import java.io.IOException;
import java.io.InputStream;
import java.util.Iterator;
import java.util.zip.ZipInputStream;
import org.gradle.api.internal.file.archive.ZipEntry;
import org.gradle.api.internal.file.archive.ZipInput;
import org.gradle.api.internal.file.archive.impl.AbstractZipEntry;
import org.gradle.internal.file.FileException;
import org.gradle.internal.impldep.com.google.common.collect.AbstractIterator;
import org.gradle.internal.io.IoFunction;

public class StreamZipInput
implements ZipInput {
    private final ZipInputStream inputStream;

    public StreamZipInput(InputStream inputStream) {
        this.inputStream = new ZipInputStream(inputStream);
    }

    @Override
    public Iterator<ZipEntry> iterator() {
        return new AbstractIterator<ZipEntry>(){

            protected ZipEntry computeNext() {
                java.util.zip.ZipEntry nextEntry;
                try {
                    nextEntry = StreamZipInput.this.inputStream.getNextEntry();
                }
                catch (IOException e) {
                    throw new FileException(e);
                }
                return nextEntry == null ? (ZipEntry)this.endOfData() : new StreamZipEntry(nextEntry);
            }
        };
    }

    @Override
    public void close() throws IOException {
        this.inputStream.close();
    }

    private class StreamZipEntry
    extends AbstractZipEntry {
        private boolean opened;

        public StreamZipEntry(java.util.zip.ZipEntry entry) {
            super(entry);
        }

        @Override
        public <T> T withInputStream(IoFunction<InputStream, T> action) throws IOException {
            if (this.opened) {
                throw new IllegalStateException("The input stream for " + this.getName() + " has already been opened.  It cannot be reopened again.");
            }
            this.opened = true;
            try {
                T t = action.apply(StreamZipInput.this.inputStream);
                return t;
            }
            finally {
                this.closeEntry();
            }
        }

        private void closeEntry() {
            try {
                StreamZipInput.this.inputStream.closeEntry();
            }
            catch (IOException e) {
                throw new FileException(e);
            }
        }

        @Override
        public boolean canReopen() {
            return false;
        }
    }
}

