/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.changedetection.state;

import java.io.File;
import java.util.Properties;
import org.gradle.cache.CacheBuilder;
import org.gradle.cache.FileLockManager;
import org.gradle.cache.IndexedCache;
import org.gradle.cache.IndexedCacheParameters;
import org.gradle.cache.PersistentCache;
import org.gradle.cache.internal.InMemoryCacheDecoratorFactory;
import org.gradle.cache.internal.filelock.LockOptionsBuilder;
import org.gradle.cache.scopes.GlobalScopedCacheBuilderFactory;
import org.gradle.internal.concurrent.Stoppable;
import org.gradle.internal.file.FileAccessTimeJournal;
import org.gradle.internal.serialize.BaseSerializerFactory;
import org.gradle.util.internal.GUtil;

public class DefaultFileAccessTimeJournal
implements FileAccessTimeJournal,
Stoppable {
    public static final String CACHE_KEY = "journal-1";
    public static final String FILE_ACCESS_CACHE_NAME = "file-access";
    public static final String FILE_ACCESS_PROPERTIES_FILE_NAME = "file-access.properties";
    public static final String INCEPTION_TIMESTAMP_KEY = "inceptionTimestamp";
    private final PersistentCache cache;
    private final IndexedCache<File, Long> store;
    private final long inceptionTimestamp;

    public DefaultFileAccessTimeJournal(GlobalScopedCacheBuilderFactory cacheBuilderFactory, InMemoryCacheDecoratorFactory cacheDecoratorFactory) {
        this.cache = cacheBuilderFactory.createCrossVersionCacheBuilder(CACHE_KEY).withCrossVersionCache(CacheBuilder.LockTarget.CacheDirectory).withDisplayName("journal cache").withLockOptions(LockOptionsBuilder.mode(FileLockManager.LockMode.OnDemand)).open();
        this.store = this.cache.createIndexedCache(IndexedCacheParameters.of(FILE_ACCESS_CACHE_NAME, BaseSerializerFactory.FILE_SERIALIZER, BaseSerializerFactory.LONG_SERIALIZER).withCacheDecorator(cacheDecoratorFactory.decorator(10000, true)));
        this.inceptionTimestamp = this.loadOrPersistInceptionTimestamp();
    }

    private long loadOrPersistInceptionTimestamp() {
        return this.cache.useCache(() -> {
            Properties properties;
            String inceptionTimestamp;
            File propertiesFile = new File(this.cache.getBaseDir(), FILE_ACCESS_PROPERTIES_FILE_NAME);
            if (propertiesFile.exists() && (inceptionTimestamp = (properties = GUtil.loadProperties(propertiesFile)).getProperty(INCEPTION_TIMESTAMP_KEY)) != null) {
                return Long.parseLong(inceptionTimestamp);
            }
            long inceptionTimestamp2 = System.currentTimeMillis();
            Properties properties2 = new Properties();
            properties2.setProperty(INCEPTION_TIMESTAMP_KEY, String.valueOf(inceptionTimestamp2));
            GUtil.saveProperties(properties2, propertiesFile);
            return inceptionTimestamp2;
        });
    }

    @Override
    public void stop() {
        this.cache.close();
    }

    @Override
    public void setLastAccessTime(File file, long millis) {
        this.store.put(file, millis);
    }

    @Override
    public long getLastAccessTime(File file) {
        Long value = this.store.getIfPresent(file);
        if (value == null) {
            return Math.max(this.inceptionTimestamp, file.lastModified());
        }
        return value;
    }

    @Override
    public void deleteLastAccessTime(File file) {
        this.store.remove(file);
    }
}

