/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.catalog;

import javax.annotation.Nullable;
import org.gradle.api.internal.artifacts.ImmutableVersionConstraint;
import org.gradle.api.internal.catalog.AbstractContextAwareModel;

public class DependencyModel
extends AbstractContextAwareModel {
    private final String group;
    private final String name;
    private final ImmutableVersionConstraint version;
    private final String versionRef;
    private final int hashCode;

    public DependencyModel(String group, String name, @Nullable String versionRef, ImmutableVersionConstraint version, @Nullable String context) {
        super(context);
        this.group = group;
        this.name = name;
        this.version = version;
        this.versionRef = versionRef;
        this.hashCode = this.doComputeHashCode();
    }

    public String getGroup() {
        return this.group;
    }

    public String getName() {
        return this.name;
    }

    public ImmutableVersionConstraint getVersion() {
        return this.version;
    }

    @Nullable
    public String getVersionRef() {
        return this.versionRef;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DependencyModel that = (DependencyModel)o;
        if (!this.group.equals(that.group)) {
            return false;
        }
        if (!this.name.equals(that.name)) {
            return false;
        }
        if (this.version != null ? !this.version.equals(that.version) : that.version != null) {
            return false;
        }
        return this.versionRef != null ? this.versionRef.equals(that.versionRef) : that.versionRef == null;
    }

    public int hashCode() {
        return this.hashCode;
    }

    private int doComputeHashCode() {
        int result2 = this.group.hashCode();
        result2 = 31 * result2 + this.name.hashCode();
        result2 = 31 * result2 + (this.version != null ? this.version.hashCode() : 0);
        result2 = 31 * result2 + (this.versionRef != null ? this.versionRef.hashCode() : 0);
        return result2;
    }

    public String toString() {
        return "dependency {group='" + this.group + '\'' + ", name='" + this.name + '\'' + ", version='" + this.version + '\'' + '}';
    }
}

