/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.transform;

import java.io.File;
import java.util.Map;
import org.gradle.api.internal.artifacts.transform.AbstractTransformExecution;
import org.gradle.api.internal.artifacts.transform.MutableTransformWorkspaceIdentity;
import org.gradle.api.internal.artifacts.transform.Transform;
import org.gradle.api.internal.artifacts.transform.TransformDependencies;
import org.gradle.api.internal.artifacts.transform.TransformExecutionListener;
import org.gradle.api.internal.artifacts.transform.TransformStepSubject;
import org.gradle.api.internal.artifacts.transform.TransformWorkspaceServices;
import org.gradle.api.internal.file.FileCollectionFactory;
import org.gradle.api.internal.project.ProjectInternal;
import org.gradle.internal.execution.InputFingerprinter;
import org.gradle.internal.execution.UnitOfWork;
import org.gradle.internal.fingerprint.CurrentFileCollectionFingerprint;
import org.gradle.internal.operations.BuildOperationExecutor;
import org.gradle.internal.operations.BuildOperationProgressEventEmitter;
import org.gradle.internal.snapshot.ValueSnapshot;

class MutableTransformExecution
extends AbstractTransformExecution {
    private final String rootProjectLocation;
    private final String producerBuildTreePath;

    public MutableTransformExecution(Transform transform, File inputArtifact, TransformDependencies dependencies, TransformStepSubject subject, ProjectInternal producerProject, TransformExecutionListener transformExecutionListener, BuildOperationExecutor buildOperationExecutor, BuildOperationProgressEventEmitter progressEventEmitter, FileCollectionFactory fileCollectionFactory, InputFingerprinter inputFingerprinter, TransformWorkspaceServices workspaceServices) {
        super(transform, inputArtifact, dependencies, subject, transformExecutionListener, buildOperationExecutor, progressEventEmitter, fileCollectionFactory, inputFingerprinter, workspaceServices);
        this.rootProjectLocation = producerProject.getRootDir().getAbsolutePath() + File.separator;
        this.producerBuildTreePath = producerProject.getBuildTreePath();
    }

    @Override
    public UnitOfWork.Identity identify(Map<String, ValueSnapshot> identityInputs, Map<String, CurrentFileCollectionFingerprint> identityFileInputs) {
        MutableTransformWorkspaceIdentity transformWorkspaceIdentity = new MutableTransformWorkspaceIdentity(this.normalizeAbsolutePath(this.inputArtifact.getAbsolutePath()), this.producerBuildTreePath, identityInputs.get("inputPropertiesHash"), identityFileInputs.get("inputArtifactDependencies").getHash());
        this.emitIdentifyTransformExecutionProgressDetails(transformWorkspaceIdentity);
        return transformWorkspaceIdentity;
    }

    private String normalizeAbsolutePath(String path) {
        if (path.startsWith(this.rootProjectLocation)) {
            return path.substring(this.rootProjectLocation.length());
        }
        return path;
    }
}

