/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.ivyservice.resolveengine.excludes.simple;

import java.util.Set;
import org.gradle.api.artifacts.ModuleIdentifier;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.excludes.simple.ExcludeJsonHelper;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.excludes.specs.GroupSetExclude;
import org.gradle.internal.component.model.IvyArtifactName;

final class DefaultGroupSetExclude
implements GroupSetExclude {
    private final Set<String> groups;
    private final int hashCode;

    DefaultGroupSetExclude(Set<String> groups) {
        this.groups = groups;
        this.hashCode = groups.hashCode();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DefaultGroupSetExclude that = (DefaultGroupSetExclude)o;
        return this.groups.equals(that.groups);
    }

    public int hashCode() {
        return this.hashCode;
    }

    @Override
    public Set<String> getGroups() {
        return this.groups;
    }

    @Override
    public boolean excludes(ModuleIdentifier module) {
        return this.groups.contains(module.getGroup());
    }

    @Override
    public boolean excludesArtifact(ModuleIdentifier module, IvyArtifactName artifactName) {
        return false;
    }

    @Override
    public boolean mayExcludeArtifacts() {
        return false;
    }

    public String toString() {
        return "{ \"groups\" : [" + ExcludeJsonHelper.toJson(this.groups) + "]}";
    }
}

