/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.ivyservice.projectmodule;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.gradle.api.artifacts.component.BuildIdentifier;
import org.gradle.api.artifacts.component.ProjectComponentIdentifier;
import org.gradle.api.internal.artifacts.ivyservice.projectmodule.LocalComponentInAnotherBuildProvider;
import org.gradle.api.internal.artifacts.ivyservice.projectmodule.LocalComponentProvider;
import org.gradle.api.internal.artifacts.ivyservice.projectmodule.LocalComponentRegistry;
import org.gradle.api.internal.project.HoldsProjectState;
import org.gradle.api.internal.project.ProjectState;
import org.gradle.api.internal.project.ProjectStateRegistry;
import org.gradle.api.internal.tasks.NodeExecutionContext;
import org.gradle.internal.Describables;
import org.gradle.internal.component.local.model.LocalComponentGraphResolveState;
import org.gradle.internal.model.CalculatedValueContainer;
import org.gradle.internal.model.CalculatedValueContainerFactory;
import org.gradle.internal.model.ValueCalculator;

public class DefaultLocalComponentRegistry
implements LocalComponentRegistry,
HoldsProjectState {
    private final BuildIdentifier thisBuild;
    private final ProjectStateRegistry projectStateRegistry;
    private final CalculatedValueContainerFactory calculatedValueContainerFactory;
    private final LocalComponentProvider provider;
    private final LocalComponentInAnotherBuildProvider otherBuildProvider;
    private final Map<ProjectComponentIdentifier, CalculatedValueContainer<LocalComponentGraphResolveState, ?>> projects = new ConcurrentHashMap();

    public DefaultLocalComponentRegistry(BuildIdentifier thisBuild, ProjectStateRegistry projectStateRegistry, CalculatedValueContainerFactory calculatedValueContainerFactory, LocalComponentProvider provider, LocalComponentInAnotherBuildProvider otherBuildProvider) {
        this.thisBuild = thisBuild;
        this.projectStateRegistry = projectStateRegistry;
        this.calculatedValueContainerFactory = calculatedValueContainerFactory;
        this.provider = provider;
        this.otherBuildProvider = otherBuildProvider;
    }

    @Override
    public LocalComponentGraphResolveState getComponent(ProjectComponentIdentifier projectIdentifier) {
        ProjectState projectState = this.projectStateRegistry.stateFor(projectIdentifier);
        if (this.isLocalProject(projectIdentifier)) {
            CalculatedValueContainer valueContainer = this.projects.computeIfAbsent(projectIdentifier, projectComponentIdentifier -> this.calculatedValueContainerFactory.create(Describables.of("metadata of", projectIdentifier), new MetadataSupplier(projectState)));
            valueContainer.finalizeIfNotAlready();
            return (LocalComponentGraphResolveState)valueContainer.get();
        }
        return this.otherBuildProvider.getComponent(projectState);
    }

    private boolean isLocalProject(ProjectComponentIdentifier projectIdentifier) {
        return projectIdentifier.getBuild().equals(this.thisBuild);
    }

    @Override
    public void discardAll() {
        this.projects.clear();
    }

    private class MetadataSupplier
    implements ValueCalculator<LocalComponentGraphResolveState> {
        private final ProjectState projectState;

        public MetadataSupplier(ProjectState projectState) {
            this.projectState = projectState;
        }

        @Override
        public LocalComponentGraphResolveState calculateValue(NodeExecutionContext context) {
            return DefaultLocalComponentRegistry.this.provider.getComponent(this.projectState);
        }
    }
}

