/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.ivyservice.ivyresolve;

import java.util.Collections;
import java.util.Map;
import javax.annotation.Nullable;
import org.gradle.api.Action;
import org.gradle.api.artifacts.ComponentMetadataSupplierDetails;
import org.gradle.api.artifacts.ModuleIdentifier;
import org.gradle.api.artifacts.component.ComponentArtifactIdentifier;
import org.gradle.api.artifacts.component.ModuleComponentIdentifier;
import org.gradle.api.attributes.AttributeContainer;
import org.gradle.api.internal.artifacts.ivyservice.ivyresolve.ModuleComponentRepository;
import org.gradle.api.internal.artifacts.ivyservice.ivyresolve.ModuleComponentRepositoryAccess;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.artifact.ResolvableArtifact;
import org.gradle.api.internal.artifacts.repositories.ArtifactResolutionDetails;
import org.gradle.api.internal.artifacts.repositories.resolver.MetadataFetchingCost;
import org.gradle.api.internal.attributes.AttributeContainerInternal;
import org.gradle.api.internal.attributes.ImmutableAttributes;
import org.gradle.api.internal.component.ArtifactType;
import org.gradle.internal.Actions;
import org.gradle.internal.Factory;
import org.gradle.internal.action.InstantiatingAction;
import org.gradle.internal.component.external.model.ModuleComponentGraphResolveState;
import org.gradle.internal.component.external.model.ModuleDependencyMetadata;
import org.gradle.internal.component.model.ComponentArtifactMetadata;
import org.gradle.internal.component.model.ComponentOverrideMetadata;
import org.gradle.internal.component.model.ComponentResolveMetadata;
import org.gradle.internal.component.model.ModuleSources;
import org.gradle.internal.resolve.result.BuildableArtifactFileResolveResult;
import org.gradle.internal.resolve.result.BuildableArtifactSetResolveResult;
import org.gradle.internal.resolve.result.BuildableModuleComponentMetaDataResolveResult;
import org.gradle.internal.resolve.result.BuildableModuleVersionListingResolveResult;

public class FilteredModuleComponentRepository
implements ModuleComponentRepository<ModuleComponentGraphResolveState> {
    private final ModuleComponentRepository<ModuleComponentGraphResolveState> delegate;
    private final Action<? super ArtifactResolutionDetails> filterAction;
    private final String consumerName;
    private final ImmutableAttributes consumerAttributes;

    public static ModuleComponentRepository<ModuleComponentGraphResolveState> of(ModuleComponentRepository<ModuleComponentGraphResolveState> delegate, Action<? super ArtifactResolutionDetails> action, String consumerName, AttributeContainer attributes) {
        if (action == Actions.doNothing()) {
            return delegate;
        }
        return new FilteredModuleComponentRepository(delegate, action, consumerName, attributes);
    }

    private FilteredModuleComponentRepository(ModuleComponentRepository<ModuleComponentGraphResolveState> delegate, Action<? super ArtifactResolutionDetails> filterAction, String consumerName, AttributeContainer attributes) {
        this.delegate = delegate;
        this.filterAction = filterAction;
        this.consumerName = consumerName;
        this.consumerAttributes = ((AttributeContainerInternal)attributes).asImmutable();
    }

    public Action<? super ArtifactResolutionDetails> getFilterAction() {
        return this.filterAction;
    }

    public String getConsumerName() {
        return this.consumerName;
    }

    @Override
    public String getId() {
        return this.delegate.getId();
    }

    @Override
    public String getName() {
        return this.delegate.getName();
    }

    @Override
    public ModuleComponentRepositoryAccess<ModuleComponentGraphResolveState> getLocalAccess() {
        return new FilteringAccess(this.delegate.getLocalAccess());
    }

    @Override
    public ModuleComponentRepositoryAccess<ModuleComponentGraphResolveState> getRemoteAccess() {
        return new FilteringAccess(this.delegate.getRemoteAccess());
    }

    @Override
    public Map<ComponentArtifactIdentifier, ResolvableArtifact> getArtifactCache() {
        return this.delegate.getArtifactCache();
    }

    @Override
    @Nullable
    public InstantiatingAction<ComponentMetadataSupplierDetails> getComponentMetadataSupplier() {
        return this.delegate.getComponentMetadataSupplier();
    }

    private static class DefaultArtifactResolutionDetails
    implements ArtifactResolutionDetails {
        private final ModuleIdentifier moduleIdentifier;
        private final ModuleComponentIdentifier moduleComponentIdentifier;
        private final String consumerName;
        private final ImmutableAttributes consumerAttributes;
        private boolean notFound;

        private DefaultArtifactResolutionDetails(ModuleIdentifier moduleIdentifier, @Nullable ModuleComponentIdentifier componentId, String consumerName, ImmutableAttributes consumerAttributes) {
            this.consumerName = consumerName;
            this.moduleIdentifier = moduleIdentifier;
            this.moduleComponentIdentifier = componentId;
            this.consumerAttributes = consumerAttributes;
        }

        @Override
        public ModuleIdentifier getModuleId() {
            return this.moduleIdentifier;
        }

        @Override
        @Nullable
        public ModuleComponentIdentifier getComponentId() {
            return this.moduleComponentIdentifier;
        }

        @Override
        public AttributeContainer getConsumerAttributes() {
            return this.consumerAttributes;
        }

        @Override
        public String getConsumerName() {
            return this.consumerName;
        }

        @Override
        public boolean isVersionListing() {
            return this.moduleComponentIdentifier == null;
        }

        @Override
        public void notFound() {
            this.notFound = true;
        }
    }

    private class FilteringAccess
    implements ModuleComponentRepositoryAccess<ModuleComponentGraphResolveState> {
        private final ModuleComponentRepositoryAccess<ModuleComponentGraphResolveState> delegate;

        private FilteringAccess(ModuleComponentRepositoryAccess<ModuleComponentGraphResolveState> delegate) {
            this.delegate = delegate;
        }

        @Override
        public void listModuleVersions(ModuleDependencyMetadata dependency, BuildableModuleVersionListingResolveResult result2) {
            ModuleIdentifier identifier = dependency.getSelector().getModuleIdentifier();
            this.whenModulePresent(identifier, null, () -> this.delegate.listModuleVersions(dependency, result2), () -> result2.listed(Collections.emptyList()));
        }

        @Override
        public void resolveComponentMetaData(ModuleComponentIdentifier moduleComponentIdentifier, ComponentOverrideMetadata requestMetaData, BuildableModuleComponentMetaDataResolveResult<ModuleComponentGraphResolveState> result2) {
            this.whenModulePresent(moduleComponentIdentifier.getModuleIdentifier(), moduleComponentIdentifier, () -> this.delegate.resolveComponentMetaData(moduleComponentIdentifier, requestMetaData, result2), result2::missing);
        }

        @Override
        public void resolveArtifactsWithType(ComponentResolveMetadata component, ArtifactType artifactType, BuildableArtifactSetResolveResult result2) {
            this.delegate.resolveArtifactsWithType(component, artifactType, result2);
        }

        @Override
        public void resolveArtifact(ComponentArtifactMetadata artifact, ModuleSources moduleSources, BuildableArtifactFileResolveResult result2) {
            this.delegate.resolveArtifact(artifact, moduleSources, result2);
        }

        @Override
        public MetadataFetchingCost estimateMetadataFetchingCost(ModuleComponentIdentifier moduleComponentIdentifier) {
            return this.whenModulePresent(moduleComponentIdentifier.getModuleIdentifier(), moduleComponentIdentifier, () -> this.delegate.estimateMetadataFetchingCost(moduleComponentIdentifier), () -> MetadataFetchingCost.FAST);
        }

        private void whenModulePresent(ModuleIdentifier id, @Nullable ModuleComponentIdentifier moduleComponentIdentifier, Runnable present, Runnable absent) {
            DefaultArtifactResolutionDetails details = new DefaultArtifactResolutionDetails(id, moduleComponentIdentifier, FilteredModuleComponentRepository.this.consumerName, FilteredModuleComponentRepository.this.consumerAttributes);
            FilteredModuleComponentRepository.this.filterAction.execute(details);
            if (details.notFound) {
                absent.run();
            } else {
                present.run();
            }
        }

        private <T> T whenModulePresent(ModuleIdentifier id, ModuleComponentIdentifier moduleComponentIdentifier, Factory<T> present, Factory<T> absent) {
            DefaultArtifactResolutionDetails details = new DefaultArtifactResolutionDetails(id, moduleComponentIdentifier, FilteredModuleComponentRepository.this.consumerName, FilteredModuleComponentRepository.this.consumerAttributes);
            FilteredModuleComponentRepository.this.filterAction.execute(details);
            if (details.notFound) {
                return absent.create();
            }
            return present.create();
        }
    }
}

