/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.ivyservice.ivyresolve;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import org.gradle.api.Action;
import org.gradle.api.InvalidUserDataException;
import org.gradle.api.Transformer;
import org.gradle.api.artifacts.ComponentMetadata;
import org.gradle.api.artifacts.ComponentMetadataBuilder;
import org.gradle.api.artifacts.ComponentMetadataSupplierDetails;
import org.gradle.api.artifacts.ModuleVersionIdentifier;
import org.gradle.api.artifacts.component.ModuleComponentIdentifier;
import org.gradle.api.artifacts.ivy.IvyModuleDescriptor;
import org.gradle.api.attributes.Attribute;
import org.gradle.api.attributes.AttributeContainer;
import org.gradle.api.internal.artifacts.DefaultModuleVersionIdentifier;
import org.gradle.api.internal.artifacts.MetadataResolutionContext;
import org.gradle.api.internal.artifacts.configurations.dynamicversion.CachePolicy;
import org.gradle.api.internal.artifacts.ivyservice.DefaultIvyModuleDescriptor;
import org.gradle.api.internal.artifacts.ivyservice.NamespaceId;
import org.gradle.api.internal.artifacts.ivyservice.ivyresolve.MetadataProvider;
import org.gradle.api.internal.artifacts.ivyservice.ivyresolve.ModuleComponentResolveState;
import org.gradle.api.internal.artifacts.ivyservice.ivyresolve.UserProvidedMetadata;
import org.gradle.api.internal.artifacts.ivyservice.ivyresolve.parser.MavenVersionUtils;
import org.gradle.api.internal.artifacts.repositories.resolver.ComponentMetadataAdapter;
import org.gradle.api.internal.attributes.AttributeContainerInternal;
import org.gradle.api.internal.attributes.ImmutableAttributes;
import org.gradle.api.internal.attributes.ImmutableAttributesFactory;
import org.gradle.api.internal.project.ProjectInternal;
import org.gradle.internal.action.InstantiatingAction;
import org.gradle.internal.component.external.model.ModuleComponentGraphResolveState;
import org.gradle.internal.component.external.model.ModuleComponentResolveMetadata;
import org.gradle.internal.component.external.model.ivy.IvyModuleResolveMetadata;
import org.gradle.internal.component.model.ComponentResolveMetadata;
import org.gradle.internal.impldep.com.google.common.collect.Lists;
import org.gradle.internal.logging.text.TreeFormatter;
import org.gradle.internal.reflect.Instantiator;
import org.gradle.internal.resolve.result.BuildableModuleComponentMetaDataResolveResult;

class DefaultMetadataProvider
implements MetadataProvider {
    private static final Transformer<ComponentMetadata, BuildableComponentMetadataSupplierDetails> TO_COMPONENT_METADATA = BuildableComponentMetadataSupplierDetails::getExecutionResult;
    private final ModuleComponentResolveState resolveState;
    private BuildableModuleComponentMetaDataResolveResult<ModuleComponentGraphResolveState> cachedResult;
    private ComponentMetadata cachedComponentMetadata;
    private boolean computedMetadata;

    DefaultMetadataProvider(ModuleComponentResolveState resolveState) {
        this.resolveState = resolveState;
    }

    @Override
    public ComponentMetadata getComponentMetadata() {
        if (this.computedMetadata) {
            return this.cachedComponentMetadata;
        }
        this.cachedComponentMetadata = this.computeMetadata();
        this.computedMetadata = true;
        return this.cachedComponentMetadata;
    }

    @Nullable
    private ComponentMetadata computeMetadata() {
        ComponentMetadata metadata = null;
        InstantiatingAction<ComponentMetadataSupplierDetails> componentMetadataSupplier = this.resolveState.getComponentMetadataSupplier();
        if (componentMetadataSupplier != null) {
            metadata = this.getComponentMetadataFromSupplier(componentMetadataSupplier);
        }
        if (metadata != null) {
            metadata = this.transformThroughComponentMetadataRules(componentMetadataSupplier, metadata);
        } else if (this.resolve()) {
            metadata = new ComponentMetadataAdapter(this.cachedResult.getMetaData().getModuleResolveMetadata());
        }
        return metadata;
    }

    private ComponentMetadata transformThroughComponentMetadataRules(InstantiatingAction<ComponentMetadataSupplierDetails> componentMetadataSupplier, ComponentMetadata metadata) {
        DefaultMetadataResolutionContext resolutionContext = new DefaultMetadataResolutionContext(this.resolveState.getCachePolicy(), componentMetadataSupplier.getInstantiator());
        metadata = this.resolveState.getComponentMetadataProcessorFactory().createComponentMetadataProcessor(resolutionContext).processMetadata(metadata);
        return metadata;
    }

    private ComponentMetadata getComponentMetadataFromSupplier(InstantiatingAction<ComponentMetadataSupplierDetails> componentMetadataSupplier) {
        ModuleVersionIdentifier id = DefaultModuleVersionIdentifier.newId(this.resolveState.getId());
        ComponentMetadata metadata = this.resolveState.getComponentMetadataSupplierExecutor().execute(id, componentMetadataSupplier, TO_COMPONENT_METADATA, id1 -> {
            SimpleComponentMetadataBuilder builder = new SimpleComponentMetadataBuilder((ModuleVersionIdentifier)id1, this.resolveState.getAttributesFactory());
            return new BuildableComponentMetadataSupplierDetails(builder);
        }, this.resolveState.getCachePolicy());
        return metadata;
    }

    @Override
    public IvyModuleDescriptor getIvyModuleDescriptor() {
        ModuleComponentResolveMetadata metaData;
        if (this.resolve() && (metaData = this.cachedResult.getMetaData().getModuleResolveMetadata()) instanceof IvyModuleResolveMetadata) {
            IvyModuleResolveMetadata ivyMetadata = (IvyModuleResolveMetadata)metaData;
            return new DefaultIvyModuleDescriptor((Map<NamespaceId, String>)ivyMetadata.getExtraAttributes(), ivyMetadata.getBranch(), ivyMetadata.getStatus());
        }
        return null;
    }

    private boolean resolve() {
        if (this.cachedResult == null) {
            this.cachedResult = this.resolveState.resolve();
        }
        return this.cachedResult.getState() == BuildableModuleComponentMetaDataResolveResult.State.Resolved;
    }

    @Override
    public boolean isUsable() {
        return this.cachedResult == null || this.cachedResult.getState() == BuildableModuleComponentMetaDataResolveResult.State.Resolved;
    }

    public BuildableModuleComponentMetaDataResolveResult<?> getResult() {
        return this.cachedResult;
    }

    private static class DefaultMetadataResolutionContext
    implements MetadataResolutionContext {
        private final CachePolicy cachePolicy;
        private final Instantiator instantiator;

        private DefaultMetadataResolutionContext(CachePolicy cachePolicy, Instantiator instantiator2) {
            this.cachePolicy = cachePolicy;
            this.instantiator = instantiator2;
        }

        @Override
        public CachePolicy getCachePolicy() {
            return this.cachePolicy;
        }

        @Override
        public Instantiator getInjectingInstantiator() {
            return this.instantiator;
        }
    }

    private class BuildableComponentMetadataSupplierDetails
    implements ComponentMetadataSupplierDetails {
        private final SimpleComponentMetadataBuilder builder;

        public BuildableComponentMetadataSupplierDetails(SimpleComponentMetadataBuilder builder) {
            this.builder = builder;
        }

        @Override
        public ModuleComponentIdentifier getId() {
            return DefaultMetadataProvider.this.resolveState.getId();
        }

        @Override
        public ComponentMetadataBuilder getResult() {
            return this.builder;
        }

        @Nullable
        public ComponentMetadata getExecutionResult() {
            if (this.builder.mutated) {
                return this.builder.build();
            }
            return null;
        }
    }

    private static class SimpleComponentMetadataBuilder
    implements ComponentMetadataBuilder {
        private final ModuleVersionIdentifier id;
        private boolean mutated;
        private List<String> statusScheme = ComponentResolveMetadata.DEFAULT_STATUS_SCHEME;
        private final AttributeContainerInternal attributes;

        private SimpleComponentMetadataBuilder(ModuleVersionIdentifier id, ImmutableAttributesFactory attributesFactory) {
            this.id = id;
            this.attributes = attributesFactory.mutable();
            this.attributes.attribute(ProjectInternal.STATUS_ATTRIBUTE, MavenVersionUtils.inferStatusFromEffectiveVersion(id.getVersion()));
        }

        @Override
        public void setStatus(String status) {
            this.attributes.attribute(ProjectInternal.STATUS_ATTRIBUTE, status);
            this.mutated = true;
        }

        @Override
        public void setStatusScheme(List<String> scheme) {
            this.statusScheme = scheme;
            this.mutated = true;
        }

        @Override
        public void attributes(Action<? super AttributeContainer> attributesConfiguration) {
            this.mutated = true;
            attributesConfiguration.execute(this.attributes);
        }

        @Override
        public AttributeContainer getAttributes() {
            this.mutated = true;
            return this.attributes;
        }

        private ImmutableAttributes validateAttributeTypes(AttributeContainerInternal attributes) {
            ArrayList invalidAttributes = null;
            for (Attribute<?> attribute : attributes.keySet()) {
                if (SimpleComponentMetadataBuilder.isValidType(attribute)) continue;
                if (invalidAttributes == null) {
                    invalidAttributes = Lists.newArrayList();
                }
                invalidAttributes.add(attribute);
            }
            this.maybeThrowValidationError(invalidAttributes);
            return attributes.asImmutable();
        }

        private void maybeThrowValidationError(@Nullable List<Attribute<?>> invalidAttributes) {
            if (invalidAttributes != null) {
                TreeFormatter fm = new TreeFormatter();
                fm.node("Invalid attributes types have been provider by component metadata supplier. Attributes must either be strings or booleans");
                fm.startChildren();
                for (Attribute<?> invalidAttribute : invalidAttributes) {
                    fm.node("Attribute '" + invalidAttribute.getName() + "' has type " + invalidAttribute.getType());
                }
                fm.endChildren();
                throw new InvalidUserDataException(fm.toString());
            }
        }

        private static boolean isValidType(Attribute<?> attribute) {
            Class<?> type = attribute.getType();
            return type == String.class || type == Boolean.class || type == Boolean.TYPE;
        }

        ComponentMetadata build() {
            return new UserProvidedMetadata(this.id, this.statusScheme, this.validateAttributeTypes(this.attributes));
        }
    }
}

