/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.configurations;

import java.util.Set;
import javax.annotation.Nullable;
import org.gradle.api.DomainObjectCollection;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.ProjectDependency;
import org.gradle.api.internal.tasks.TaskDependencyContainerInternal;
import org.gradle.api.internal.tasks.TaskDependencyFactory;
import org.gradle.api.internal.tasks.TaskDependencyResolveContext;

class TasksFromDependentProjects
implements TaskDependencyContainerInternal {
    private final String taskName;
    private final String configurationName;
    private final TaskDependencyContainerInternal taskDependencyDelegate;

    public TasksFromDependentProjects(String taskName, String configurationName, TaskDependencyFactory taskDependencyFactory) {
        this(taskName, configurationName, new TaskDependencyChecker(), taskDependencyFactory);
    }

    public TasksFromDependentProjects(String taskName, String configurationName, TaskDependencyChecker checker, TaskDependencyFactory taskDependencyFactory) {
        this.taskName = taskName;
        this.configurationName = configurationName;
        this.taskDependencyDelegate = taskDependencyFactory.visitingDependencies(context -> {
            Project thisProject = context.getTask().getProject();
            Set<Task> tasksWithName = thisProject.getRootProject().getTasksByName(taskName, true);
            for (Task nextTask : tasksWithName) {
                boolean isDependency;
                if (context.getTask() == nextTask || !(isDependency = checker.isDependent(thisProject, configurationName, nextTask.getProject()))) continue;
                context.add(nextTask);
            }
        });
    }

    @Override
    public void visitDependencies(TaskDependencyResolveContext context) {
        this.taskDependencyDelegate.visitDependencies(context);
    }

    @Override
    public Set<? extends Task> getDependencies(@Nullable Task task) {
        return this.taskDependencyDelegate.getDependencies(task);
    }

    @Override
    public Set<? extends Task> getDependenciesForInternalUse(@Nullable Task task) {
        return this.taskDependencyDelegate.getDependenciesForInternalUse(task);
    }

    public String getTaskName() {
        return this.taskName;
    }

    public String getConfigurationName() {
        return this.configurationName;
    }

    static class TaskDependencyChecker {
        TaskDependencyChecker() {
        }

        boolean isDependent(Project originProject, String configurationName, Project candidateProject) {
            Configuration configuration = (Configuration)candidateProject.getConfigurations().findByName(configurationName);
            return configuration != null && TaskDependencyChecker.doesConfigurationDependOnProject(configuration, originProject);
        }

        private static boolean doesConfigurationDependOnProject(Configuration configuration, Project project) {
            DomainObjectCollection projectDependencies = configuration.getAllDependencies().withType(ProjectDependency.class);
            for (ProjectDependency projectDependency : projectDependencies) {
                if (!projectDependency.getDependencyProject().equals(project)) continue;
                return true;
            }
            return false;
        }
    }
}

