/*
 * Decompiled with CFR 0.152.
 */
package net.rubygrapefruit.platform.internal;

import java.io.FileDescriptor;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import net.rubygrapefruit.platform.NativeException;
import net.rubygrapefruit.platform.internal.FunctionResult;
import net.rubygrapefruit.platform.internal.PeekInputStream;
import net.rubygrapefruit.platform.internal.jni.PosixTerminalFunctions;
import net.rubygrapefruit.platform.terminal.TerminalInput;
import net.rubygrapefruit.platform.terminal.TerminalInputListener;

public class PosixTerminalInput
implements TerminalInput {
    private final PeekInputStream inputStream = new PeekInputStream(new FileInputStream(FileDescriptor.in));
    private final Object lock = new Object();
    private static final int UP_ARROW = 65;
    private static final int DOWN_ARROW = 66;
    private static final int RIGHT_ARROW = 67;
    private static final int LEFT_ARROW = 68;
    private static final int BACK_TAB = 90;
    private static final int END = 70;
    private static final int END1 = 52;
    private static final int HOME = 72;
    private static final int HOME1 = 49;
    private static final int ERASE1 = 51;
    private static final int PAGE_UP = 53;
    private static final int PAGE_DOWN = 54;
    private static final int TILDE = 126;

    public String toString() {
        return "POSIX input on stdin";
    }

    public InputStream getInputStream() {
        return this.inputStream;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void read(TerminalInputListener listener2) {
        Object object = this.lock;
        synchronized (object) {
            int ch;
            if (this.peek(0) == 27 && this.peek(1) == 91) {
                ch = this.peek(2);
                if (ch == 65) {
                    this.inputStream.consumeAll();
                    listener2.controlKey(TerminalInputListener.Key.UpArrow);
                    return;
                }
                if (ch == 66) {
                    this.inputStream.consumeAll();
                    listener2.controlKey(TerminalInputListener.Key.DownArrow);
                    return;
                }
                if (ch == 68) {
                    this.inputStream.consumeAll();
                    listener2.controlKey(TerminalInputListener.Key.LeftArrow);
                    return;
                }
                if (ch == 67) {
                    this.inputStream.consumeAll();
                    listener2.controlKey(TerminalInputListener.Key.RightArrow);
                    return;
                }
                if (ch == 90) {
                    this.inputStream.consumeAll();
                    listener2.controlKey(TerminalInputListener.Key.BackTab);
                    return;
                }
                if (ch == 72) {
                    this.inputStream.consumeAll();
                    listener2.controlKey(TerminalInputListener.Key.Home);
                    return;
                }
                if (ch == 70) {
                    this.inputStream.consumeAll();
                    listener2.controlKey(TerminalInputListener.Key.End);
                    return;
                }
                if (ch == 51 && this.peek(3) == 126) {
                    this.inputStream.consumeAll();
                    listener2.controlKey(TerminalInputListener.Key.EraseForward);
                    return;
                }
                if (ch == 49 && this.peek(3) == 126) {
                    this.inputStream.consumeAll();
                    listener2.controlKey(TerminalInputListener.Key.Home);
                    return;
                }
                if (ch == 52 && this.peek(3) == 126) {
                    this.inputStream.consumeAll();
                    listener2.controlKey(TerminalInputListener.Key.End);
                    return;
                }
                if (ch == 53 && this.peek(3) == 126) {
                    this.inputStream.consumeAll();
                    listener2.controlKey(TerminalInputListener.Key.PageUp);
                    return;
                }
                if (ch == 54 && this.peek(3) == 126) {
                    this.inputStream.consumeAll();
                    listener2.controlKey(TerminalInputListener.Key.PageDown);
                    return;
                }
            }
            if ((ch = this.next()) < 0) {
                listener2.endInput();
            } else if (ch == 10) {
                listener2.controlKey(TerminalInputListener.Key.Enter);
            } else if (ch == 127 || ch == 8) {
                listener2.controlKey(TerminalInputListener.Key.EraseBack);
            } else if (ch == 4) {
                listener2.endInput();
            } else {
                listener2.character((char)ch);
            }
        }
    }

    private int peek(int i) {
        try {
            return this.inputStream.peek(i);
        }
        catch (IOException e) {
            throw new NativeException("Could not read from terminal.", e);
        }
    }

    private int next() {
        int ch;
        try {
            ch = this.inputStream.read();
        }
        catch (IOException e) {
            throw new NativeException("Could not read from terminal.", e);
        }
        return ch;
    }

    public boolean supportsRawMode() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TerminalInput rawMode() throws NativeException {
        Object object = this.lock;
        synchronized (object) {
            FunctionResult result2 = new FunctionResult();
            PosixTerminalFunctions.rawInputMode(result2);
            if (result2.isFailed()) {
                throw new NativeException(String.format("Could not switch terminal input to raw mode: %s", result2.getMessage()));
            }
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TerminalInput reset() {
        Object object = this.lock;
        synchronized (object) {
            FunctionResult result2 = new FunctionResult();
            PosixTerminalFunctions.resetInputMode(result2);
            if (result2.isFailed()) {
                throw new NativeException(String.format("Could not reset terminal input mode: %s", result2.getMessage()));
            }
        }
        return this;
    }
}

