/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.swing.driver;

import java.awt.Component;
import java.awt.Window;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import org.assertj.core.util.Preconditions;
import org.assertj.core.util.Strings;
import org.assertj.swing.annotation.RunsInEDT;
import org.assertj.swing.core.Robot;
import org.assertj.swing.core.WindowAncestorFinder;
import org.assertj.swing.dependency.jsr305.Nonnull;
import org.assertj.swing.dependency.jsr305.Nullable;
import org.assertj.swing.driver.ComponentPreconditions;
import org.assertj.swing.driver.JComponentDriver;
import org.assertj.swing.driver.JMenuItemLocation;
import org.assertj.swing.driver.JMenuPopupMenuQuery;
import org.assertj.swing.driver.WindowMoveToFrontTask;
import org.assertj.swing.edt.GuiActionRunner;
import org.assertj.swing.exception.ActionFailedException;
import org.assertj.swing.format.Formatting;
import org.assertj.swing.internal.annotation.InternalApi;
import org.assertj.swing.timing.Pause;
import org.assertj.swing.util.Platform;

@InternalApi
public class JMenuItemDriver
extends JComponentDriver {
    public JMenuItemDriver(@Nonnull Robot robot) {
        super(robot);
    }

    @Override
    public void click(Component c) {
        if (c instanceof JMenuItem) {
            this.click((JMenuItem)c);
        } else {
            super.click(c);
        }
    }

    @RunsInEDT
    public void click(@Nonnull JMenuItem menuItem) {
        this.show(menuItem);
        this.doClick(menuItem);
        this.ensurePopupIsShowing(menuItem);
    }

    @RunsInEDT
    private void show(@Nonnull JMenuItem menuItem) {
        JMenuItemLocation location = JMenuItemDriver.locationOf(menuItem);
        this.activateParentIfIsMenu(location);
        this.moveParentWindowToFront(location);
        if (menuItem instanceof JMenu && !location.inMenuBar()) {
            this.waitForSubMenuToShow();
        }
    }

    @Nonnull
    @RunsInEDT
    private static JMenuItemLocation locationOf(@Nonnull JMenuItem menuItem) {
        JMenuItemLocation result = GuiActionRunner.execute(() -> new JMenuItemLocation(menuItem));
        return Preconditions.checkNotNull(result);
    }

    @RunsInEDT
    private void activateParentIfIsMenu(@Nonnull JMenuItemLocation location) {
        if (!location.isParentAMenu()) {
            return;
        }
        Component c = location.parentOrInvoker();
        if (c instanceof JMenuItem) {
            this.click((JMenuItem)c);
        }
    }

    @RunsInEDT
    private void moveParentWindowToFront(@Nonnull JMenuItemLocation location) {
        if (!location.inMenuBar()) {
            return;
        }
        this.moveToFront(WindowAncestorFinder.windowAncestorOf(location.parentOrInvoker()));
    }

    @RunsInEDT
    private void doClick(@Nonnull JMenuItem menuItem) {
        if (this.isMacOSMenuBar(menuItem)) {
            JMenuItemDriver.validateAndDoClick(menuItem);
            return;
        }
        super.click(menuItem);
        this.robot.waitForIdle();
    }

    private boolean isMacOSMenuBar(@Nonnull JMenuItem menuItem) {
        return menuItem instanceof JMenu && JMenuItemDriver.locationOf(menuItem).inMenuBar() && Platform.isOSX() && (Boolean.getBoolean("apple.laf.useScreenMenuBar") || Boolean.getBoolean("com.apple.macos.useScreenMenuBar"));
    }

    @RunsInEDT
    private static void validateAndDoClick(@Nonnull JMenuItem menuItem) {
        GuiActionRunner.execute(() -> {
            ComponentPreconditions.checkEnabledAndShowing(menuItem);
            menuItem.doClick();
        });
    }

    @RunsInEDT
    private void ensurePopupIsShowing(@Nonnull JMenuItem menuItem) {
        if (!(menuItem instanceof JMenu)) {
            return;
        }
        JPopupMenu popup = JMenuPopupMenuQuery.popupMenuOf((JMenu)menuItem);
        if (!this.waitForShowing(popup, this.robot.settings().timeoutToFindPopup())) {
            throw ActionFailedException.actionFailure(Strings.concat("Clicking on menu item <", Formatting.format(menuItem), "> never showed a pop-up menu"));
        }
        this.waitForSubMenuToShow();
    }

    private void waitForSubMenuToShow() {
        Pause.pause(this.robot.settings().timeoutToFindSubMenu());
    }

    @RunsInEDT
    private void moveToFront(@Nullable Window w) {
        if (w == null) {
            return;
        }
        WindowMoveToFrontTask.toFront(w);
        this.robot.waitForIdle();
        this.robot.moveMouse(w);
    }
}

