/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.core.internal;

import java.io.IOException;
import java.io.LineNumberReader;
import java.io.StringReader;
import java.text.Normalizer;
import java.util.Base64;
import java.util.Comparator;
import java.util.LinkedHashSet;
import java.util.Locale;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.assertj.core.api.AssertionInfo;
import org.assertj.core.error.ShouldBeBase64;
import org.assertj.core.error.ShouldBeBlank;
import org.assertj.core.error.ShouldBeEmpty;
import org.assertj.core.error.ShouldBeEqual;
import org.assertj.core.error.ShouldBeEqualIgnoringCase;
import org.assertj.core.error.ShouldBeEqualIgnoringNewLineDifferences;
import org.assertj.core.error.ShouldBeEqualIgnoringNewLines;
import org.assertj.core.error.ShouldBeEqualIgnoringWhitespace;
import org.assertj.core.error.ShouldBeEqualNormalizingPunctuationAndWhitespace;
import org.assertj.core.error.ShouldBeEqualNormalizingUnicode;
import org.assertj.core.error.ShouldBeEqualNormalizingWhitespace;
import org.assertj.core.error.ShouldBeLowerCase;
import org.assertj.core.error.ShouldBeMixedCase;
import org.assertj.core.error.ShouldBeNullOrEmpty;
import org.assertj.core.error.ShouldBeSubstring;
import org.assertj.core.error.ShouldBeUpperCase;
import org.assertj.core.error.ShouldBeVisible;
import org.assertj.core.error.ShouldContainAnyOf;
import org.assertj.core.error.ShouldContainCharSequence;
import org.assertj.core.error.ShouldContainCharSequenceOnlyOnce;
import org.assertj.core.error.ShouldContainOneOrMoreWhitespaces;
import org.assertj.core.error.ShouldContainOnlyDigits;
import org.assertj.core.error.ShouldContainOnlyWhitespaces;
import org.assertj.core.error.ShouldContainPattern;
import org.assertj.core.error.ShouldContainSequenceOfCharSequence;
import org.assertj.core.error.ShouldContainSubsequenceOfCharSequence;
import org.assertj.core.error.ShouldEndWith;
import org.assertj.core.error.ShouldEndWithIgnoringCase;
import org.assertj.core.error.ShouldHaveSizeGreaterThan;
import org.assertj.core.error.ShouldHaveSizeGreaterThanOrEqualTo;
import org.assertj.core.error.ShouldHaveSizeLessThan;
import org.assertj.core.error.ShouldHaveSizeLessThanOrEqualTo;
import org.assertj.core.error.ShouldMatchPattern;
import org.assertj.core.error.ShouldNotBeBlank;
import org.assertj.core.error.ShouldNotBeEmpty;
import org.assertj.core.error.ShouldNotBeEqualIgnoringCase;
import org.assertj.core.error.ShouldNotBeEqualIgnoringWhitespace;
import org.assertj.core.error.ShouldNotBeEqualNormalizingWhitespace;
import org.assertj.core.error.ShouldNotContainAnyWhitespaces;
import org.assertj.core.error.ShouldNotContainCharSequence;
import org.assertj.core.error.ShouldNotContainOnlyWhitespaces;
import org.assertj.core.error.ShouldNotContainPattern;
import org.assertj.core.error.ShouldNotEndWith;
import org.assertj.core.error.ShouldNotEndWithIgnoringCase;
import org.assertj.core.error.ShouldNotMatchPattern;
import org.assertj.core.error.ShouldNotStartWith;
import org.assertj.core.error.ShouldNotStartWithIgnoringCase;
import org.assertj.core.error.ShouldStartWith;
import org.assertj.core.error.ShouldStartWithIgnoringCase;
import org.assertj.core.internal.Arrays;
import org.assertj.core.internal.CommonErrors;
import org.assertj.core.internal.CommonValidations;
import org.assertj.core.internal.ComparatorBasedComparisonStrategy;
import org.assertj.core.internal.ComparisonStrategy;
import org.assertj.core.internal.Failures;
import org.assertj.core.internal.InputStreamsException;
import org.assertj.core.internal.Objects;
import org.assertj.core.internal.StandardComparisonStrategy;
import org.assertj.core.util.VisibleForTesting;
import org.assertj.core.util.xml.XmlStringPrettyFormatter;

public class Strings {
    private static final String EMPTY_STRING = "";
    private static final Strings INSTANCE = new Strings();
    private static final String PUNCTUATION_REGEX = "\\p{Punct}";
    private final ComparisonStrategy comparisonStrategy;
    @VisibleForTesting
    Failures failures = Failures.instance();

    public static Strings instance() {
        return INSTANCE;
    }

    @VisibleForTesting
    Strings() {
        this(StandardComparisonStrategy.instance());
    }

    public Strings(ComparisonStrategy comparisonStrategy) {
        this.comparisonStrategy = comparisonStrategy;
    }

    @VisibleForTesting
    public Comparator<?> getComparator() {
        if (this.comparisonStrategy instanceof ComparatorBasedComparisonStrategy) {
            return ((ComparatorBasedComparisonStrategy)this.comparisonStrategy).getComparator();
        }
        return null;
    }

    public void assertNullOrEmpty(AssertionInfo info, CharSequence actual) {
        if (actual != null && Strings.hasContent(actual)) {
            throw this.failures.failure(info, ShouldBeNullOrEmpty.shouldBeNullOrEmpty(actual));
        }
    }

    public void assertEmpty(AssertionInfo info, CharSequence actual) {
        this.assertNotNull(info, actual);
        if (Strings.hasContent(actual)) {
            throw this.failures.failure(info, ShouldBeEmpty.shouldBeEmpty(actual));
        }
    }

    public void assertNotEmpty(AssertionInfo info, CharSequence actual) {
        this.assertNotNull(info, actual);
        if (!Strings.hasContent(actual)) {
            throw this.failures.failure(info, ShouldNotBeEmpty.shouldNotBeEmpty());
        }
    }

    private static boolean hasContent(CharSequence s) {
        return s.length() > 0;
    }

    public void assertBlank(AssertionInfo info, CharSequence actual) {
        if (!this.isBlank(actual)) {
            throw this.failures.failure(info, ShouldBeBlank.shouldBeBlank(actual));
        }
    }

    public void assertNotBlank(AssertionInfo info, CharSequence actual) {
        if (this.isBlank(actual)) {
            throw this.failures.failure(info, ShouldNotBeBlank.shouldNotBeBlank(actual));
        }
    }

    private boolean isBlank(CharSequence actual) {
        return this.isNullOrEmpty(actual) || this.strictlyContainsWhitespaces(actual);
    }

    private boolean containsWhitespaces(CharSequence actual) {
        return !this.isNullOrEmpty(actual) && this.containsOneOrMoreWhitespaces(actual);
    }

    private boolean containsOnlyWhitespaces(CharSequence actual) {
        return !this.isNullOrEmpty(actual) && this.strictlyContainsWhitespaces(actual);
    }

    private boolean isNullOrEmpty(CharSequence actual) {
        return actual == null || actual.length() == 0;
    }

    private boolean containsOneOrMoreWhitespaces(CharSequence actual) {
        return actual.chars().anyMatch(Character::isWhitespace);
    }

    private boolean strictlyContainsWhitespaces(CharSequence actual) {
        return actual.chars().allMatch(Character::isWhitespace);
    }

    public void assertContainsWhitespaces(AssertionInfo info, CharSequence actual) {
        if (!this.containsWhitespaces(actual)) {
            throw this.failures.failure(info, ShouldContainOneOrMoreWhitespaces.shouldContainOneOrMoreWhitespaces(actual));
        }
    }

    public void assertContainsOnlyWhitespaces(AssertionInfo info, CharSequence actual) {
        if (!this.containsOnlyWhitespaces(actual)) {
            throw this.failures.failure(info, ShouldContainOnlyWhitespaces.shouldContainOnlyWhitespaces(actual));
        }
    }

    public void assertDoesNotContainAnyWhitespaces(AssertionInfo info, CharSequence actual) {
        if (this.containsWhitespaces(actual)) {
            throw this.failures.failure(info, ShouldNotContainAnyWhitespaces.shouldNotContainAnyWhitespaces(actual));
        }
    }

    public void assertDoesNotContainOnlyWhitespaces(AssertionInfo info, CharSequence actual) {
        if (this.containsOnlyWhitespaces(actual)) {
            throw this.failures.failure(info, ShouldNotContainOnlyWhitespaces.shouldNotContainOnlyWhitespaces(actual));
        }
    }

    public void assertJavaBlank(AssertionInfo info, CharSequence actual) {
        if (!this.isJavaBlank(actual)) {
            throw this.failures.failure(info, ShouldBeBlank.shouldBeBlank(actual));
        }
    }

    public void assertNotJavaBlank(AssertionInfo info, CharSequence actual) {
        if (this.isJavaBlank(actual)) {
            throw this.failures.failure(info, ShouldNotBeBlank.shouldNotBeBlank(actual));
        }
    }

    private boolean isJavaBlank(CharSequence actual) {
        if (actual == null || actual.length() == 0) {
            return false;
        }
        for (int i = 0; i < actual.length(); ++i) {
            if (Character.isWhitespace(actual.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public void assertHasSize(AssertionInfo info, CharSequence actual, int expectedSize) {
        this.assertNotNull(info, actual);
        CommonValidations.checkSizes(actual, actual.length(), expectedSize, info);
    }

    public void assertHasSizeLessThan(AssertionInfo info, CharSequence actual, int expectedMaxSizeExcluded) {
        this.assertNotNull(info, actual);
        if (actual.length() >= expectedMaxSizeExcluded) {
            throw this.failures.failure(info, ShouldHaveSizeLessThan.shouldHaveSizeLessThan(actual, actual.length(), expectedMaxSizeExcluded));
        }
    }

    public void assertHasSizeLessThanOrEqualTo(AssertionInfo info, CharSequence actual, int expectedMaxSizeIncluded) {
        this.assertNotNull(info, actual);
        if (actual.length() > expectedMaxSizeIncluded) {
            throw this.failures.failure(info, ShouldHaveSizeLessThanOrEqualTo.shouldHaveSizeLessThanOrEqualTo(actual, actual.length(), expectedMaxSizeIncluded));
        }
    }

    public void assertHasSizeGreaterThan(AssertionInfo info, CharSequence actual, int expectedMinSizeExcluded) {
        this.assertNotNull(info, actual);
        if (actual.length() <= expectedMinSizeExcluded) {
            throw this.failures.failure(info, ShouldHaveSizeGreaterThan.shouldHaveSizeGreaterThan(actual, actual.length(), expectedMinSizeExcluded));
        }
    }

    public void assertHasSizeGreaterThanOrEqualTo(AssertionInfo info, CharSequence actual, int expectedMinSizeIncluded) {
        this.assertNotNull(info, actual);
        if (actual.length() < expectedMinSizeIncluded) {
            throw this.failures.failure(info, ShouldHaveSizeGreaterThanOrEqualTo.shouldHaveSizeGreaterThanOrEqualTo(actual, actual.length(), expectedMinSizeIncluded));
        }
    }

    public void assertHasSizeBetween(AssertionInfo info, CharSequence actual, int lowerBoundary, int higherBoundary) {
        this.assertNotNull(info, actual);
        CommonValidations.checkSizeBetween(actual, lowerBoundary, higherBoundary, actual.length(), info);
    }

    public void assertHasLineCount(AssertionInfo info, CharSequence actual, int expectedLineCount) {
        this.assertNotNull(info, actual);
        LineNumberReader reader = new LineNumberReader(new StringReader(actual.toString()));
        try {
            while (reader.readLine() != null) {
            }
        }
        catch (IOException e) {
            throw new InputStreamsException(String.format("Unable to count lines in `%s`", actual), e);
        }
        CommonValidations.checkLineCounts(actual, reader.getLineNumber(), expectedLineCount, info);
    }

    public void assertHasSameSizeAs(AssertionInfo info, CharSequence actual, Iterable<?> other) {
        this.assertNotNull(info, actual);
        CommonValidations.hasSameSizeAsCheck(info, (Object)actual, other, actual.length());
    }

    public void assertHasSameSizeAs(AssertionInfo info, CharSequence actual, Object array) {
        Objects.instance().assertNotNull(info, actual);
        Arrays.assertIsArray(info, array);
        CommonValidations.hasSameSizeAsCheck(info, (Object)actual, array, actual.length());
    }

    public void assertHasSameSizeAs(AssertionInfo info, CharSequence actual, CharSequence other) {
        Objects.instance().assertNotNull(info, actual);
        CommonValidations.checkOtherIsNotNull(other, "CharSequence or String");
        CommonValidations.checkSameSizes(info, actual, other, actual.length(), other.length());
    }

    public void assertContains(AssertionInfo info, CharSequence actual, CharSequence ... values) {
        this.doCommonCheckForCharSequence(info, actual, values);
        Set notFound = java.util.Arrays.stream(values).filter(value -> !this.stringContains(actual, (CharSequence)value)).collect(Collectors.toCollection(LinkedHashSet::new));
        if (notFound.isEmpty()) {
            return;
        }
        if (notFound.size() == 1 && values.length == 1) {
            throw this.failures.failure(info, ShouldContainCharSequence.shouldContain(actual, values[0], this.comparisonStrategy));
        }
        throw this.failures.failure(info, ShouldContainCharSequence.shouldContain(actual, values, notFound, this.comparisonStrategy));
    }

    public void assertContainsAnyOf(AssertionInfo info, CharSequence actual, CharSequence[] values) {
        this.doCommonCheckForCharSequence(info, actual, values);
        boolean found = java.util.Arrays.stream(values).anyMatch(value -> this.stringContains(actual, (CharSequence)value));
        if (!found) {
            throw this.failures.failure(info, ShouldContainAnyOf.shouldContainAnyOf(actual, values, this.comparisonStrategy));
        }
    }

    public void assertContainsOnlyDigits(AssertionInfo info, CharSequence actual) {
        this.assertNotNull(info, actual);
        if (actual.length() == 0) {
            throw this.failures.failure(info, ShouldContainOnlyDigits.shouldContainOnlyDigits(actual));
        }
        for (int index = 0; index < actual.length(); ++index) {
            char character = actual.charAt(index);
            if (Character.isDigit(character)) continue;
            throw this.failures.failure(info, ShouldContainOnlyDigits.shouldContainOnlyDigits(actual, character, index));
        }
    }

    private void checkIsNotNull(CharSequence ... values) {
        if (values == null) {
            throw CommonErrors.arrayOfValuesToLookForIsNull();
        }
    }

    private void checkIsNotEmpty(CharSequence ... values) {
        if (values.length == 0) {
            throw CommonErrors.arrayOfValuesToLookForIsEmpty();
        }
    }

    private boolean stringContains(CharSequence actual, CharSequence sequence) {
        return this.comparisonStrategy.stringContains(actual.toString(), sequence.toString());
    }

    public void assertContainsIgnoringCase(AssertionInfo info, CharSequence actual, CharSequence sequence) {
        Strings.checkCharSequenceIsNotNull(sequence);
        this.assertNotNull(info, actual);
        if (!this.containsIgnoreCase(actual, sequence)) {
            throw this.failures.failure(info, ShouldContainCharSequence.shouldContainIgnoringCase(actual, sequence));
        }
    }

    private boolean containsIgnoreCase(CharSequence actual, CharSequence sequence) {
        return this.comparisonStrategy.stringContains(actual.toString().toLowerCase(Locale.ROOT), sequence.toString().toLowerCase(Locale.ROOT));
    }

    public void assertContainsIgnoringNewLines(AssertionInfo info, CharSequence actual, CharSequence ... values) {
        this.doCommonCheckForCharSequence(info, actual, values);
        String actualNoNewLines = Strings.removeNewLines(actual);
        Set notFound = java.util.Arrays.stream(values).filter(value -> !this.stringContains(actualNoNewLines, Strings.removeNewLines(value))).collect(Collectors.toCollection(LinkedHashSet::new));
        if (notFound.isEmpty()) {
            return;
        }
        throw this.failures.failure(info, ShouldContainCharSequence.containsIgnoringNewLines(actual, values, notFound, this.comparisonStrategy));
    }

    public void assertContainsIgnoringWhitespaces(AssertionInfo info, CharSequence actual, CharSequence ... values) {
        this.doCommonCheckForCharSequence(info, actual, values);
        String actualWithoutWhitespace = Strings.removeAllWhitespaces(actual);
        Set notFound = java.util.Arrays.stream(values).map(Strings::removeAllWhitespaces).filter(value -> !this.stringContains(actualWithoutWhitespace, (CharSequence)value)).collect(Collectors.toCollection(LinkedHashSet::new));
        if (notFound.isEmpty()) {
            return;
        }
        if (values.length == 1) {
            throw this.failures.failure(info, ShouldContainCharSequence.shouldContainIgnoringWhitespaces(actual, values[0], this.comparisonStrategy));
        }
        throw this.failures.failure(info, ShouldContainCharSequence.shouldContainIgnoringWhitespaces(actual, values, notFound, this.comparisonStrategy));
    }

    public void assertDoesNotContainIgnoringCase(AssertionInfo info, CharSequence actual, CharSequence ... values) {
        this.doCommonCheckForCharSequence(info, actual, values);
        Set foundValues = java.util.Arrays.stream(values).filter(value -> this.containsIgnoreCase(actual, (CharSequence)value)).collect(Collectors.toCollection(LinkedHashSet::new));
        if (foundValues.isEmpty()) {
            return;
        }
        if (foundValues.size() == 1 && values.length == 1) {
            throw this.failures.failure(info, ShouldNotContainCharSequence.shouldNotContainIgnoringCase(actual, values[0]));
        }
        throw this.failures.failure(info, ShouldNotContainCharSequence.shouldNotContainIgnoringCase(actual, values, foundValues));
    }

    public void assertDoesNotContain(AssertionInfo info, CharSequence actual, CharSequence ... values) {
        this.doCommonCheckForCharSequence(info, actual, values);
        Set found = java.util.Arrays.stream(values).filter(value -> this.stringContains(actual, (CharSequence)value)).collect(Collectors.toCollection(LinkedHashSet::new));
        if (found.isEmpty()) {
            return;
        }
        if (found.size() == 1 && values.length == 1) {
            throw this.failures.failure(info, ShouldNotContainCharSequence.shouldNotContain(actual, values[0], this.comparisonStrategy));
        }
        throw this.failures.failure(info, ShouldNotContainCharSequence.shouldNotContain(actual, values, found, this.comparisonStrategy));
    }

    private static void checkCharSequenceIsNotNull(CharSequence sequence) {
        java.util.Objects.requireNonNull(sequence, "The char sequence to look for should not be null");
    }

    public void assertEqualsIgnoringCase(AssertionInfo info, CharSequence actual, CharSequence expected) {
        if (!this.areEqualIgnoringCase(actual, expected)) {
            throw this.failures.failure(info, ShouldBeEqualIgnoringCase.shouldBeEqual(actual, expected), actual, expected);
        }
    }

    public void assertNotEqualsIgnoringCase(AssertionInfo info, CharSequence actual, CharSequence expected) {
        if (this.areEqualIgnoringCase(actual, expected)) {
            throw this.failures.failure(info, ShouldNotBeEqualIgnoringCase.shouldNotBeEqualIgnoringCase(actual, expected));
        }
    }

    private boolean areEqualIgnoringCase(CharSequence actual, CharSequence expected) {
        if (actual == null) {
            return expected == null;
        }
        if (expected == null) {
            return false;
        }
        return actual.toString().equalsIgnoreCase(expected.toString());
    }

    public void assertIsEqualToNormalizingNewlines(AssertionInfo info, CharSequence actual, CharSequence expected) {
        String expectedNormalized;
        String actualNormalized = Strings.normalizeNewlines(actual);
        if (!actualNormalized.equals(expectedNormalized = Strings.normalizeNewlines(expected))) {
            throw this.failures.failure(info, ShouldBeEqualIgnoringNewLineDifferences.shouldBeEqualIgnoringNewLineDifferences(actual, expected), actualNormalized, expectedNormalized);
        }
    }

    private static String normalizeNewlines(CharSequence actual) {
        return actual.toString().replace("\r\n", "\n");
    }

    public void assertEqualsIgnoringWhitespace(AssertionInfo info, CharSequence actual, CharSequence expected) {
        if (!this.areEqualIgnoringWhitespace(actual, expected)) {
            throw this.failures.failure(info, ShouldBeEqualIgnoringWhitespace.shouldBeEqualIgnoringWhitespace(actual, expected), actual, expected);
        }
    }

    public void assertNotEqualsIgnoringWhitespace(AssertionInfo info, CharSequence actual, CharSequence expected) {
        if (this.areEqualIgnoringWhitespace(actual, expected)) {
            throw this.failures.failure(info, ShouldNotBeEqualIgnoringWhitespace.shouldNotBeEqualIgnoringWhitespace(actual, expected));
        }
    }

    private boolean areEqualIgnoringWhitespace(CharSequence actual, CharSequence expected) {
        if (actual == null) {
            return expected == null;
        }
        Strings.checkCharSequenceIsNotNull(expected);
        return Strings.removeAllWhitespaces(actual).equals(Strings.removeAllWhitespaces(expected));
    }

    private static String removeAllWhitespaces(CharSequence toBeStripped) {
        StringBuilder result = new StringBuilder(toBeStripped.length());
        for (int i = 0; i < toBeStripped.length(); ++i) {
            char c = toBeStripped.charAt(i);
            if (Character.isWhitespace(c)) continue;
            result.append(c);
        }
        return result.toString();
    }

    public void assertEqualsNormalizingWhitespace(AssertionInfo info, CharSequence actual, CharSequence expected) {
        String normalizedExpected;
        String normalizedActual;
        if (actual != null) {
            Strings.checkCharSequenceIsNotNull(expected);
        }
        if (!java.util.Objects.equals(normalizedActual = Strings.normalizeWhitespace(actual), normalizedExpected = Strings.normalizeWhitespace(expected))) {
            throw this.failures.failure(info, ShouldBeEqualNormalizingWhitespace.shouldBeEqualNormalizingWhitespace(actual, expected), normalizedActual, normalizedExpected);
        }
    }

    public void assertNotEqualsNormalizingWhitespace(AssertionInfo info, CharSequence actual, CharSequence expected) {
        String normalizedExpected;
        String normalizedActual;
        if (actual != null) {
            Strings.checkCharSequenceIsNotNull(expected);
        }
        if (java.util.Objects.equals(normalizedActual = Strings.normalizeWhitespace(actual), normalizedExpected = Strings.normalizeWhitespace(expected))) {
            throw this.failures.failure(info, ShouldNotBeEqualNormalizingWhitespace.shouldNotBeEqualNormalizingWhitespace(actual, expected));
        }
    }

    private static String normalizeWhitespace(CharSequence toNormalize) {
        if (toNormalize == null) {
            return null;
        }
        StringBuilder result = new StringBuilder(toNormalize.length());
        boolean lastWasSpace = true;
        for (int i = 0; i < toNormalize.length(); ++i) {
            char c = toNormalize.charAt(i);
            if (Character.isWhitespace(c)) {
                if (!lastWasSpace) {
                    result.append(' ');
                }
                lastWasSpace = true;
                continue;
            }
            result.append(c);
            lastWasSpace = false;
        }
        return result.toString().trim();
    }

    public void assertEqualsNormalizingPunctuationAndWhitespace(AssertionInfo info, CharSequence actual, CharSequence expected) {
        String normalizedExpected;
        String normalizedActual;
        if (actual != null) {
            Strings.checkCharSequenceIsNotNull(expected);
        }
        if (!java.util.Objects.equals(normalizedActual = Strings.normalizeWhitespaceAndPunctuation(actual), normalizedExpected = Strings.normalizeWhitespaceAndPunctuation(expected))) {
            throw this.failures.failure(info, ShouldBeEqualNormalizingPunctuationAndWhitespace.shouldBeEqualNormalizingPunctuationAndWhitespace(actual, expected), normalizedActual, normalizedExpected);
        }
    }

    private static String normalizeWhitespaceAndPunctuation(CharSequence toNormalize) {
        if (toNormalize == null) {
            return null;
        }
        return Strings.normalizeWhitespace(toNormalize.toString().replaceAll(PUNCTUATION_REGEX, EMPTY_STRING));
    }

    public void assertEqualsToNormalizingUnicode(AssertionInfo info, CharSequence actual, CharSequence expected) {
        String normalizedExpected;
        String normalizedActual;
        if (actual != null) {
            Strings.checkCharSequenceIsNotNull(expected);
        }
        if (!java.util.Objects.equals(normalizedActual = Normalizer.normalize(actual, Normalizer.Form.NFC), normalizedExpected = Normalizer.normalize(expected, Normalizer.Form.NFC))) {
            throw this.failures.failure(info, ShouldBeEqualNormalizingUnicode.shouldBeEqualNormalizingUnicode(actual, expected, normalizedActual, normalizedExpected), normalizedActual, normalizedExpected);
        }
    }

    public void assertContainsOnlyOnce(AssertionInfo info, CharSequence actual, CharSequence sequence) {
        Strings.checkCharSequenceIsNotNull(sequence);
        this.assertNotNull(info, actual);
        int sequenceOccurrencesInActual = this.countOccurrences(sequence, actual);
        if (sequenceOccurrencesInActual == 1) {
            return;
        }
        throw this.failures.failure(info, ShouldContainCharSequenceOnlyOnce.shouldContainOnlyOnce(actual, sequence, sequenceOccurrencesInActual, this.comparisonStrategy));
    }

    private int countOccurrences(CharSequence sequenceToSearch, CharSequence actual) {
        String strToSearch = sequenceToSearch.toString();
        String strActual = actual.toString();
        int occurrences = 0;
        for (int i = 0; i <= strActual.length() - strToSearch.length(); ++i) {
            if (!this.comparisonStrategy.areEqual(strActual.substring(i, i + sequenceToSearch.length()), strToSearch)) continue;
            ++occurrences;
        }
        return occurrences;
    }

    public void assertStartsWith(AssertionInfo info, CharSequence actual, CharSequence prefix) {
        Strings.failIfPrefixIsNull(prefix);
        this.assertNotNull(info, actual);
        if (!this.startsWith(actual, prefix, false)) {
            throw this.failures.failure(info, ShouldStartWith.shouldStartWith(actual, prefix, this.comparisonStrategy));
        }
    }

    public void assertStartsWithIgnoringCase(AssertionInfo info, CharSequence actual, CharSequence prefix) {
        Strings.failIfPrefixIsNull(prefix);
        this.assertNotNull(info, actual);
        if (!this.startsWith(actual, prefix, true)) {
            throw this.failures.failure(info, ShouldStartWithIgnoringCase.shouldStartWithIgnoringCase(actual, prefix, this.comparisonStrategy));
        }
    }

    public void assertDoesNotStartWith(AssertionInfo info, CharSequence actual, CharSequence prefix) {
        Strings.failIfPrefixIsNull(prefix);
        this.assertNotNull(info, actual);
        if (this.startsWith(actual, prefix, false)) {
            throw this.failures.failure(info, ShouldNotStartWith.shouldNotStartWith(actual, prefix, this.comparisonStrategy));
        }
    }

    public void assertDoesNotStartWithIgnoringCase(AssertionInfo info, CharSequence actual, CharSequence prefix) {
        Strings.failIfPrefixIsNull(prefix);
        this.assertNotNull(info, actual);
        if (this.startsWith(actual, prefix, true)) {
            throw this.failures.failure(info, ShouldNotStartWithIgnoringCase.shouldNotStartWithIgnoringCase(actual, prefix, this.comparisonStrategy));
        }
    }

    private static void failIfPrefixIsNull(CharSequence prefix) {
        java.util.Objects.requireNonNull(prefix, "The given prefix should not be null");
    }

    private boolean startsWith(CharSequence actual, CharSequence prefix, boolean ignoreCase) {
        return ignoreCase ? this.comparisonStrategy.stringStartsWith(actual.toString().toLowerCase(Locale.ROOT), prefix.toString().toLowerCase(Locale.ROOT)) : this.comparisonStrategy.stringStartsWith(actual.toString(), prefix.toString());
    }

    public void assertEndsWith(AssertionInfo info, CharSequence actual, CharSequence suffix) {
        Strings.failIfSuffixIsNull(suffix);
        this.assertNotNull(info, actual);
        if (!this.endsWith(actual, suffix, false)) {
            throw this.failures.failure(info, ShouldEndWith.shouldEndWith(actual, suffix, this.comparisonStrategy));
        }
    }

    public void assertEndsWithIgnoringCase(AssertionInfo info, CharSequence actual, CharSequence suffix) {
        Strings.failIfSuffixIsNull(suffix);
        this.assertNotNull(info, actual);
        if (!this.endsWith(actual, suffix, true)) {
            throw this.failures.failure(info, ShouldEndWithIgnoringCase.shouldEndWithIgnoringCase(actual, suffix, this.comparisonStrategy));
        }
    }

    public void assertDoesNotEndWith(AssertionInfo info, CharSequence actual, CharSequence suffix) {
        Strings.failIfSuffixIsNull(suffix);
        this.assertNotNull(info, actual);
        if (this.endsWith(actual, suffix, false)) {
            throw this.failures.failure(info, ShouldNotEndWith.shouldNotEndWith(actual, suffix, this.comparisonStrategy));
        }
    }

    public void assertDoesNotEndWithIgnoringCase(AssertionInfo info, CharSequence actual, CharSequence suffix) {
        Strings.failIfSuffixIsNull(suffix);
        this.assertNotNull(info, actual);
        if (this.endsWith(actual, suffix, true)) {
            throw this.failures.failure(info, ShouldNotEndWithIgnoringCase.shouldNotEndWithIgnoringCase(actual, suffix, this.comparisonStrategy));
        }
    }

    private static void failIfSuffixIsNull(CharSequence suffix) {
        java.util.Objects.requireNonNull(suffix, "The given suffix should not be null");
    }

    private boolean endsWith(CharSequence actual, CharSequence suffix, boolean ignoreCase) {
        return ignoreCase ? this.comparisonStrategy.stringEndsWith(actual.toString().toLowerCase(Locale.ROOT), suffix.toString().toLowerCase(Locale.ROOT)) : this.comparisonStrategy.stringEndsWith(actual.toString(), suffix.toString());
    }

    public void assertMatches(AssertionInfo info, CharSequence actual, CharSequence regex) {
        this.checkRegexIsNotNull(regex);
        this.assertNotNull(info, actual);
        if (!Pattern.matches(regex.toString(), actual)) {
            throw this.failures.failure(info, ShouldMatchPattern.shouldMatch(actual, regex));
        }
    }

    public void assertDoesNotMatch(AssertionInfo info, CharSequence actual, CharSequence regex) {
        this.checkRegexIsNotNull(regex);
        this.assertNotNull(info, actual);
        if (Pattern.matches(regex.toString(), actual)) {
            throw this.failures.failure(info, ShouldNotMatchPattern.shouldNotMatch(actual, regex));
        }
    }

    private void checkRegexIsNotNull(CharSequence regex) {
        if (regex == null) {
            throw this.patternToMatchIsNull();
        }
    }

    public void assertMatches(AssertionInfo info, CharSequence actual, Pattern pattern) {
        this.checkIsNotNull(pattern);
        this.assertNotNull(info, actual);
        this.assertMatches(info, actual, pattern.matcher(actual));
    }

    public void assertMatches(AssertionInfo info, CharSequence actual, Matcher matcher) {
        this.checkIsNotNull(matcher);
        this.assertNotNull(info, actual);
        if (!matcher.matches()) {
            throw this.failures.failure(info, ShouldMatchPattern.shouldMatch(actual, matcher.pattern().pattern()));
        }
    }

    public void assertDoesNotMatch(AssertionInfo info, CharSequence actual, Pattern pattern) {
        this.checkIsNotNull(pattern);
        if (actual != null && pattern.matcher(actual).matches()) {
            throw this.failures.failure(info, ShouldNotMatchPattern.shouldNotMatch(actual, pattern.pattern()));
        }
    }

    private void checkIsNotNull(Pattern pattern) {
        if (pattern == null) {
            throw this.patternToMatchIsNull();
        }
    }

    private NullPointerException patternToMatchIsNull() {
        return new NullPointerException("The regular expression pattern to match should not be null");
    }

    private void checkIsNotNull(Matcher matcher) {
        if (matcher == null) {
            throw new NullPointerException("The matcher should not be null");
        }
    }

    private void assertNotNull(AssertionInfo info, CharSequence actual) {
        Objects.instance().assertNotNull(info, actual);
    }

    public void assertContainsSequence(AssertionInfo info, CharSequence actual, CharSequence[] sequence) {
        String strSequence;
        this.doCommonCheckForCharSequence(info, actual, sequence);
        Set notFound = java.util.Arrays.stream(sequence).filter(value -> !this.stringContains(actual, (CharSequence)value)).collect(Collectors.toCollection(LinkedHashSet::new));
        if (!notFound.isEmpty()) {
            if (notFound.size() == 1 && sequence.length == 1) {
                throw this.failures.failure(info, ShouldContainCharSequence.shouldContain(actual, sequence[0], this.comparisonStrategy));
            }
            throw this.failures.failure(info, ShouldContainCharSequence.shouldContain(actual, sequence, notFound, this.comparisonStrategy));
        }
        if (sequence.length == 1) {
            return;
        }
        String strActual = actual.toString();
        if (!this.stringContains(strActual, strSequence = String.join((CharSequence)EMPTY_STRING, sequence))) {
            throw this.failures.failure(info, ShouldContainSequenceOfCharSequence.shouldContainSequence(actual, sequence, this.comparisonStrategy));
        }
    }

    public void assertContainsSubsequence(AssertionInfo info, CharSequence actual, CharSequence[] subsequence) {
        this.doCommonCheckForCharSequence(info, actual, subsequence);
        Set notFound = java.util.Arrays.stream(subsequence).filter(value -> !this.stringContains(actual, (CharSequence)value)).collect(Collectors.toCollection(LinkedHashSet::new));
        if (!notFound.isEmpty()) {
            if (notFound.size() == 1 && subsequence.length == 1) {
                throw this.failures.failure(info, ShouldContainCharSequence.shouldContain(actual, subsequence[0], this.comparisonStrategy));
            }
            throw this.failures.failure(info, ShouldContainCharSequence.shouldContain(actual, subsequence, notFound, this.comparisonStrategy));
        }
        if (subsequence.length == 1) {
            return;
        }
        String actualRest = this.removeUpTo(actual.toString(), subsequence[0]);
        for (int i = 1; i < subsequence.length; ++i) {
            if (!this.stringContains(actualRest, subsequence[i])) {
                throw this.failures.failure(info, ShouldContainSubsequenceOfCharSequence.shouldContainSubsequence(actual, subsequence, i - 1, this.comparisonStrategy));
            }
            actualRest = this.removeUpTo(actualRest, subsequence[i]);
        }
    }

    private String removeUpTo(String string, CharSequence toRemove) {
        int index = this.indexOf(string, toRemove);
        return string.substring(index + toRemove.length());
    }

    private int indexOf(String string, CharSequence toFind) {
        if (EMPTY_STRING.equals(string) && EMPTY_STRING.equals(toFind.toString())) {
            return 0;
        }
        for (int i = 0; i < string.length(); ++i) {
            if (!this.comparisonStrategy.stringStartsWith(string.substring(i), toFind.toString())) continue;
            return i;
        }
        throw new IllegalStateException(String.format("%s should have been found in %s, please raise an assertj-core issue", toFind, string));
    }

    public void assertXmlEqualsTo(AssertionInfo info, CharSequence actualXml, CharSequence expectedXml) {
        Strings.checkCharSequenceIsNotNull(expectedXml);
        this.assertNotNull(info, actualXml);
        String formattedActualXml = XmlStringPrettyFormatter.xmlPrettyFormat(actualXml.toString());
        String formattedExpectedXml = XmlStringPrettyFormatter.xmlPrettyFormat(expectedXml.toString());
        if (!this.comparisonStrategy.areEqual(formattedActualXml, formattedExpectedXml)) {
            throw this.failures.failure(info, ShouldBeEqual.shouldBeEqual(formattedActualXml, formattedExpectedXml, this.comparisonStrategy, info.representation()));
        }
    }

    public void assertIsSubstringOf(AssertionInfo info, CharSequence actual, CharSequence sequence) {
        this.assertNotNull(info, actual);
        java.util.Objects.requireNonNull(sequence, "Expecting CharSequence not to be null");
        if (this.stringContains(sequence.toString(), actual.toString())) {
            return;
        }
        throw this.failures.failure(info, ShouldBeSubstring.shouldBeSubstring(actual, sequence, this.comparisonStrategy));
    }

    public void assertContainsPattern(AssertionInfo info, CharSequence actual, CharSequence regex) {
        this.checkRegexIsNotNull(regex);
        this.assertContainsPattern(info, actual, Pattern.compile(regex.toString()));
    }

    public void assertContainsPattern(AssertionInfo info, CharSequence actual, Matcher matcher) {
        this.assertNotNull(info, actual);
        this.checkIsNotNull(matcher);
        if (!matcher.find()) {
            throw this.failures.failure(info, ShouldContainPattern.shouldContainPattern(actual, matcher.pattern().pattern()));
        }
    }

    public void assertContainsPattern(AssertionInfo info, CharSequence actual, Pattern pattern) {
        this.checkIsNotNull(pattern);
        this.assertNotNull(info, actual);
        Matcher matcher = pattern.matcher(actual);
        if (!matcher.find()) {
            throw this.failures.failure(info, ShouldContainPattern.shouldContainPattern(actual, pattern.pattern()));
        }
    }

    public void assertDoesNotContainPattern(AssertionInfo info, CharSequence actual, CharSequence regex) {
        this.checkRegexIsNotNull(regex);
        Pattern pattern = Pattern.compile(regex.toString());
        this.assertDoesNotContainPattern(info, actual, pattern);
    }

    public void assertDoesNotContainPattern(AssertionInfo info, CharSequence actual, Pattern pattern) {
        this.checkIsNotNull(pattern);
        this.assertNotNull(info, actual);
        Matcher matcher = pattern.matcher(actual);
        if (matcher.find()) {
            throw this.failures.failure(info, ShouldNotContainPattern.shouldNotContainPattern(actual, pattern.pattern()));
        }
    }

    private void checkCharSequenceArrayDoesNotHaveNullElements(CharSequence[] values) {
        if (values.length == 1) {
            Strings.checkCharSequenceIsNotNull(values[0]);
        } else {
            for (int i = 0; i < values.length; ++i) {
                java.util.Objects.requireNonNull(values[i], "Expecting CharSequence elements not to be null but found one at index " + i);
            }
        }
    }

    public void assertIsEqualToIgnoringNewLines(AssertionInfo info, CharSequence actual, CharSequence expected) {
        String expectedWithoutNewLines;
        String actualWithoutNewLines = Strings.removeNewLines(actual);
        if (!actualWithoutNewLines.equals(expectedWithoutNewLines = Strings.removeNewLines(expected))) {
            throw this.failures.failure(info, ShouldBeEqualIgnoringNewLines.shouldBeEqualIgnoringNewLines(actual, expected), actual, expected);
        }
    }

    public void assertLowerCase(AssertionInfo info, CharSequence actual) {
        this.assertNotNull(info, actual);
        if (!this.isLowerCase(actual)) {
            throw this.failures.failure(info, ShouldBeLowerCase.shouldBeLowerCase(actual));
        }
    }

    private boolean isLowerCase(CharSequence actual) {
        return actual.equals(actual.toString().toLowerCase());
    }

    public void assertUpperCase(AssertionInfo info, CharSequence actual) {
        this.assertNotNull(info, actual);
        if (!this.isUpperCase(actual)) {
            throw this.failures.failure(info, ShouldBeUpperCase.shouldBeUpperCase(actual));
        }
    }

    private boolean isUpperCase(CharSequence actual) {
        return actual.equals(actual.toString().toUpperCase());
    }

    public void assertMixedCase(AssertionInfo info, CharSequence actual) {
        this.assertNotNull(info, actual);
        if (this.isLowerCase(actual) != this.isUpperCase(actual)) {
            throw this.failures.failure(info, ShouldBeMixedCase.shouldBeMixedCase(actual));
        }
    }

    public void assertIsBase64(AssertionInfo info, String actual) {
        this.assertNotNull(info, actual);
        try {
            Base64.getDecoder().decode(actual);
        }
        catch (IllegalArgumentException e) {
            throw this.failures.failure(info, ShouldBeBase64.shouldBeBase64(actual));
        }
    }

    private static String removeNewLines(CharSequence text2) {
        String normalizedText = Strings.normalizeNewlines(text2);
        return normalizedText.replace("\n", EMPTY_STRING);
    }

    private void doCommonCheckForCharSequence(AssertionInfo info, CharSequence actual, CharSequence[] sequence) {
        this.assertNotNull(info, actual);
        this.checkIsNotNull(sequence);
        this.checkIsNotEmpty(sequence);
        this.checkCharSequenceArrayDoesNotHaveNullElements(sequence);
    }

    public void assertVisible(AssertionInfo info, CharSequence actual) {
        this.assertNotNull(info, actual);
        if (!Pattern.matches("\\p{Graph}*", actual)) {
            throw this.failures.failure(info, ShouldBeVisible.shouldBeVisible(actual));
        }
    }
}

