/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.core.error;

import org.assertj.core.configuration.ConfigurationProvider;
import org.assertj.core.error.BasicErrorMessageFactory;

public class ShouldOnlyHaveElementsOfTypes
extends BasicErrorMessageFactory {
    public static ShouldOnlyHaveElementsOfTypes shouldOnlyHaveElementsOfTypes(Object actual, Class<?>[] types, Iterable<?> mismatches) {
        return new ShouldOnlyHaveElementsOfTypes(actual, types, mismatches);
    }

    private ShouldOnlyHaveElementsOfTypes(Object actual, Class<?>[] types, Iterable<?> nonMatchingElements) {
        super("%nExpecting actual:%n  %s%nto only have instances of:%n  %s%nbut these elements are not:%n  [" + ShouldOnlyHaveElementsOfTypes.resolveClassNames(nonMatchingElements) + "]", actual, types);
    }

    private static String resolveClassNames(Iterable<?> elements) {
        StringBuilder builder = new StringBuilder();
        for (Object element2 : elements) {
            if (builder.length() > 0) {
                builder.append(", ");
            }
            String formatted = ConfigurationProvider.CONFIGURATION_PROVIDER.representation().toStringOf(element2);
            builder.append(formatted);
            if (element2 == null || formatted.contains(element2.getClass().getName())) continue;
            builder.append(" (").append(element2.getClass().getName()).append(")");
        }
        return builder.toString();
    }
}

