/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.performancePlugin.commands;

import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.playback.PlaybackContext;
import com.intellij.openapi.ui.playback.commands.AbstractCommand;
import com.intellij.openapi.util.ActionCallback;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.util.indexing.FileBasedIndexTumbler;
import com.intellij.util.indexing.diagnostic.dump.IndexContentDiagnostic;
import com.intellij.util.indexing.diagnostic.dump.IndexContentDiagnosticDumper;
import com.jetbrains.performancePlugin.PerformanceTestingBundle;
import com.jetbrains.performancePlugin.commands.StoreIndices;
import com.jetbrains.performancePlugin.utils.ActionCallbackProfilerStopper;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;
import java.util.stream.Stream;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jdk7.AutoCloseableKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.concurrency.Promise;
import org.jetbrains.concurrency.Promises;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u00142\u00020\u0001:\u0001\u0014B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0018\u0010\u0007\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\t0\b2\u0006\u0010\n\u001a\u00020\u000bH\u0014J \u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0002\u00a8\u0006\u0015"}, d2={"Lcom/jetbrains/performancePlugin/commands/StoreIndices;", "Lcom/intellij/openapi/ui/playback/commands/AbstractCommand;", "text", "", "line", "", "(Ljava/lang/String;I)V", "_execute", "Lorg/jetbrains/concurrency/Promise;", "", "context", "Lcom/intellij/openapi/ui/playback/PlaybackContext;", "storeIndexesTo", "", "storedIndexDir", "Ljava/nio/file/Path;", "indicator", "Lcom/intellij/openapi/progress/ProgressIndicator;", "project", "Lcom/intellij/openapi/project/Project;", "Companion", "intellij.performanceTesting"})
@SourceDebugExtension(value={"SMAP\nStoreIndices.kt\nKotlin\n*S Kotlin\n*F\n+ 1 StoreIndices.kt\ncom/jetbrains/performancePlugin/commands/StoreIndices\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,130:1\n10#2:131\n*S KotlinDebug\n*F\n+ 1 StoreIndices.kt\ncom/jetbrains/performancePlugin/commands/StoreIndices\n*L\n101#1:131\n*E\n"})
public final class StoreIndices
extends AbstractCommand {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    public static final String PREFIX = "%storeIndices";
    @NotNull
    private static final Logger LOG;

    public StoreIndices(@NotNull String text2, int line) {
        Intrinsics.checkNotNullParameter((Object)text2, (String)"text");
        super(text2, line);
    }

    @NotNull
    protected Promise<Object> _execute(@NotNull PlaybackContext context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        ActionCallbackProfilerStopper actionCallback = new ActionCallbackProfilerStopper();
        Project project = context.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        Project project2 = project;
        LOG.info("dynamic.classpath: " + PropertiesComponent.getInstance((Project)project2).getValue("dynamic.classpath"));
        Path storedIndexDir = StoreIndices.Companion.getOrCreateDirectoryToStoreIndex();
        LOG.info("Index will be stored to " + storedIndexDir);
        DumbService.Companion.getInstance(project2).smartInvokeLater(() -> StoreIndices._execute$lambda$1(project2, actionCallback, this, storedIndexDir));
        return Promises.toPromise((ActionCallback)actionCallback);
    }

    private final void storeIndexesTo(Path storedIndexDir, ProgressIndicator indicator, Project project) {
        ActionsKt.runReadAction((Function0)storeIndexesTo.1.INSTANCE);
        indicator.setIndeterminate(true);
        indicator.setText(PerformanceTestingBundle.message("storing.indexes.copying", new Object[0]));
        Path path = PathManager.getIndexRoot();
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"getIndexRoot(...)");
        Path indexRoot = path;
        try {
            FileUtil.delete((Path)storedIndexDir);
            FileUtil.copyDir((File)indexRoot.toFile(), (File)storedIndexDir.toFile());
            LOG.info("Stored index directory contains: " + Companion.dumpDirectory(storedIndexDir));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        IndexContentDiagnostic contentDiagnostic = IndexContentDiagnosticDumper.INSTANCE.getIndexContentDiagnosticForProject(project, indicator);
        IndexContentDiagnosticDumper.INSTANCE.writeTo(Companion.getFileForDiagnostic(storedIndexDir), contentDiagnostic);
    }

    private static final void _execute$lambda$1$lambda$0(Function0 $tmp0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke();
    }

    private static final void _execute$lambda$1(Project $project, ActionCallbackProfilerStopper $actionCallback, StoreIndices this$0, Path $storedIndexDir) {
        Intrinsics.checkNotNullParameter((Object)$project, (String)"$project");
        Intrinsics.checkNotNullParameter((Object)((Object)$actionCallback), (String)"$actionCallback");
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$storedIndexDir, (String)"$storedIndexDir");
        FileBasedIndexTumbler switcher = new FileBasedIndexTumbler("Storing indexes command");
        switcher.turnOff();
        Ref.ObjectRef error = new Ref.ObjectRef();
        Function0 storeIndexesAction2 = (Function0)new Function0<Unit>(this$0, $storedIndexDir, $project, (Ref.ObjectRef<Throwable>)error){
            final /* synthetic */ StoreIndices this$0;
            final /* synthetic */ Path $storedIndexDir;
            final /* synthetic */ Project $project;
            final /* synthetic */ Ref.ObjectRef<Throwable> $error;
            {
                this.this$0 = $receiver;
                this.$storedIndexDir = $storedIndexDir;
                this.$project = $project;
                this.$error = $error;
                super(0);
            }

            public final void invoke() {
                try {
                    ProgressIndicator progressIndicator = ProgressManager.getInstance().getProgressIndicator();
                    Intrinsics.checkNotNullExpressionValue((Object)progressIndicator, (String)"getProgressIndicator(...)");
                    StoreIndices.access$storeIndexesTo(this.this$0, this.$storedIndexDir, progressIndicator, this.$project);
                    StoreIndices.access$getLOG$cp().info("Indices have been successfully stored to " + this.$storedIndexDir);
                }
                catch (Throwable e) {
                    this.$error.element = e;
                }
            }
        };
        ProgressManager.getInstance().runProcessWithProgressSynchronously(() -> StoreIndices._execute$lambda$1$lambda$0(storeIndexesAction2), PerformanceTestingBundle.message("storing.indexes", new Object[0]), false, $project);
        switcher.turnOn(null);
        if (error.element != null) {
            Object object = error.element;
            Intrinsics.checkNotNull((Object)object);
            LOG.error((Throwable)object);
            Object object2 = error.element;
            Intrinsics.checkNotNull((Object)object2);
            $actionCallback.reject(((Throwable)object2).getMessage());
        } else {
            $actionCallback.setDone();
        }
    }

    public static final /* synthetic */ void access$storeIndexesTo(StoreIndices $this, Path storedIndexDir, ProgressIndicator indicator, Project project) {
        $this.storeIndexesTo(storedIndexDir, indicator, project);
    }

    public static final /* synthetic */ Logger access$getLOG$cp() {
        return LOG;
    }

    static {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(StoreIndices.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00060\b2\u0006\u0010\t\u001a\u00020\nJ\u000e\u0010\u000b\u001a\u00020\n2\u0006\u0010\f\u001a\u00020\nJ\b\u0010\r\u001a\u00020\nH\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/jetbrains/performancePlugin/commands/StoreIndices$Companion;", "", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "PREFIX", "", "dumpDirectory", "", "dir", "Ljava/nio/file/Path;", "getFileForDiagnostic", "indexesHomeDirectory", "getOrCreateDirectoryToStoreIndex", "intellij.performanceTesting"})
    @SourceDebugExtension(value={"SMAP\nStoreIndices.kt\nKotlin\n*S Kotlin\n*F\n+ 1 StoreIndices.kt\ncom/jetbrains/performancePlugin/commands/StoreIndices$Companion\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,130:1\n1#2:131\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        private final Path getOrCreateDirectoryToStoreIndex() {
            Path path;
            String property = System.getProperty("store.indices.command.stored.indexes.dump.directory");
            if (property != null) {
                Path path2 = Paths.get(property, new String[0]);
                Intrinsics.checkNotNull((Object)path2);
                path = path2;
            } else {
                Path path3;
                try {
                    path3 = FileUtil.createTempDirectory((String)"stored_index", null).toPath();
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
                Path path4 = path3;
                Intrinsics.checkNotNull((Object)path4);
                path = path4;
            }
            return path;
        }

        @NotNull
        public final Path getFileForDiagnostic(@NotNull Path indexesHomeDirectory) {
            Intrinsics.checkNotNullParameter((Object)indexesHomeDirectory, (String)"indexesHomeDirectory");
            Path path = indexesHomeDirectory.resolve("indexedFilePaths.json");
            Intrinsics.checkNotNullExpressionValue((Object)path, (String)"resolve(...)");
            return path;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @NotNull
        public final List<String> dumpDirectory(@NotNull Path dir) {
            List<String> list;
            Intrinsics.checkNotNullParameter((Object)dir, (String)"dir");
            AutoCloseable autoCloseable = Files.list(dir);
            Throwable throwable = null;
            try {
                Stream it = (Stream)autoCloseable;
                boolean bl = false;
                List<String> list2 = it.map(arg_0 -> Companion.dumpDirectory$lambda$1$lambda$0(dumpDirectory.1.1.INSTANCE, arg_0)).toList();
                list = list2;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
            }
            Intrinsics.checkNotNullExpressionValue(list, (String)"use(...)");
            return list;
        }

        private static final String dumpDirectory$dumpFileInfo(Path file) {
            if (Files.isDirectory(file, new LinkOption[0])) {
                return ((Object)file.getFileName()).toString();
            }
            return file.getFileName() + "(size=" + Files.size(file) + "b, mod stamp=" + Files.getLastModifiedTime(file, new LinkOption[0]) + ")";
        }

        private static final String dumpDirectory$lambda$1$lambda$0(Function1 $tmp0, Object p0) {
            Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
            return (String)$tmp0.invoke(p0);
        }

        public static final /* synthetic */ String access$dumpDirectory$dumpFileInfo(Path file) {
            return com.jetbrains.performancePlugin.commands.StoreIndices$Companion.dumpDirectory$dumpFileInfo(file);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

