/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.gradle.toolingExtension.modelAction;

import java.io.File;
import java.io.Serializable;
import org.gradle.tooling.internal.gradle.DefaultProjectIdentifier;
import org.gradle.tooling.model.GradleProject;
import org.gradle.tooling.model.ProjectIdentifier;
import org.gradle.tooling.model.gradle.BasicGradleProject;
import org.gradle.tooling.model.idea.IdeaModule;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.gradle.model.Project;

@ApiStatus.Internal
class DefaultProject
implements Project,
Serializable {
    private final String myName;
    private final DefaultProjectIdentifier myProjectIdentifier;

    private DefaultProject(@NotNull String name, @NotNull File rootDir, @NotNull String projectPath) {
        if (name == null) {
            DefaultProject.$$$reportNull$$$0(0);
        }
        if (rootDir == null) {
            DefaultProject.$$$reportNull$$$0(1);
        }
        if (projectPath == null) {
            DefaultProject.$$$reportNull$$$0(2);
        }
        this.myName = name;
        this.myProjectIdentifier = new DefaultProjectIdentifier(rootDir, projectPath);
    }

    @Override
    public String getName() {
        return this.myName;
    }

    public ProjectIdentifier getProjectIdentifier() {
        return this.myProjectIdentifier;
    }

    public String toString() {
        return "ProjectModel{name='" + this.myName + '\'' + ", id=" + this.myProjectIdentifier + '}';
    }

    @NotNull
    public static Project convertGradleProject(@NotNull BasicGradleProject gradleProject) {
        if (gradleProject == null) {
            DefaultProject.$$$reportNull$$$0(3);
        }
        String name = gradleProject.getName();
        ProjectIdentifier projectIdentifier = gradleProject.getProjectIdentifier();
        File rootDir = projectIdentifier.getBuildIdentifier().getRootDir();
        String projectPath = projectIdentifier.getProjectPath();
        return new DefaultProject(name, rootDir, projectPath);
    }

    @NotNull
    public static Project convertIdeaProject(@NotNull IdeaModule ideaModule) {
        if (ideaModule == null) {
            DefaultProject.$$$reportNull$$$0(4);
        }
        GradleProject gradleProject = ideaModule.getGradleProject();
        String name = gradleProject.getName();
        ProjectIdentifier projectIdentifier = gradleProject.getProjectIdentifier();
        File rootDir = projectIdentifier.getBuildIdentifier().getRootDir();
        String projectPath = projectIdentifier.getProjectPath();
        return new DefaultProject(name, rootDir, projectPath);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rootDir";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "projectPath";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "gradleProject";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ideaModule";
                break;
            }
        }
        objectArray2[1] = "com/intellij/gradle/toolingExtension/modelAction/DefaultProject";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "convertGradleProject";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "convertIdeaProject";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

