/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.searchEverywhereMl.semantics.utils;

import com.intellij.searchEverywhereMl.semantics.utils.InvalidTokenNotificationManager;
import com.intellij.searchEverywhereMl.semantics.utils.RequestResult;
import com.intellij.util.io.HttpRequests;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000\u0010\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\u001a\u0018\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0003H\u0000\u00a8\u0006\u0005"}, d2={"sendRequest", "Lcom/intellij/searchEverywhereMl/semantics/utils/RequestResult;", "url", "", "requestBody", "intellij.searchEverywhereMl.semantics"})
public final class RequestsKt {
    @NotNull
    public static final RequestResult sendRequest(@NotNull String url, @NotNull String requestBody) {
        RequestResult requestResult;
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        Intrinsics.checkNotNullParameter((Object)requestBody, (String)"requestBody");
        String string = new URL(url).toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        String parsedUrl = string;
        try {
            String result = (String)HttpRequests.post((String)parsedUrl, (String)"application/json; charset=UTF-8").tuner(RequestsKt::sendRequest$lambda$0).connect(arg_0 -> RequestsKt.sendRequest$lambda$1(requestBody, arg_0));
            Intrinsics.checkNotNull((Object)result);
            requestResult = new RequestResult.Success(result);
        }
        catch (HttpRequests.HttpStatusException e) {
            if (e.getStatusCode() == 401) {
                InvalidTokenNotificationManager.Companion.getInstance().showNotification();
            }
            requestResult = new RequestResult.Error(e.getMessage());
        }
        catch (Exception e) {
            requestResult = new RequestResult.Error(e.getMessage());
        }
        return requestResult;
    }

    private static final void sendRequest$lambda$0(URLConnection it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        it.setRequestProperty("Accept", "application/json");
        it.setDoInput(true);
        it.setDoOutput(true);
    }

    private static final String sendRequest$lambda$1(String $requestBody, HttpRequests.Request request) {
        Intrinsics.checkNotNullParameter((Object)$requestBody, (String)"$requestBody");
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        request.write($requestBody);
        URLConnection uRLConnection = request.getConnection();
        Intrinsics.checkNotNull((Object)uRLConnection, (String)"null cannot be cast to non-null type java.net.HttpURLConnection");
        int responseCode = ((HttpURLConnection)uRLConnection).getResponseCode();
        return responseCode == 200 ? request.readString() : "";
    }
}

