/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.testIntegration;

import com.intellij.execution.junit.JUnitTestFramework;
import com.intellij.execution.junit.JUnitUtil;
import com.intellij.ide.fileTemplates.FileTemplateDescriptor;
import com.intellij.lang.Language;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.IncorrectOperationException;
import icons.JetgroovyIcons;
import java.io.File;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.GroovyLanguage;
import org.jetbrains.plugins.groovy.bundled.BundledGroovy;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElementFactory;

public class GroovyTestFramework
extends JUnitTestFramework {
    private static final Logger LOG = Logger.getInstance(GroovyTestFramework.class);

    protected String getMarkerClassFQName() {
        return "groovy.util.GroovyTestCase";
    }

    protected boolean isTestClass(PsiClass clazz, boolean canBePotential) {
        return clazz.getLanguage() == GroovyLanguage.INSTANCE && InheritanceUtil.isInheritor((PsiClass)clazz, (String)"groovy.util.GroovyTestCase");
    }

    protected PsiMethod findSetUpMethod(@NotNull PsiClass clazz) {
        if (clazz == null) {
            GroovyTestFramework.$$$reportNull$$$0(0);
        }
        if (!this.isTestClass(clazz, false)) {
            return null;
        }
        for (PsiMethod method : clazz.getMethods()) {
            if (!method.getName().equals("setUp")) continue;
            return method;
        }
        return null;
    }

    protected PsiMethod findTearDownMethod(@NotNull PsiClass clazz) {
        if (clazz == null) {
            GroovyTestFramework.$$$reportNull$$$0(1);
        }
        if (!this.isTestClass(clazz, false)) {
            return null;
        }
        for (PsiMethod method : clazz.getMethods()) {
            if (!method.getName().equals("tearDown")) continue;
            return method;
        }
        return null;
    }

    protected PsiMethod findOrCreateSetUpMethod(PsiClass clazz) throws IncorrectOperationException {
        PsiMethod inClass;
        PsiMethod baseMethod;
        LOG.assertTrue(clazz.getLanguage() == GroovyLanguage.INSTANCE);
        GroovyPsiElementFactory factory = GroovyPsiElementFactory.getInstance(clazz.getProject());
        PsiMethod patternMethod = this.createSetUpPatternMethod(factory);
        PsiClass baseClass = clazz.getSuperClass();
        if (baseClass != null && (baseMethod = baseClass.findMethodBySignature(patternMethod, false)) != null && baseMethod.hasModifierProperty("public")) {
            PsiUtil.setModifierProperty((PsiModifierListOwner)patternMethod, (String)"protected", (boolean)false);
            PsiUtil.setModifierProperty((PsiModifierListOwner)patternMethod, (String)"public", (boolean)true);
        }
        if ((inClass = clazz.findMethodBySignature(patternMethod, false)) == null) {
            PsiMethod testMethod = JUnitUtil.findFirstTestMethod((PsiClass)clazz);
            if (testMethod != null) {
                return (PsiMethod)clazz.addBefore((PsiElement)patternMethod, (PsiElement)testMethod);
            }
            return (PsiMethod)clazz.add((PsiElement)patternMethod);
        }
        if (inClass.getBody() == null) {
            return (PsiMethod)inClass.replace((PsiElement)patternMethod);
        }
        return inClass;
    }

    @NotNull
    public String getName() {
        return "Groovy JUnit";
    }

    @NotNull
    public Icon getIcon() {
        Icon icon = JetgroovyIcons.Groovy.Groovy_16x16;
        if (icon == null) {
            GroovyTestFramework.$$$reportNull$$$0(2);
        }
        return icon;
    }

    public String getLibraryPath() {
        return ((File)BundledGroovy.getBundledGroovyFile().get()).getAbsolutePath();
    }

    public String getDefaultSuperClass() {
        return "groovy.util.GroovyTestCase";
    }

    public FileTemplateDescriptor getTestClassFileTemplateDescriptor() {
        return new FileTemplateDescriptor("Groovy JUnit Test Case.groovy");
    }

    public FileTemplateDescriptor getSetUpMethodFileTemplateDescriptor() {
        return new FileTemplateDescriptor("Groovy JUnit SetUp Method.groovy");
    }

    public FileTemplateDescriptor getTearDownMethodFileTemplateDescriptor() {
        return new FileTemplateDescriptor("Groovy JUnit TearDown Method.groovy");
    }

    @NotNull
    public FileTemplateDescriptor getTestMethodFileTemplateDescriptor() {
        return new FileTemplateDescriptor("Groovy JUnit Test Method.groovy");
    }

    @NotNull
    public Language getLanguage() {
        GroovyLanguage groovyLanguage = GroovyLanguage.INSTANCE;
        if (groovyLanguage == null) {
            GroovyTestFramework.$$$reportNull$$$0(3);
        }
        return groovyLanguage;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 3 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "clazz";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/groovy/testIntegration/GroovyTestFramework";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/groovy/testIntegration/GroovyTestFramework";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getIcon";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getLanguage";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "findSetUpMethod";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "findTearDownMethod";
                break;
            }
            case 2: 
            case 3: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 3 -> new IllegalStateException(string);
        };
    }
}

