/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.stubs;

import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.extensions.AreaInstance;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.impl.java.stubs.index.JavaStubIndexKeys;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.PsiShortNamesCache;
import com.intellij.psi.stubs.StubIndex;
import com.intellij.psi.stubs.StubIndexImpl;
import com.intellij.psi.stubs.StubIndexKey;
import com.intellij.util.ArrayFactory;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.Processor;
import com.intellij.util.Processors;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.indexing.IdFilter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.lang.psi.GroovyFile;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrField;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrAnnotationMethod;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrMethod;
import org.jetbrains.plugins.groovy.lang.psi.impl.search.GrSourceFilterScope;
import org.jetbrains.plugins.groovy.lang.psi.stubs.index.GrAnnotationMethodNameIndex;
import org.jetbrains.plugins.groovy.lang.psi.stubs.index.GrFieldNameIndex;
import org.jetbrains.plugins.groovy.lang.psi.stubs.index.GrFullClassNameStringIndex;
import org.jetbrains.plugins.groovy.lang.psi.stubs.index.GrFullScriptNameStringIndex;
import org.jetbrains.plugins.groovy.lang.psi.stubs.index.GrMethodNameIndex;
import org.jetbrains.plugins.groovy.lang.psi.stubs.index.GrScriptClassNameIndex;

public class GroovyShortNamesCache
extends PsiShortNamesCache {
    private final Project myProject;
    private volatile TopLevelFQNames myTopLevelFQNames;
    private volatile TopLevelFQNames myTopLevelScriptFQNames;

    public GroovyShortNamesCache(Project project) {
        this.myProject = project;
    }

    public static GroovyShortNamesCache getGroovyShortNamesCache(Project project) {
        return Objects.requireNonNull((GroovyShortNamesCache)((Object)ContainerUtil.findInstance((Iterable)PsiShortNamesCache.EP_NAME.getExtensionList((AreaInstance)project), GroovyShortNamesCache.class)));
    }

    @Nullable
    private TopLevelFQNames getTopLevelNames() {
        TopLevelFQNames scriptTopLevelFQNames;
        TopLevelFQNames topLevelFQNames = this.myTopLevelFQNames;
        StubIndexImpl stubIndex = (StubIndexImpl)StubIndex.getInstance();
        long timestamp = stubIndex.getIndexModificationStamp(GrFullClassNameStringIndex.KEY, this.myProject) + stubIndex.getIndexModificationStamp(GrFullScriptNameStringIndex.KEY, this.myProject);
        if (topLevelFQNames != null && topLevelFQNames.timestamp == timestamp) {
            return topLevelFQNames.useful ? topLevelFQNames : null;
        }
        TopLevelFQNames classTopLevelFQNames = new TopLevelFQNames(GrFullClassNameStringIndex.KEY, this.myProject);
        this.myTopLevelScriptFQNames = scriptTopLevelFQNames = new TopLevelFQNames(GrFullScriptNameStringIndex.KEY, this.myProject);
        this.myTopLevelFQNames = topLevelFQNames = classTopLevelFQNames.merge(scriptTopLevelFQNames);
        return topLevelFQNames;
    }

    @Nullable
    private TopLevelFQNames getScriptTopLevelNames() {
        TopLevelFQNames names = (TopLevelFQNames)ReadAction.compute(() -> this.getTopLevelNames());
        if (names == null) {
            return null;
        }
        TopLevelFQNames topLevelFQNames = this.myTopLevelScriptFQNames;
        StubIndexImpl stubIndex = (StubIndexImpl)StubIndex.getInstance();
        return topLevelFQNames != null && topLevelFQNames.useful && topLevelFQNames.timestamp == stubIndex.getIndexModificationStamp(GrFullScriptNameStringIndex.KEY, this.myProject) ? topLevelFQNames : null;
    }

    @NotNull
    private static String toTopLevelName(@NotNull String fqName) {
        int index;
        if (fqName == null) {
            GroovyShortNamesCache.$$$reportNull$$$0(0);
        }
        return (index = fqName.indexOf(46)) >= 1 ? fqName.substring(0, index) : "";
    }

    @NotNull
    public @NotNull PsiClass @NotNull [] getClassesByName(@NotNull @NonNls String name, @NotNull GlobalSearchScope scope) {
        if (name == null) {
            GroovyShortNamesCache.$$$reportNull$$$0(1);
        }
        if (scope == null) {
            GroovyShortNamesCache.$$$reportNull$$$0(2);
        }
        SmartList allClasses = new SmartList();
        this.processClassesWithName(name, (Processor<? super PsiClass>)Processors.cancelableCollectProcessor((Collection)allClasses), scope, null);
        if (allClasses.isEmpty()) {
            if (PsiClass.EMPTY_ARRAY == null) {
                GroovyShortNamesCache.$$$reportNull$$$0(3);
            }
            return PsiClass.EMPTY_ARRAY;
        }
        PsiClass[] psiClassArray = allClasses.toArray(PsiClass.EMPTY_ARRAY);
        if (psiClassArray == null) {
            GroovyShortNamesCache.$$$reportNull$$$0(4);
        }
        return psiClassArray;
    }

    public List<PsiClass> getScriptClassesByFQName(String name, GlobalSearchScope scope, boolean srcOnly) {
        String topLevelName;
        TopLevelFQNames names = this.getScriptTopLevelNames();
        if (names != null && !names.names.contains(topLevelName = GroovyShortNamesCache.toTopLevelName(name))) {
            return Collections.emptyList();
        }
        Object actualScope = srcOnly ? new GrSourceFilterScope(scope) : scope;
        return ContainerUtil.map((Collection)StubIndex.getElements(GrFullScriptNameStringIndex.KEY, (Object)name, (Project)this.myProject, (GlobalSearchScope)actualScope, GroovyFile.class), o -> Objects.requireNonNull(o.getScriptClass()));
    }

    @NotNull
    public List<PsiClass> getClassesByFQName(String name, GlobalSearchScope scope, boolean inSource) {
        String topLevelName;
        TopLevelFQNames names = (TopLevelFQNames)ReadAction.compute(() -> this.getTopLevelNames());
        if (names != null && !names.names.contains(topLevelName = GroovyShortNamesCache.toTopLevelName(name))) {
            List<PsiClass> list = Collections.emptyList();
            if (list == null) {
                GroovyShortNamesCache.$$$reportNull$$$0(5);
            }
            return list;
        }
        if (DumbService.getInstance((Project)this.myProject).isAlternativeResolveEnabled()) {
            List<PsiClass> list = Collections.emptyList();
            if (list == null) {
                GroovyShortNamesCache.$$$reportNull$$$0(6);
            }
            return list;
        }
        Object actualScope = inSource ? new GrSourceFilterScope(scope) : scope;
        List list = (List)ReadAction.compute(() -> this.lambda$getClassesByFQName$3(name, (GlobalSearchScope)actualScope, scope, inSource));
        if (list == null) {
            GroovyShortNamesCache.$$$reportNull$$$0(7);
        }
        return list;
    }

    @NotNull
    public @NotNull String @NotNull [] getAllClassNames() {
        String[] stringArray = ArrayUtilRt.toStringArray((Collection)StubIndex.getInstance().getAllKeys(GrScriptClassNameIndex.KEY, this.myProject));
        if (stringArray == null) {
            GroovyShortNamesCache.$$$reportNull$$$0(8);
        }
        return stringArray;
    }

    @NotNull
    public @NotNull PsiMethod @NotNull [] getMethodsByName(@NonNls @NotNull String name, @NotNull GlobalSearchScope scope) {
        if (name == null) {
            GroovyShortNamesCache.$$$reportNull$$$0(9);
        }
        if (scope == null) {
            GroovyShortNamesCache.$$$reportNull$$$0(10);
        }
        Collection methods = StubIndex.getElements(GrMethodNameIndex.KEY, (Object)name, (Project)this.myProject, (GlobalSearchScope)new GrSourceFilterScope(scope), GrMethod.class);
        Collection annMethods = StubIndex.getElements(GrAnnotationMethodNameIndex.KEY, (Object)name, (Project)this.myProject, (GlobalSearchScope)new GrSourceFilterScope(scope), GrAnnotationMethod.class);
        if (methods.isEmpty() && annMethods.isEmpty()) {
            if (PsiMethod.EMPTY_ARRAY == null) {
                GroovyShortNamesCache.$$$reportNull$$$0(11);
            }
            return PsiMethod.EMPTY_ARRAY;
        }
        PsiMethod[] psiMethodArray = (PsiMethod[])ArrayUtil.mergeCollections((Collection)annMethods, (Collection)methods, (ArrayFactory)PsiMethod.ARRAY_FACTORY);
        if (psiMethodArray == null) {
            GroovyShortNamesCache.$$$reportNull$$$0(12);
        }
        return psiMethodArray;
    }

    public boolean processMethodsWithName(@NonNls @NotNull String name, @NotNull GlobalSearchScope scope, @NotNull Processor<? super PsiMethod> processor) {
        if (name == null) {
            GroovyShortNamesCache.$$$reportNull$$$0(13);
        }
        if (scope == null) {
            GroovyShortNamesCache.$$$reportNull$$$0(14);
        }
        if (processor == null) {
            GroovyShortNamesCache.$$$reportNull$$$0(15);
        }
        return this.processMethodsWithName(name, processor, scope, null);
    }

    public boolean processMethodsWithName(@NonNls @NotNull String name, @NotNull Processor<? super PsiMethod> processor, @NotNull GlobalSearchScope scope, @Nullable IdFilter filter2) {
        if (name == null) {
            GroovyShortNamesCache.$$$reportNull$$$0(16);
        }
        if (processor == null) {
            GroovyShortNamesCache.$$$reportNull$$$0(17);
        }
        if (scope == null) {
            GroovyShortNamesCache.$$$reportNull$$$0(18);
        }
        GrSourceFilterScope filterScope = new GrSourceFilterScope(scope);
        return StubIndex.getInstance().processElements(GrMethodNameIndex.KEY, (Object)name, this.myProject, (GlobalSearchScope)filterScope, filter2, GrMethod.class, processor) && StubIndex.getInstance().processElements(GrAnnotationMethodNameIndex.KEY, (Object)name, this.myProject, (GlobalSearchScope)filterScope, filter2, GrAnnotationMethod.class, processor);
    }

    @NotNull
    public @NotNull PsiMethod @NotNull [] getMethodsByNameIfNotMoreThan(@NonNls @NotNull String name, @NotNull GlobalSearchScope scope, int maxCount) {
        if (name == null) {
            GroovyShortNamesCache.$$$reportNull$$$0(19);
        }
        if (scope == null) {
            GroovyShortNamesCache.$$$reportNull$$$0(20);
        }
        PsiMethod[] psiMethodArray = this.getMethodsByName(name, scope);
        if (psiMethodArray == null) {
            GroovyShortNamesCache.$$$reportNull$$$0(21);
        }
        return psiMethodArray;
    }

    @NotNull
    public @NotNull PsiField @NotNull [] getFieldsByNameIfNotMoreThan(@NonNls @NotNull String name, @NotNull GlobalSearchScope scope, int maxCount) {
        if (name == null) {
            GroovyShortNamesCache.$$$reportNull$$$0(22);
        }
        if (scope == null) {
            GroovyShortNamesCache.$$$reportNull$$$0(23);
        }
        PsiField[] psiFieldArray = this.getFieldsByName(name, scope);
        if (psiFieldArray == null) {
            GroovyShortNamesCache.$$$reportNull$$$0(24);
        }
        return psiFieldArray;
    }

    @NotNull
    public @NotNull String @NotNull [] getAllMethodNames() {
        Collection keys = StubIndex.getInstance().getAllKeys(GrMethodNameIndex.KEY, this.myProject);
        keys.addAll(StubIndex.getInstance().getAllKeys(GrAnnotationMethodNameIndex.KEY, this.myProject));
        String[] stringArray = ArrayUtilRt.toStringArray((Collection)keys);
        if (stringArray == null) {
            GroovyShortNamesCache.$$$reportNull$$$0(25);
        }
        return stringArray;
    }

    @NotNull
    public @NotNull PsiField @NotNull [] getFieldsByName(@NotNull @NonNls String name, @NotNull GlobalSearchScope scope) {
        Collection fields;
        if (name == null) {
            GroovyShortNamesCache.$$$reportNull$$$0(26);
        }
        if (scope == null) {
            GroovyShortNamesCache.$$$reportNull$$$0(27);
        }
        if ((fields = StubIndex.getElements(GrFieldNameIndex.KEY, (Object)name, (Project)this.myProject, (GlobalSearchScope)new GrSourceFilterScope(scope), GrField.class)).isEmpty()) {
            if (PsiField.EMPTY_ARRAY == null) {
                GroovyShortNamesCache.$$$reportNull$$$0(28);
            }
            return PsiField.EMPTY_ARRAY;
        }
        PsiField[] psiFieldArray = fields.toArray(PsiField.EMPTY_ARRAY);
        if (psiFieldArray == null) {
            GroovyShortNamesCache.$$$reportNull$$$0(29);
        }
        return psiFieldArray;
    }

    @NotNull
    public @NotNull String @NotNull [] getAllFieldNames() {
        Collection fields = StubIndex.getInstance().getAllKeys(GrFieldNameIndex.KEY, this.myProject);
        String[] stringArray = ArrayUtilRt.toStringArray((Collection)fields);
        if (stringArray == null) {
            GroovyShortNamesCache.$$$reportNull$$$0(30);
        }
        return stringArray;
    }

    public boolean processFieldsWithName(@NotNull String name, @NotNull Processor<? super PsiField> processor, @NotNull GlobalSearchScope scope, @Nullable IdFilter filter2) {
        if (name == null) {
            GroovyShortNamesCache.$$$reportNull$$$0(31);
        }
        if (processor == null) {
            GroovyShortNamesCache.$$$reportNull$$$0(32);
        }
        if (scope == null) {
            GroovyShortNamesCache.$$$reportNull$$$0(33);
        }
        return StubIndex.getInstance().processElements(GrFieldNameIndex.KEY, (Object)name, this.myProject, (GlobalSearchScope)new GrSourceFilterScope(scope), filter2, GrField.class, processor);
    }

    public boolean processClassesWithName(@NotNull String name, @NotNull Processor<? super PsiClass> processor, @NotNull GlobalSearchScope scope, @Nullable IdFilter filter2) {
        if (name == null) {
            GroovyShortNamesCache.$$$reportNull$$$0(34);
        }
        if (processor == null) {
            GroovyShortNamesCache.$$$reportNull$$$0(35);
        }
        if (scope == null) {
            GroovyShortNamesCache.$$$reportNull$$$0(36);
        }
        return this.processClasses(name, processor, scope, filter2) && this.processScriptClasses(name, processor, scope, filter2);
    }

    private boolean processClasses(@NotNull String name, @NotNull Processor<? super PsiClass> processor, @NotNull GlobalSearchScope scope, @Nullable IdFilter filter2) {
        if (name == null) {
            GroovyShortNamesCache.$$$reportNull$$$0(37);
        }
        if (processor == null) {
            GroovyShortNamesCache.$$$reportNull$$$0(38);
        }
        if (scope == null) {
            GroovyShortNamesCache.$$$reportNull$$$0(39);
        }
        return StubIndex.getInstance().processElements(JavaStubIndexKeys.CLASS_SHORT_NAMES, (Object)name, this.myProject, (GlobalSearchScope)new GrSourceFilterScope(scope), filter2, PsiClass.class, processor);
    }

    private boolean processScriptClasses(@NotNull String name, @NotNull Processor<? super PsiClass> processor, @NotNull GlobalSearchScope scope, @Nullable IdFilter filter2) {
        if (name == null) {
            GroovyShortNamesCache.$$$reportNull$$$0(40);
        }
        if (processor == null) {
            GroovyShortNamesCache.$$$reportNull$$$0(41);
        }
        if (scope == null) {
            GroovyShortNamesCache.$$$reportNull$$$0(42);
        }
        for (GroovyFile file : StubIndex.getElements(GrScriptClassNameIndex.KEY, (Object)name, (Project)this.myProject, (GlobalSearchScope)new GrSourceFilterScope(scope), (IdFilter)filter2, GroovyFile.class)) {
            PsiClass aClass = file.getScriptClass();
            if (aClass == null || processor.process((Object)aClass)) continue;
            return true;
        }
        return true;
    }

    private /* synthetic */ List lambda$getClassesByFQName$3(String name, GlobalSearchScope actualScope, GlobalSearchScope scope, boolean inSource) throws RuntimeException {
        ArrayList<PsiClass> result2 = new ArrayList<PsiClass>();
        result2.addAll(StubIndex.getElements(GrFullClassNameStringIndex.KEY, (Object)name, (Project)this.myProject, (GlobalSearchScope)actualScope, PsiClass.class));
        result2.addAll(this.getScriptClassesByFQName(name, scope, inSource));
        return result2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3, 4, 5, 6, 7, 8, 11, 12, 21, 24, 25, 28, 29, 30 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fqName";
                break;
            }
            case 1: 
            case 9: 
            case 13: 
            case 16: 
            case 19: 
            case 22: 
            case 26: 
            case 31: 
            case 34: 
            case 37: 
            case 40: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 2: 
            case 10: 
            case 14: 
            case 18: 
            case 20: 
            case 23: 
            case 27: 
            case 33: 
            case 36: 
            case 39: 
            case 42: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 11: 
            case 12: 
            case 21: 
            case 24: 
            case 25: 
            case 28: 
            case 29: 
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/groovy/lang/stubs/GroovyShortNamesCache";
                break;
            }
            case 15: 
            case 17: 
            case 32: 
            case 35: 
            case 38: 
            case 41: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/groovy/lang/stubs/GroovyShortNamesCache";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getClassesByName";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getClassesByFQName";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllClassNames";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getMethodsByName";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "getMethodsByNameIfNotMoreThan";
                break;
            }
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "getFieldsByNameIfNotMoreThan";
                break;
            }
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllMethodNames";
                break;
            }
            case 28: 
            case 29: {
                objectArray = objectArray2;
                objectArray2[1] = "getFieldsByName";
                break;
            }
            case 30: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllFieldNames";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "toTopLevelName";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getClassesByName";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 11: 
            case 12: 
            case 21: 
            case 24: 
            case 25: 
            case 28: 
            case 29: 
            case 30: {
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getMethodsByName";
                break;
            }
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "processMethodsWithName";
                break;
            }
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "getMethodsByNameIfNotMoreThan";
                break;
            }
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "getFieldsByNameIfNotMoreThan";
                break;
            }
            case 26: 
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "getFieldsByName";
                break;
            }
            case 31: 
            case 32: 
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "processFieldsWithName";
                break;
            }
            case 34: 
            case 35: 
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "processClassesWithName";
                break;
            }
            case 37: 
            case 38: 
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "processClasses";
                break;
            }
            case 40: 
            case 41: 
            case 42: {
                objectArray = objectArray;
                objectArray[2] = "processScriptClasses";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3, 4, 5, 6, 7, 8, 11, 12, 21, 24, 25, 28, 29, 30 -> new IllegalStateException(string);
        };
    }

    private static class TopLevelFQNames {
        final long timestamp;
        @NotNull
        final Set<String> names;
        final boolean useful;

        private TopLevelFQNames(@NotNull StubIndexKey<String, ?> indexKey, @NotNull Project project) {
            if (indexKey == null) {
                TopLevelFQNames.$$$reportNull$$$0(0);
            }
            if (project == null) {
                TopLevelFQNames.$$$reportNull$$$0(1);
            }
            StubIndexImpl stubIndex = (StubIndexImpl)StubIndex.getInstance();
            this.timestamp = stubIndex.getIndexModificationStamp(indexKey, project);
            HashSet names = new HashSet();
            Processor processor = fqName -> {
                ProgressManager.checkCanceled();
                String topLevelName = GroovyShortNamesCache.toTopLevelName(fqName);
                return !names.add(topLevelName) || names.size() <= 500;
            };
            boolean useful = stubIndex.processAllKeys(indexKey, project, processor);
            this.names = useful ? names : Collections.emptySet();
            this.useful = useful;
        }

        /*
         * WARNING - void declaration
         */
        private TopLevelFQNames(long timestamp, @NotNull Set<String> names, boolean bl) {
            void useful;
            if (names == null) {
                TopLevelFQNames.$$$reportNull$$$0(2);
            }
            this.timestamp = timestamp;
            this.names = names;
            this.useful = useful;
        }

        public TopLevelFQNames merge(TopLevelFQNames other) {
            Set<String> set;
            boolean mergedUseful;
            boolean bl = mergedUseful = this.useful && other.useful;
            if (mergedUseful) {
                set = new HashSet<String>(this.names);
                set.addAll(other.names);
            } else {
                set = Collections.emptySet();
            }
            return new TopLevelFQNames(this.timestamp + other.timestamp, set, mergedUseful);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "indexKey";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "project";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[0] = "names";
                    break;
                }
            }
            objectArray[1] = "org/jetbrains/plugins/groovy/lang/stubs/GroovyShortNamesCache$TopLevelFQNames";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

