/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.psi.impl;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.pom.java.LanguageLevel;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypes;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.LazyKt;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import kotlin.Lazy;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElement;
import org.jetbrains.plugins.groovy.lang.psi.api.GrFunctionalExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.GroovyResolveResult;
import org.jetbrains.plugins.groovy.lang.psi.api.signatures.GrSignature;
import org.jetbrains.plugins.groovy.lang.psi.impl.GrLiteralClassType;
import org.jetbrains.plugins.groovy.lang.psi.impl.signatures.CurryKt;
import org.jetbrains.plugins.groovy.lang.psi.impl.signatures.GrClosureSignatureUtil;
import org.jetbrains.plugins.groovy.lang.psi.impl.statements.expressions.TypesUtil;

public final class GrClosureType
extends GrLiteralClassType {
    private final List<GrSignature> mySignatures;
    private final Lazy<PsiType[]> myTypeArgs;
    private static boolean ourForbidClosureInference;

    private GrClosureType(@NotNull LanguageLevel languageLevel, @NotNull GlobalSearchScope scope, @NotNull JavaPsiFacade facade, @NotNull List<GrSignature> signatures2, boolean shouldInferTypeParameters) {
        if (languageLevel == null) {
            GrClosureType.$$$reportNull$$$0(0);
        }
        if (scope == null) {
            GrClosureType.$$$reportNull$$$0(1);
        }
        if (facade == null) {
            GrClosureType.$$$reportNull$$$0(2);
        }
        if (signatures2 == null) {
            GrClosureType.$$$reportNull$$$0(3);
        }
        super(languageLevel, scope, facade);
        this.mySignatures = signatures2;
        this.myTypeArgs = shouldInferTypeParameters ? LazyKt.recursionSafeLazy(null, this::inferParameters) : kotlin.LazyKt.lazyOf((Object)PsiType.EMPTY_ARRAY);
    }

    private GrClosureType(@NotNull LanguageLevel level, @NotNull GlobalSearchScope scope, @NotNull JavaPsiFacade facade, @NotNull List<GrSignature> signatures2, @Nullable Lazy<PsiType[]> typeArgs) {
        if (level == null) {
            GrClosureType.$$$reportNull$$$0(4);
        }
        if (scope == null) {
            GrClosureType.$$$reportNull$$$0(5);
        }
        if (facade == null) {
            GrClosureType.$$$reportNull$$$0(6);
        }
        if (signatures2 == null) {
            GrClosureType.$$$reportNull$$$0(7);
        }
        super(level, scope, facade);
        this.mySignatures = signatures2;
        this.myTypeArgs = typeArgs;
    }

    public int getParameterCount() {
        PsiClass resolved = this.resolve();
        return resolved != null && resolved.getTypeParameters().length == 1 ? 1 : 0;
    }

    public PsiType @NotNull [] getParameters() {
        if (ourForbidClosureInference) {
            throw new IllegalStateException();
        }
        PsiType[] psiTypeArray = (PsiType[])ObjectUtils.notNull((Object)((PsiType[])this.myTypeArgs.getValue()), (Object)PsiType.EMPTY_ARRAY);
        if (psiTypeArray == null) {
            GrClosureType.$$$reportNull$$$0(8);
        }
        return psiTypeArray;
    }

    public PsiType @NotNull [] inferParameters() {
        PsiClass psiClass = this.resolve();
        if (psiClass != null && psiClass.getTypeParameters().length == 1) {
            PsiType type2 = GrClosureSignatureUtil.getReturnType(this.mySignatures);
            if (type2 == PsiTypes.nullType() || type2 == null) {
                PsiType[] psiTypeArray = new PsiType[]{null};
                if (psiTypeArray == null) {
                    GrClosureType.$$$reportNull$$$0(9);
                }
                return psiTypeArray;
            }
            PsiType[] psiTypeArray = new PsiType[]{TypesUtil.boxPrimitiveType(type2, this.getPsiManager(), this.getResolveScope(), true)};
            if (psiTypeArray == null) {
                GrClosureType.$$$reportNull$$$0(10);
            }
            return psiTypeArray;
        }
        if (PsiType.EMPTY_ARRAY == null) {
            GrClosureType.$$$reportNull$$$0(11);
        }
        return PsiType.EMPTY_ARRAY;
    }

    @Override
    @NotNull
    protected String getJavaClassName() {
        return "groovy.lang.Closure";
    }

    @Override
    @NotNull
    public PsiClassType rawType() {
        PsiType[] typeArgs = (PsiType[])this.myTypeArgs.getValue();
        if (typeArgs != null && typeArgs.length == 0) {
            GrClosureType grClosureType = this;
            if (grClosureType == null) {
                GrClosureType.$$$reportNull$$$0(12);
            }
            return grClosureType;
        }
        return new GrClosureType(this.getLanguageLevel(), this.getResolveScope(), this.myFacade, this.mySignatures, false);
    }

    public boolean isValid() {
        return ContainerUtil.all(this.mySignatures, GrSignature::isValid);
    }

    public boolean equals(Object obj) {
        if (obj instanceof GrClosureType) {
            return Comparing.equal(this.mySignatures, ((GrClosureType)((Object)obj)).mySignatures);
        }
        return super.equals(obj);
    }

    @NotNull
    public PsiClassType setLanguageLevel(@NotNull LanguageLevel languageLevel) {
        if (languageLevel == null) {
            GrClosureType.$$$reportNull$$$0(13);
        }
        return new GrClosureType(languageLevel, this.myScope, this.myFacade, this.mySignatures, this.myTypeArgs);
    }

    @NotNull
    public static GrClosureType create(@NotNull Iterable<? extends GroovyResolveResult> results, @NotNull GroovyPsiElement context) {
        if (results == null) {
            GrClosureType.$$$reportNull$$$0(14);
        }
        if (context == null) {
            GrClosureType.$$$reportNull$$$0(15);
        }
        ArrayList<GrSignature> signatures2 = new ArrayList<GrSignature>();
        for (GroovyResolveResult groovyResolveResult : results) {
            if (!(groovyResolveResult.getElement() instanceof PsiMethod)) continue;
            signatures2.add(GrClosureSignatureUtil.createSignature((PsiMethod)groovyResolveResult.getElement(), groovyResolveResult.getSubstitutor()));
        }
        GlobalSearchScope resolveScope = context.getResolveScope();
        JavaPsiFacade javaPsiFacade = JavaPsiFacade.getInstance((Project)context.getProject());
        return GrClosureType.create(signatures2, resolveScope, javaPsiFacade, LanguageLevel.JDK_1_5, true);
    }

    public static GrClosureType create(@NotNull GrFunctionalExpression expression, boolean shouldInferTypeParameters) {
        if (expression == null) {
            GrClosureType.$$$reportNull$$$0(16);
        }
        GrSignature signature = GrClosureSignatureUtil.createSignature(expression);
        GlobalSearchScope resolveScope = expression.getResolveScope();
        JavaPsiFacade facade = JavaPsiFacade.getInstance((Project)expression.getProject());
        return GrClosureType.create(Collections.singletonList(signature), resolveScope, facade, LanguageLevel.JDK_1_5, shouldInferTypeParameters);
    }

    @NotNull
    public static GrClosureType create(@NotNull List<GrSignature> signatures2, GlobalSearchScope scope, JavaPsiFacade facade, @NotNull LanguageLevel languageLevel, boolean shouldInferTypeParameters) {
        if (signatures2 == null) {
            GrClosureType.$$$reportNull$$$0(17);
        }
        if (languageLevel == null) {
            GrClosureType.$$$reportNull$$$0(18);
        }
        return new GrClosureType(languageLevel, scope, facade, signatures2, shouldInferTypeParameters);
    }

    @Nullable
    public PsiType curry(PsiType @NotNull [] args, int position, @NotNull PsiElement context) {
        List<GrSignature> curried;
        if (context == null) {
            GrClosureType.$$$reportNull$$$0(19);
        }
        if (args == null) {
            GrClosureType.$$$reportNull$$$0(20);
        }
        if ((curried = CurryKt.curry(this.mySignatures, args, position, context)).isEmpty()) {
            return null;
        }
        return new GrClosureType(this.myLanguageLevel, this.myScope, this.myFacade, curried, this.myTypeArgs);
    }

    @NotNull
    public List<GrSignature> getSignatures() {
        List<GrSignature> list = this.mySignatures;
        if (list == null) {
            GrClosureType.$$$reportNull$$$0(21);
        }
        return list;
    }

    @NonNls
    public String toString() {
        return "PsiType: Closure<*>";
    }

    @TestOnly
    public static void forbidClosureInference(@NotNull Runnable runnable) {
        if (runnable == null) {
            GrClosureType.$$$reportNull$$$0(22);
        }
        ourForbidClosureInference = true;
        try {
            runnable.run();
        }
        finally {
            ourForbidClosureInference = false;
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 8, 9, 10, 11, 12, 21 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "languageLevel";
                break;
            }
            case 1: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
            case 2: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "facade";
                break;
            }
            case 3: 
            case 7: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "signatures";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "level";
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/groovy/lang/psi/impl/GrClosureType";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "results";
                break;
            }
            case 15: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "args";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runnable";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/groovy/lang/psi/impl/GrClosureType";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getParameters";
                break;
            }
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "inferParameters";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "rawType";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "getSignatures";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 21: {
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "setLanguageLevel";
                break;
            }
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "create";
                break;
            }
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "curry";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "forbidClosureInference";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 8, 9, 10, 11, 12, 21 -> new IllegalStateException(string);
        };
    }
}

