/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.folding;

import com.intellij.codeInsight.folding.JavaCodeFoldingSettings;
import com.intellij.codeInsight.folding.impl.JavaFoldingBuilderBase;
import com.intellij.lang.ASTNode;
import com.intellij.lang.folding.CustomFoldingBuilder;
import com.intellij.lang.folding.FoldingDescriptor;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.FoldingGroup;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.impl.source.tree.LeafPsiElement;
import com.intellij.psi.tree.IElementType;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.lang.groovydoc.parser.GroovyDocElementTypes;
import org.jetbrains.plugins.groovy.lang.lexer.GroovyTokenTypes;
import org.jetbrains.plugins.groovy.lang.lexer.TokenSets;
import org.jetbrains.plugins.groovy.lang.parser.GrBlockElementType;
import org.jetbrains.plugins.groovy.lang.parser.GroovyElementTypes;
import org.jetbrains.plugins.groovy.lang.parser.GroovyEmptyStubElementTypes;
import org.jetbrains.plugins.groovy.lang.parser.GroovyStubElementTypes;
import org.jetbrains.plugins.groovy.lang.psi.GroovyFile;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.blocks.GrCodeBlock;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.literals.GrString;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.literals.GrStringInjection;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.GrTypeDefinition;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.GrTypeDefinitionBody;
import org.jetbrains.plugins.groovy.lang.psi.api.toplevel.imports.GrImportStatement;
import org.jetbrains.plugins.groovy.lang.psi.impl.PsiImplUtil;
import org.jetbrains.plugins.groovy.lang.psi.util.GrStringUtil;

public class GroovyFoldingBuilder
extends CustomFoldingBuilder
implements DumbAware {
    protected void buildLanguageFoldRegions(@NotNull List<FoldingDescriptor> descriptors, @NotNull PsiElement root, @NotNull Document document, boolean quick) {
        if (descriptors == null) {
            GroovyFoldingBuilder.$$$reportNull$$$0(0);
        }
        if (root == null) {
            GroovyFoldingBuilder.$$$reportNull$$$0(1);
        }
        if (document == null) {
            GroovyFoldingBuilder.$$$reportNull$$$0(2);
        }
        GroovyFoldingBuilder.appendDescriptors(root, descriptors, new HashSet());
    }

    private static void appendDescriptors(PsiElement element, List<? super FoldingDescriptor> descriptors, Set<? super PsiElement> usedComments) {
        ASTNode node = element.getNode();
        if (node == null) {
            return;
        }
        IElementType type2 = node.getElementType();
        if ((TokenSets.BLOCK_SET.contains(type2) && !GroovyFoldingBuilder.isSingleHighLevelClassBody(element) || type2 == GroovyElementTypes.CLOSABLE_BLOCK) && GroovyFoldingBuilder.isMultiline(element)) {
            GroovyFoldingBuilder.collapseBlock(descriptors, element);
        }
        if (type2.equals(GroovyTokenTypes.mML_COMMENT) && GroovyFoldingBuilder.isMultiline(element) && GroovyFoldingBuilder.isWellEndedComment(element)) {
            descriptors.add((FoldingDescriptor)new FoldingDescriptor(node, node.getTextRange(), null, "/*...*/", Boolean.valueOf(GroovyFoldingBuilder.isFileHeader(node) && JavaCodeFoldingSettings.getInstance().isCollapseFileHeader()), Collections.emptySet()));
        }
        if (type2.equals(GroovyDocElementTypes.GROOVY_DOC_COMMENT) && GroovyFoldingBuilder.isMultiline(element) && GroovyFoldingBuilder.isWellEndedComment(element)) {
            descriptors.add((FoldingDescriptor)new FoldingDescriptor(node, node.getTextRange(), null, "/**...*/", Boolean.valueOf(GroovyFoldingBuilder.isFileHeader(node) ? JavaCodeFoldingSettings.getInstance().isCollapseFileHeader() : JavaCodeFoldingSettings.getInstance().isCollapseJavadocs()), Collections.emptySet()));
        }
        if (type2.equals(GroovyTokenTypes.mSL_COMMENT) && usedComments.add((PsiElement)element) && !GroovyFoldingBuilder.isCustomRegionElement((PsiElement)element)) {
            PsiElement end = null;
            for (PsiElement current = element.getNextSibling(); current != null; current = current.getNextSibling()) {
                if (PsiImplUtil.isWhiteSpaceOrNls(current)) continue;
                IElementType elementType = current.getNode().getElementType();
                if (elementType != GroovyTokenTypes.mSL_COMMENT || !usedComments.add((PsiElement)current) || GroovyFoldingBuilder.isCustomRegionElement((PsiElement)current)) break;
                end = current;
            }
            if (end != null) {
                TextRange range = new TextRange(element.getTextRange().getStartOffset(), end.getTextRange().getEndOffset());
                descriptors.add((FoldingDescriptor)new FoldingDescriptor(node, range, null, "...", Boolean.valueOf(GroovyFoldingBuilder.isFileHeader(node) ? JavaCodeFoldingSettings.getInstance().isCollapseFileHeader() : JavaCodeFoldingSettings.getInstance().isCollapseEndOfLineComments()), Collections.emptySet()));
            }
        }
        GroovyFoldingBuilder.addFoldingForStrings(descriptors, node);
        HashSet newUsedComments = new HashSet();
        for (PsiElement child = element.getFirstChild(); child != null; child = child.getNextSibling()) {
            GroovyFoldingBuilder.appendDescriptors(child, descriptors, newUsedComments);
        }
        if (element instanceof GroovyFile) {
            GroovyFoldingBuilder.processImports(descriptors, ((GroovyFile)element).getImportStatements());
        }
    }

    private static boolean isCollapseBlock(@NotNull ASTNode node) {
        PsiElement parent2;
        if (node == null) {
            GroovyFoldingBuilder.$$$reportNull$$$0(3);
        }
        IElementType type2 = node.getElementType();
        JavaCodeFoldingSettings settings = JavaCodeFoldingSettings.getInstance();
        if ((type2 instanceof GrBlockElementType || type2 == GroovyElementTypes.CONSTRUCTOR_BODY) && node.getTreeParent().getElementType() == GroovyStubElementTypes.METHOD) {
            return settings.isCollapseMethods();
        }
        if (type2 == GroovyElementTypes.CLOSABLE_BLOCK) {
            return settings.isCollapseAnonymousClasses();
        }
        if (type2 == GroovyEmptyStubElementTypes.CLASS_BODY && (parent2 = node.getPsi().getParent()) instanceof PsiClass) {
            if (parent2 instanceof PsiAnonymousClass) {
                return settings.isCollapseAnonymousClasses();
            }
            if (((PsiClass)parent2).getContainingClass() != null) {
                return settings.isCollapseInnerClasses();
            }
        }
        return false;
    }

    private static void collapseBlock(List<? super FoldingDescriptor> descriptors, @NotNull PsiElement psi) {
        int lineFeedCount;
        if (psi == null) {
            GroovyFoldingBuilder.$$$reportNull$$$0(4);
        }
        ASTNode node = psi.getNode();
        boolean collapse = GroovyFoldingBuilder.isCollapseBlock(node);
        if (psi instanceof GrCodeBlock && (lineFeedCount = StringUtil.countChars((CharSequence)psi.getText(), (char)'\n')) <= 2) {
            PsiElement lbrace = ((GrCodeBlock)psi).getLBrace();
            PsiElement rbrace = ((GrCodeBlock)psi).getRBrace();
            if (lbrace != null && rbrace != null) {
                PsiElement next = lbrace.getNextSibling();
                PsiElement prev = rbrace.getPrevSibling();
                if (PsiImplUtil.isWhiteSpaceOrNls(next) && PsiImplUtil.isWhiteSpaceOrNls(prev)) {
                    FoldingGroup group = FoldingGroup.newGroup((String)"block_group");
                    descriptors.add((FoldingDescriptor)new FoldingDescriptor(node, new TextRange(lbrace.getTextRange().getStartOffset(), next.getTextRange().getEndOffset()), group, "{", Boolean.valueOf(collapse), Collections.emptySet()));
                    descriptors.add((FoldingDescriptor)new FoldingDescriptor(node, new TextRange(prev.getTextRange().getStartOffset(), rbrace.getTextRange().getEndOffset()), group, "}", Boolean.valueOf(collapse), Collections.emptySet()));
                    return;
                }
            }
        }
        descriptors.add((FoldingDescriptor)new FoldingDescriptor(node, node.getTextRange(), null, "{...}", Boolean.valueOf(collapse), Collections.emptySet()));
    }

    private static boolean isSingleHighLevelClassBody(PsiElement element) {
        if (!(element instanceof GrTypeDefinitionBody)) {
            return false;
        }
        PsiElement parent2 = element.getParent();
        if (!(parent2 instanceof GrTypeDefinition)) {
            return false;
        }
        GrTypeDefinition clazz = (GrTypeDefinition)parent2;
        if (clazz.isAnonymous() || clazz.getContainingClass() != null) {
            return false;
        }
        PsiFile file = element.getContainingFile();
        return file instanceof GroovyFile && ((GroovyFile)file).getClasses().length == 1;
    }

    private static void addFoldingForStrings(List<? super FoldingDescriptor> descriptors, ASTNode node) {
        GrStringInjection injection;
        TextRange injectionRange;
        if (!GroovyFoldingBuilder.isMultiLineStringLiteral(node)) {
            return;
        }
        if (!node.getElementType().equals(GroovyElementTypes.GSTRING) && !node.getElementType().equals(GroovyElementTypes.REGEX)) {
            descriptors.add((FoldingDescriptor)new FoldingDescriptor(node, node.getTextRange(), null, GroovyFoldingBuilder.multiLineStringLiteralPlaceholder(node), Boolean.valueOf(false), Collections.emptySet()));
            return;
        }
        GrString grString = (GrString)node.getPsi();
        if (grString == null) {
            return;
        }
        GrStringInjection[] injections = grString.getInjections();
        if (injections.length == 0) {
            descriptors.add((FoldingDescriptor)new FoldingDescriptor(node, node.getTextRange(), null, GroovyFoldingBuilder.multiLineStringLiteralPlaceholder(node), Boolean.valueOf(false), Collections.emptySet()));
            return;
        }
        FoldingGroup group = FoldingGroup.newGroup((String)"GString");
        TextRange nodeRange = node.getTextRange();
        int startOffset = nodeRange.getStartOffset();
        if (startOffset + 1 < (injectionRange = (injection = injections[0]).getTextRange()).getStartOffset()) {
            String start_quote = GrStringUtil.getStartQuote(node.getText());
            descriptors.add((FoldingDescriptor)new FoldingDescriptor(node, new TextRange(startOffset, injectionRange.getStartOffset()), group, start_quote, Boolean.valueOf(false), Collections.emptySet()));
        }
        startOffset = injectionRange.getEndOffset();
        for (int i2 = 1; i2 < injections.length; ++i2) {
            injection = injections[i2];
            injectionRange = injection.getTextRange();
            int endOffset = injectionRange.getStartOffset();
            if (endOffset - startOffset >= 2) {
                descriptors.add((FoldingDescriptor)new FoldingDescriptor(injection.getNode().getTreePrev(), new TextRange(startOffset, endOffset), group, " ", Boolean.valueOf(false), Collections.emptySet()));
            }
            startOffset = injectionRange.getEndOffset();
        }
        if (startOffset + 1 < nodeRange.getEndOffset()) {
            String end_quote = GrStringUtil.getEndQuote(node.getText());
            descriptors.add((FoldingDescriptor)new FoldingDescriptor(node.getLastChildNode(), new TextRange(startOffset, nodeRange.getEndOffset()), group, end_quote, Boolean.valueOf(false), Collections.emptySet()));
        }
    }

    private static void processImports(List<? super FoldingDescriptor> descriptors, GrImportStatement[] imports2) {
        if (imports2.length < 2) {
            return;
        }
        GrImportStatement first = imports2[0];
        while (first != null) {
            GrImportStatement marker = first;
            PsiElement next = first.getNextSibling();
            while (next instanceof GrImportStatement || next instanceof LeafPsiElement) {
                if (next instanceof GrImportStatement) {
                    marker = next;
                }
                next = next.getNextSibling();
            }
            if (marker != first) {
                int start = first.getTextRange().getStartOffset();
                int end = marker.getTextRange().getEndOffset();
                int tail = "import ".length();
                if (start + tail < end && !JavaFoldingBuilderBase.hasErrorElementsNearby((PsiFile)first.getContainingFile(), (int)start, (int)end)) {
                    FoldingDescriptor descriptor2 = new FoldingDescriptor(first.getNode(), new TextRange(start + tail, end), null, "...", Boolean.valueOf(JavaCodeFoldingSettings.getInstance().isCollapseImports()), Collections.emptySet());
                    descriptor2.setCanBeRemovedWhenCollapsed(true);
                    descriptors.add((FoldingDescriptor)descriptor2);
                }
            }
            while (!(next instanceof GrImportStatement) && next != null) {
                next = next.getNextSibling();
            }
            first = next;
        }
    }

    private static boolean isWellEndedComment(PsiElement element) {
        return element.getText().endsWith("*/");
    }

    private static boolean isMultiline(@NotNull PsiElement element) {
        String text;
        if (element == null) {
            GroovyFoldingBuilder.$$$reportNull$$$0(5);
        }
        return (text = element.getText()).contains("\n") || text.contains("\r");
    }

    @Nullable
    protected String getLanguagePlaceholderText(@NotNull ASTNode node, @NotNull TextRange range) {
        if (node == null) {
            GroovyFoldingBuilder.$$$reportNull$$$0(6);
        }
        if (range == null) {
            GroovyFoldingBuilder.$$$reportNull$$$0(7);
        }
        return null;
    }

    @NotNull
    private static String multiLineStringLiteralPlaceholder(@NotNull ASTNode node) {
        if (node == null) {
            GroovyFoldingBuilder.$$$reportNull$$$0(8);
        }
        String start_quote = GrStringUtil.getStartQuote(node.getText());
        String end_quote = GrStringUtil.getEndQuote(node.getText());
        String string = start_quote + "..." + end_quote;
        if (string == null) {
            GroovyFoldingBuilder.$$$reportNull$$$0(9);
        }
        return string;
    }

    private static boolean isFileHeader(ASTNode node) {
        PsiElement element = node.getPsi();
        PsiElement parent2 = element.getParent();
        if (parent2 instanceof GroovyFile) {
            PsiElement firstChild = parent2.getFirstChild();
            if (firstChild instanceof PsiWhiteSpace) {
                firstChild = firstChild.getNextSibling();
            }
            return element.equals(firstChild);
        }
        return false;
    }

    protected boolean isRegionCollapsedByDefault(@NotNull ASTNode node) {
        if (node == null) {
            GroovyFoldingBuilder.$$$reportNull$$$0(10);
        }
        return false;
    }

    private static boolean isMultiLineStringLiteral(ASTNode node) {
        return (TokenSets.STRING_LITERAL_SET.contains(node.getElementType()) || node.getElementType().equals(GroovyElementTypes.GSTRING) || node.getElementType().equals(GroovyElementTypes.REGEX)) && GroovyFoldingBuilder.isMultiline(node.getPsi()) && GrStringUtil.isWellEndedString(node.getPsi());
    }

    protected boolean isCustomFoldingCandidate(@NotNull ASTNode node) {
        if (node == null) {
            GroovyFoldingBuilder.$$$reportNull$$$0(11);
        }
        return node.getElementType() == GroovyTokenTypes.mSL_COMMENT;
    }

    protected boolean isCustomFoldingRoot(@NotNull ASTNode node) {
        IElementType nodeType;
        if (node == null) {
            GroovyFoldingBuilder.$$$reportNull$$$0(12);
        }
        return (nodeType = node.getElementType()) == GroovyStubElementTypes.CLASS_TYPE_DEFINITION || nodeType instanceof GrBlockElementType;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 9 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptors";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "root";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "document";
                break;
            }
            case 3: 
            case 6: 
            case 8: 
            case 10: 
            case 11: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psi";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "range";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/groovy/lang/folding/GroovyFoldingBuilder";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/groovy/lang/folding/GroovyFoldingBuilder";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "multiLineStringLiteralPlaceholder";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "buildLanguageFoldRegions";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "isCollapseBlock";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "collapseBlock";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "isMultiline";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getLanguagePlaceholderText";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "multiLineStringLiteralPlaceholder";
                break;
            }
            case 9: {
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "isRegionCollapsedByDefault";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "isCustomFoldingCandidate";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "isCustomFoldingRoot";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 9 -> new IllegalStateException(string);
        };
    }
}

