/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.findUsages;

import com.intellij.openapi.application.QueryExecutorBase;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.search.LocalSearchScope;
import com.intellij.psi.search.PsiSearchHelper;
import com.intellij.psi.search.RequestResultProcessor;
import com.intellij.psi.search.SearchRequestCollector;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.SearchSession;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.util.Processor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.findUsages.GroovyScopeUtil;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrAccessorMethod;
import org.jetbrains.plugins.groovy.lang.psi.api.toplevel.imports.GrImportStatement;
import org.jetbrains.plugins.groovy.lang.psi.util.GroovyPropertyUtils;

public class GrAliasedImportedElementSearcher
extends QueryExecutorBase<PsiReference, ReferencesSearch.SearchParameters> {
    public GrAliasedImportedElementSearcher() {
        super(true);
    }

    public void processQuery(@NotNull ReferencesSearch.SearchParameters parameters2, @NotNull Processor<? super PsiReference> consumer) {
        PsiField field;
        PsiMethod method;
        PsiElement target;
        if (parameters2 == null) {
            GrAliasedImportedElementSearcher.$$$reportNull$$$0(0);
        }
        if (consumer == null) {
            GrAliasedImportedElementSearcher.$$$reportNull$$$0(1);
        }
        if (!((target = parameters2.getElementToSearch()) instanceof PsiMember) || !(target instanceof PsiNamedElement)) {
            return;
        }
        String name = ((PsiNamedElement)target).getName();
        if (name == null || StringUtil.isEmptyOrSpaces((String)name)) {
            return;
        }
        SearchScope onlyGroovy = GroovyScopeUtil.restrictScopeToGroovyFiles(parameters2.getEffectiveSearchScope());
        SearchRequestCollector collector = parameters2.getOptimizer();
        SearchSession session = collector.getSearchSession();
        if (target instanceof PsiMethod && GroovyPropertyUtils.isSimplePropertyAccessor(method = (PsiMethod)target) && (field = GroovyPropertyUtils.findFieldForAccessor(method, true)) != null) {
            String propertyName = field.getName();
            MyProcessor processor = new MyProcessor((PsiElement)method, GroovyPropertyUtils.getAccessorPrefix(method), session);
            collector.searchWord(propertyName, onlyGroovy, (short)1, true, (PsiElement)method, (RequestResultProcessor)processor);
        }
        collector.searchWord(name, onlyGroovy, (short)1, true, target, (RequestResultProcessor)new MyProcessor(target, null, session));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "parameters";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "consumer";
                break;
            }
        }
        objectArray[1] = "org/jetbrains/plugins/groovy/findUsages/GrAliasedImportedElementSearcher";
        objectArray[2] = "processQuery";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class MyProcessor
    extends RequestResultProcessor {
        private final PsiElement myTarget;
        private final String prefix;
        private final SearchSession mySession;

        MyProcessor(PsiElement target, @Nullable String prefix, SearchSession session) {
            super(new Object[]{target, prefix});
            this.myTarget = target;
            this.prefix = prefix;
            this.mySession = session;
        }

        public boolean processTextOccurrence(@NotNull PsiElement element, int offsetInElement, @NotNull Processor<? super PsiReference> consumer) {
            String alias;
            if (element == null) {
                MyProcessor.$$$reportNull$$$0(0);
            }
            if (consumer == null) {
                MyProcessor.$$$reportNull$$$0(1);
            }
            if ((alias = MyProcessor.getAlias(element)) == null) {
                return true;
            }
            PsiReference reference = element.getReference();
            if (reference == null) {
                return true;
            }
            if (!reference.isReferenceTo((PsiElement)(this.myTarget instanceof GrAccessorMethod ? ((GrAccessorMethod)this.myTarget).getProperty() : this.myTarget))) {
                return true;
            }
            SearchRequestCollector collector = new SearchRequestCollector(this.mySession);
            LocalSearchScope fileScope = new LocalSearchScope((PsiElement)element.getContainingFile());
            collector.searchWord(alias, (SearchScope)fileScope, (short)1, true, this.myTarget);
            if (this.prefix != null) {
                collector.searchWord(this.prefix + GroovyPropertyUtils.capitalize(alias), (SearchScope)fileScope, (short)1, true, this.myTarget);
            }
            return PsiSearchHelper.getInstance((Project)element.getProject()).processRequests(collector, consumer);
        }

        @Nullable
        private static String getAlias(PsiElement element) {
            PsiElement psiElement = element.getParent();
            if (!(psiElement instanceof GrImportStatement)) {
                return null;
            }
            GrImportStatement importStatement = (GrImportStatement)psiElement;
            if (!importStatement.isAliasedImport()) {
                return null;
            }
            return importStatement.getImportedName();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "element";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "consumer";
                    break;
                }
            }
            objectArray[1] = "org/jetbrains/plugins/groovy/findUsages/GrAliasedImportedElementSearcher$MyProcessor";
            objectArray[2] = "processTextOccurrence";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

