/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.dsl;

import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ProcessingContext;
import com.intellij.util.containers.MultiMap;
import groovy.lang.Closure;
import groovy.lang.GroovyShell;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.codehaus.groovy.control.CompilerConfiguration;
import org.codehaus.groovy.runtime.DefaultGroovyMethods;
import org.jetbrains.plugins.groovy.dsl.CustomMembersGenerator;
import org.jetbrains.plugins.groovy.dsl.DslPointcut;
import org.jetbrains.plugins.groovy.dsl.GdslScriptBase;
import org.jetbrains.plugins.groovy.dsl.GroovyClassDescriptor;
import org.jetbrains.plugins.groovy.dsl.holders.CustomMembersHolder;
import org.jetbrains.plugins.groovy.dsl.psi.PsiEnhancerCategory;
import org.jetbrains.plugins.groovy.dsl.toplevel.ContextFilter;

public class GroovyDslExecutor {
    private static final List<Class> cats = DefaultGroovyMethods.collect((Object[])((PsiEnhancerCategory[])PsiEnhancerCategory.EP_NAME.getExtensions()), (Closure)new Closure<Class>(null, null){

        public Class doCall(PsiEnhancerCategory it) {
            return it.getClass();
        }

        public Class doCall() {
            throw new UnsupportedOperationException();
        }
    });
    private final GdslScriptBase myScript;
    private final String myFileName;

    public GroovyDslExecutor(GdslScriptBase script, String fileName) {
        this.myScript = script;
        this.myFileName = fileName;
    }

    public List<Pair<ContextFilter, Closure>> getEnhancers() {
        return this.myScript.getEnhancers();
    }

    public MultiMap getStaticInfo() {
        return this.myScript.getStaticInfo();
    }

    public CustomMembersHolder processVariants(GroovyClassDescriptor descriptor2, ProcessingContext ctx) {
        if (!DefaultGroovyMethods.asBoolean(this.getEnhancers())) {
            return CustomMembersHolder.EMPTY;
        }
        ArrayList<CustomMembersHolder> holders = new ArrayList<CustomMembersHolder>();
        for (Pair<ContextFilter, Closure> pair : this.getEnhancers()) {
            ProgressManager.checkCanceled();
            ctx.put(DslPointcut.BOUND, null);
            if (!((ContextFilter)pair.getFirst()).isApplicable(descriptor2, ctx)) continue;
            CustomMembersGenerator generator = new CustomMembersGenerator(descriptor2, (Map)ctx.get(DslPointcut.BOUND));
            this.doRun(generator, (Closure)pair.getSecond());
            List<CustomMembersHolder> membersHolder = generator.getMembersHolder();
            if (membersHolder == null) continue;
            holders.addAll(membersHolder);
        }
        return CustomMembersHolder.create(holders);
    }

    private void doRun(final CustomMembersGenerator generator, final Closure closure) {
        DefaultGroovyMethods.use((Object)this, cats, (Closure)new Closure<Object>((Object)this, (Object)this){

            public Object doCall(Object ignoredIt) {
                return DefaultGroovyMethods.with((Object)generator, (Closure)closure);
            }

            public Object doCall() {
                return this.doCall(null);
            }
        });
    }

    public String toString() {
        return this.myFileName;
    }

    public static GroovyDslExecutor createAndRunExecutor(String text, String fileName) {
        CompilerConfiguration configuration = new CompilerConfiguration();
        configuration.setScriptBaseClass(GdslScriptBase.class.getName());
        GroovyShell shell = new GroovyShell(GroovyDslExecutor.class.getClassLoader(), configuration);
        GdslScriptBase script = (GdslScriptBase)((Object)DefaultGroovyMethods.asType((Object)shell.parse(text, StringUtil.sanitizeJavaIdentifier((String)fileName)), GdslScriptBase.class));
        script.run();
        return new GroovyDslExecutor(script, fileName);
    }

    public static List<Class> getCats() {
        return cats;
    }
}

