/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.config;

import com.intellij.ide.util.projectWizard.JavaModuleBuilder;
import com.intellij.ide.util.projectWizard.ModuleBuilder;
import com.intellij.ide.util.projectWizard.ModuleWizardStep;
import com.intellij.ide.util.projectWizard.SettingsStep;
import com.intellij.ide.util.projectWizard.WizardContext;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModifiableRootModel;
import com.intellij.openapi.roots.ui.configuration.ModulesProvider;
import com.intellij.openapi.startup.StartupManager;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import icons.JetgroovyIcons;
import javax.swing.Icon;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.GroovyBundle;
import org.jetbrains.plugins.groovy.config.GroovySdkForNewModuleWizardStep;
import org.jetbrains.plugins.groovy.config.wizard.GroovyProjectWizardUtils;

public final class GroovyAwareModuleBuilder
extends JavaModuleBuilder {
    @Nullable
    private String myPathToGroovySample = null;

    public ModuleWizardStep modifyProjectTypeStep(@NotNull SettingsStep settingsStep) {
        if (settingsStep == null) {
            GroovyAwareModuleBuilder.$$$reportNull$$$0(0);
        }
        return new GroovySdkForNewModuleWizardStep((ModuleBuilder)this, settingsStep);
    }

    public void setupRootModel(@NotNull ModifiableRootModel rootModel) throws ConfigurationException {
        if (rootModel == null) {
            GroovyAwareModuleBuilder.$$$reportNull$$$0(1);
        }
        super.setupRootModel(rootModel);
        if (this.myPathToGroovySample != null) {
            this.addGroovySample(rootModel);
        }
    }

    private void addGroovySample(@NotNull ModifiableRootModel rootModel) {
        Project project;
        if (rootModel == null) {
            GroovyAwareModuleBuilder.$$$reportNull$$$0(2);
        }
        if (!(project = rootModel.getProject()).isInitialized()) {
            StartupManager.getInstance((Project)project).runAfterOpened(() -> this.doAddGroovySample(rootModel));
        } else {
            this.doAddGroovySample(rootModel);
        }
    }

    private void doAddGroovySample(@NotNull ModifiableRootModel rootModel) {
        String rootPath;
        if (rootModel == null) {
            GroovyAwareModuleBuilder.$$$reportNull$$$0(3);
        }
        if ((rootPath = this.getContentEntryPath()) == null) {
            return;
        }
        VirtualFile root = LocalFileSystem.getInstance().refreshAndFindFileByPath(FileUtil.toSystemIndependentName((String)(rootPath + "/" + this.myPathToGroovySample)));
        if (root == null) {
            return;
        }
        GroovyProjectWizardUtils.createSampleGroovyCodeFile((ModuleBuilder)this, rootModel.getProject(), root);
    }

    public ModuleWizardStep[] createWizardSteps(@NotNull WizardContext wizardContext, @NotNull ModulesProvider modulesProvider) {
        if (wizardContext == null) {
            GroovyAwareModuleBuilder.$$$reportNull$$$0(4);
        }
        if (modulesProvider == null) {
            GroovyAwareModuleBuilder.$$$reportNull$$$0(5);
        }
        return ModuleWizardStep.EMPTY_ARRAY;
    }

    @NonNls
    public String getBuilderId() {
        return "groovy";
    }

    public void addGroovySample(@NotNull String path) {
        if (path == null) {
            GroovyAwareModuleBuilder.$$$reportNull$$$0(6);
        }
        this.myPathToGroovySample = path;
    }

    public Icon getNodeIcon() {
        return JetgroovyIcons.Groovy.Groovy_16x16;
    }

    public String getDescription() {
        return GroovyBundle.message("module.with.groovy", new Object[0]);
    }

    public String getPresentableName() {
        return GroovyBundle.message("language.groovy", new Object[0]);
    }

    public String getGroupName() {
        return "Groovy";
    }

    public String getParentGroup() {
        return "Groovy";
    }

    public int getWeight() {
        return 60;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settingsStep";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rootModel";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "wizardContext";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "modulesProvider";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/plugins/groovy/config/GroovyAwareModuleBuilder";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "modifyProjectTypeStep";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "setupRootModel";
                break;
            }
            case 2: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "addGroovySample";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "doAddGroovySample";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "createWizardSteps";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

