/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.codeInspection.control;

import org.jetbrains.annotations.NonNls;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrBlockStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.branch.GrReturnStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrAssignmentExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;

@NonNls
final class ConditionalUtils {
    private ConditionalUtils() {
    }

    public static GrStatement stripBraces(GrStatement branch) {
        if (branch instanceof GrBlockStatement) {
            GrBlockStatement block = (GrBlockStatement)branch;
            GrStatement[] statements2 = block.getBlock().getStatements();
            if (statements2.length == 1) {
                return statements2[0];
            }
            return block;
        }
        return branch;
    }

    public static boolean isReturn(GrStatement statement, String value2) {
        if (statement == null) {
            return false;
        }
        if (!(statement instanceof GrReturnStatement)) {
            return false;
        }
        GrReturnStatement returnStatement = (GrReturnStatement)statement;
        GrExpression returnValue = returnStatement.getReturnValue();
        if (returnValue == null) {
            return false;
        }
        String returnValueText = returnValue.getText();
        return value2.equals(returnValueText);
    }

    public static boolean isAssignment(GrStatement statement, String value2) {
        if (statement == null) {
            return false;
        }
        if (!(statement instanceof GrAssignmentExpression)) {
            return false;
        }
        GrAssignmentExpression assignment = (GrAssignmentExpression)statement;
        GrExpression rhs = assignment.getRValue();
        if (rhs == null) {
            return false;
        }
        String rhsText = rhs.getText();
        return value2.equals(rhsText);
    }
}

