/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.actions;

import com.intellij.ide.IdeView;
import com.intellij.ide.actions.CreateFileFromTemplateDialog;
import com.intellij.ide.actions.JavaCreateTemplateInPackageAction;
import com.intellij.ide.fileTemplates.FileTemplate;
import com.intellij.ide.fileTemplates.FileTemplateManager;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.actionSystem.PlatformCoreDataKeys;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.ex.FileTypeManagerEx;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.ui.InputValidator;
import com.intellij.openapi.ui.InputValidatorEx;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaDirectoryService;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiNameHelper;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.util.IncorrectOperationException;
import icons.JetgroovyIcons;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.GroovyBundle;
import org.jetbrains.plugins.groovy.GroovyFileType;
import org.jetbrains.plugins.groovy.actions.GroovySourceFolderDetector;
import org.jetbrains.plugins.groovy.actions.GroovyTemplatesFactory;
import org.jetbrains.plugins.groovy.config.GroovyConfigUtils;
import org.jetbrains.plugins.groovy.lang.psi.GroovyFile;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.GrTypeDefinition;
import org.jetbrains.plugins.groovy.projectRoots.RootTypesKt;
import org.jetbrains.plugins.groovy.util.LibrariesUtil;

final class NewGroovyClassAction
extends JavaCreateTemplateInPackageAction<GrTypeDefinition>
implements DumbAware {
    NewGroovyClassAction() {
        super(GroovyBundle.messagePointer("new.class.action.text", new Object[0]), GroovyBundle.messagePointer("new.class.action.description", new Object[0]), () -> JetgroovyIcons.Groovy.Class, RootTypesKt.ROOT_TYPES);
    }

    protected void buildDialog(final @NotNull Project project, PsiDirectory directory, CreateFileFromTemplateDialog.Builder builder) {
        if (project == null) {
            NewGroovyClassAction.$$$reportNull$$$0(0);
        }
        builder.setTitle(GroovyBundle.message("new.class.dialog.title", new Object[0])).addKind(GroovyBundle.message("new.class.list.item.class", new Object[0]), JetgroovyIcons.Groovy.Class, "Groovy Class.groovy").addKind(GroovyBundle.message("new.class.list.item.interface", new Object[0]), JetgroovyIcons.Groovy.Interface, "Groovy Interface.groovy");
        if (GroovyConfigUtils.getInstance().isVersionAtLeast((PsiElement)directory, "2.3", true)) {
            builder.addKind(GroovyBundle.message("new.class.list.item.trait", new Object[0]), JetgroovyIcons.Groovy.Trait, "Groovy Trait.groovy");
        }
        builder.addKind(GroovyBundle.message("new.class.list.item.enum", new Object[0]), JetgroovyIcons.Groovy.Enum, "Groovy Enum.groovy").addKind(GroovyBundle.message("new.class.list.item.annotation", new Object[0]), JetgroovyIcons.Groovy.AnnotationType, "Groovy Annotation.groovy");
        if (GroovyConfigUtils.isAtLeastGroovy40((PsiElement)directory)) {
            builder.addKind(GroovyBundle.message("new.class.list.item.record", new Object[0]), JetgroovyIcons.Groovy.Record, "Groovy Record.groovy");
        }
        for (FileTemplate template : FileTemplateManager.getInstance((Project)project).getAllTemplates()) {
            FileType fileType = FileTypeManagerEx.getInstanceEx().getFileTypeByExtension(template.getExtension());
            if (!fileType.equals((Object)GroovyFileType.GROOVY_FILE_TYPE) || JavaDirectoryService.getInstance().getPackage(directory) == null) continue;
            builder.addKind(template.getName(), JetgroovyIcons.Groovy.Class, template.getName());
        }
        builder.setValidator((InputValidator)new InputValidatorEx(){

            public String getErrorText(String inputString) {
                return GroovyBundle.message("invalid.qualified.name", new Object[0]);
            }

            public boolean checkInput(String inputString) {
                return true;
            }

            public boolean canClose(String inputString) {
                return !StringUtil.isEmptyOrSpaces((String)inputString) && PsiNameHelper.getInstance((Project)project).isQualifiedName(inputString);
            }
        });
    }

    protected boolean isAvailable(DataContext dataContext) {
        return super.isAvailable(dataContext) && LibrariesUtil.hasGroovySdk((Module)PlatformCoreDataKeys.MODULE.getData(dataContext));
    }

    protected String getActionName(PsiDirectory directory, @NotNull String newName, String templateName) {
        if (newName == null) {
            NewGroovyClassAction.$$$reportNull$$$0(1);
        }
        return GroovyBundle.message("new.class.action.text", new Object[0]);
    }

    protected PsiElement getNavigationElement(@NotNull GrTypeDefinition createdElement) {
        if (createdElement == null) {
            NewGroovyClassAction.$$$reportNull$$$0(2);
        }
        return createdElement.getLBrace();
    }

    public void update(@NotNull AnActionEvent e) {
        if (e == null) {
            NewGroovyClassAction.$$$reportNull$$$0(3);
        }
        super.update(e);
        Presentation presentation = e.getPresentation();
        if (!presentation.isVisible()) {
            return;
        }
        IdeView view = (IdeView)e.getData(LangDataKeys.IDE_VIEW);
        if (view == null) {
            return;
        }
        Project project = e.getProject();
        if (project == null) {
            return;
        }
        ProjectFileIndex projectFileIndex = ProjectRootManager.getInstance((Project)project).getFileIndex();
        for (PsiDirectory dir : view.getDirectories()) {
            if (!projectFileIndex.isInSourceContent(dir.getVirtualFile()) || !this.checkPackageExists(dir)) continue;
            for (GroovySourceFolderDetector detector : (GroovySourceFolderDetector[])GroovySourceFolderDetector.EP_NAME.getExtensions()) {
                if (!detector.isGroovySourceFolder(dir)) continue;
                presentation.setWeight(42.0);
                break;
            }
            return;
        }
    }

    protected GrTypeDefinition doCreate(PsiDirectory dir, String className, String templateName) throws IncorrectOperationException {
        String fileName = className + ".groovy";
        PsiFile fromTemplate = GroovyTemplatesFactory.createFromTemplate(dir, className, fileName, templateName, true, new String[0]);
        if (fromTemplate instanceof GroovyFile) {
            CodeStyleManager.getInstance((PsiManager)fromTemplate.getManager()).reformat((PsiElement)fromTemplate);
            return ((GroovyFile)fromTemplate).getTypeDefinitions()[0];
        }
        String description = fromTemplate.getFileType().getDescription();
        throw new IncorrectOperationException(GroovyBundle.message("groovy.file.extension.is.not.mapped.to.groovy.file.type", description));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newName";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "createdElement";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/plugins/groovy/actions/NewGroovyClassAction";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "buildDialog";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "getActionName";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "getNavigationElement";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "update";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

