/*
 * Decompiled with CFR 0.152.
 */
package org.editorconfig.language.schema.parser;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.util.containers.Stack;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.editorconfig.language.schema.descriptors.EditorConfigDescriptor;
import org.editorconfig.language.schema.descriptors.impl.EditorConfigConstantDescriptor;
import org.editorconfig.language.schema.parser.EditorConfigJsonSchemaException;
import org.editorconfig.language.schema.parser.handlers.EditorConfigDescriptorParseHandlerBase;
import org.editorconfig.language.schema.parser.handlers.impl.EditorConfigConstantDescriptorParseHandler;
import org.editorconfig.language.schema.parser.handlers.impl.EditorConfigDeclarationDescriptorParseHandler;
import org.editorconfig.language.schema.parser.handlers.impl.EditorConfigListDescriptorParseHandler;
import org.editorconfig.language.schema.parser.handlers.impl.EditorConfigOptionDescriptorParseHandler;
import org.editorconfig.language.schema.parser.handlers.impl.EditorConfigPairDescriptorParseHandler;
import org.editorconfig.language.schema.parser.handlers.impl.EditorConfigQualifiedOptionKeyDescriptorParseHandler;
import org.editorconfig.language.schema.parser.handlers.impl.EditorConfigReferenceDescriptorParseHandler;
import org.editorconfig.language.schema.parser.handlers.impl.EditorConfigStandardTypeDescriptorParseHandler;
import org.editorconfig.language.schema.parser.handlers.impl.EditorConfigUnionDescriptorParseHandler;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u000e\u001a\u00020\u00072\u0006\u0010\u000f\u001a\u00020\rH\u0002J\u000e\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013J\u0016\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00072\u0006\u0010\u0017\u001a\u00020\rJ\u000e\u0010\u0018\u001a\u00020\u00152\u0006\u0010\u0019\u001a\u00020\u0007R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\n0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\r0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lorg/editorconfig/language/schema/parser/EditorConfigJsonSchemaParser;", "", "logger", "Lcom/intellij/openapi/diagnostic/Logger;", "(Lcom/intellij/openapi/diagnostic/Logger;)V", "forbiddenTypes", "Lcom/intellij/util/containers/Stack;", "", "handlers", "", "Lorg/editorconfig/language/schema/parser/handlers/EditorConfigDescriptorParseHandlerBase;", "typeAliases", "", "Lcom/google/gson/JsonObject;", "getTypeName", "jsonObject", "parse", "Lorg/editorconfig/language/schema/descriptors/EditorConfigDescriptor;", "element", "Lcom/google/gson/JsonElement;", "registerTypeAlias", "", "alias", "type", "warn", "message", "intellij.editorconfig"})
@SourceDebugExtension(value={"SMAP\nEditorConfigJsonSchemaParser.kt\nKotlin\n*S Kotlin\n*F\n+ 1 EditorConfigJsonSchemaParser.kt\norg/editorconfig/language/schema/parser/EditorConfigJsonSchemaParser\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,119:1\n1855#2,2:120\n1#3:122\n*S KotlinDebug\n*F\n+ 1 EditorConfigJsonSchemaParser.kt\norg/editorconfig/language/schema/parser/EditorConfigJsonSchemaParser\n*L\n95#1:120,2\n*E\n"})
public final class EditorConfigJsonSchemaParser {
    @NotNull
    private final Logger logger;
    @NotNull
    private final Map<String, EditorConfigDescriptorParseHandlerBase> handlers;
    @NotNull
    private final Map<String, JsonObject> typeAliases;
    @NotNull
    private final Stack<String> forbiddenTypes;

    public EditorConfigJsonSchemaParser(@NotNull Logger logger) {
        Intrinsics.checkNotNullParameter((Object)logger, (String)"logger");
        this.logger = logger;
        this.typeAliases = new LinkedHashMap();
        this.forbiddenTypes = new Stack();
        Map handlers = new LinkedHashMap();
        EditorConfigStandardTypeDescriptorParseHandler standardTypeParseHandler = new EditorConfigStandardTypeDescriptorParseHandler();
        EditorConfigJsonSchemaParser._init_$registerParseHandler(handlers, this, (Pair<String, ? extends EditorConfigDescriptorParseHandlerBase>)TuplesKt.to((Object)"number", (Object)standardTypeParseHandler));
        EditorConfigJsonSchemaParser._init_$registerParseHandler(handlers, this, (Pair<String, ? extends EditorConfigDescriptorParseHandlerBase>)TuplesKt.to((Object)"string", (Object)standardTypeParseHandler));
        EditorConfigJsonSchemaParser._init_$registerParseHandler(handlers, this, (Pair<String, ? extends EditorConfigDescriptorParseHandlerBase>)TuplesKt.to((Object)"text", (Object)standardTypeParseHandler));
        EditorConfigJsonSchemaParser._init_$registerParseHandler(handlers, this, (Pair<String, ? extends EditorConfigDescriptorParseHandlerBase>)TuplesKt.to((Object)"declaration", (Object)new EditorConfigDeclarationDescriptorParseHandler()));
        EditorConfigJsonSchemaParser._init_$registerParseHandler(handlers, this, (Pair<String, ? extends EditorConfigDescriptorParseHandlerBase>)TuplesKt.to((Object)"reference", (Object)new EditorConfigReferenceDescriptorParseHandler()));
        EditorConfigJsonSchemaParser._init_$registerParseHandler(handlers, this, (Pair<String, ? extends EditorConfigDescriptorParseHandlerBase>)TuplesKt.to((Object)"list", (Object)new EditorConfigListDescriptorParseHandler()));
        EditorConfigJsonSchemaParser._init_$registerParseHandler(handlers, this, (Pair<String, ? extends EditorConfigDescriptorParseHandlerBase>)TuplesKt.to((Object)"union", (Object)new EditorConfigUnionDescriptorParseHandler()));
        EditorConfigJsonSchemaParser._init_$registerParseHandler(handlers, this, (Pair<String, ? extends EditorConfigDescriptorParseHandlerBase>)TuplesKt.to((Object)"constant", (Object)new EditorConfigConstantDescriptorParseHandler()));
        EditorConfigJsonSchemaParser._init_$registerParseHandler(handlers, this, (Pair<String, ? extends EditorConfigDescriptorParseHandlerBase>)TuplesKt.to((Object)"pair", (Object)new EditorConfigPairDescriptorParseHandler()));
        EditorConfigJsonSchemaParser._init_$registerParseHandler(handlers, this, (Pair<String, ? extends EditorConfigDescriptorParseHandlerBase>)TuplesKt.to((Object)"option", (Object)new EditorConfigOptionDescriptorParseHandler()));
        EditorConfigJsonSchemaParser._init_$registerParseHandler(handlers, this, (Pair<String, ? extends EditorConfigDescriptorParseHandlerBase>)TuplesKt.to((Object)"qualified", (Object)new EditorConfigQualifiedOptionKeyDescriptorParseHandler()));
        this.handlers = handlers;
    }

    public final void registerTypeAlias(@NotNull String alias, @NotNull JsonObject type) {
        Intrinsics.checkNotNullParameter((Object)alias, (String)"alias");
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        JsonObject presentAlias = this.typeAliases.get(alias);
        if (Intrinsics.areEqual((Object)presentAlias, (Object)type)) {
            return;
        }
        if (presentAlias != null) {
            this.warn("Attempted to register type alias " + alias + " twice");
            return;
        }
        EditorConfigDescriptorParseHandlerBase presentHandler = this.handlers.get(alias);
        if (presentHandler != null) {
            this.warn("Attempted to register type alias " + alias + " that conflicts existing parse handler");
            return;
        }
        this.typeAliases.put(alias, type);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final EditorConfigDescriptor parse(@NotNull JsonElement element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        if (element.isJsonPrimitive()) {
            String string = element.getAsString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getAsString(...)");
            return new EditorConfigConstantDescriptor(string, null, null);
        }
        if (!element.isJsonObject()) {
            throw new EditorConfigJsonSchemaException(element);
        }
        JsonObject jsonObject = element.getAsJsonObject();
        Intrinsics.checkNotNull((Object)jsonObject);
        String type = this.getTypeName(jsonObject);
        if (this.forbiddenTypes.contains((Object)type)) {
            throw new EditorConfigJsonSchemaException((JsonElement)jsonObject);
        }
        EditorConfigDescriptorParseHandlerBase handler = this.handlers.get(type);
        if (handler != null) {
            try {
                EditorConfigDescriptor $this$forEach$iv;
                Iterable iterable = handler.getForbiddenChildren();
                Stack<String> stack = this.forbiddenTypes;
                boolean $i$f$forEach = false;
                Iterator iterator = $this$forEach$iv.iterator();
                while (iterator.hasNext()) {
                    Object element$iv = iterator.next();
                    String p0 = (String)element$iv;
                    boolean bl = false;
                    stack.push((Object)p0);
                }
                $this$forEach$iv = handler.handle(jsonObject, this);
                return $this$forEach$iv;
            }
            finally {
                int n = handler.getForbiddenChildren().size();
                int n2 = 0;
                while (n2 < n) {
                    int it = n2++;
                    boolean bl = false;
                    this.forbiddenTypes.tryPop();
                }
            }
        }
        JsonObject jsonObject2 = this.typeAliases.get(type);
        if (jsonObject2 == null) {
            throw new EditorConfigJsonSchemaException((JsonElement)jsonObject);
        }
        JsonObject alias = jsonObject2;
        return this.parse((JsonElement)alias);
    }

    private final String getTypeName(JsonObject jsonObject) {
        JsonElement type = jsonObject.get("type");
        if (type == null || !type.isJsonPrimitive()) {
            throw new EditorConfigJsonSchemaException((JsonElement)jsonObject);
        }
        String string = type.getAsString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getAsString(...)");
        return string;
    }

    public final void warn(@NotNull String message2) {
        Intrinsics.checkNotNullParameter((Object)message2, (String)"message");
        this.logger.warn(message2);
    }

    private static final EditorConfigJsonSchemaParser _init_$registerParseHandler(Map<String, EditorConfigDescriptorParseHandlerBase> handlers, EditorConfigJsonSchemaParser this$0, Pair<String, ? extends EditorConfigDescriptorParseHandlerBase> pair) {
        if (handlers.get(pair.getFirst()) != null) {
            throw new IllegalStateException("Handler with key " + pair.getFirst() + " has already been registered");
        }
        handlers.put((String)pair.getFirst(), (EditorConfigDescriptorParseHandlerBase)pair.getSecond());
        return this$0;
    }
}

