/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.serialization.builtins;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.builtins.StandardNames;
import org.jetbrains.kotlin.builtins.jvm.JvmBuiltInClassDescriptorFactory;
import org.jetbrains.kotlin.cli.common.CLIConfigurationKeys;
import org.jetbrains.kotlin.cli.common.CommonCompilerPerformanceManager;
import org.jetbrains.kotlin.cli.common.config.ContentRootsKt;
import org.jetbrains.kotlin.cli.common.messages.CompilerMessageSeverity;
import org.jetbrains.kotlin.cli.common.messages.CompilerMessageSourceLocation;
import org.jetbrains.kotlin.cli.common.messages.GroupingMessageCollector;
import org.jetbrains.kotlin.cli.common.messages.MessageRenderer;
import org.jetbrains.kotlin.cli.common.messages.PrintingMessageCollector;
import org.jetbrains.kotlin.cli.jvm.compiler.EnvironmentConfigFiles;
import org.jetbrains.kotlin.cli.jvm.compiler.KotlinCoreEnvironment;
import org.jetbrains.kotlin.cli.jvm.config.JvmContentRootsKt;
import org.jetbrains.kotlin.cli.metadata.CommonAnalysisResult;
import org.jetbrains.kotlin.cli.metadata.MetadataSerializer;
import org.jetbrains.kotlin.config.CommonConfigurationKeys;
import org.jetbrains.kotlin.config.CommonConfigurationKeysKt;
import org.jetbrains.kotlin.config.CompilerConfiguration;
import org.jetbrains.kotlin.config.LanguageVersionSettings;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.ModuleDescriptor;
import org.jetbrains.kotlin.descriptors.PackageFragmentDescriptor;
import org.jetbrains.kotlin.descriptors.PackageViewDescriptor;
import org.jetbrains.kotlin.descriptors.impl.EmptyPackageFragmentDescriptor;
import org.jetbrains.kotlin.metadata.builtins.BuiltInsBinaryVersion;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.resolve.DescriptorUtils;
import org.jetbrains.kotlin.resolve.scopes.DescriptorKindFilter;
import org.jetbrains.kotlin.resolve.scopes.ResolutionScope;
import org.jetbrains.kotlin.serialization.KotlinSerializerExtensionBase;
import org.jetbrains.kotlin.serialization.builtins.BuiltInsSerializer;
import org.jetbrains.kotlin.serialization.builtins.BuiltInsSerializerExtension;
import org.jetbrains.kotlin.serialization.deserialization.builtins.BuiltInSerializerProtocol;
import org.jetbrains.kotlin.storage.LockBasedStorageManager;
import org.jetbrains.kotlin.storage.StorageManager;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u00152\u00020\u0001:\u0001\u0015B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0002J\b\u0010\r\u001a\u00020\u000eH\u0014J\u0018\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0014\u00a8\u0006\u0016"}, d2={"Lorg/jetbrains/kotlin/serialization/builtins/BuiltInsSerializer;", "Lorg/jetbrains/kotlin/cli/metadata/MetadataSerializer;", "configuration", "Lorg/jetbrains/kotlin/config/CompilerConfiguration;", "environment", "Lorg/jetbrains/kotlin/cli/jvm/compiler/KotlinCoreEnvironment;", "dependOnOldBuiltIns", "", "(Lorg/jetbrains/kotlin/config/CompilerConfiguration;Lorg/jetbrains/kotlin/cli/jvm/compiler/KotlinCoreEnvironment;Z)V", "createCloneable", "Lorg/jetbrains/kotlin/descriptors/ClassDescriptor;", "module", "Lorg/jetbrains/kotlin/descriptors/ModuleDescriptor;", "createSerializerExtension", "Lorg/jetbrains/kotlin/serialization/KotlinSerializerExtensionBase;", "serialize", "", "analysisResult", "Lorg/jetbrains/kotlin/cli/metadata/CommonAnalysisResult;", "destDir", "Ljava/io/File;", "Companion", "cli"})
@SourceDebugExtension(value={"SMAP\nBuiltInsSerializer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BuiltInsSerializer.kt\norg/jetbrains/kotlin/serialization/builtins/BuiltInsSerializer\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,124:1\n1549#2:125\n1620#2,3:126\n1855#2:129\n1360#2:130\n1446#2,5:131\n1856#2:136\n*E\n*S KotlinDebug\n*F\n+ 1 BuiltInsSerializer.kt\norg/jetbrains/kotlin/serialization/builtins/BuiltInsSerializer\n*L\n100#1:125\n100#1,3:126\n100#1:129\n104#1:130\n104#1,5:131\n100#1:136\n*E\n"})
public final class BuiltInsSerializer
extends MetadataSerializer {
    @NotNull
    public static final Companion Companion = new Companion(null);

    /*
     * WARNING - void declaration
     */
    @Override
    protected void serialize(@NotNull CommonAnalysisResult analysisResult2, @NotNull File destDir) {
        Iterable it;
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter(analysisResult2, "analysisResult");
        Intrinsics.checkNotNullParameter(destDir, "destDir");
        List<KtFile> files2 = this.getEnvironment().getSourceFiles();
        ModuleDescriptor module2 = analysisResult2.getModuleDescriptor();
        FilesKt.deleteRecursively(destDir);
        if (!destDir.mkdirs()) {
            throw (Throwable)((Object)new AssertionError((Object)("Could not make directories: " + destDir)));
        }
        Iterable $this$map$iv = files2;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            KtFile ktFile = (KtFile)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            FqName fqName2 = ((KtFile)((Object)it)).getPackageFqName();
            collection.add(fqName2);
        }
        Iterable $this$forEach$iv = CollectionsKt.toSet((List)destination$iv$iv);
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            void $this$flatMapTo$iv$iv;
            void $this$flatMap$iv;
            FqName fqName3 = (FqName)element$iv;
            boolean bl = false;
            PackageViewDescriptor packageView = module2.getPackage(fqName3);
            it = packageView.getFragments();
            Collection collection = CollectionsKt.plus(ResolutionScope.DefaultImpls.getContributedDescriptors$default(packageView.getMemberScope(), DescriptorKindFilter.CLASSIFIERS, null, 2, null), this.createCloneable(module2));
            BuiltInsSerializer builtInsSerializer = this;
            boolean $i$f$flatMap = false;
            void var16_21 = $this$flatMap$iv;
            Collection destination$iv$iv2 = new ArrayList();
            boolean $i$f$flatMapTo = false;
            for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
                PackageFragmentDescriptor fragment = (PackageFragmentDescriptor)element$iv$iv;
                boolean bl2 = false;
                Iterable list$iv$iv = DescriptorUtils.getAllDescriptors(fragment.getMemberScope());
                CollectionsKt.addAll(destination$iv$iv2, list$iv$iv);
            }
            List list2 = (List)destination$iv$iv2;
            DefaultConstructorMarker defaultConstructorMarker = null;
            int n = 32;
            Project project = null;
            LanguageVersionSettings languageVersionSettings2 = CommonConfigurationKeysKt.getLanguageVersionSettings(this.getEnvironment().getConfiguration());
            File file2 = new File(destDir, BuiltInSerializerProtocol.INSTANCE.getBuiltInsFilePath(packageView.getFqName()));
            FqName fqName4 = packageView.getFqName();
            Collection collection2 = list2;
            Collection collection3 = collection;
            BuiltInsSerializer builtInsSerializer2 = builtInsSerializer;
            new MetadataSerializer.PackageSerializer(builtInsSerializer2, collection3, collection2, fqName4, file2, languageVersionSettings2, project, n, defaultConstructorMarker).run();
        }
    }

    @Override
    @NotNull
    protected KotlinSerializerExtensionBase createSerializerExtension() {
        return new BuiltInsSerializerExtension();
    }

    private final ClassDescriptor createCloneable(ModuleDescriptor module2) {
        StorageManager storageManager = LockBasedStorageManager.NO_LOCKS;
        Intrinsics.checkNotNullExpressionValue(storageManager, "LockBasedStorageManager.NO_LOCKS");
        JvmBuiltInClassDescriptorFactory factory2 = new JvmBuiltInClassDescriptorFactory(storageManager, module2, (Function1<? super ModuleDescriptor, ? extends DeclarationDescriptor>)new Function1<ModuleDescriptor, DeclarationDescriptor>(module2){
            final /* synthetic */ ModuleDescriptor $module;

            @NotNull
            public final DeclarationDescriptor invoke(@NotNull ModuleDescriptor it) {
                Intrinsics.checkNotNullParameter(it, "it");
                return new EmptyPackageFragmentDescriptor(this.$module, StandardNames.BUILT_INS_PACKAGE_FQ_NAME);
            }
            {
                this.$module = moduleDescriptor;
                super(1);
            }
        });
        ClassId classId = ClassId.topLevel(StandardNames.FqNames.cloneable.toSafe());
        Intrinsics.checkNotNullExpressionValue(classId, "ClassId.topLevel(Standar\u2026Names.cloneable.toSafe())");
        ClassDescriptor classDescriptor2 = factory2.createClass(classId);
        if (classDescriptor2 == null) {
            String string2 = "Could not create kotlin.Cloneable in " + module2;
            throw new IllegalStateException(string2.toString());
        }
        return classDescriptor2;
    }

    public BuiltInsSerializer(@NotNull CompilerConfiguration configuration2, @NotNull KotlinCoreEnvironment environment, boolean dependOnOldBuiltIns) {
        Intrinsics.checkNotNullParameter(configuration2, "configuration");
        Intrinsics.checkNotNullParameter(environment, "environment");
        super(configuration2, environment, dependOnOldBuiltIns, BuiltInsBinaryVersion.INSTANCE);
    }

    public static final /* synthetic */ void access$setTotalSize$p(BuiltInsSerializer $this, int n) {
        $this.setTotalSize(n);
    }

    public static final /* synthetic */ void access$setTotalFiles$p(BuiltInsSerializer $this, int n) {
        $this.setTotalFiles(n);
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000=\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\b\u0003*\u0001\u0014\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002Jj\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00060\b2\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00060\b2\u0006\u0010\n\u001a\u00020\u000b26\u0010\f\u001a2\u0012\u0013\u0012\u00110\u000e\u00a2\u0006\f\b\u000f\u0012\b\b\u0010\u0012\u0004\b\b(\u0011\u0012\u0013\u0012\u00110\u000e\u00a2\u0006\f\b\u000f\u0012\b\b\u0010\u0012\u0004\b\b(\u0012\u0012\u0004\u0012\u00020\u00040\rJ\r\u0010\u0013\u001a\u00020\u0014H\u0002\u00a2\u0006\u0002\u0010\u0015\u00a8\u0006\u0016"}, d2={"Lorg/jetbrains/kotlin/serialization/builtins/BuiltInsSerializer$Companion;", "", "()V", "analyzeAndSerialize", "", "destDir", "Ljava/io/File;", "srcDirs", "", "extraClassPath", "dependOnOldBuiltIns", "", "onComplete", "Lkotlin/Function2;", "", "Lkotlin/ParameterName;", "name", "totalSize", "totalFiles", "createMessageCollector", "org/jetbrains/kotlin/serialization/builtins/BuiltInsSerializer$Companion$createMessageCollector$1", "()Lorg/jetbrains/kotlin/serialization/builtins/BuiltInsSerializer$Companion$createMessageCollector$1;", "cli"})
    @SourceDebugExtension(value={"SMAP\nBuiltInsSerializer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BuiltInsSerializer.kt\norg/jetbrains/kotlin/serialization/builtins/BuiltInsSerializer$Companion\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,124:1\n1549#2:125\n1620#2,3:126\n*E\n*S KotlinDebug\n*F\n+ 1 BuiltInsSerializer.kt\norg/jetbrains/kotlin/serialization/builtins/BuiltInsSerializer$Companion\n*L\n56#1:125\n56#1,3:126\n*E\n"})
    public static final class Companion {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * WARNING - void declaration
         */
        public final void analyzeAndSerialize(@NotNull File destDir, @NotNull List<? extends File> srcDirs, @NotNull List<? extends File> extraClassPath, boolean dependOnOldBuiltIns, @NotNull Function2<? super Integer, ? super Integer, Unit> onComplete) {
            Intrinsics.checkNotNullParameter(destDir, "destDir");
            Intrinsics.checkNotNullParameter(srcDirs, "srcDirs");
            Intrinsics.checkNotNullParameter(extraClassPath, "extraClassPath");
            Intrinsics.checkNotNullParameter(onComplete, "onComplete");
            Disposable disposable = Disposer.newDisposable();
            Intrinsics.checkNotNullExpressionValue(disposable, "Disposer.newDisposable()");
            Disposable rootDisposable = disposable;
            createMessageCollector.1 messageCollector = this.createMessageCollector();
            CommonCompilerPerformanceManager performanceManager2 = new CommonCompilerPerformanceManager("test"){};
            try {
                Collection<String> collection;
                void $this$mapTo$iv$iv;
                void $this$map$iv;
                CompilerConfiguration compilerConfiguration2;
                CompilerConfiguration $this$apply = compilerConfiguration2 = new CompilerConfiguration();
                boolean bl = false;
                $this$apply.put(CLIConfigurationKeys.MESSAGE_COLLECTOR_KEY, messageCollector);
                Iterable iterable = srcDirs;
                CompilerConfiguration compilerConfiguration3 = $this$apply;
                boolean $i$f$map = false;
                void var16_15 = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    void it;
                    File file2 = (File)item$iv$iv;
                    collection = destination$iv$iv;
                    boolean bl2 = false;
                    String string2 = it.getPath();
                    collection.add(string2);
                }
                collection = (List)destination$iv$iv;
                ContentRootsKt.addKotlinSourceRoots(compilerConfiguration3, (List<String>)collection);
                JvmContentRootsKt.addJvmClasspathRoots($this$apply, extraClassPath);
                JvmContentRootsKt.configureJdkClasspathRoots($this$apply);
                $this$apply.put(CLIConfigurationKeys.METADATA_DESTINATION_DIRECTORY, destDir);
                $this$apply.put(CommonConfigurationKeys.MODULE_NAME, "module for built-ins serialization");
                $this$apply.put(CLIConfigurationKeys.PERF_MANAGER, performanceManager2);
                CompilerConfiguration configuration2 = compilerConfiguration2;
                KotlinCoreEnvironment environment = KotlinCoreEnvironment.Companion.createForProduction(rootDisposable, configuration2, EnvironmentConfigFiles.JVM_CONFIG_FILES);
                BuiltInsSerializer serializer2 = new BuiltInsSerializer(configuration2, environment, dependOnOldBuiltIns);
                serializer2.analyzeAndSerialize();
                onComplete.invoke((Integer)serializer2.getTotalSize(), (Integer)serializer2.getTotalFiles());
            }
            finally {
                messageCollector.flush();
                Disposer.dispose(rootDisposable);
            }
        }

        private final createMessageCollector.1 createMessageCollector() {
            return new GroupingMessageCollector(new PrintingMessageCollector(System.err, MessageRenderer.PLAIN_RELATIVE_PATHS, false), false){

                public void report(@NotNull CompilerMessageSeverity severity, @NotNull String message2, @Nullable CompilerMessageSourceLocation location) {
                    Intrinsics.checkNotNullParameter((Object)((Object)severity), "severity");
                    Intrinsics.checkNotNullParameter(message2, "message");
                    if (location == null) {
                        super.report(severity, message2, location);
                    }
                }
            };
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

