/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.konan.diagnostics;

import com.intellij.psi.PsiElement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.builtins.StandardNames;
import org.jetbrains.kotlin.descriptors.CallableMemberDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.annotations.AnnotationDescriptor;
import org.jetbrains.kotlin.diagnostics.DiagnosticFactory1;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.psi.Call;
import org.jetbrains.kotlin.psi.KtAnnotationEntry;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.BindingTrace;
import org.jetbrains.kotlin.resolve.DescriptorToSourceUtils;
import org.jetbrains.kotlin.resolve.annotations.ThrowUtilKt;
import org.jetbrains.kotlin.resolve.calls.util.CallUtilKt;
import org.jetbrains.kotlin.resolve.checkers.DeclarationChecker;
import org.jetbrains.kotlin.resolve.checkers.DeclarationCheckerContext;
import org.jetbrains.kotlin.resolve.constants.ArrayValue;
import org.jetbrains.kotlin.resolve.constants.ConstantValue;
import org.jetbrains.kotlin.resolve.constants.KClassValue;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;
import org.jetbrains.kotlin.resolve.konan.diagnostics.ErrorsNative;
import org.jetbrains.kotlin.resolve.konan.diagnostics.NativeThrowsChecker;
import org.jetbrains.kotlin.resolve.konan.diagnostics.NativeThrowsCheckerKt;
import org.jetbrains.kotlin.utils.DFS;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001!B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J \u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J2\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\b\u0010\u0013\u001a\u0004\u0018\u00010\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J\u0012\u0010\u0017\u001a\u00020\u00182\b\u0010\u0013\u001a\u0004\u0018\u00010\u0014H\u0002J\u001c\u0010\u0019\u001a\u000e\u0012\u0004\u0012\u00020\u001b\u0012\u0004\u0012\u00020\u00180\u001a2\u0006\u0010\r\u001a\u00020\u001bH\u0002J\u0016\u0010\u001c\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u001e0\u001d*\u00020\u0014H\u0002J\u001e\u0010\u001f\u001a\u00020\u0012*\u0006\u0012\u0002\b\u00030\u001e2\f\u0010 \u001a\b\u0012\u0004\u0012\u00020\u00050\u0004H\u0002R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\""}, d2={"Lorg/jetbrains/kotlin/resolve/konan/diagnostics/NativeThrowsChecker;", "Lorg/jetbrains/kotlin/resolve/checkers/DeclarationChecker;", "()V", "cancellationExceptionAndSupersClassIds", "", "Lorg/jetbrains/kotlin/name/ClassId;", "cancellationExceptionFqName", "Lorg/jetbrains/kotlin/name/FqName;", "throwsFqName", "check", "", "declaration", "Lorg/jetbrains/kotlin/psi/KtDeclaration;", "descriptor", "Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;", "context", "Lorg/jetbrains/kotlin/resolve/checkers/DeclarationCheckerContext;", "checkInheritance", "", "throwsAnnotation", "Lorg/jetbrains/kotlin/descriptors/annotations/AnnotationDescriptor;", "reportLocation", "Lorg/jetbrains/kotlin/psi/KtElement;", "decodeThrowsFilter", "Lorg/jetbrains/kotlin/resolve/konan/diagnostics/NativeThrowsChecker$ThrowsFilter;", "findInheritedThrows", "", "Lorg/jetbrains/kotlin/descriptors/CallableMemberDescriptor;", "getVariadicArguments", "", "Lorg/jetbrains/kotlin/resolve/constants/ConstantValue;", "isGlobalClassWithId", "classIds", "ThrowsFilter", "frontend.native"})
@SourceDebugExtension(value={"SMAP\nNativeThrowsChecker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 NativeThrowsChecker.kt\norg/jetbrains/kotlin/resolve/konan/diagnostics/NativeThrowsChecker\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,151:1\n1#2:152\n2624#3,3:153\n1655#3,8:156\n1549#3:164\n1620#3,3:165\n*S KotlinDebug\n*F\n+ 1 NativeThrowsChecker.kt\norg/jetbrains/kotlin/resolve/konan/diagnostics/NativeThrowsChecker\n*L\n65#1:153,3\n84#1:156,8\n87#1:164\n87#1:165,3\n*E\n"})
public final class NativeThrowsChecker
implements DeclarationChecker {
    @NotNull
    public static final NativeThrowsChecker INSTANCE = new NativeThrowsChecker();
    @NotNull
    private static final FqName throwsFqName = ThrowUtilKt.getKOTLIN_THROWS_ANNOTATION_FQ_NAME();
    @NotNull
    private static final FqName cancellationExceptionFqName = new FqName("kotlin.coroutines.cancellation.CancellationException");
    @NotNull
    private static final Set<ClassId> cancellationExceptionAndSupersClassIds;

    private NativeThrowsChecker() {
    }

    @Override
    public void check(@NotNull KtDeclaration declaration, @NotNull DeclarationDescriptor descriptor2, @NotNull DeclarationCheckerContext context) {
        KtElement reportLocation;
        KtAnnotationEntry throwsAnnotationEntry;
        KtAnnotationEntry ktAnnotationEntry;
        AnnotationDescriptor throwsAnnotation;
        Intrinsics.checkNotNullParameter(declaration, "declaration");
        Intrinsics.checkNotNullParameter(descriptor2, "descriptor");
        Intrinsics.checkNotNullParameter(context, "context");
        AnnotationDescriptor annotationDescriptor = throwsAnnotation = descriptor2.getAnnotations().findAnnotation(throwsFqName);
        if (annotationDescriptor != null) {
            AnnotationDescriptor it = annotationDescriptor;
            boolean bl = false;
            ktAnnotationEntry = DescriptorToSourceUtils.getSourceFromAnnotation(it);
        } else {
            ktAnnotationEntry = null;
        }
        KtAnnotationEntry ktAnnotationEntry2 = throwsAnnotationEntry = ktAnnotationEntry;
        KtElement ktElement = reportLocation = ktAnnotationEntry2 != null ? (KtElement)ktAnnotationEntry2 : (KtElement)declaration;
        if (!this.checkInheritance(declaration, descriptor2, context, throwsAnnotation, reportLocation)) {
            return;
        }
        if (throwsAnnotation == null) {
            return;
        }
        BindingContext bindingContext = context.getTrace().getBindingContext();
        Intrinsics.checkNotNullExpressionValue(bindingContext, "context.trace.bindingContext");
        BindingContext bindingContext2 = bindingContext;
        Object object = throwsAnnotationEntry;
        boolean bl = object != null && (object = CallUtilKt.getCall((KtElement)object, bindingContext2)) != null ? NativeThrowsCheckerKt.access$hasUnresolvedArgumentsRecursive((Call)object, bindingContext2) : false;
        if (bl) {
            return;
        }
        List<ConstantValue<?>> classes2 = this.getVariadicArguments(throwsAnnotation);
        if (classes2.isEmpty()) {
            context.getTrace().report(ErrorsNative.THROWS_LIST_EMPTY.on((KtElement)((PsiElement)reportLocation)));
            return;
        }
        if (declaration.hasModifier(KtTokens.SUSPEND_KEYWORD)) {
            boolean bl2;
            block11: {
                Iterable $this$none$iv = classes2;
                boolean $i$f$none = false;
                if ($this$none$iv instanceof Collection && ((Collection)$this$none$iv).isEmpty()) {
                    bl2 = true;
                } else {
                    for (Object element$iv : $this$none$iv) {
                        ConstantValue it = (ConstantValue)element$iv;
                        boolean bl3 = false;
                        if (!INSTANCE.isGlobalClassWithId(it, cancellationExceptionAndSupersClassIds)) continue;
                        bl2 = false;
                        break block11;
                    }
                    bl2 = true;
                }
            }
            if (bl2) {
                context.getTrace().report(ErrorsNative.MISSING_EXCEPTION_IN_THROWS_ON_SUSPEND.on((KtElement)((PsiElement)reportLocation), cancellationExceptionFqName));
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private final boolean checkInheritance(KtDeclaration declaration, DeclarationDescriptor descriptor2, DeclarationCheckerContext context, AnnotationDescriptor throwsAnnotation, KtElement reportLocation) {
        if (!(descriptor2 instanceof CallableMemberDescriptor) || ((CallableMemberDescriptor)descriptor2).getOverriddenDescriptors().isEmpty()) {
            return true;
        }
        Iterable $this$distinctBy$iv = this.findInheritedThrows((CallableMemberDescriptor)descriptor2).entrySet();
        boolean $i$f$distinctBy = false;
        HashSet<ThrowsFilter> set$iv = new HashSet<ThrowsFilter>();
        ArrayList list$iv = new ArrayList();
        for (Object e$iv : $this$distinctBy$iv) {
            Map.Entry it = (Map.Entry)e$iv;
            boolean bl = false;
            ThrowsFilter key$iv = (ThrowsFilter)it.getValue();
            if (!set$iv.add(key$iv)) continue;
            list$iv.add(e$iv);
        }
        List inherited = list$iv;
        if (inherited.size() >= 2) {
            Collection<DeclarationDescriptor> collection;
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            $this$distinctBy$iv = inherited;
            PsiElement psiElement = declaration;
            DiagnosticFactory1<KtDeclaration, Collection<DeclarationDescriptor>> diagnosticFactory1 = ErrorsNative.INCOMPATIBLE_THROWS_INHERITED;
            BindingTrace bindingTrace = context.getTrace();
            boolean $i$f$map = false;
            set$iv = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                Map.Entry bl = (Map.Entry)item$iv$iv;
                collection = destination$iv$iv;
                boolean bl2 = false;
                DeclarationDescriptor declarationDescriptor = ((CallableMemberDescriptor)it.getKey()).getContainingDeclaration();
                Intrinsics.checkNotNullExpressionValue(declarationDescriptor, "it.key.containingDeclaration");
                collection.add(declarationDescriptor);
            }
            collection = (List)destination$iv$iv;
            bindingTrace.report(diagnosticFactory1.on((KtDeclaration)psiElement, collection));
            return false;
        }
        if (throwsAnnotation == null) {
            return true;
        }
        Map.Entry entry = (Map.Entry)CollectionsKt.firstOrNull(inherited);
        if (entry == null) {
            return true;
        }
        Map.Entry entry2 = entry;
        CallableMemberDescriptor overriddenMember = (CallableMemberDescriptor)entry2.getKey();
        ThrowsFilter overriddenThrows = (ThrowsFilter)entry2.getValue();
        if (!Intrinsics.areEqual(this.decodeThrowsFilter(throwsAnnotation), overriddenThrows)) {
            context.getTrace().report(ErrorsNative.INCOMPATIBLE_THROWS_OVERRIDE.on((KtElement)((PsiElement)reportLocation), overriddenMember.getContainingDeclaration()));
            return false;
        }
        return true;
    }

    private final Map<CallableMemberDescriptor, ThrowsFilter> findInheritedThrows(CallableMemberDescriptor descriptor2) {
        Map result2 = new LinkedHashMap();
        DFS.dfs(descriptor2.getOverriddenDescriptors(), NativeThrowsChecker::findInheritedThrows$lambda$4, new DFS.AbstractNodeHandler<CallableMemberDescriptor, Unit>((Map<CallableMemberDescriptor, ThrowsFilter>)result2){
            final /* synthetic */ Map<CallableMemberDescriptor, ThrowsFilter> $result;
            {
                this.$result = $result;
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public boolean beforeChildren(@NotNull CallableMemberDescriptor current) {
                AnnotationDescriptor throwsAnnotation;
                Intrinsics.checkNotNullParameter(current, "current");
                Object object = current.getAnnotations().findAnnotation(NativeThrowsChecker.access$getThrowsFqName$p());
                AnnotationDescriptor it = object;
                boolean bl = false;
                AnnotationDescriptor annotationDescriptor = throwsAnnotation = current.getKind().isReal() ? object : null;
                if (throwsAnnotation == null) {
                    Collection<? extends CallableMemberDescriptor> collection = current.getOverriddenDescriptors();
                    Intrinsics.checkNotNullExpressionValue(collection, "current.overriddenDescriptors");
                    if (!collection.isEmpty()) {
                        return true;
                    }
                    boolean bl2 = false;
                    if (bl2) {
                        return true;
                    }
                }
                object = this.$result;
                CallableMemberDescriptor callableMemberDescriptor = current.getOriginal();
                Intrinsics.checkNotNullExpressionValue(callableMemberDescriptor, "current.original");
                CallableMemberDescriptor callableMemberDescriptor2 = callableMemberDescriptor;
                ThrowsFilter throwsFilter = NativeThrowsChecker.access$decodeThrowsFilter(NativeThrowsChecker.INSTANCE, throwsAnnotation);
                object.put(callableMemberDescriptor2, throwsFilter);
                return false;
            }

            public void result() {
            }
        });
        return result2;
    }

    private final List<ConstantValue<?>> getVariadicArguments(AnnotationDescriptor $this$getVariadicArguments) {
        ConstantValue<?> constantValue = DescriptorUtilsKt.firstArgument($this$getVariadicArguments);
        ArrayValue arrayValue = constantValue instanceof ArrayValue ? (ArrayValue)constantValue : null;
        if (arrayValue == null) {
            return CollectionsKt.emptyList();
        }
        ArrayValue argument2 = arrayValue;
        return (List)argument2.getValue();
    }

    private final ThrowsFilter decodeThrowsFilter(AnnotationDescriptor throwsAnnotation) {
        Object object = throwsAnnotation;
        return new ThrowsFilter(object != null && (object = this.getVariadicArguments((AnnotationDescriptor)object)) != null ? CollectionsKt.toSet((Iterable)object) : null);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean isGlobalClassWithId(ConstantValue<?> $this$isGlobalClassWithId, Set<ClassId> classIds) {
        if (!($this$isGlobalClassWithId instanceof KClassValue)) return false;
        KClassValue.Value value2 = (KClassValue.Value)((KClassValue)$this$isGlobalClassWithId).getValue();
        if (!(value2 instanceof KClassValue.Value.NormalClass)) {
            if (!(value2 instanceof KClassValue.Value.LocalClass)) throw new NoWhenBranchMatchedException();
            return false;
        }
        boolean bl = classIds.contains(((KClassValue.Value.NormalClass)value2).getClassId());
        if (!bl) return false;
        return true;
    }

    private static final Iterable findInheritedThrows$lambda$4(CallableMemberDescriptor current) {
        return current.getOverriddenDescriptors();
    }

    public static final /* synthetic */ FqName access$getThrowsFqName$p() {
        return throwsFqName;
    }

    public static final /* synthetic */ ThrowsFilter access$decodeThrowsFilter(NativeThrowsChecker $this, AnnotationDescriptor throwsAnnotation) {
        return $this.decodeThrowsFilter(throwsAnnotation);
    }

    static {
        FqName[] fqNameArray = new FqName[]{StandardNames.FqNames.throwable, new FqName("kotlin.Exception"), new FqName("kotlin.RuntimeException"), new FqName("kotlin.IllegalStateException"), cancellationExceptionFqName};
        cancellationExceptionAndSupersClassIds = SequencesKt.toSet(SequencesKt.map(SequencesKt.sequenceOf(fqNameArray), cancellationExceptionAndSupersClassIds.1.INSTANCE));
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0082\b\u0018\u00002\u00020\u0001B\u0019\u0012\u0012\u0010\u0002\u001a\u000e\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u0004\u0018\u00010\u0003\u00a2\u0006\u0002\u0010\u0005J\u0015\u0010\b\u001a\u000e\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u0004\u0018\u00010\u0003H\u00c6\u0003J\u001f\u0010\t\u001a\u00020\u00002\u0014\b\u0002\u0010\u0002\u001a\u000e\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u0004\u0018\u00010\u0003H\u00c6\u0001J\u0013\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\r\u001a\u00020\u000eH\u00d6\u0001J\t\u0010\u000f\u001a\u00020\u0010H\u00d6\u0001R\u001d\u0010\u0002\u001a\u000e\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0011"}, d2={"Lorg/jetbrains/kotlin/resolve/konan/diagnostics/NativeThrowsChecker$ThrowsFilter;", "", "classes", "", "Lorg/jetbrains/kotlin/resolve/constants/ConstantValue;", "(Ljava/util/Set;)V", "getClasses", "()Ljava/util/Set;", "component1", "copy", "equals", "", "other", "hashCode", "", "toString", "", "frontend.native"})
    private static final class ThrowsFilter {
        @Nullable
        private final Set<ConstantValue<?>> classes;

        public ThrowsFilter(@Nullable Set<? extends ConstantValue<?>> classes2) {
            this.classes = classes2;
        }

        @Nullable
        public final Set<ConstantValue<?>> getClasses() {
            return this.classes;
        }

        @Nullable
        public final Set<ConstantValue<?>> component1() {
            return this.classes;
        }

        @NotNull
        public final ThrowsFilter copy(@Nullable Set<? extends ConstantValue<?>> classes2) {
            return new ThrowsFilter(classes2);
        }

        public static /* synthetic */ ThrowsFilter copy$default(ThrowsFilter throwsFilter, Set set, int n, Object object) {
            if ((n & 1) != 0) {
                set = throwsFilter.classes;
            }
            return throwsFilter.copy(set);
        }

        @NotNull
        public String toString() {
            return "ThrowsFilter(classes=" + this.classes + ')';
        }

        public int hashCode() {
            return this.classes == null ? 0 : ((Object)this.classes).hashCode();
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof ThrowsFilter)) {
                return false;
            }
            ThrowsFilter throwsFilter = (ThrowsFilter)other;
            return Intrinsics.areEqual(this.classes, throwsFilter.classes);
        }
    }
}

