/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.incremental.multiproject;

import java.io.Closeable;
import java.io.File;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.io.CloseableKt;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.incremental.IncrementalModuleEntry;
import org.jetbrains.kotlin.incremental.IncrementalModuleInfo;
import org.jetbrains.kotlin.incremental.multiproject.ModulesApiHistoryAndroid;
import org.jetbrains.kotlin.incremental.multiproject.ModulesApiHistoryBase;
import org.jetbrains.kotlin.incremental.multiproject.ModulesApiHistoryJvm;
import org.jetbrains.kotlin.incremental.multiproject.ModulesApiHistoryKt;
import org.jetbrains.kotlin.incremental.util.Either;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001c\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0010\u001e\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u001c\u0010\u0007\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\n0\t0\b2\u0006\u0010\u000b\u001a\u00020\nH\u0016J\u001c\u0010\f\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\n0\t0\b2\u0006\u0010\u000b\u001a\u00020\nH\u0014J\u001c\u0010\r\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\n0\t0\b2\u0006\u0010\u000e\u001a\u00020\nH\u0014J>\u0010\u000f\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\n0\t0\b2\u0006\u0010\u0010\u001a\u00020\u00112\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00140\u00132\u0012\u0010\u0015\u001a\u000e\u0012\u0004\u0012\u00020\u0017\u0012\u0004\u0012\u00020\n0\u0016H\u0002J\u0016\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00140\u00192\u0006\u0010\u0010\u001a\u00020\nH\u0002J\u0016\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00140\u001b2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J\"\u0010\u001c\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\n0\t0\b2\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\n0\tH\u0016R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lorg/jetbrains/kotlin/incremental/multiproject/ModulesApiHistoryAndroid;", "Lorg/jetbrains/kotlin/incremental/multiproject/ModulesApiHistoryBase;", "modulesInfo", "Lorg/jetbrains/kotlin/incremental/IncrementalModuleInfo;", "(Lorg/jetbrains/kotlin/incremental/IncrementalModuleInfo;)V", "delegate", "Lorg/jetbrains/kotlin/incremental/multiproject/ModulesApiHistoryJvm;", "abiSnapshot", "Lorg/jetbrains/kotlin/incremental/util/Either;", "", "Ljava/io/File;", "jar", "getBuildHistoryFilesForJar", "getBuildHistoryForDir", "file", "getHistoryForModuleNames", "path", "Ljava/nio/file/Path;", "moduleNames", "", "", "fileLocation", "Lkotlin/Function1;", "Lorg/jetbrains/kotlin/incremental/IncrementalModuleEntry;", "getPossibleModuleNamesForDir", "", "getPossibleModuleNamesFromJar", "", "historyFilesForChangedFiles", "changedFiles", "incremental-compilation-impl"})
@SourceDebugExtension(value={"SMAP\nModulesApiHistory.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ModulesApiHistory.kt\norg/jetbrains/kotlin/incremental/multiproject/ModulesApiHistoryAndroid\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,245:1\n3792#2:246\n4307#2,2:247\n1549#3:249\n1620#3,3:250\n1446#3,5:253\n766#3:258\n857#3,2:259\n1620#3,3:261\n*S KotlinDebug\n*F\n+ 1 ModulesApiHistory.kt\norg/jetbrains/kotlin/incremental/multiproject/ModulesApiHistoryAndroid\n*L\n230#1:246\n230#1:247,2\n230#1:249\n230#1:250,3\n235#1:253,5\n236#1:258\n236#1:259,2\n239#1:261,3\n*E\n"})
public final class ModulesApiHistoryAndroid
extends ModulesApiHistoryBase {
    @NotNull
    private final ModulesApiHistoryJvm delegate;

    public ModulesApiHistoryAndroid(@NotNull IncrementalModuleInfo modulesInfo) {
        Intrinsics.checkNotNullParameter(modulesInfo, "modulesInfo");
        super(modulesInfo);
        this.delegate = new ModulesApiHistoryJvm(modulesInfo);
    }

    @Override
    @NotNull
    public Either<Set<File>> historyFilesForChangedFiles(@NotNull Set<? extends File> changedFiles) {
        Intrinsics.checkNotNullParameter(changedFiles, "changedFiles");
        Either<Set<File>> historyFromDelegate = this.delegate.historyFilesForChangedFiles(changedFiles);
        if (historyFromDelegate instanceof Either.Success) {
            return historyFromDelegate;
        }
        return super.historyFilesForChangedFiles(changedFiles);
    }

    @Override
    @NotNull
    protected Either<Set<File>> getBuildHistoryFilesForJar(@NotNull File jar) {
        Intrinsics.checkNotNullParameter(jar, "jar");
        if (!this.isInProjectBuildDir(jar)) {
            return new Either.Error("Non-project jar is modified " + jar);
        }
        Path jarPath = Paths.get(jar.getAbsolutePath(), new String[0]);
        Intrinsics.checkNotNullExpressionValue(jarPath, "jarPath");
        return this.getHistoryForModuleNames(jarPath, (Iterable<String>)this.getPossibleModuleNamesFromJar(jarPath), getBuildHistoryFilesForJar.1.INSTANCE);
    }

    @Override
    @NotNull
    public Either<Set<File>> abiSnapshot(@NotNull File jar) {
        Either either;
        Intrinsics.checkNotNullParameter(jar, "jar");
        Path jarPath = Paths.get(jar.getAbsolutePath(), new String[0]);
        Intrinsics.checkNotNullExpressionValue(jarPath, "jarPath");
        Either<Set<File>> result2 = this.getHistoryForModuleNames(jarPath, (Iterable<String>)this.getPossibleModuleNamesFromJar(jarPath), abiSnapshot.result.1.INSTANCE);
        if (result2 instanceof Either.Success) {
            either = new Either.Success(((Either.Success)result2).getValue());
        } else if (result2 instanceof Either.Error) {
            either = new Either.Error(((Either.Error)result2).getReason());
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return either;
    }

    @Override
    @NotNull
    protected Either<Set<File>> getBuildHistoryForDir(@NotNull File file2) {
        Intrinsics.checkNotNullParameter(file2, "file");
        if (!this.isInProjectBuildDir(file2)) {
            return new Either.Error("Non-project file while looking for history " + file2);
        }
        List moduleNames = CollectionsKt.plus((Collection)this.getPossibleModuleNamesForDir(FilesKt.resolve(file2, "meta-inf")), (Iterable)this.getPossibleModuleNamesForDir(FilesKt.resolve(file2, "META-INF")));
        if (moduleNames.isEmpty()) {
            Either either;
            if (file2.getParentFile() == null) {
                either = new Either.Error("Unable to find history for " + file2);
            } else {
                File file3 = file2.getParentFile();
                Intrinsics.checkNotNullExpressionValue(file3, "file.parentFile");
                either = this.getBuildHistoryForDir(file3);
            }
            return either;
        }
        Path path2 = file2.toPath();
        Intrinsics.checkNotNullExpressionValue(path2, "file.toPath()");
        return this.getHistoryForModuleNames(path2, moduleNames, getBuildHistoryForDir.1.INSTANCE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final Collection<String> getPossibleModuleNamesFromJar(Path path2) {
        HashSet<String> result2 = new HashSet<String>();
        try {
            Closeable closeable = new ZipFile(path2.toFile());
            Throwable throwable = null;
            try {
                ZipFile zip2 = (ZipFile)closeable;
                boolean bl = false;
                Enumeration<? extends ZipEntry> entries = zip2.entries();
                while (entries.hasMoreElements()) {
                    ZipEntry entry = entries.nextElement();
                    String name2 = entry.getName();
                    Intrinsics.checkNotNullExpressionValue(name2, "name");
                    if (!StringsKt.endsWith(name2, ".kotlin_module", true)) continue;
                    result2.add(FilesKt.getNameWithoutExtension(new File(name2)));
                }
                Unit unit2 = Unit.INSTANCE;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally(closeable, throwable);
            }
        }
        catch (Throwable t) {
            return CollectionsKt.emptyList();
        }
        return result2;
    }

    /*
     * WARNING - void declaration
     */
    private final List<String> getPossibleModuleNamesForDir(File path2) {
        void $this$mapTo$iv$iv;
        Iterable $this$filterTo$iv$iv;
        if (!path2.isDirectory()) {
            return CollectionsKt.emptyList();
        }
        File[] fileArray = path2.listFiles();
        Intrinsics.checkNotNullExpressionValue(fileArray, "path.listFiles()");
        Object[] $this$filter$iv = fileArray;
        boolean $i$f$filter = false;
        Object[] objectArray = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (File element$iv$iv : $this$filterTo$iv$iv) {
            File it = element$iv$iv;
            boolean bl = false;
            String string2 = it.getName();
            Intrinsics.checkNotNullExpressionValue(string2, "it.name");
            if (!StringsKt.endsWith(string2, ".kotlin_module", true)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$map$iv = (List)destination$iv$iv;
        boolean $i$f$map = false;
        $this$filterTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            File element$iv$iv;
            element$iv$iv = (File)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            Intrinsics.checkNotNullExpressionValue(it, "it");
            collection.add(FilesKt.getNameWithoutExtension((File)it));
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    private final Either<Set<File>> getHistoryForModuleNames(Path path2, Iterable<String> moduleNames, Function1<? super IncrementalModuleEntry, ? extends File> fileLocation) {
        void $this$mapTo$iv;
        void $this$filterTo$iv$iv;
        void $this$flatMapTo$iv;
        Iterable<String> iterable = moduleNames;
        Collection destination$iv = new HashSet();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv : $this$flatMapTo$iv) {
            String it = (String)element$iv;
            boolean bl = false;
            Set<IncrementalModuleEntry> set = this.getModulesInfo().getNameToModules().get(it);
            if (set == null) {
                set = SetsKt.emptySet();
            }
            Iterable list$iv = set;
            CollectionsKt.addAll(destination$iv, list$iv);
        }
        HashSet possibleModules = (HashSet)destination$iv;
        Iterable $this$filter$iv = possibleModules;
        boolean $i$f$filter22 = false;
        Iterable iterable2 = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            IncrementalModuleEntry it = (IncrementalModuleEntry)element$iv$iv;
            boolean bl = false;
            Path path3 = Paths.get(it.getBuildDir().getAbsolutePath(), new String[0]);
            Intrinsics.checkNotNullExpressionValue(path3, "get(it.buildDir.absolutePath)");
            if (!ModulesApiHistoryKt.access$isParentOf(path3, path2)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List modules2 = (List)destination$iv$iv;
        if (modules2.isEmpty()) {
            return new Either.Error("Unknown module for " + path2 + " (candidates: " + CollectionsKt.joinToString$default(possibleModules, null, null, null, 0, null, null, 63, null) + ')');
        }
        Iterable $i$f$filter22 = modules2;
        Collection destination$iv2 = new HashSet();
        boolean $i$f$mapTo = false;
        for (Object item$iv : $this$mapTo$iv) {
            void it;
            Object element$iv$iv;
            element$iv$iv = (IncrementalModuleEntry)item$iv;
            Collection collection = destination$iv2;
            boolean bl = false;
            collection.add(fileLocation.invoke((IncrementalModuleEntry)it));
        }
        HashSet result2 = (HashSet)destination$iv2;
        return new Either.Success<HashSet>(result2);
    }
}

