/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.checkers.expression;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.AbstractKtSourceElement;
import org.jetbrains.kotlin.KtFakeSourceElementKind;
import org.jetbrains.kotlin.KtSourceElement;
import org.jetbrains.kotlin.diagnostics.DiagnosticContext;
import org.jetbrains.kotlin.diagnostics.DiagnosticReporter;
import org.jetbrains.kotlin.diagnostics.KtDiagnosticReportHelpersKt;
import org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import org.jetbrains.kotlin.fir.analysis.checkers.expression.FirExpressionChecker;
import org.jetbrains.kotlin.fir.analysis.diagnostics.FirErrors;
import org.jetbrains.kotlin.fir.diagnostics.ConeDiagnostic;
import org.jetbrains.kotlin.fir.diagnostics.ConeSimpleDiagnostic;
import org.jetbrains.kotlin.fir.diagnostics.DiagnosticKind;
import org.jetbrains.kotlin.fir.expressions.FirExpression;
import org.jetbrains.kotlin.fir.expressions.FirStatement;
import org.jetbrains.kotlin.fir.expressions.impl.FirNoReceiverExpression;
import org.jetbrains.kotlin.fir.types.ConeClassLikeType;
import org.jetbrains.kotlin.fir.types.ConeErrorType;
import org.jetbrains.kotlin.fir.types.ConeKotlinType;
import org.jetbrains.kotlin.fir.types.ConeTypeProjection;
import org.jetbrains.kotlin.fir.types.ConeTypeProjectionKt;
import org.jetbrains.kotlin.fir.types.FirTypeUtilsKt;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\f\u0012\u0004\u0012\u00020\u00020\u0001j\u0002`\u0003B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0004J \u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u00022\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016R\u0018\u0010\u0005\u001a\u00020\u0006*\u00020\u00028BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0007\u00a8\u0006\u000f"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/checkers/expression/FirRecursiveProblemChecker;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/expression/FirExpressionChecker;", "Lorg/jetbrains/kotlin/fir/expressions/FirStatement;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/expression/FirBasicExpressionChecker;", "()V", "isExpressionWithAlwaysImplicitTypeRef", "", "(Lorg/jetbrains/kotlin/fir/expressions/FirStatement;)Z", "check", "", "expression", "context", "Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "reporter", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;", "checkers"})
public final class FirRecursiveProblemChecker
extends FirExpressionChecker<FirStatement> {
    @NotNull
    public static final FirRecursiveProblemChecker INSTANCE = new FirRecursiveProblemChecker();

    private FirRecursiveProblemChecker() {
    }

    @Override
    public void check(@NotNull FirStatement expression2, @NotNull CheckerContext context, @NotNull DiagnosticReporter reporter) {
        block3: {
            block2: {
                Intrinsics.checkNotNullParameter(expression2, "expression");
                Intrinsics.checkNotNullParameter(context, "context");
                Intrinsics.checkNotNullParameter(reporter, "reporter");
                if (!(expression2 instanceof FirExpression)) break block2;
                KtSourceElement ktSourceElement = expression2.getSource();
                if (!((ktSourceElement != null ? ktSourceElement.getKind() : null) instanceof KtFakeSourceElementKind) && !this.isExpressionWithAlwaysImplicitTypeRef(expression2)) break block3;
            }
            return;
        }
        FirRecursiveProblemChecker.check$checkConeType(reporter, expression2, context, FirTypeUtilsKt.getConeType(((FirExpression)expression2).getTypeRef()));
    }

    private final boolean isExpressionWithAlwaysImplicitTypeRef(FirStatement $this$isExpressionWithAlwaysImplicitTypeRef) {
        return $this$isExpressionWithAlwaysImplicitTypeRef instanceof FirNoReceiverExpression;
    }

    /*
     * Enabled aggressive block sorting
     */
    private static final void check$checkConeType(DiagnosticReporter $reporter, FirStatement $expression, CheckerContext $context, ConeKotlinType coneType) {
        if (coneType instanceof ConeErrorType) {
            ConeDiagnostic coneDiagnostic = ((ConeErrorType)coneType).getDiagnostic();
            ConeSimpleDiagnostic coneSimpleDiagnostic = coneDiagnostic instanceof ConeSimpleDiagnostic ? (ConeSimpleDiagnostic)coneDiagnostic : null;
            if ((coneSimpleDiagnostic != null ? coneSimpleDiagnostic.getKind() : null) == DiagnosticKind.RecursionInImplicitTypes) {
                KtDiagnosticReportHelpersKt.reportOn$default($reporter, (AbstractKtSourceElement)$expression.getSource(), FirErrors.INSTANCE.getTYPECHECKER_HAS_RUN_INTO_RECURSIVE_PROBLEM(), (DiagnosticContext)$context, null, 8, null);
                return;
            }
        }
        if (!(coneType instanceof ConeClassLikeType)) return;
        ConeTypeProjection[] coneTypeProjectionArray = ((ConeClassLikeType)coneType).getTypeArguments();
        int n = 0;
        int n2 = coneTypeProjectionArray.length;
        while (n < n2) {
            ConeTypeProjection typeArgument = coneTypeProjectionArray[n];
            FirRecursiveProblemChecker.check$checkConeType($reporter, $expression, $context, ConeTypeProjectionKt.getType(typeArgument));
            ++n;
        }
    }
}

