/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.codegen.intrinsics;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.builtins.StandardNames;
import org.jetbrains.kotlin.codegen.AsmUtil;
import org.jetbrains.kotlin.codegen.StackValue;
import org.jetbrains.kotlin.codegen.inline.ReificationArgument;
import org.jetbrains.kotlin.codegen.inline.ReifiedTypeInliner;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.PackageFragmentDescriptor;
import org.jetbrains.kotlin.resolve.jvm.AsmTypes;
import org.jetbrains.kotlin.util.OperatorNameConventions;
import org.jetbrains.org.objectweb.asm.Label;
import org.jetbrains.org.objectweb.asm.Type;
import org.jetbrains.org.objectweb.asm.commons.InstructionAdapter;
import org.jetbrains.org.objectweb.asm.commons.Method;
import org.jetbrains.org.objectweb.asm.tree.MethodNode;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nJ\u000e\u0010\u000b\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nJ\u000e\u0010\f\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nJ\u000e\u0010\r\u001a\u00020\u00042\u0006\u0010\u000e\u001a\u00020\u000fJ\u000e\u0010\u0010\u001a\u00020\u00042\u0006\u0010\u000e\u001a\u00020\u000fR\u0018\u0010\u0003\u001a\u00020\u0004*\u00020\u00058BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0003\u0010\u0006\u00a8\u0006\u0011"}, d2={"Lorg/jetbrains/kotlin/codegen/intrinsics/IntrinsicArrayConstructors;", "", "()V", "isBuiltInsPackage", "", "Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;", "(Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;)Z", "generateArrayConstructorBody", "Lorg/jetbrains/org/objectweb/asm/tree/MethodNode;", "method", "Lorg/jetbrains/org/objectweb/asm/commons/Method;", "generateArrayOfBody", "generateEmptyArrayBody", "isArrayOf", "descriptor", "Lorg/jetbrains/kotlin/descriptors/FunctionDescriptor;", "isEmptyArray", "backend"})
public final class IntrinsicArrayConstructors {
    @NotNull
    public static final IntrinsicArrayConstructors INSTANCE = new IntrinsicArrayConstructors();

    private IntrinsicArrayConstructors() {
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final boolean isArrayOf(@NotNull FunctionDescriptor descriptor2) {
        Intrinsics.checkNotNullParameter(descriptor2, "descriptor");
        if (!Intrinsics.areEqual(descriptor2.getName().asString(), "arrayOf")) return false;
        DeclarationDescriptor declarationDescriptor = descriptor2.getContainingDeclaration();
        Intrinsics.checkNotNullExpressionValue(declarationDescriptor, "descriptor.containingDeclaration");
        if (!this.isBuiltInsPackage(declarationDescriptor)) return false;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final boolean isEmptyArray(@NotNull FunctionDescriptor descriptor2) {
        Intrinsics.checkNotNullParameter(descriptor2, "descriptor");
        if (!Intrinsics.areEqual(descriptor2.getName().asString(), "emptyArray")) return false;
        DeclarationDescriptor declarationDescriptor = descriptor2.getContainingDeclaration();
        Intrinsics.checkNotNullExpressionValue(declarationDescriptor, "descriptor.containingDeclaration");
        if (!this.isBuiltInsPackage(declarationDescriptor)) return false;
        return true;
    }

    private final boolean isBuiltInsPackage(DeclarationDescriptor $this$isBuiltInsPackage) {
        return $this$isBuiltInsPackage instanceof PackageFragmentDescriptor && Intrinsics.areEqual(((PackageFragmentDescriptor)$this$isBuiltInsPackage).getFqName(), StandardNames.BUILT_INS_PACKAGE_FQ_NAME);
    }

    @NotNull
    public final MethodNode generateArrayConstructorBody(@NotNull Method method) {
        Intrinsics.checkNotNullParameter(method, "method");
        MethodNode node = new MethodNode(393216, 25, method.getName(), method.getDescriptor(), null, null);
        Type arrayType = method.getReturnType();
        Type type2 = AsmUtil.correctElementType(arrayType);
        Intrinsics.checkNotNullExpressionValue(type2, "correctElementType(arrayType)");
        Type elementType = type2;
        StackValue.Local local = StackValue.local(0, Type.INT_TYPE);
        Intrinsics.checkNotNullExpressionValue(local, "local(0, Type.INT_TYPE)");
        StackValue.Local size = local;
        StackValue.Local local2 = StackValue.local(1, AsmTypes.FUNCTION1);
        Intrinsics.checkNotNullExpressionValue(local2, "local(1, AsmTypes.FUNCTION1)");
        StackValue.Local lambda2 = local2;
        StackValue.Local local3 = StackValue.local(2, Type.INT_TYPE);
        Intrinsics.checkNotNullExpressionValue(local3, "local(2, Type.INT_TYPE)");
        StackValue.Local loopIndex = local3;
        StackValue.Local local4 = StackValue.local(3, arrayType);
        Intrinsics.checkNotNullExpressionValue(local4, "local(3, arrayType)");
        StackValue.Local array2 = local4;
        InstructionAdapter iv = new InstructionAdapter(node);
        size.put(iv);
        if (elementType.getSort() == 10) {
            ReifiedTypeInliner.Companion.putReifiedOperationMarker(ReifiedTypeInliner.OperationKind.NEW_ARRAY, new ReificationArgument("T", true, 0), iv);
        }
        iv.newarray(elementType);
        array2.store(StackValue.onStack(arrayType), iv);
        loopIndex.store(StackValue.constant(0), iv);
        Label begin = new Label();
        iv.visitLabel(begin);
        loopIndex.put(iv);
        size.put(iv);
        Label end = new Label();
        iv.ificmpge(end);
        array2.put(iv);
        loopIndex.put(iv);
        lambda2.put(iv);
        loopIndex.put(AsmUtil.boxType(Type.INT_TYPE), iv);
        Type[] typeArray = new Type[]{AsmTypes.OBJECT_TYPE};
        iv.invokeinterface(AsmTypes.FUNCTION1.getInternalName(), OperatorNameConventions.INVOKE.asString(), Type.getMethodDescriptor(AsmTypes.OBJECT_TYPE, typeArray));
        StackValue.coerce(AsmTypes.OBJECT_TYPE, elementType, iv);
        iv.astore(elementType);
        iv.iinc(loopIndex.index, 1);
        iv.goTo(begin);
        iv.visitLabel(end);
        array2.put(iv);
        iv.areturn(arrayType);
        iv.visitMaxs(5, 4);
        return node;
    }

    @NotNull
    public final MethodNode generateEmptyArrayBody(@NotNull Method method) {
        Intrinsics.checkNotNullParameter(method, "method");
        MethodNode node = new MethodNode(393216, 25, method.getName(), method.getDescriptor(), null, null);
        InstructionAdapter iv = new InstructionAdapter(node);
        iv.iconst(0);
        ReifiedTypeInliner.Companion.putReifiedOperationMarker(ReifiedTypeInliner.OperationKind.NEW_ARRAY, new ReificationArgument("T", true, 0), iv);
        iv.newarray(AsmTypes.OBJECT_TYPE);
        iv.areturn(AsmTypes.OBJECT_TYPE);
        iv.visitMaxs(3, 1);
        return node;
    }

    @NotNull
    public final MethodNode generateArrayOfBody(@NotNull Method method) {
        Intrinsics.checkNotNullParameter(method, "method");
        MethodNode node = new MethodNode(393216, 25, method.getName(), method.getDescriptor(), null, null);
        InstructionAdapter iv = new InstructionAdapter(node);
        iv.load(0, AsmTypes.OBJECT_TYPE);
        iv.areturn(AsmTypes.OBJECT_TYPE);
        iv.visitMaxs(1, 1);
        return node;
    }
}

