/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rd.ui.icons;

import com.intellij.codeWithMe.ClientId;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.ui.icons.CachedImageIconKt;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.rd.ide.model.IconModel;
import com.jetbrains.rd.platform.util.idea.LifetimedService;
import com.jetbrains.rd.ui.icons.ProtocolIconConverter;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicLong;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Service(value={Service.Level.APP})
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\t\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0007\u0018\u0000 \u00172\u00020\u0001:\u0001\u0017B\u0005\u00a2\u0006\u0002\u0010\u0002J\"\u0010\f\u001a\u00020\u00072\u0006\u0010\r\u001a\u00020\u00052\u0012\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00070\u000fJ&\u0010\u0010\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\u0011\u001a\u00020\u00072\u0014\u0010\u000e\u001a\u0010\u0012\u0004\u0012\u00020\u0005\u0012\u0006\u0012\u0004\u0018\u00010\u000b0\u000fJ\u000e\u0010\u0012\u001a\u00020\u00072\u0006\u0010\u0013\u001a\u00020\u000bJ\u0010\u0010\u0014\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\u0011\u001a\u00020\u0007J\u0006\u0010\u0015\u001a\u00020\u0016R)\u0010\u0003\u001a\u001d\u0012\t\u0012\u00070\u0005\u00a2\u0006\u0002\b\u0006\u0012\t\u0012\u00070\u0007\u00a2\u0006\u0002\b\u00060\u0004\u00a2\u0006\u0002\b\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R)\u0010\n\u001a\u001d\u0012\t\u0012\u00070\u0007\u00a2\u0006\u0002\b\u0006\u0012\t\u0012\u00070\u000b\u00a2\u0006\u0002\b\u00060\u0004\u00a2\u0006\u0002\b\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lcom/jetbrains/rd/ui/icons/ProtocolIconRegistry;", "Lcom/jetbrains/rd/platform/util/idea/LifetimedService;", "()V", "imageIconCache", "Ljava/util/concurrent/ConcurrentMap;", "", "Lorg/jetbrains/annotations/NotNull;", "Ljavax/swing/Icon;", "imageIconCounter", "Ljava/util/concurrent/atomic/AtomicLong;", "imageIconModelCache", "Lcom/jetbrains/rd/ide/model/IconModel;", "cacheIcon", "identity", "function", "Lkotlin/Function1;", "cacheModel", "icon", "createIcon", "model", "createModel", "dropCache", "", "Companion", "intellij.rd.platform"})
@SourceDebugExtension(value={"SMAP\nProtocolIconRegistry.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ProtocolIconRegistry.kt\ncom/jetbrains/rd/ui/icons/ProtocolIconRegistry\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,58:1\n10#2:59\n*S KotlinDebug\n*F\n+ 1 ProtocolIconRegistry.kt\ncom/jetbrains/rd/ui/icons/ProtocolIconRegistry\n*L\n18#1:59\n*E\n"})
public final class ProtocolIconRegistry
extends LifetimedService {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ConcurrentMap<Long, Icon> imageIconCache;
    @NotNull
    private final ConcurrentMap<Icon, IconModel> imageIconModelCache;
    @NotNull
    private final AtomicLong imageIconCounter;
    @NotNull
    private static final Logger logger;

    public ProtocolIconRegistry() {
        ConcurrentMap concurrentMap = ContainerUtil.createConcurrentSoftValueMap();
        Intrinsics.checkNotNullExpressionValue((Object)concurrentMap, (String)"createConcurrentSoftValueMap(...)");
        this.imageIconCache = concurrentMap;
        ConcurrentMap concurrentMap2 = ContainerUtil.createConcurrentSoftKeySoftValueMap();
        Intrinsics.checkNotNullExpressionValue((Object)concurrentMap2, (String)"createConcurrentSoftKeySoftValueMap(...)");
        this.imageIconModelCache = concurrentMap2;
        this.imageIconCounter = new AtomicLong();
    }

    @NotNull
    public final Icon createIcon(@NotNull IconModel model) {
        Intrinsics.checkNotNullParameter((Object)model, (String)"model");
        Icon icon2 = (Icon)ProtocolIconConverter.Companion.getEP_NAME().computeSafeIfAny(arg_0 -> ProtocolIconRegistry.createIcon$lambda$0(model, this, arg_0));
        if (icon2 == null) {
            logger.error("Failed to deserialize an icon for model " + model);
            return CachedImageIconKt.getEMPTY_ICON();
        }
        return icon2;
    }

    @Nullable
    public final IconModel createModel(@NotNull Icon icon2) {
        Intrinsics.checkNotNullParameter((Object)icon2, (String)"icon");
        IconModel model = (IconModel)ProtocolIconConverter.Companion.getEP_NAME().computeSafeIfAny(arg_0 -> ProtocolIconRegistry.createModel$lambda$1(icon2, this, arg_0));
        if (model == null) {
            logger.warn("Failed to serialize a model for icon " + icon2);
        }
        return model;
    }

    @Nullable
    public final IconModel cacheModel(@NotNull Icon icon2, @NotNull Function1<? super Long, ? extends IconModel> function) {
        Intrinsics.checkNotNullParameter((Object)icon2, (String)"icon");
        Intrinsics.checkNotNullParameter(function, (String)"function");
        return this.imageIconModelCache.computeIfAbsent(icon2, arg_0 -> ProtocolIconRegistry.cacheModel$lambda$2((Function1)new Function1<Icon, IconModel>(function, this){
            final /* synthetic */ Function1<Long, IconModel> $function;
            final /* synthetic */ ProtocolIconRegistry this$0;
            {
                this.$function = $function;
                this.this$0 = $receiver;
                super(1);
            }

            public final IconModel invoke(Icon it) {
                return (IconModel)this.$function.invoke((Object)ProtocolIconRegistry.access$getImageIconCounter$p(this.this$0).incrementAndGet());
            }
        }, arg_0));
    }

    @NotNull
    public final Icon cacheIcon(long identity, @NotNull Function1<? super Long, ? extends Icon> function) {
        Intrinsics.checkNotNullParameter(function, (String)"function");
        Icon icon2 = this.imageIconCache.computeIfAbsent(identity, arg_0 -> ProtocolIconRegistry.cacheIcon$lambda$3(function, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)icon2, (String)"computeIfAbsent(...)");
        return icon2;
    }

    public final void dropCache() {
        this.imageIconCache.clear();
        this.imageIconModelCache.clear();
    }

    private static final Icon createIcon$lambda$0(IconModel $model, ProtocolIconRegistry this$0, ProtocolIconConverter it) {
        Intrinsics.checkNotNullParameter((Object)$model, (String)"$model");
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.createIcon($model, this$0);
    }

    private static final IconModel createModel$lambda$1(Icon $icon, ProtocolIconRegistry this$0, ProtocolIconConverter it) {
        Intrinsics.checkNotNullParameter((Object)$icon, (String)"$icon");
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.createModel($icon, this$0);
    }

    private static final IconModel cacheModel$lambda$2(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (IconModel)$tmp0.invoke(p0);
    }

    private static final Icon cacheIcon$lambda$3(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Icon)$tmp0.invoke(p0);
    }

    public static final /* synthetic */ AtomicLong access$getImageIconCounter$p(ProtocolIconRegistry $this) {
        return $this.imageIconCounter;
    }

    static {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(ProtocolIconRegistry.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        ProtocolIconRegistry.logger = logger;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\u0005\u001a\u00020\u0006R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lcom/jetbrains/rd/ui/icons/ProtocolIconRegistry$Companion;", "", "()V", "logger", "Lcom/intellij/openapi/diagnostic/Logger;", "getInstance", "Lcom/jetbrains/rd/ui/icons/ProtocolIconRegistry;", "intellij.rd.platform"})
    @SourceDebugExtension(value={"SMAP\nProtocolIconRegistry.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ProtocolIconRegistry.kt\ncom/jetbrains/rd/ui/icons/ProtocolIconRegistry$Companion\n+ 2 service.kt\ncom/intellij/openapi/components/ServiceKt\n*L\n1#1,58:1\n43#2,3:59\n*S KotlinDebug\n*F\n+ 1 ProtocolIconRegistry.kt\ncom/jetbrains/rd/ui/icons/ProtocolIconRegistry$Companion\n*L\n16#1:59,3\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final ProtocolIconRegistry getInstance() {
            boolean $i$f$service = false;
            Class<ProtocolIconRegistry> serviceClass$iv = ProtocolIconRegistry.class;
            Object object = ApplicationManager.getApplication().getService(serviceClass$iv);
            if (object == null) {
                throw new RuntimeException("Cannot find service " + serviceClass$iv.getName() + " (classloader=" + serviceClass$iv.getClassLoader() + ", client=" + ClientId.Companion.getCurrentOrNull() + ")");
            }
            return (ProtocolIconRegistry)object;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

