/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rd.ui.bindable.views;

import com.intellij.execution.console.ConsolePromptDecorator;
import com.intellij.execution.impl.ConsoleViewUtil;
import com.intellij.execution.ui.ConsoleViewContentType;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.TextAnnotationGutterProvider;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.impl.EditorComponentImpl;
import com.intellij.openapi.ui.Splitter;
import com.intellij.util.ui.UIUtil;
import com.jetbrains.ide.model.uiautomation.BeConsole;
import com.jetbrains.ide.model.uiautomation.BeConsolePrompt;
import com.jetbrains.rd.ui.bindable.ViewBinder;
import com.jetbrains.rd.ui.bindable.ViewRegistryKt;
import com.jetbrains.rd.ui.bindable.views.ThinClientConsoleEditorPanel;
import com.jetbrains.rd.util.lifetime.Lifetime;
import java.util.Collection;
import javax.swing.JComponent;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00022\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u000e\u0010\t\u001a\u0004\u0018\u00010\n*\u00020\u0005H\u0002\u00a8\u0006\u000b"}, d2={"Lcom/jetbrains/rd/ui/bindable/views/ConsoleControl;", "Lcom/jetbrains/rd/ui/bindable/ViewBinder;", "Lcom/jetbrains/ide/model/uiautomation/BeConsole;", "()V", "bind", "Ljavax/swing/JComponent;", "viewModel", "lifetime", "Lcom/jetbrains/rd/util/lifetime/Lifetime;", "findEditor", "Lcom/intellij/openapi/editor/ex/EditorEx;", "intellij.rd.ui"})
@SourceDebugExtension(value={"SMAP\nConsoleControl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ConsoleControl.kt\ncom/jetbrains/rd/ui/bindable/views/ConsoleControl\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,74:1\n10#2:75\n1#3:76\n*S KotlinDebug\n*F\n+ 1 ConsoleControl.kt\ncom/jetbrains/rd/ui/bindable/views/ConsoleControl\n*L\n31#1:75\n*E\n"})
public final class ConsoleControl
implements ViewBinder<BeConsole> {
    @Override
    @NotNull
    public JComponent bind(@NotNull BeConsole viewModel, @NotNull Lifetime lifetime) {
        Intrinsics.checkNotNullParameter((Object)((Object)viewModel), (String)"viewModel");
        Intrinsics.checkNotNullParameter((Object)lifetime, (String)"lifetime");
        JComponent editorPanel = ViewRegistryKt.getView(viewModel.getEditor(), lifetime);
        JComponent commandEditorPanel = ViewRegistryKt.getView(viewModel.getCommandEditor(), lifetime);
        EditorEx editor = this.findEditor(editorPanel);
        EditorEx commandEditor = this.findEditor(commandEditorPanel);
        if (editor == null || commandEditor == null) {
            boolean $i$f$logger = false;
            Logger logger = Logger.getInstance(ConsoleControl.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
            logger.error("Can't find editors for " + viewModel + " - " + editorPanel + " / " + commandEditorPanel);
            Splitter panel2 = new Splitter(true);
            panel2.setFirstComponent(editorPanel);
            panel2.setSecondComponent(commandEditorPanel);
            return (JComponent)panel2;
        }
        BeConsolePrompt prompt = viewModel.getPrompt();
        if (prompt != null) {
            ConsolePromptDecorator promptDecorator = new ConsolePromptDecorator(commandEditor);
            promptDecorator.setMainPrompt(prompt.getMainPrompt());
            promptDecorator.setIndentPrompt(prompt.getIndentPrompt());
            if (prompt.getTextAttributeKey() != null) {
                Object v3;
                block5: {
                    Collection collection = ConsoleViewContentType.getRegisteredTypes();
                    Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"getRegisteredTypes(...)");
                    Iterable iterable = collection;
                    for (Object t : iterable) {
                        ConsoleViewContentType it = (ConsoleViewContentType)t;
                        boolean bl = false;
                        TextAttributesKey textAttributesKey = it.getAttributesKey();
                        if (!Intrinsics.areEqual((Object)(textAttributesKey != null ? textAttributesKey.getExternalName() : null), (Object)prompt.getTextAttributeKey())) continue;
                        v3 = t;
                        break block5;
                    }
                    v3 = null;
                }
                ConsoleViewContentType contentType = v3;
                if (contentType != null) {
                    promptDecorator.setPromptAttributes(contentType);
                }
            }
            commandEditor.getGutter().registerTextAnnotation((TextAnnotationGutterProvider)promptDecorator);
        }
        ConsoleViewUtil.setupLanguageConsoleEditor((EditorEx)editor);
        ConsoleViewUtil.setupLanguageConsoleEditor((EditorEx)commandEditor);
        return new ThinClientConsoleEditorPanel(editor, commandEditor, editorPanel, commandEditorPanel);
    }

    private final EditorEx findEditor(JComponent $this$findEditor) {
        EditorComponentImpl editorComponentImpl = (EditorComponentImpl)UIUtil.findComponentOfType((JComponent)$this$findEditor, EditorComponentImpl.class);
        if (editorComponentImpl == null) {
            return null;
        }
        EditorComponentImpl editorComponent = editorComponentImpl;
        return (EditorEx)editorComponent.getEditor();
    }
}

