/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rd.ide.completion;

import com.intellij.codeInsight.CodeInsightBundle;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupEvent;
import com.intellij.codeInsight.lookup.LookupFocusDegree;
import com.intellij.codeInsight.lookup.LookupListener;
import com.intellij.codeInsight.lookup.impl.LookupImpl;
import com.intellij.codeInsight.lookup.impl.PrefixChangeListener;
import com.intellij.featureStatistics.FeatureUsageTracker;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.keymap.KeymapUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ui.update.MergingUpdateQueue;
import com.intellij.util.ui.update.Update;
import com.jetbrains.rd.ide.completion.LookupImplWrapper;
import com.jetbrains.rd.ide.completion.LookupUtilsKt;
import com.jetbrains.rd.ide.completion.LookupWrapper;
import com.jetbrains.rd.ide.completion.LookupWrapperListener;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function5;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.IntRange;
import kotlin.ranges.RangesKt;
import kotlin.reflect.KMutableProperty1;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.Promise;
import org.jetbrains.concurrency.Promises;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000l\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0010\u0018\u0000 <2\u00020\u0001:\u0001<B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010,\u001a\u00020-2\u0006\u0010.\u001a\u00020\u0016H\u0016J\b\u0010/\u001a\u00020-H\u0002J\b\u00100\u001a\u00020-H\u0002J\b\u00101\u001a\u00020-H\u0002J\b\u00102\u001a\u00020-H\u0016J\u001c\u00103\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00130\u00120\u00112\u0006\u00104\u001a\u00020\u0010H\u0016J\b\u00105\u001a\u00020-H\u0002J(\u00106\u001a\u00020-2\u001e\u00107\u001a\u001a\u0012\u0004\u0012\u00020\u0010\u0012\u0010\u0012\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00130\u00120\u00110\u000fH\u0016J$\u00108\u001a\b\u0012\u0004\u0012\u00020-0\u00112\f\u00109\u001a\b\u0012\u0004\u0012\u00020\u00130\u00122\u0006\u0010:\u001a\u00020\bH\u0016J\b\u0010;\u001a\u00020-H\u0016R\u0014\u0010\u0007\u001a\u00020\b8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\nR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R(\u0010\u000e\u001a\u001c\u0012\u0004\u0012\u00020\u0010\u0012\u0010\u0012\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00130\u00120\u0011\u0018\u00010\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00160\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R$\u0010\u0019\u001a\u00020\u00182\u0006\u0010\u0017\u001a\u00020\u00188V@VX\u0096\u000e\u00a2\u0006\f\u001a\u0004\b\u001a\u0010\u001b\"\u0004\b\u001c\u0010\u001dR$\u0010\u001f\u001a\u00020\u001e2\u0006\u0010\u0017\u001a\u00020\u001e8V@VX\u0096\u000e\u00a2\u0006\f\u001a\u0004\b \u0010!\"\u0004\b\"\u0010#R\u000e\u0010$\u001a\u00020%X\u0082\u0004\u00a2\u0006\u0002\n\u0000R$\u0010&\u001a\u00020\b2\u0006\u0010\u0017\u001a\u00020\b8V@VX\u0096\u000e\u00a2\u0006\f\u001a\u0004\b'\u0010\n\"\u0004\b(\u0010)R\u000e\u0010*\u001a\u00020+X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006="}, d2={"Lcom/jetbrains/rd/ide/completion/LookupImplWrapper;", "Lcom/jetbrains/rd/ide/completion/LookupWrapper;", "lookup", "Lcom/intellij/codeInsight/lookup/impl/LookupImpl;", "hasAllItems", "", "(Lcom/intellij/codeInsight/lookup/impl/LookupImpl;Z)V", "firstVisibleIndexOrZero", "", "getFirstVisibleIndexOrZero", "()I", "isChangingPrefix", "isUpdating", "Ljava/util/concurrent/atomic/AtomicBoolean;", "itemHandler", "Lkotlin/Function1;", "Lkotlin/ranges/IntRange;", "Lorg/jetbrains/concurrency/Promise;", "", "Lcom/intellij/codeInsight/lookup/LookupElement;", "listeners", "", "Lcom/jetbrains/rd/ide/completion/LookupWrapperListener;", "value", "Lcom/intellij/codeInsight/lookup/LookupFocusDegree;", "lookupFocusDegree", "getLookupFocusDegree", "()Lcom/intellij/codeInsight/lookup/LookupFocusDegree;", "setLookupFocusDegree", "(Lcom/intellij/codeInsight/lookup/LookupFocusDegree;)V", "", "prefix", "getPrefix", "()Ljava/lang/String;", "setPrefix", "(Ljava/lang/String;)V", "queue", "Lcom/intellij/util/ui/update/MergingUpdateQueue;", "selectedIndex", "getSelectedIndex", "setSelectedIndex", "(I)V", "updateCounter", "Ljava/util/concurrent/atomic/AtomicInteger;", "addListener", "", "listener", "advertiseCtrlArrows", "advertiseCtrlDot", "advertiseTabReplacement", "hide", "queryItems", "indices", "scheduleItemQuery", "setMissingItemHandler", "handler", "setVisibleItemsAsync", "items", "itemCount", "show", "Companion", "intellij.rd.platform"})
@SourceDebugExtension(value={"SMAP\nLookupImplWrapper.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LookupImplWrapper.kt\ncom/jetbrains/rd/ide/completion/LookupImplWrapper\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 ReflectionUtil.kt\ncom/jetbrains/rd/util/reflection/ReflectionUtilKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,294:1\n1#2:295\n11#3,12:296\n1855#4,2:308\n*S KotlinDebug\n*F\n+ 1 LookupImplWrapper.kt\ncom/jetbrains/rd/ide/completion/LookupImplWrapper\n*L\n79#1:296,12\n89#1:308,2\n*E\n"})
public final class LookupImplWrapper
implements LookupWrapper {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final LookupImpl lookup;
    private final boolean hasAllItems;
    private boolean isChangingPrefix;
    @NotNull
    private final List<LookupWrapperListener> listeners;
    @Nullable
    private Function1<? super IntRange, ? extends Promise<List<LookupElement>>> itemHandler;
    @NotNull
    private final MergingUpdateQueue queue;
    @NotNull
    private final AtomicBoolean isUpdating;
    @NotNull
    private final AtomicInteger updateCounter;
    private static final int HEAD_COUNT = 25;
    private static final int PRELOAD_THRESHOLD = 12;

    public LookupImplWrapper(@NotNull LookupImpl lookup, boolean hasAllItems) {
        Intrinsics.checkNotNullParameter((Object)lookup, (String)"lookup");
        this.lookup = lookup;
        this.hasAllItems = hasAllItems;
        this.listeners = new ArrayList();
        this.queue = new MergingUpdateQueue("LookupImplWrapper.queue", 250, true, null);
        this.isUpdating = new AtomicBoolean(false);
        this.updateCounter = new AtomicInteger(0);
        this.lookup.addLookupListener(new LookupListener(){

            public void uiRefreshed() {
                this.scheduleItemQuery();
            }

            public void currentItemChanged(@NotNull LookupEvent event) {
                Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                this.scheduleItemQuery();
            }
        });
        JList jList = this.lookup.getList();
        Intrinsics.checkNotNullExpressionValue((Object)jList, (String)"getList(...)");
        LookupImplWrapper.Companion.addCellRendererListener(jList, (Function1<? super LookupElement, Unit>)((Function1)new Function1<LookupElement, Unit>(){

            public final void invoke(@NotNull LookupElement item) {
                Intrinsics.checkNotNullParameter((Object)item, (String)"item");
                if (item == lookup.getDummyItem()) {
                    this.scheduleItemQuery();
                }
            }
        }));
    }

    private final int getFirstVisibleIndexOrZero() {
        Integer n = this.lookup.getList().getFirstVisibleIndex();
        int it = ((Number)n).intValue();
        boolean bl = false;
        Integer n2 = it >= 0 && this.hasAllItems ? n : null;
        return n2 != null ? n2 : 0;
    }

    @Override
    @NotNull
    public String getPrefix() {
        return LookupUtilsKt.getPrefix(this.lookup);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @Override
    public void setPrefix(@NotNull String value2) {
        Intrinsics.checkNotNullParameter((Object)value2, (String)"value");
        String oldPrefix = LookupUtilsKt.getPrefix(this.lookup);
        if (!Intrinsics.areEqual((Object)oldPrefix, (Object)value2) && !this.lookup.isLookupDisposed()) {
            void $this$usingTrueFlag_u24default$iv;
            LookupImplWrapper lookupImplWrapper = this;
            KMutableProperty1 flag$iv = (KMutableProperty1)prefix.1.INSTANCE;
            boolean set$iv = true;
            boolean $i$f$usingTrueFlag = false;
            if (!((Boolean)flag$iv.get((Object)$this$usingTrueFlag_u24default$iv) == false)) {
                String string = "Failed requirement.";
                throw new IllegalArgumentException(string.toString());
            }
            try {
                flag$iv.set((Object)$this$usingTrueFlag_u24default$iv, (Object)true);
                boolean bl = false;
                int commonPrefixLength = LookupImplWrapper.Companion.getCommonPrefixLength(oldPrefix, value2);
                int n = oldPrefix.length() - commonPrefixLength;
                int n2 = 0;
                while (n2 < n) {
                    int it = n2++;
                    boolean bl2 = false;
                    this.lookup.truncatePrefix(true, 0, false);
                }
                n2 = value2.length();
                for (int i2 = commonPrefixLength; i2 < n2; ++i2) {
                    this.lookup.appendPrefix(value2.charAt(i2), false);
                }
                this.lookup.refreshUi(false, true);
                Unit unit = Unit.INSTANCE;
            }
            finally {
                flag$iv.set((Object)$this$usingTrueFlag_u24default$iv, (Object)false);
            }
            Iterable $this$forEach$iv = this.listeners;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                LookupWrapperListener it = (LookupWrapperListener)element$iv;
                boolean bl = false;
                it.prefixChanged(LookupUtilsKt.getPrefix(this.lookup));
            }
        }
    }

    @Override
    public int getSelectedIndex() {
        return this.lookup.getSelectedIndex() - this.getFirstVisibleIndexOrZero();
    }

    @Override
    public void setSelectedIndex(int value2) {
        if (!this.lookup.isLookupDisposed()) {
            this.lookup.setSelectedIndex(value2 + this.getFirstVisibleIndexOrZero());
            this.lookup.markSelectionTouched();
        }
    }

    @Override
    @NotNull
    public LookupFocusDegree getLookupFocusDegree() {
        LookupFocusDegree lookupFocusDegree2 = this.lookup.getLookupFocusDegree();
        Intrinsics.checkNotNullExpressionValue((Object)lookupFocusDegree2, (String)"getLookupFocusDegree(...)");
        return lookupFocusDegree2;
    }

    @Override
    public void setLookupFocusDegree(@NotNull LookupFocusDegree value2) {
        Intrinsics.checkNotNullParameter((Object)value2, (String)"value");
        if (!this.lookup.isLookupDisposed() && this.lookup.getLookupFocusDegree() != value2) {
            this.lookup.setLookupFocusDegree(value2);
            ActionsKt.runInEdt$default(null, (Function0)((Function0)new Function0<Unit>(value2, this){
                final /* synthetic */ LookupFocusDegree $value;
                final /* synthetic */ LookupImplWrapper this$0;
                {
                    this.$value = $value;
                    this.this$0 = $receiver;
                    super(0);
                }

                public final void invoke() {
                    if (this.$value == LookupFocusDegree.FOCUSED) {
                        LookupImplWrapper.access$getLookup$p(this.this$0).markSelectionTouched();
                    }
                    LookupImplWrapper.access$getLookup$p(this.this$0).refreshUi(true, false);
                }
            }), (int)1, null);
        }
    }

    @Override
    public void setMissingItemHandler(@NotNull Function1<? super IntRange, ? extends Promise<List<LookupElement>>> handler2) {
        Intrinsics.checkNotNullParameter(handler2, (String)"handler");
        this.itemHandler = handler2;
    }

    @Override
    public void addListener(@NotNull LookupWrapperListener listener2) {
        Intrinsics.checkNotNullParameter((Object)listener2, (String)"listener");
        if (this.lookup.isLookupDisposed()) {
            return;
        }
        Disposer.register((Disposable)((Disposable)this.lookup), () -> LookupImplWrapper.addListener$lambda$4(listener2));
        this.lookup.addLookupListener(new LookupListener(listener2, this){
            final /* synthetic */ LookupWrapperListener $listener;
            final /* synthetic */ LookupImplWrapper this$0;
            {
                this.$listener = $listener;
                this.this$0 = $receiver;
            }

            public void lookupShown(@NotNull LookupEvent event) {
                Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                this.$listener.shown();
            }

            public void currentItemChanged(@NotNull LookupEvent event) {
                Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                this.$listener.selectedIndexChanged(this.this$0.getSelectedIndex());
            }

            public void uiRefreshed() {
                List<E> allItems = LookupImplWrapper.access$getLookup$p(this.this$0).getItems();
                if (allItems.isEmpty()) {
                    this.$listener.visibleItemsChanged(CollectionsKt.emptyList(), 0);
                    return;
                }
                List visibleItems = LookupImplWrapper.access$getLookup$p(this.this$0).getVisibleItems();
                Intrinsics.checkNotNull((Object)visibleItems);
                if (!((Collection)visibleItems).isEmpty()) {
                    this.$listener.visibleItemsChanged(visibleItems, visibleItems.size());
                } else {
                    List<E> sublist = allItems.size() <= 25 ? allItems : allItems.subList(0, 25);
                    Intrinsics.checkNotNull(sublist);
                    this.$listener.visibleItemsChanged(sublist, allItems.size());
                }
            }

            public void focusDegreeChanged() {
                this.$listener.focusDegreeChanged(this.this$0.getLookupFocusDegree());
            }
        });
        this.lookup.addPrefixChangeListener(new PrefixChangeListener(this, listener2){
            final /* synthetic */ LookupImplWrapper this$0;
            final /* synthetic */ LookupWrapperListener $listener;
            {
                this.this$0 = $receiver;
                this.$listener = $listener;
            }

            public void afterAppend(char c) {
                if (LookupImplWrapper.access$isChangingPrefix$p(this.this$0)) {
                    return;
                }
                this.$listener.prefixChanged(LookupUtilsKt.getPrefix(LookupImplWrapper.access$getLookup$p(this.this$0)));
            }

            public void afterTruncate() {
                if (LookupImplWrapper.access$isChangingPrefix$p(this.this$0)) {
                    return;
                }
                this.$listener.prefixChanged(LookupUtilsKt.getPrefix(LookupImplWrapper.access$getLookup$p(this.this$0)));
            }
        }, (Disposable)this.lookup);
        this.listeners.add(listener2);
    }

    @Override
    @NotNull
    public Promise<Unit> setVisibleItemsAsync(@NotNull List<? extends LookupElement> items, int itemCount) {
        Intrinsics.checkNotNullParameter(items, (String)"items");
        if (this.lookup.isLookupDisposed()) {
            return Promises.cancelledPromise();
        }
        this.updateCounter.incrementAndGet();
        LookupUtilsKt.setItems(this.lookup, items, itemCount);
        return Promises.resolvedPromise();
    }

    @Override
    @NotNull
    public Promise<List<LookupElement>> queryItems(@NotNull IntRange indices) {
        Intrinsics.checkNotNullParameter((Object)indices, (String)"indices");
        List items = this.lookup.getItems();
        if (indices.getFirst() < 0 || indices.getLast() >= items.size()) {
            return Promises.resolvedPromise((Object)CollectionsKt.emptyList());
        }
        List sublist = CollectionsKt.toList((Iterable)items.subList(indices.getFirst(), indices.getLast() + 1));
        return Promises.resolvedPromise((Object)sublist);
    }

    @Override
    public void hide() {
        if (!this.lookup.isLookupDisposed() && this.lookup.isShown()) {
            this.lookup.hide();
        }
    }

    @Override
    public void show() {
        if (!this.lookup.isLookupDisposed() && !this.lookup.isShown()) {
            this.advertiseCtrlArrows();
            this.advertiseCtrlDot();
            this.advertiseTabReplacement();
            this.lookup.showLookup();
        }
    }

    private final void advertiseTabReplacement() {
        String string = KeymapUtil.getFirstKeyboardShortcutText((String)"EditorChooseLookupItemReplace");
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getFirstKeyboardShortcutText(...)");
        String shortcut = string;
        if (StringUtil.isNotEmpty((String)shortcut)) {
            Object[] objectArray = new Object[]{shortcut};
            this.lookup.getAdvertiser().addAdvertisement(CodeInsightBundle.message((String)"completion.ad.use.0.to.overwrite", (Object[])objectArray), null);
        }
    }

    private final void advertiseCtrlDot() {
        Project project = this.lookup.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        Project project2 = project;
        if (FeatureUsageTracker.getInstance().isToBeAdvertisedInLookup("editing.completion.finishByCtrlDot", project2)) {
            String string = KeymapUtil.getFirstKeyboardShortcutText((String)"EditorChooseLookupItemDot");
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getFirstKeyboardShortcutText(...)");
            String dotShortcut = string;
            if (StringUtil.isNotEmpty((String)dotShortcut)) {
                Object[] objectArray = new Object[]{dotShortcut};
                this.lookup.getAdvertiser().addAdvertisement(CodeInsightBundle.message((String)"completion.ad.press.0.to.choose.with.dot", (Object[])objectArray), null);
            }
        }
    }

    private final void advertiseCtrlArrows() {
        Project project = this.lookup.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        Project project2 = project;
        if (!this.lookup.getEditor().isOneLineMode() && FeatureUsageTracker.getInstance().isToBeAdvertisedInLookup("editing.completion.cancelByControlArrows", project2)) {
            String string = KeymapUtil.getFirstKeyboardShortcutText((String)"EditorLookupDown");
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getFirstKeyboardShortcutText(...)");
            String downShortcut = string;
            String string2 = KeymapUtil.getFirstKeyboardShortcutText((String)"EditorLookupUp");
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getFirstKeyboardShortcutText(...)");
            String upShortcut = string2;
            if (StringUtil.isNotEmpty((String)downShortcut) && StringUtil.isNotEmpty((String)upShortcut)) {
                Object[] objectArray = new Object[]{downShortcut, upShortcut};
                this.lookup.getAdvertiser().addAdvertisement(CodeInsightBundle.message((String)"completion.ad.moving.caret.down.and.up.in.the.editor", (Object[])objectArray), null);
            }
        }
    }

    private final void scheduleItemQuery() {
        int update = this.updateCounter.get();
        if (update == 0) {
            return;
        }
        this.queue.queue(new Update(update, this){
            final /* synthetic */ int $update;
            final /* synthetic */ LookupImplWrapper this$0;
            {
                this.$update = $update;
                this.this$0 = $receiver;
                super((Object)"LookupImplWrapper.update");
            }

            public void run() {
                int visibleItemCount;
                int step;
                int selectedIndex2;
                if (this.$update != LookupImplWrapper.access$getUpdateCounter$p(this.this$0).get() || LookupImplWrapper.access$getLookup$p(this.this$0).getDummyItemCount() == 0) {
                    return;
                }
                if (LookupImplWrapper.access$isUpdating$p(this.this$0).get()) {
                    LookupImplWrapper.access$scheduleItemQuery(this.this$0);
                    return;
                }
                int allItemCount = LookupImplWrapper.access$getLookup$p(this.this$0).getList().getModel().getSize();
                int itemCount = LookupImplWrapper.access$getLookup$p(this.this$0).getItems().size();
                Function1 handler2 = LookupImplWrapper.access$getItemHandler$p(this.this$0);
                if (handler2 == null) {
                    return;
                }
                int lastVisibleIndex = LookupImplWrapper.access$getLookup$p(this.this$0).getLastVisibleIndex();
                int nextIndex = Math.max(lastVisibleIndex, (selectedIndex2 = LookupImplWrapper.access$getLookup$p(this.this$0).getSelectedIndex()) + 12);
                int nextItemCount = Math.min(com.jetbrains.rd.ide.completion.LookupImplWrapper$Companion.access$ceilBy(LookupImplWrapper.Companion, nextIndex + 1, step = Math.max(visibleItemCount = LookupImplWrapper.access$getLookup$p(this.this$0).getVisibleItems().size(), 25)), allItemCount);
                if (nextItemCount <= itemCount) {
                    return;
                }
                LookupImplWrapper.access$isUpdating$p(this.this$0).set(true);
                ((Promise)handler2.invoke((Object)RangesKt.until((int)itemCount, (int)nextItemCount))).onSuccess(arg_0 -> scheduleItemQuery.1.run$lambda$0((Function1)new Function1<List<? extends LookupElement>, Unit>(this.$update, this.this$0){
                    final /* synthetic */ int $update;
                    final /* synthetic */ LookupImplWrapper this$0;
                    {
                        this.$update = $update;
                        this.this$0 = $receiver;
                        super(1);
                    }

                    public final void invoke(List<? extends LookupElement> items) {
                        if (this.$update == LookupImplWrapper.access$getUpdateCounter$p(this.this$0).get()) {
                            Intrinsics.checkNotNull(items);
                            if (!((Collection)items).isEmpty()) {
                                LookupUtilsKt.addItems(LookupImplWrapper.access$getLookup$p(this.this$0), items);
                            }
                        }
                    }
                }, arg_0)).onProcessed(arg_0 -> scheduleItemQuery.1.run$lambda$1((Function1)new Function1<List<? extends LookupElement>, Unit>(this.this$0){
                    final /* synthetic */ LookupImplWrapper this$0;
                    {
                        this.this$0 = $receiver;
                        super(1);
                    }

                    public final void invoke(List<? extends LookupElement> it) {
                        LookupImplWrapper.access$isUpdating$p(this.this$0).set(false);
                    }
                }, arg_0));
            }

            private static final void run$lambda$0(Function1 $tmp0, Object p0) {
                Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
                $tmp0.invoke(p0);
            }

            private static final void run$lambda$1(Function1 $tmp0, Object p0) {
                Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
                $tmp0.invoke(p0);
            }
        });
    }

    private static final void addListener$lambda$4(LookupWrapperListener $listener) {
        Intrinsics.checkNotNullParameter((Object)$listener, (String)"$listener");
        $listener.hidden();
    }

    public static final /* synthetic */ boolean access$isChangingPrefix$p(LookupImplWrapper $this) {
        return $this.isChangingPrefix;
    }

    public static final /* synthetic */ void access$setChangingPrefix$p(LookupImplWrapper $this, boolean bl) {
        $this.isChangingPrefix = bl;
    }

    public static final /* synthetic */ AtomicInteger access$getUpdateCounter$p(LookupImplWrapper $this) {
        return $this.updateCounter;
    }

    public static final /* synthetic */ AtomicBoolean access$isUpdating$p(LookupImplWrapper $this) {
        return $this.isUpdating;
    }

    public static final /* synthetic */ Function1 access$getItemHandler$p(LookupImplWrapper $this) {
        return $this.itemHandler;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0006\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\u0004H\u0002J\u0018\u0010\t\u001a\u00020\u00042\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u000bH\u0002J&\u0010\r\u001a\u00020\u000e*\b\u0012\u0004\u0012\u00020\u00100\u000f2\u0012\u0010\u0011\u001a\u000e\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\u000e0\u0012H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lcom/jetbrains/rd/ide/completion/LookupImplWrapper$Companion;", "", "()V", "HEAD_COUNT", "", "PRELOAD_THRESHOLD", "ceilBy", "value", "step", "getCommonPrefixLength", "a", "", "b", "addCellRendererListener", "", "Ljavax/swing/JList;", "Lcom/intellij/codeInsight/lookup/LookupElement;", "listener", "Lkotlin/Function1;", "intellij.rd.platform"})
    public static final class Companion {
        private Companion() {
        }

        private final int ceilBy(int value2, int step) {
            return (value2 + step - 1) / step * step;
        }

        private final int getCommonPrefixLength(String a, String b) {
            int minLength = Math.min(a.length(), b.length());
            for (int i2 = 0; i2 < minLength; ++i2) {
                if (a.charAt(i2) == b.charAt(i2)) continue;
                return i2;
            }
            return minLength;
        }

        private final void addCellRendererListener(JList<LookupElement> $this$addCellRendererListener, Function1<? super LookupElement, Unit> listener2) {
            ListCellRenderer<LookupElement> originalRenderer = $this$addCellRendererListener.getCellRenderer();
            $this$addCellRendererListener.setCellRenderer((arg_0, arg_1, arg_2, arg_3, arg_4) -> Companion.addCellRendererListener$lambda$0((Function5)new Function5<JList<? extends LookupElement>, LookupElement, Integer, Boolean, Boolean, Component>(listener2, originalRenderer){
                final /* synthetic */ Function1<LookupElement, Unit> $listener;
                final /* synthetic */ ListCellRenderer<? super LookupElement> $originalRenderer;
                {
                    this.$listener = $listener;
                    this.$originalRenderer = $originalRenderer;
                    super(5);
                }

                public final Component invoke(JList<? extends LookupElement> list2, LookupElement value2, int index, boolean isSelected, boolean cellHasFocus) {
                    Intrinsics.checkNotNull((Object)value2);
                    this.$listener.invoke((Object)value2);
                    return this.$originalRenderer.getListCellRendererComponent(list2, (LookupElement)value2, index, isSelected, cellHasFocus);
                }
            }, arg_0, arg_1, arg_2, arg_3, arg_4));
        }

        private static final Component addCellRendererListener$lambda$0(Function5 $tmp0, JList p0, Object p1, int p2, boolean p3, boolean p4) {
            Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
            return (Component)$tmp0.invoke((Object)p0, p1, (Object)p2, (Object)p3, (Object)p4);
        }

        public static final /* synthetic */ int access$ceilBy(Companion $this, int value2, int step) {
            return $this.ceilBy(value2, step);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

