/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.completion.ml.sorting;

import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.completion.ml.CompletionEnvironment;
import com.intellij.codeInsight.completion.ml.ContextFeatureProvider;
import com.intellij.codeInsight.completion.ml.MLFeatureValue;
import com.intellij.codeInsight.lookup.impl.LookupImpl;
import com.intellij.completion.ml.sorting.AdditionalContextFeatureProvider;
import com.intellij.completion.ml.sorting.MyEnvironment;
import com.intellij.completion.ml.storage.MutableLookupStorage;
import com.intellij.lang.Language;
import com.intellij.openapi.extensions.impl.ExtensionProcessingHelper;
import com.intellij.openapi.progress.ProgressManager;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n\u00a8\u0006\u000b"}, d2={"Lcom/intellij/completion/ml/sorting/ContextFactorCalculator;", "", "()V", "calculateContextFactors", "", "lookup", "Lcom/intellij/codeInsight/lookup/impl/LookupImpl;", "parameters", "Lcom/intellij/codeInsight/completion/CompletionParameters;", "storage", "Lcom/intellij/completion/ml/storage/MutableLookupStorage;", "intellij.completionMlRanking"})
@SourceDebugExtension(value={"SMAP\nContextFactorCalculator.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ContextFactorCalculator.kt\ncom/intellij/completion/ml/sorting/ContextFactorCalculator\n+ 2 Timing.kt\nkotlin/system/TimingKt\n*L\n1#1,45:1\n17#2,6:46\n*S KotlinDebug\n*F\n+ 1 ContextFactorCalculator.kt\ncom/intellij/completion/ml/sorting/ContextFactorCalculator\n*L\n23#1:46,6\n*E\n"})
public final class ContextFactorCalculator {
    @NotNull
    public static final ContextFactorCalculator INSTANCE = new ContextFactorCalculator();

    private ContextFactorCalculator() {
    }

    public final void calculateContextFactors(@NotNull LookupImpl lookup, @NotNull CompletionParameters parameters, @NotNull MutableLookupStorage storage) {
        Intrinsics.checkNotNullParameter((Object)lookup, (String)"lookup");
        Intrinsics.checkNotNullParameter((Object)parameters, (String)"parameters");
        Intrinsics.checkNotNullParameter((Object)storage, (String)"storage");
        MyEnvironment environment = new MyEnvironment(lookup, parameters);
        Map contextFeatures = new LinkedHashMap();
        List list = ContextFeatureProvider.forLanguage((Language)storage.getLanguage());
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"forLanguage(...)");
        ExtensionProcessingHelper.INSTANCE.forEachExtensionSafe((Iterable)list, arg_0 -> ContextFactorCalculator.calculateContextFactors$lambda$1(storage, environment, contextFeatures, arg_0));
        for (AdditionalContextFeatureProvider contextFeatureProvider : AdditionalContextFeatureProvider.forLanguage(storage.getLanguage())) {
            Map<String, MLFeatureValue> map = contextFeatureProvider.calculateFeatures(contextFeatures);
            Intrinsics.checkNotNullExpressionValue(map, (String)"calculateFeatures(...)");
            contextFeatures.putAll(map);
        }
        storage.initContextFactors(contextFeatures, environment);
    }

    private static final void calculateContextFactors$lambda$1(MutableLookupStorage $storage, MyEnvironment $environment, Map $contextFeatures, ContextFeatureProvider provider) {
        Intrinsics.checkNotNullParameter((Object)$storage, (String)"$storage");
        Intrinsics.checkNotNullParameter((Object)((Object)$environment), (String)"$environment");
        Intrinsics.checkNotNullParameter((Object)$contextFeatures, (String)"$contextFeatures");
        Intrinsics.checkNotNullParameter((Object)provider, (String)"provider");
        ProgressManager.checkCanceled();
        String string = provider.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
        String providerName = string;
        boolean $i$f$measureTimeMillis = false;
        long start$iv = System.currentTimeMillis();
        boolean bl = false;
        Map map = provider.calculateFeatures((CompletionEnvironment)$environment);
        Intrinsics.checkNotNullExpressionValue((Object)map, (String)"calculateFeatures(...)");
        Map features2 = map;
        for (Map.Entry entry : features2.entrySet()) {
            String featureName = (String)entry.getKey();
            MLFeatureValue value = (MLFeatureValue)entry.getValue();
            String string2 = "ml_ctx_" + providerName + "_" + featureName;
            Intrinsics.checkNotNull((Object)value);
            $contextFeatures.put(string2, value);
        }
        long timeSpent = System.currentTimeMillis() - start$iv;
        $storage.getPerformanceTracker().contextFeaturesCalculated(providerName, TimeUnit.NANOSECONDS.toMillis(timeSpent));
    }
}

