/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.completion.ml.performance;

import com.intellij.completion.ml.performance.MLCompletionPerformanceTracker;
import com.intellij.completion.ml.performance.PerformanceMetricCollector;
import com.intellij.completion.ml.performance.PerformanceMetricCollectorFactory;
import com.intellij.completion.ml.performance.PerformanceTracker;
import com.intellij.platform.diagnostic.telemetry.PlatformScopesKt;
import com.intellij.platform.diagnostic.telemetry.TelemetryManager;
import io.opentelemetry.api.metrics.LongCounter;
import io.opentelemetry.api.metrics.Meter;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.LongAdder;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010$\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u0001:\u0003-./B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00052\u0006\u0010\u0015\u001a\u00020\u000fH\u0002J\u000e\u0010\u0016\u001a\u00020\u00132\u0006\u0010\u0017\u001a\u00020\u0018J\u0016\u0010\u0019\u001a\u00020\u00132\u0006\u0010\u001a\u001a\u00020\u00052\u0006\u0010\u001b\u001a\u00020\u000fJ\u0016\u0010\u001c\u001a\u00020\u00132\u0006\u0010\u001d\u001a\u00020\u00052\u0006\u0010\u001b\u001a\u00020\u000fJ\b\u0010\u001e\u001a\u00020\u0013H\u0002J\u0016\u0010\u001f\u001a\u00020\u00132\u0006\u0010 \u001a\u00020\r2\u0006\u0010\u001b\u001a\u00020\u000fJ\u0012\u0010!\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u000f0\"J\u0016\u0010#\u001a\u00020\u00132\u0006\u0010\u001a\u001a\u00020\u00052\u0006\u0010\u001b\u001a\u00020\u000fJ\u0006\u0010$\u001a\u00020\u0013J\u0016\u0010%\u001a\u00020\u00132\u0006\u0010 \u001a\u00020\r2\u0006\u0010&\u001a\u00020\u000fJ\u0006\u0010'\u001a\u00020\u000fJ'\u0010(\u001a\u0002H)\"\u0004\b\u0000\u0010)2\u0006\u0010\u001a\u001a\u00020\u00052\f\u0010*\u001a\b\u0012\u0004\u0012\u0002H)0+\u00a2\u0006\u0002\u0010,R\u001a\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00060"}, d2={"Lcom/intellij/completion/ml/performance/MLCompletionPerformanceTracker;", "", "()V", "elementProvidersMeasurer", "Ljava/util/concurrent/ConcurrentHashMap;", "", "Ljava/util/concurrent/atomic/LongAdder;", "measuredTracker", "Lcom/intellij/completion/ml/performance/MLCompletionPerformanceTracker$MeasuredTracker;", "metricCollectors", "", "Lcom/intellij/completion/ml/performance/PerformanceMetricCollector;", "sortingCount", "", "totalMlContribution", "", "tracker", "Lcom/intellij/completion/ml/performance/MLCompletionPerformanceTracker$DelegatingTracker;", "addByKey", "", "key", "timeMs", "addMetricCollector", "metricCollectorFactory", "Lcom/intellij/completion/ml/performance/PerformanceMetricCollectorFactory;", "contextFeaturesCalculated", "providerName", "timeSpent", "eventLogged", "eventType", "flushElementProvidersContribution", "itemsScored", "itemsCount", "measurements", "", "recommendersFeaturesCalculated", "reorderedByML", "sortingPerformed", "totalTime", "totalMLTimeContribution", "trackElementFeaturesCalculation", "T", "compute", "Lkotlin/Function0;", "(Ljava/lang/String;Lkotlin/jvm/functions/Function0;)Ljava/lang/Object;", "DelegatingTracker", "MeasuredTracker", "OTelTracker", "intellij.completionMlRanking"})
@SourceDebugExtension(value={"SMAP\nMLCompletionPerformanceTracker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MLCompletionPerformanceTracker.kt\ncom/intellij/completion/ml/performance/MLCompletionPerformanceTracker\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,114:1\n1855#2,2:115\n215#3,2:117\n*S KotlinDebug\n*F\n+ 1 MLCompletionPerformanceTracker.kt\ncom/intellij/completion/ml/performance/MLCompletionPerformanceTracker\n*L\n71#1:115,2\n77#1:117,2\n*E\n"})
public final class MLCompletionPerformanceTracker {
    @NotNull
    private final MeasuredTracker measuredTracker = new MeasuredTracker();
    @NotNull
    private final DelegatingTracker tracker;
    @NotNull
    private final ConcurrentHashMap<String, LongAdder> elementProvidersMeasurer;
    private int sortingCount;
    private long totalMlContribution;
    @NotNull
    private final List<PerformanceMetricCollector> metricCollectors;

    public MLCompletionPerformanceTracker() {
        Object[] objectArray = new PerformanceTracker[]{new OTelTracker(), this.measuredTracker};
        this.tracker = new DelegatingTracker(CollectionsKt.listOf((Object[])objectArray));
        this.elementProvidersMeasurer = new ConcurrentHashMap();
        this.metricCollectors = new ArrayList();
    }

    public final void addMetricCollector(@NotNull PerformanceMetricCollectorFactory metricCollectorFactory) {
        Intrinsics.checkNotNullParameter((Object)metricCollectorFactory, (String)"metricCollectorFactory");
        PerformanceTracker performanceTracker2 = new PerformanceTracker(this, metricCollectorFactory){
            final /* synthetic */ MLCompletionPerformanceTracker this$0;
            final /* synthetic */ PerformanceMetricCollectorFactory $metricCollectorFactory;
            {
                this.this$0 = $receiver;
                this.$metricCollectorFactory = $metricCollectorFactory;
            }

            public void addByKey(@NotNull String key, long timeMs) {
                Intrinsics.checkNotNullParameter((Object)key, (String)"key");
                MLCompletionPerformanceTracker.access$getTracker$p(this.this$0).addByKey(this.$metricCollectorFactory.getPerformanceMetricName() + "." + key, timeMs);
            }
        };
        PerformanceMetricCollector metricCollector = metricCollectorFactory.createMetricCollector(performanceTracker2);
        this.metricCollectors.add(metricCollector);
    }

    public final long totalMLTimeContribution() {
        return this.totalMlContribution;
    }

    public final void sortingPerformed(int itemsCount, long totalTime) {
        this.addByKey("sorting.items." + this.sortingCount, itemsCount);
        this.addByKey("sorting.time." + this.sortingCount, totalTime);
        this.totalMlContribution += totalTime;
        ++this.sortingCount;
    }

    public final void eventLogged(@NotNull String eventType, long timeSpent) {
        Intrinsics.checkNotNullParameter((Object)eventType, (String)"eventType");
        this.addByKey("log." + eventType, timeSpent);
        this.addByKey("log.total", timeSpent);
    }

    public final void contextFeaturesCalculated(@NotNull String providerName, long timeSpent) {
        Intrinsics.checkNotNullParameter((Object)providerName, (String)"providerName");
        this.addByKey("context.features." + providerName, timeSpent);
    }

    public final void recommendersFeaturesCalculated(@NotNull String providerName, long timeSpent) {
        Intrinsics.checkNotNullParameter((Object)providerName, (String)"providerName");
        this.addByKey("recommenders.features." + providerName, timeSpent);
    }

    public final void itemsScored(int itemsCount, long timeSpent) {
        this.addByKey("model.items." + this.sortingCount, itemsCount);
        this.addByKey("model.time." + this.sortingCount, timeSpent);
    }

    public final void reorderedByML() {
        this.addByKey("reordered.by.ml", 1L);
    }

    public final <T> T trackElementFeaturesCalculation(@NotNull String providerName, @NotNull Function0<? extends T> compute2) {
        Intrinsics.checkNotNullParameter((Object)providerName, (String)"providerName");
        Intrinsics.checkNotNullParameter(compute2, (String)"compute");
        long started = System.nanoTime();
        Object result = compute2.invoke();
        this.elementProvidersMeasurer.computeIfAbsent(providerName, arg_0 -> MLCompletionPerformanceTracker.trackElementFeaturesCalculation$lambda$0(trackElementFeaturesCalculation.1.INSTANCE, arg_0)).add(System.nanoTime() - started);
        return (T)result;
    }

    @NotNull
    public final Map<String, Long> measurements() {
        Iterable $this$forEach$iv = this.metricCollectors;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            PerformanceMetricCollector it = (PerformanceMetricCollector)element$iv;
            boolean bl = false;
            it.onFinishCollecting();
        }
        this.flushElementProvidersContribution();
        return this.measuredTracker.measurements();
    }

    private final void flushElementProvidersContribution() {
        Map $this$forEach$iv = this.elementProvidersMeasurer;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry element$iv;
            Map.Entry it = element$iv = iterator.next();
            boolean bl = false;
            this.addByKey("element.features." + it.getKey(), TimeUnit.NANOSECONDS.toMillis(((LongAdder)it.getValue()).longValue()));
        }
        this.elementProvidersMeasurer.clear();
    }

    private final void addByKey(String key, long timeMs) {
        if (timeMs > 0L) {
            this.tracker.addByKey(key, timeMs);
        }
    }

    private static final LongAdder trackElementFeaturesCalculation$lambda$0(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (LongAdder)$tmp0.invoke(p0);
    }

    public static final /* synthetic */ DelegatingTracker access$getTracker$p(MLCompletionPerformanceTracker $this) {
        return $this.tracker;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\t\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0013\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00010\u0003\u00a2\u0006\u0002\u0010\u0004J\u0018\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016R\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00010\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lcom/intellij/completion/ml/performance/MLCompletionPerformanceTracker$DelegatingTracker;", "Lcom/intellij/completion/ml/performance/PerformanceTracker;", "trackers", "", "(Ljava/util/List;)V", "addByKey", "", "key", "", "timeMs", "", "intellij.completionMlRanking"})
    @SourceDebugExtension(value={"SMAP\nMLCompletionPerformanceTracker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MLCompletionPerformanceTracker.kt\ncom/intellij/completion/ml/performance/MLCompletionPerformanceTracker$DelegatingTracker\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,114:1\n1855#2,2:115\n*S KotlinDebug\n*F\n+ 1 MLCompletionPerformanceTracker.kt\ncom/intellij/completion/ml/performance/MLCompletionPerformanceTracker$DelegatingTracker\n*L\n99#1:115,2\n*E\n"})
    private static final class DelegatingTracker
    implements PerformanceTracker {
        @NotNull
        private final List<PerformanceTracker> trackers;

        public DelegatingTracker(@NotNull List<? extends PerformanceTracker> trackers) {
            Intrinsics.checkNotNullParameter(trackers, (String)"trackers");
            this.trackers = trackers;
        }

        @Override
        public void addByKey(@NotNull String key, long timeMs) {
            Intrinsics.checkNotNullParameter((Object)key, (String)"key");
            Iterable $this$forEach$iv = this.trackers;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                PerformanceTracker it = (PerformanceTracker)element$iv;
                boolean bl = false;
                it.addByKey(key, timeMs);
            }
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\u0010$\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u00052\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0012\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u000b0\fR\u001a\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lcom/intellij/completion/ml/performance/MLCompletionPerformanceTracker$MeasuredTracker;", "Lcom/intellij/completion/ml/performance/PerformanceTracker;", "()V", "measurements", "Ljava/util/concurrent/ConcurrentHashMap;", "", "Ljava/util/concurrent/atomic/LongAdder;", "addByKey", "", "key", "timeMs", "", "", "intellij.completionMlRanking"})
    @SourceDebugExtension(value={"SMAP\nMLCompletionPerformanceTracker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MLCompletionPerformanceTracker.kt\ncom/intellij/completion/ml/performance/MLCompletionPerformanceTracker$MeasuredTracker\n+ 2 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,114:1\n453#2:115\n403#2:116\n1238#3,4:117\n*S KotlinDebug\n*F\n+ 1 MLCompletionPerformanceTracker.kt\ncom/intellij/completion/ml/performance/MLCompletionPerformanceTracker$MeasuredTracker\n*L\n110#1:115\n110#1:116\n110#1:117,4\n*E\n"})
    private static final class MeasuredTracker
    implements PerformanceTracker {
        @NotNull
        private final ConcurrentHashMap<String, LongAdder> measurements = new ConcurrentHashMap();

        @Override
        public void addByKey(@NotNull String key, long timeMs) {
            Intrinsics.checkNotNullParameter((Object)key, (String)"key");
            this.measurements.computeIfAbsent(key, arg_0 -> MeasuredTracker.addByKey$lambda$0(addByKey.1.INSTANCE, arg_0)).add(timeMs);
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final Map<String, Long> measurements() {
            void $this$mapValuesTo$iv$iv;
            Map $this$mapValues$iv = this.measurements;
            boolean $i$f$mapValues = false;
            Map map = $this$mapValues$iv;
            Map destination$iv$iv = new LinkedHashMap(MapsKt.mapCapacity((int)$this$mapValues$iv.size()));
            boolean $i$f$mapValuesTo = false;
            Iterable $this$associateByTo$iv$iv$iv = $this$mapValuesTo$iv$iv.entrySet();
            boolean $i$f$associateByTo = false;
            for (Object element$iv$iv$iv : $this$associateByTo$iv$iv$iv) {
                void it;
                void it$iv$iv;
                Map.Entry entry = (Map.Entry)element$iv$iv$iv;
                Map map2 = destination$iv$iv;
                boolean bl = false;
                Map.Entry entry2 = (Map.Entry)element$iv$iv$iv;
                Object k = it$iv$iv.getKey();
                Map map3 = map2;
                boolean bl2 = false;
                Long l = ((LongAdder)it.getValue()).longValue();
                map3.put(k, l);
            }
            return destination$iv$iv;
        }

        private static final LongAdder addByKey$lambda$0(Function1 $tmp0, Object p0) {
            Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
            return (LongAdder)$tmp0.invoke(p0);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u00052\u0006\u0010\f\u001a\u00020\rH\u0016R\u001a\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/intellij/completion/ml/performance/MLCompletionPerformanceTracker$OTelTracker;", "Lcom/intellij/completion/ml/performance/PerformanceTracker;", "()V", "key2counter", "", "", "Lio/opentelemetry/api/metrics/LongCounter;", "meter", "Lio/opentelemetry/api/metrics/Meter;", "addByKey", "", "key", "timeMs", "", "intellij.completionMlRanking"})
    private static final class OTelTracker
    implements PerformanceTracker {
        @NotNull
        private final Meter meter = TelemetryManager.Companion.getMeter(PlatformScopesKt.CompletionRanking);
        @NotNull
        private final Map<String, LongCounter> key2counter = new LinkedHashMap();

        @Override
        public void addByKey(@NotNull String key, long timeMs) {
            Intrinsics.checkNotNullParameter((Object)key, (String)"key");
            this.key2counter.computeIfAbsent(key, arg_0 -> OTelTracker.addByKey$lambda$0((Function1)new Function1<String, LongCounter>(this, key){
                final /* synthetic */ OTelTracker this$0;
                final /* synthetic */ String $key;
                {
                    this.this$0 = $receiver;
                    this.$key = $key;
                    super(1);
                }

                @NotNull
                public final LongCounter invoke(@NotNull String it) {
                    Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                    return OTelTracker.access$getMeter$p(this.this$0).counterBuilder(this.$key).build();
                }
            }, arg_0)).add(timeMs);
        }

        private static final LongCounter addByKey$lambda$0(Function1 $tmp0, Object p0) {
            Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
            return (LongCounter)$tmp0.invoke(p0);
        }

        public static final /* synthetic */ Meter access$getMeter$p(OTelTracker $this) {
            return $this.meter;
        }
    }
}

