/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.service.project;

import com.intellij.openapi.externalSystem.model.DataNode;
import com.intellij.openapi.externalSystem.model.Key;
import com.intellij.openapi.externalSystem.model.ProjectKeys;
import com.intellij.openapi.externalSystem.model.project.AbstractDependencyData;
import com.intellij.openapi.externalSystem.model.project.ExternalSystemSourceType;
import com.intellij.openapi.externalSystem.model.project.LibraryData;
import com.intellij.openapi.externalSystem.model.project.LibraryDependencyData;
import com.intellij.openapi.externalSystem.model.project.LibraryLevel;
import com.intellij.openapi.externalSystem.model.project.LibraryPathType;
import com.intellij.openapi.externalSystem.model.project.ModuleData;
import com.intellij.openapi.externalSystem.model.project.ModuleDependencyData;
import com.intellij.openapi.externalSystem.util.ExternalSystemApiUtil;
import com.intellij.openapi.roots.DependencyScope;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import java.io.File;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.gradle.util.GradleVersion;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.gradle.model.ExternalSourceSet;
import org.jetbrains.plugins.gradle.model.data.GradleSourceSetData;
import org.jetbrains.plugins.gradle.service.project.ArtifactMappingService;
import org.jetbrains.plugins.gradle.service.project.GradleProjectResolver;
import org.jetbrains.plugins.gradle.service.project.GradleProjectResolverUtil;
import org.jetbrains.plugins.gradle.service.project.ModuleLookupResult;
import org.jetbrains.plugins.gradle.service.project.ModuleMappingInfo;
import org.jetbrains.plugins.gradle.service.project.ProjectResolverContext;
import org.jetbrains.plugins.gradle.settings.GradleExecutionSettings;

@ApiStatus.Internal
public class LibraryDataNodeSubstitutor {
    @NotNull
    private final ProjectResolverContext resolverContext;
    @Nullable
    private final File gradleUserHomeDir;
    @Nullable
    private final File gradleHomeDir;
    @Nullable
    private final GradleVersion gradleVersion;
    @NotNull
    private final Map<String, Pair<DataNode<GradleSourceSetData>, ExternalSourceSet>> sourceSetMap;
    @NotNull
    private final Map<String, Pair<String, ExternalSystemSourceType>> moduleOutputsMap;
    @NotNull
    private final ArtifactMappingService artifactsMap;

    public LibraryDataNodeSubstitutor(@NotNull ProjectResolverContext context, @Nullable File gradleUserHomeDir, @Nullable File gradleHomeDir, @Nullable GradleVersion gradleVersion2, @NotNull Map<String, Pair<DataNode<GradleSourceSetData>, ExternalSourceSet>> sourceSetMap, @NotNull Map<String, Pair<String, ExternalSystemSourceType>> moduleOutputsMap, @NotNull ArtifactMappingService artifactsMap) {
        if (context == null) {
            LibraryDataNodeSubstitutor.$$$reportNull$$$0(0);
        }
        if (sourceSetMap == null) {
            LibraryDataNodeSubstitutor.$$$reportNull$$$0(1);
        }
        if (moduleOutputsMap == null) {
            LibraryDataNodeSubstitutor.$$$reportNull$$$0(2);
        }
        if (artifactsMap == null) {
            LibraryDataNodeSubstitutor.$$$reportNull$$$0(3);
        }
        this.resolverContext = context;
        this.gradleUserHomeDir = gradleUserHomeDir;
        this.gradleHomeDir = gradleHomeDir;
        this.gradleVersion = gradleVersion2;
        this.sourceSetMap = sourceSetMap;
        this.moduleOutputsMap = moduleOutputsMap;
        this.artifactsMap = artifactsMap;
    }

    public void run(@NotNull DataNode<LibraryDependencyData> libraryDependencyDataNode) {
        DataNode libraryNodeParent;
        if (libraryDependencyDataNode == null) {
            LibraryDataNodeSubstitutor.$$$reportNull$$$0(4);
        }
        if ((libraryNodeParent = libraryDependencyDataNode.getParent()) == null) {
            return;
        }
        LibraryDependencyData libraryDependencyData = (LibraryDependencyData)libraryDependencyDataNode.getData();
        LibraryData libraryData = (LibraryData)libraryDependencyData.getTarget();
        Set libraryPaths = libraryData.getPaths(LibraryPathType.BINARY);
        if (libraryPaths.isEmpty()) {
            return;
        }
        if (StringUtil.isNotEmpty((String)libraryData.getExternalName())) {
            if (this.gradleUserHomeDir != null) {
                GradleProjectResolverUtil.attachSourcesAndJavadocFromGradleCacheIfNeeded(this.resolverContext, this.gradleUserHomeDir, libraryData);
            }
            return;
        }
        boolean shouldKeepTransitiveDependencies = !libraryPaths.isEmpty() && !libraryDependencyDataNode.getChildren().isEmpty();
        Collection<AbstractDependencyData<?>> dependenciesToShift = LibraryDataNodeSubstitutor.collectDependenciesOrderedAfter(libraryNodeParent, libraryDependencyData.getOrder());
        int classpathOrderShift = -1;
        ArrayDeque<String> unprocessedPaths = new ArrayDeque<String>(libraryPaths);
        while (!unprocessedPaths.isEmpty()) {
            String path = (String)unprocessedPaths.remove();
            Collection<ModuleLookupResult> lookupResults = this.lookupTargetModule(path);
            for (ModuleLookupResult result : lookupResults) {
                if (!LibraryDataNodeSubstitutor.createAndMaybeAttachNewModuleDependency(libraryDependencyDataNode, result, libraryPaths, shouldKeepTransitiveDependencies, unprocessedPaths, classpathOrderShift, path)) continue;
                ++classpathOrderShift;
            }
            ModuleMappingInfo mapping = this.resolverContext.getArtifactsMap().getModuleMapping(path);
            if (!(lookupResults.isEmpty() || mapping != null && mapping.getHasNonModulesContent())) {
                libraryPaths.remove(path);
            }
            if (!libraryPaths.isEmpty()) continue;
            libraryDependencyDataNode.clear(true);
            break;
        }
        LibraryDataNodeSubstitutor.applyClasspathShift(dependenciesToShift, classpathOrderShift);
        if (libraryDependencyDataNode.getParent() != null && libraryPaths.size() > 1) {
            SmartList toRemove = new SmartList();
            for (String path : libraryPaths) {
                File binaryPath = new File(path);
                if (!binaryPath.isFile()) continue;
                LibraryData extractedLibrary = new LibraryData(libraryDependencyData.getOwner(), "");
                extractedLibrary.addPath(LibraryPathType.BINARY, path);
                if (this.gradleHomeDir != null && this.gradleVersion != null) {
                    GradleProjectResolverUtil.attachGradleSdkSources(binaryPath, extractedLibrary, this.gradleHomeDir, this.gradleVersion);
                }
                LibraryDependencyData extractedDependencyData = new LibraryDependencyData(libraryDependencyData.getOwnerModule(), extractedLibrary, LibraryLevel.MODULE);
                libraryDependencyDataNode.getParent().createChild(ProjectKeys.LIBRARY_DEPENDENCY, (Object)extractedDependencyData);
                toRemove.add(path);
            }
            libraryPaths.removeAll((Collection<?>)toRemove);
            if (libraryPaths.isEmpty()) {
                libraryDependencyDataNode.clear(true);
            }
        }
    }

    private static Collection<AbstractDependencyData<?>> collectDependenciesOrderedAfter(@NotNull DataNode<?> parent, int order) {
        if (parent == null) {
            LibraryDataNodeSubstitutor.$$$reportNull$$$0(5);
        }
        return ContainerUtil.mapNotNull((Collection)parent.getChildren(), it -> {
            AbstractDependencyData depData;
            Object patt6326$temp = it.getData();
            if (patt6326$temp instanceof AbstractDependencyData && (depData = (AbstractDependencyData)patt6326$temp).getOrder() > order) {
                return depData;
            }
            return null;
        });
    }

    private static boolean createAndMaybeAttachNewModuleDependency(@NotNull DataNode<LibraryDependencyData> libraryDependencyDataNode, @NotNull ModuleLookupResult lookupResult, @NotNull Set<String> libraryPaths, boolean shouldKeepTransitiveDependencies, @NotNull ArrayDeque<String> unprocessedPaths, int classpathOrderShift, String path) {
        DataNode found;
        if (libraryDependencyDataNode == null) {
            LibraryDataNodeSubstitutor.$$$reportNull$$$0(6);
        }
        if (lookupResult == null) {
            LibraryDataNodeSubstitutor.$$$reportNull$$$0(7);
        }
        if (libraryPaths == null) {
            LibraryDataNodeSubstitutor.$$$reportNull$$$0(8);
        }
        if (unprocessedPaths == null) {
            LibraryDataNodeSubstitutor.$$$reportNull$$$0(9);
        }
        boolean addedNewDependency = false;
        LibraryDependencyData libraryDependencyData = (LibraryDependencyData)libraryDependencyDataNode.getData();
        DataNode libraryNodeParent = libraryDependencyDataNode.getParent();
        if (libraryNodeParent == null) {
            return addedNewDependency;
        }
        DataNode<GradleSourceSetData> targetSourceSetNode = lookupResult.sourceSetDataDataNode();
        ExternalSourceSet targetExternalSourceSet = lookupResult.externalSourceSet();
        ModuleData targetModuleData = (ModuleData)targetSourceSetNode.getData();
        Set<String> targetModuleOutputPaths = LibraryDataNodeSubstitutor.collectTargetModuleOutputPaths(libraryPaths, (MultiMap<ExternalSystemSourceType, String>)((MultiMap)targetSourceSetNode.getUserData(GradleProjectResolver.GRADLE_OUTPUTS)));
        ModuleData ownerModule = libraryDependencyData.getOwnerModule();
        ModuleDependencyData moduleDependencyData = new ModuleDependencyData(ownerModule, targetModuleData);
        moduleDependencyData.setScope(libraryDependencyData.getScope());
        moduleDependencyData.setOrder(libraryDependencyData.getOrder() + classpathOrderShift + 1);
        moduleDependencyData.setModuleDependencyArtifacts(Collections.singleton(path));
        if (targetExternalSourceSet != null && GradleProjectResolverUtil.isTestSourceSet(targetExternalSourceSet)) {
            moduleDependencyData.setProductionOnTestDependency(true);
        }
        if ((found = ExternalSystemApiUtil.findChild((DataNode)libraryNodeParent, (Key)ProjectKeys.MODULE_DEPENDENCY, node -> {
            ModuleDependencyData candidateData = (ModuleDependencyData)node.getData();
            if (!moduleDependencyData.getInternalName().equals(candidateData.getInternalName())) {
                return false;
            }
            moduleDependencyData.setModuleDependencyArtifacts(candidateData.getModuleDependencyArtifacts());
            boolean result = moduleDependencyData.getScope() == DependencyScope.PROVIDED || candidateData.getScope() == DependencyScope.COMPILE ? LibraryDataNodeSubstitutor.isEqualIgnoringScope(moduleDependencyData, candidateData) : moduleDependencyData.equals((Object)candidateData);
            return result;
        })) == null) {
            DataNode moduleDependencyNode = libraryNodeParent.createChild(ProjectKeys.MODULE_DEPENDENCY, (Object)moduleDependencyData);
            addedNewDependency = true;
            if (shouldKeepTransitiveDependencies) {
                for (DataNode node2 : libraryDependencyDataNode.getChildren()) {
                    moduleDependencyNode.addChild(node2);
                }
            }
        }
        if (targetModuleOutputPaths != null) {
            unprocessedPaths.removeAll(targetModuleOutputPaths);
            libraryPaths.removeAll(targetModuleOutputPaths);
        }
        return addedNewDependency;
    }

    private static boolean isEqualIgnoringScope(@NotNull ModuleDependencyData data1, @NotNull ModuleDependencyData data2) {
        if (data1 == null) {
            LibraryDataNodeSubstitutor.$$$reportNull$$$0(10);
        }
        if (data2 == null) {
            LibraryDataNodeSubstitutor.$$$reportNull$$$0(11);
        }
        DependencyScope tmp = data1.getScope();
        data1.setScope(data2.getScope());
        boolean result = data1.equals((Object)data2);
        data1.setScope(tmp);
        return result;
    }

    @NotNull
    private Collection<ModuleLookupResult> lookupTargetModule(String path) {
        String moduleId;
        Pair<DataNode<GradleSourceSetData>, ExternalSourceSet> pair;
        ArrayList<ModuleLookupResult> results = new ArrayList<ModuleLookupResult>();
        GradleSourceSetData targetModule = Optional.ofNullable(this.resolverContext.getSettings()).map(GradleExecutionSettings::getExecutionWorkspace).map(ws -> ws.findModuleDataByArtifacts(Collections.singleton(new File(path)))).filter(md -> md instanceof GradleSourceSetData).map(GradleSourceSetData.class::cast).orElse(null);
        if (targetModule != null) {
            Set<ModuleLookupResult> set = Collections.singleton(new ModuleLookupResult((DataNode<GradleSourceSetData>)new DataNode(GradleSourceSetData.KEY, (Object)targetModule, null), null));
            if (set == null) {
                LibraryDataNodeSubstitutor.$$$reportNull$$$0(12);
            }
            return set;
        }
        Pair<String, ExternalSystemSourceType> sourceTypePair = this.moduleOutputsMap.get(path);
        if (sourceTypePair != null && (pair = this.sourceSetMap.get(moduleId = (String)sourceTypePair.first)) != null) {
            Set<ModuleLookupResult> set = Collections.singleton(new ModuleLookupResult((DataNode<GradleSourceSetData>)((DataNode)pair.first), (ExternalSourceSet)pair.second));
            if (set == null) {
                LibraryDataNodeSubstitutor.$$$reportNull$$$0(13);
            }
            return set;
        }
        ModuleMappingInfo mapping = this.artifactsMap.getModuleMapping(path);
        if (mapping != null) {
            for (String id : mapping.getModuleIds()) {
                Pair<DataNode<GradleSourceSetData>, ExternalSourceSet> pair2 = this.sourceSetMap.get(id);
                if (pair2 == null) continue;
                results.add(new ModuleLookupResult((DataNode<GradleSourceSetData>)((DataNode)pair2.first), (ExternalSourceSet)pair2.second));
            }
        }
        ArrayList<ModuleLookupResult> arrayList = results;
        if (arrayList == null) {
            LibraryDataNodeSubstitutor.$$$reportNull$$$0(14);
        }
        return arrayList;
    }

    private static void applyClasspathShift(@NotNull Collection<AbstractDependencyData<?>> dependenciesToMove, int shift) {
        if (dependenciesToMove == null) {
            LibraryDataNodeSubstitutor.$$$reportNull$$$0(15);
        }
        if (shift > 0) {
            dependenciesToMove.forEach(data -> {
                int order = data.getOrder();
                data.setOrder(order + shift);
            });
        }
    }

    @Nullable
    private static Set<String> collectTargetModuleOutputPaths(@NotNull Set<String> libraryPaths, @Nullable MultiMap<ExternalSystemSourceType, String> gradleOutputs) {
        if (libraryPaths == null) {
            LibraryDataNodeSubstitutor.$$$reportNull$$$0(16);
        }
        if (gradleOutputs == null) {
            return null;
        }
        HashSet<String> compileSet = new HashSet<String>();
        ContainerUtil.addAllNotNull(compileSet, (Iterable)gradleOutputs.get((Object)ExternalSystemSourceType.SOURCE));
        ContainerUtil.addAllNotNull(compileSet, (Iterable)gradleOutputs.get((Object)ExternalSystemSourceType.RESOURCE));
        if (ContainerUtil.intersects(libraryPaths, compileSet)) {
            return compileSet;
        }
        HashSet<String> testSet = new HashSet<String>();
        ContainerUtil.addAllNotNull(testSet, (Iterable)gradleOutputs.get((Object)ExternalSystemSourceType.TEST));
        ContainerUtil.addAllNotNull(testSet, (Iterable)gradleOutputs.get((Object)ExternalSystemSourceType.TEST_RESOURCE));
        if (ContainerUtil.intersects(libraryPaths, testSet)) {
            return testSet;
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 12, 13, 14 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sourceSetMap";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "moduleOutputsMap";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "artifactsMap";
                break;
            }
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "libraryDependencyDataNode";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "lookupResult";
                break;
            }
            case 8: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "libraryPaths";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "unprocessedPaths";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "data1";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "data2";
                break;
            }
            case 12: 
            case 13: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/gradle/service/project/LibraryDataNodeSubstitutor";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dependenciesToMove";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/gradle/service/project/LibraryDataNodeSubstitutor";
                break;
            }
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "lookupTargetModule";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "run";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "collectDependenciesOrderedAfter";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "createAndMaybeAttachNewModuleDependency";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "isEqualIgnoringScope";
                break;
            }
            case 12: 
            case 13: 
            case 14: {
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "applyClasspathShift";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "collectTargetModuleOutputPaths";
                break;
            }
        }
        String string2 = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string2);
            case 12, 13, 14 -> new IllegalStateException(string2);
        };
    }
}

