/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal.statistic.eventLog.connection;

import com.intellij.internal.statistic.config.StatisticsStringUtil;
import com.intellij.internal.statistic.config.eventLog.EventLogBuildType;
import com.intellij.internal.statistic.eventLog.DataCollectorDebugLogger;
import com.intellij.internal.statistic.eventLog.EventLogApplicationInfo;
import com.intellij.internal.statistic.eventLog.EventLogFile;
import com.intellij.internal.statistic.eventLog.EventLogSendConfig;
import com.intellij.internal.statistic.eventLog.LogEventRecord;
import com.intellij.internal.statistic.eventLog.LogEventRecordRequest;
import com.intellij.internal.statistic.eventLog.LogEventSerializer;
import com.intellij.internal.statistic.eventLog.MachineId;
import com.intellij.internal.statistic.eventLog.connection.EventLogConnectionSettings;
import com.intellij.internal.statistic.eventLog.connection.EventLogResultDecorator;
import com.intellij.internal.statistic.eventLog.connection.EventLogSendListener;
import com.intellij.internal.statistic.eventLog.connection.EventLogSettingsService;
import com.intellij.internal.statistic.eventLog.connection.EventLogUploadSettingsService;
import com.intellij.internal.statistic.eventLog.connection.StatServiceException;
import com.intellij.internal.statistic.eventLog.connection.StatisticsResult;
import com.intellij.internal.statistic.eventLog.connection.StatisticsService;
import com.intellij.internal.statistic.eventLog.connection.request.StatsHttpRequests;
import com.intellij.internal.statistic.eventLog.connection.request.StatsHttpResponse;
import com.intellij.internal.statistic.eventLog.connection.request.StatsRequestBuilder;
import com.intellij.internal.statistic.eventLog.filters.LogEventFilter;
import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

@ApiStatus.Internal
public class EventLogStatisticsService
implements StatisticsService {
    private final EventLogSendConfig myConfiguration;
    private final EventLogSettingsService mySettingsService;
    private final EventLogSendListener mySendListener;

    public EventLogStatisticsService(@NotNull EventLogSendConfig config, @NotNull EventLogApplicationInfo application, @Nullable EventLogSendListener listener) {
        if (config == null) {
            EventLogStatisticsService.$$$reportNull$$$0(0);
        }
        if (application == null) {
            EventLogStatisticsService.$$$reportNull$$$0(1);
        }
        this.myConfiguration = config;
        this.mySettingsService = new EventLogUploadSettingsService(config.getRecorderId(), application);
        this.mySendListener = listener;
    }

    @TestOnly
    public EventLogStatisticsService(@NotNull EventLogSendConfig config, @Nullable EventLogSendListener listener, @Nullable EventLogUploadSettingsService settingsService) {
        if (config == null) {
            EventLogStatisticsService.$$$reportNull$$$0(2);
        }
        this.myConfiguration = config;
        this.mySettingsService = settingsService;
        this.mySendListener = listener;
    }

    @Override
    public StatisticsResult send() {
        return EventLogStatisticsService.send(this.myConfiguration, this.mySettingsService, new EventLogCounterResultDecorator(this.mySendListener));
    }

    public StatisticsResult send(@NotNull EventLogResultDecorator decorator) {
        if (decorator == null) {
            EventLogStatisticsService.$$$reportNull$$$0(3);
        }
        return EventLogStatisticsService.send(this.myConfiguration, this.mySettingsService, decorator);
    }

    public static StatisticsResult send(@NotNull EventLogSendConfig config, @NotNull EventLogSettingsService settings, @NotNull EventLogResultDecorator decorator) {
        if (config == null) {
            EventLogStatisticsService.$$$reportNull$$$0(4);
        }
        if (settings == null) {
            EventLogStatisticsService.$$$reportNull$$$0(5);
        }
        if (decorator == null) {
            EventLogStatisticsService.$$$reportNull$$$0(6);
        }
        EventLogApplicationInfo info = settings.getApplicationInfo();
        DataCollectorDebugLogger logger = info.getLogger();
        List<EventLogFile> logs = EventLogStatisticsService.getLogFiles(config, logger);
        if (!config.isSendEnabled()) {
            EventLogStatisticsService.cleanupEventLogFiles(logs, logger);
            return new StatisticsResult(StatisticsResult.ResultCode.NOTHING_TO_SEND, "Event Log collector is not enabled");
        }
        if (logs.isEmpty()) {
            return new StatisticsResult(StatisticsResult.ResultCode.NOTHING_TO_SEND, "No files to send");
        }
        if (!settings.isSettingsReachable()) {
            return new StatisticsResult(StatisticsResult.ResultCode.ERROR_IN_CONFIG, "ERROR: settings server is unreachable");
        }
        if (!settings.isSendEnabled()) {
            EventLogStatisticsService.cleanupEventLogFiles(logs, logger);
            return new StatisticsResult(StatisticsResult.ResultCode.NOT_PERMITTED_SERVER, "NOT_PERMITTED");
        }
        String serviceUrl = settings.getServiceUrl();
        if (serviceUrl == null) {
            return new StatisticsResult(StatisticsResult.ResultCode.ERROR_IN_CONFIG, "ERROR: unknown Statistics Service URL.");
        }
        boolean isInternal = info.isInternal();
        String productCode = info.getProductCode();
        EventLogBuildType defaultBuildType = EventLogStatisticsService.getDefaultBuildType(info.isEAP());
        LogEventFilter baseFilter = settings.getBaseEventFilter();
        MachineId machineId = EventLogStatisticsService.getActualOrDisabledMachineId(config.getMachineId(), settings);
        try {
            EventLogConnectionSettings connectionSettings = info.getConnectionSettings();
            decorator.onLogsLoaded(logs.size());
            ArrayList<File> toRemove = new ArrayList<File>(logs.size());
            for (EventLogFile logFile : logs) {
                File file = logFile.getFile();
                EventLogBuildType type = logFile.getType(defaultBuildType);
                LogEventFilter filter = settings.getEventFilter(baseFilter, type);
                String deviceId = config.getDeviceId();
                LogEventRecordRequest recordRequest = LogEventRecordRequest.Companion.create(file, config.getRecorderId(), productCode, deviceId, filter, isInternal, logger, machineId, config.isEscapingEnabled());
                ValidationErrorInfo error = EventLogStatisticsService.validate(recordRequest, file);
                if (error != null) {
                    if (logger.isTraceEnabled()) {
                        logger.trace(file.getName() + "-> " + error.getMessage());
                    }
                    decorator.onFailed(recordRequest, error.getCode(), null);
                    toRemove.add(file);
                    continue;
                }
                try {
                    StatsHttpRequests.post(serviceUrl, connectionSettings).withBody(LogEventSerializer.INSTANCE.toString(recordRequest), "application/json", StandardCharsets.UTF_8).succeed((r, code) -> {
                        toRemove.add(file);
                        decorator.onSucceed(recordRequest, EventLogStatisticsService.loadAndLogResponse(logger, r, file), file.getAbsolutePath());
                    }).fail((r, code) -> {
                        if (code == 400) {
                            toRemove.add(file);
                        }
                        decorator.onFailed(recordRequest, code, EventLogStatisticsService.loadAndLogResponse(logger, r, file));
                    }).send();
                }
                catch (Exception e) {
                    if (logger.isTraceEnabled()) {
                        logger.trace(file.getName() + " -> " + e.getMessage());
                    }
                    int errorCode = e instanceof StatsRequestBuilder.InvalidHttpRequest ? ((StatsRequestBuilder.InvalidHttpRequest)e).getCode() : 50;
                    decorator.onFailed(null, errorCode, null);
                }
            }
            EventLogStatisticsService.cleanupFiles(toRemove, logger);
            return decorator.onFinished();
        }
        catch (Exception e) {
            String message = e.getMessage();
            logger.info(message != null ? message : "", e);
            throw new StatServiceException("Error during data sending.", e);
        }
    }

    private static MachineId getActualOrDisabledMachineId(@NotNull MachineId machineId, @NotNull EventLogSettingsService settings) {
        if (machineId == null) {
            EventLogStatisticsService.$$$reportNull$$$0(7);
        }
        if (settings == null) {
            EventLogStatisticsService.$$$reportNull$$$0(8);
        }
        if (machineId == MachineId.DISABLED) {
            return MachineId.DISABLED;
        }
        Map<String, String> options = settings.getOptions();
        String machineIdSaltOption = options.get("id_salt");
        if ("disabled".equals(machineIdSaltOption)) {
            return MachineId.DISABLED;
        }
        return machineId;
    }

    @NotNull
    private static EventLogBuildType getDefaultBuildType(boolean isEap) {
        EventLogBuildType eventLogBuildType = isEap ? EventLogBuildType.EAP : EventLogBuildType.RELEASE;
        if (eventLogBuildType == null) {
            EventLogStatisticsService.$$$reportNull$$$0(9);
        }
        return eventLogBuildType;
    }

    @NotNull
    private static String loadAndLogResponse(@NotNull DataCollectorDebugLogger logger, @NotNull StatsHttpResponse response, @NotNull File file) throws IOException {
        String message;
        String content;
        if (logger == null) {
            EventLogStatisticsService.$$$reportNull$$$0(10);
        }
        if (response == null) {
            EventLogStatisticsService.$$$reportNull$$$0(11);
        }
        if (file == null) {
            EventLogStatisticsService.$$$reportNull$$$0(12);
        }
        String string = content = (message = response.readAsString()) != null ? message : Integer.toString(response.getStatusCode());
        if (logger.isTraceEnabled()) {
            logger.trace(file.getName() + " -> " + content);
        }
        String string2 = content;
        if (string2 == null) {
            EventLogStatisticsService.$$$reportNull$$$0(13);
        }
        return string2;
    }

    @Nullable
    private static ValidationErrorInfo validate(@Nullable LogEventRecordRequest request, @NotNull File file) {
        if (file == null) {
            EventLogStatisticsService.$$$reportNull$$$0(14);
        }
        if (request == null) {
            return new ValidationErrorInfo("File is empty or has invalid format: " + file.getName(), 1);
        }
        if (StatisticsStringUtil.isEmpty(request.getDevice())) {
            return new ValidationErrorInfo("Cannot upload event log, device ID is empty", 2);
        }
        if (StatisticsStringUtil.isEmpty(request.getProduct())) {
            return new ValidationErrorInfo("Cannot upload event log, product code is empty", 3);
        }
        if (StatisticsStringUtil.isEmpty(request.getRecorder())) {
            return new ValidationErrorInfo("Cannot upload event log, recorder code is empty", 4);
        }
        if (request.getRecords().isEmpty()) {
            return new ValidationErrorInfo("Cannot upload event log, record list is empty", 5);
        }
        for (LogEventRecord content : request.getRecords()) {
            if (!content.getEvents().isEmpty()) continue;
            return new ValidationErrorInfo("Cannot upload event log, event list is empty", 6);
        }
        return null;
    }

    @NotNull
    protected static List<EventLogFile> getLogFiles(@NotNull EventLogSendConfig config, @NotNull DataCollectorDebugLogger logger) {
        List<EventLogFile> list;
        if (config == null) {
            EventLogStatisticsService.$$$reportNull$$$0(15);
        }
        if (logger == null) {
            EventLogStatisticsService.$$$reportNull$$$0(16);
        }
        try {
            list = config.getFilesToSendProvider().getFilesToSend();
        }
        catch (Exception e) {
            String message = e.getMessage();
            logger.info(message != null ? message : "", e);
            List<EventLogFile> list2 = Collections.emptyList();
            if (list2 == null) {
                EventLogStatisticsService.$$$reportNull$$$0(18);
            }
            return list2;
        }
        if (list == null) {
            EventLogStatisticsService.$$$reportNull$$$0(17);
        }
        return list;
    }

    private static void cleanupEventLogFiles(@NotNull List<EventLogFile> toRemove, @NotNull DataCollectorDebugLogger logger) {
        if (toRemove == null) {
            EventLogStatisticsService.$$$reportNull$$$0(19);
        }
        if (logger == null) {
            EventLogStatisticsService.$$$reportNull$$$0(20);
        }
        ArrayList<File> filesToRemove = new ArrayList<File>();
        for (EventLogFile file : toRemove) {
            filesToRemove.add(file.getFile());
        }
        EventLogStatisticsService.cleanupFiles(filesToRemove, logger);
    }

    private static void cleanupFiles(@NotNull List<? extends File> toRemove, @NotNull DataCollectorDebugLogger logger) {
        if (toRemove == null) {
            EventLogStatisticsService.$$$reportNull$$$0(21);
        }
        if (logger == null) {
            EventLogStatisticsService.$$$reportNull$$$0(22);
        }
        for (File file : toRemove) {
            if (!file.delete()) {
                logger.warn("Failed deleting event log: " + file.getName());
            }
            if (!logger.isTraceEnabled()) continue;
            logger.trace("Removed sent log: " + file.getName());
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 9, 13, 17, 18 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "config";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "application";
                break;
            }
            case 3: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "decorator";
                break;
            }
            case 5: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settings";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "machineId";
                break;
            }
            case 9: 
            case 13: 
            case 17: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/internal/statistic/eventLog/connection/EventLogStatisticsService";
                break;
            }
            case 10: 
            case 16: 
            case 20: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "logger";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "response";
                break;
            }
            case 12: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 19: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toRemove";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/internal/statistic/eventLog/connection/EventLogStatisticsService";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefaultBuildType";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "loadAndLogResponse";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "getLogFiles";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "send";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getActualOrDisabledMachineId";
                break;
            }
            case 9: 
            case 13: 
            case 17: 
            case 18: {
                break;
            }
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "loadAndLogResponse";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "validate";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "getLogFiles";
                break;
            }
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "cleanupEventLogFiles";
                break;
            }
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "cleanupFiles";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 9, 13, 17, 18 -> new IllegalStateException(string);
        };
    }

    private static final class EventLogCounterResultDecorator
    implements EventLogResultDecorator {
        private final EventLogSendListener myListener;
        private int myLocalFiles = -1;
        private final List<String> mySuccessfullySentFiles = new ArrayList<String>();
        private final List<Integer> myErrors = new ArrayList<Integer>();

        private EventLogCounterResultDecorator(@Nullable EventLogSendListener listener) {
            this.myListener = listener;
        }

        @Override
        public void onLogsLoaded(int localFiles) {
            this.myLocalFiles = localFiles;
        }

        @Override
        public void onSucceed(@NotNull LogEventRecordRequest request, @NotNull String content, @NotNull String logPath) {
            if (request == null) {
                EventLogCounterResultDecorator.$$$reportNull$$$0(0);
            }
            if (content == null) {
                EventLogCounterResultDecorator.$$$reportNull$$$0(1);
            }
            if (logPath == null) {
                EventLogCounterResultDecorator.$$$reportNull$$$0(2);
            }
            this.mySuccessfullySentFiles.add(logPath);
        }

        @Override
        public void onFailed(@Nullable LogEventRecordRequest request, int error, @Nullable String content) {
            this.myErrors.add(error);
        }

        @Override
        @NotNull
        public StatisticsResult onFinished() {
            int failed;
            int succeed;
            int total;
            if (this.myListener != null) {
                this.myListener.onLogsSend(this.mySuccessfullySentFiles, this.myErrors, this.myLocalFiles);
            }
            if ((total = (succeed = this.mySuccessfullySentFiles.size()) + (failed = this.myErrors.size())) == 0) {
                return new StatisticsResult(StatisticsResult.ResultCode.NOTHING_TO_SEND, "No files to upload.");
            }
            if (failed > 0) {
                return new StatisticsResult(StatisticsResult.ResultCode.SENT_WITH_ERRORS, "Uploaded " + succeed + " out of " + total + " files.");
            }
            return new StatisticsResult(StatisticsResult.ResultCode.SEND, "Uploaded " + succeed + " files.");
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "request";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "content";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[0] = "logPath";
                    break;
                }
            }
            objectArray[1] = "com/intellij/internal/statistic/eventLog/connection/EventLogStatisticsService$EventLogCounterResultDecorator";
            objectArray[2] = "onSucceed";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static final class ValidationErrorInfo {
        private final int myCode;
        private final String myError;

        private ValidationErrorInfo(@NotNull String error, int code) {
            if (error == null) {
                ValidationErrorInfo.$$$reportNull$$$0(0);
            }
            this.myError = error;
            this.myCode = code;
        }

        private int getCode() {
            return this.myCode;
        }

        @NotNull
        private String getMessage() {
            String string = this.myError;
            if (string == null) {
                ValidationErrorInfo.$$$reportNull$$$0(1);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "error";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/internal/statistic/eventLog/connection/EventLogStatisticsService$ValidationErrorInfo";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/internal/statistic/eventLog/connection/EventLogStatisticsService$ValidationErrorInfo";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getMessage";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 1 -> new IllegalStateException(string);
            };
        }
    }
}

