/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sisu.plexus;

import java.net.URL;
import org.codehaus.plexus.component.annotations.Component;
import org.eclipse.sisu.inject.Logs;
import org.eclipse.sisu.plexus.ComponentImpl;
import org.eclipse.sisu.plexus.Hints;
import org.eclipse.sisu.plexus.PlexusTypeListener;
import org.eclipse.sisu.space.AnnotationVisitor;
import org.eclipse.sisu.space.ClassSpace;
import org.eclipse.sisu.space.ClassVisitor;
import org.eclipse.sisu.space.LoadedClass;
import org.eclipse.sisu.space.QualifiedTypeVisitor;
import org.eclipse.sisu.space.SpaceScanner;
import org.eclipse.sisu.space.SpaceVisitor;

public final class PlexusTypeVisitor
implements SpaceVisitor,
ClassVisitor {
    private static final String COMPONENT_DESC = SpaceScanner.jvmDescriptor(Component.class);
    private final ComponentAnnotationVisitor componentVisitor = new ComponentAnnotationVisitor();
    private final PlexusTypeListener plexusTypeListener;
    private final QualifiedTypeVisitor qualifiedTypeVisitor;
    private ClassSpace space;
    private String source;
    private String implementation;

    public PlexusTypeVisitor(PlexusTypeListener listener) {
        this.plexusTypeListener = listener;
        this.qualifiedTypeVisitor = new QualifiedTypeVisitor(listener);
    }

    @Override
    public void enterSpace(ClassSpace _space) {
        this.space = _space;
        this.source = _space.toString();
        this.qualifiedTypeVisitor.enterSpace(_space);
        if (Logs.TRACE_ENABLED) {
            QualifiedTypeVisitor.verify(_space, Component.class);
        }
    }

    @Override
    public ClassVisitor visitClass(URL url) {
        this.componentVisitor.reset();
        this.implementation = null;
        this.qualifiedTypeVisitor.visitClass(null);
        return this;
    }

    @Override
    public void enterClass(int modifiers, String name, String _extends, String[] _implements) {
        if ((modifiers & 0x7600) == 0) {
            this.implementation = name;
        }
        this.qualifiedTypeVisitor.enterClass(modifiers, name, _extends, _implements);
    }

    @Override
    public AnnotationVisitor visitAnnotation(String desc) {
        if (COMPONENT_DESC.equals(desc)) {
            return this.componentVisitor;
        }
        return this.qualifiedTypeVisitor.visitAnnotation(desc);
    }

    @Override
    public void leaveClass() {
        Component component;
        if (this.implementation != null && (component = this.componentVisitor.getComponent(this.space)) != null) {
            Class<?> clazz = this.space.loadClass(this.implementation.replace('/', '.'));
            this.plexusTypeListener.hear(component, new LoadedClass(clazz), this.source);
            this.qualifiedTypeVisitor.disqualify();
        }
        this.qualifiedTypeVisitor.leaveClass();
    }

    @Override
    public void leaveSpace() {
        this.qualifiedTypeVisitor.leaveSpace();
    }

    static final class ComponentAnnotationVisitor
    implements AnnotationVisitor {
        private String role;
        private String hint;
        private String strategy;
        private String description;

        ComponentAnnotationVisitor() {
        }

        public void reset() {
            this.role = null;
            this.hint = "default";
            this.strategy = "singleton";
            this.description = "";
        }

        @Override
        public void enterAnnotation() {
        }

        @Override
        public void visitElement(String name, Object value) {
            if ("role".equals(name)) {
                this.role = (String)value;
            } else if ("hint".equals(name)) {
                this.hint = Hints.canonicalHint((String)value);
            } else if ("instantiationStrategy".equals(name)) {
                this.strategy = (String)value;
            } else if ("description".equals(name)) {
                this.description = (String)value;
            }
        }

        @Override
        public void leaveAnnotation() {
        }

        public Component getComponent(ClassSpace space) {
            return this.role != null ? new ComponentImpl(space.loadClass(this.role), this.hint, this.strategy, this.description) : null;
        }
    }
}

