/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.testFramework.utils.inlays.declarative;

import com.intellij.codeInsight.hints.InlayDumpUtil;
import com.intellij.codeInsight.hints.declarative.InlayHintsProvider;
import com.intellij.codeInsight.hints.declarative.InlayProviderPassInfo;
import com.intellij.codeInsight.hints.declarative.impl.DeclarativeHintsPreviewProvider;
import com.intellij.codeInsight.hints.declarative.impl.DeclarativeInlayHintsPass;
import com.intellij.codeInsight.hints.declarative.impl.DeclarativeInlayHintsPassFactory;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.progress.EmptyProgressIndicator;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.testFramework.fixtures.BasePlatformTestCase;
import com.intellij.testFramework.utils.inlays.InlayHintsProviderTestCase;
import com.intellij.testFramework.utils.inlays.declarative.DeclarativeInlayHintsProviderTestCase;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.intellij.lang.annotations.Language;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\u0010\u000b\n\u0002\b\u0002\b&\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J \u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\bH\u0002J(\u0010\n\u001a\u00020\u00042\b\b\u0001\u0010\t\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fJ>\u0010\u0010\u001a\u00020\u00042\u0006\u0010\u0011\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\b2\u0006\u0010\f\u001a\u00020\r2\u0014\b\u0002\u0010\u0012\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\u00140\u00132\b\b\u0002\u0010\u0015\u001a\u00020\u0014\u00a8\u0006\u0016"}, d2={"Lcom/intellij/testFramework/utils/inlays/declarative/DeclarativeInlayHintsProviderTestCase;", "Lcom/intellij/testFramework/fixtures/BasePlatformTestCase;", "()V", "applyPassAndCheckResult", "", "pass", "Lcom/intellij/codeInsight/hints/declarative/impl/DeclarativeInlayHintsPass;", "previewText", "", "expectedText", "doTestPreview", "providerId", "provider", "Lcom/intellij/codeInsight/hints/declarative/InlayHintsProvider;", "language", "Lcom/intellij/lang/Language;", "doTestProvider", "fileName", "enabledOptions", "", "", "verifyHintsPresence", "intellij.platform.testFramework"})
public abstract class DeclarativeInlayHintsProviderTestCase
extends BasePlatformTestCase {
    public final void doTestProvider(@NotNull String fileName, @NotNull String expectedText, @NotNull InlayHintsProvider provider, @NotNull Map<String, Boolean> enabledOptions, boolean verifyHintsPresence) {
        Intrinsics.checkNotNullParameter((Object)fileName, (String)"fileName");
        Intrinsics.checkNotNullParameter((Object)expectedText, (String)"expectedText");
        Intrinsics.checkNotNullParameter((Object)provider, (String)"provider");
        Intrinsics.checkNotNullParameter(enabledOptions, (String)"enabledOptions");
        if (verifyHintsPresence) {
            InlayHintsProviderTestCase.Companion.verifyHintsPresence(expectedText);
        }
        String sourceText = InlayDumpUtil.INSTANCE.removeHints(expectedText);
        this.myFixture.configureByText(fileName, sourceText);
        PsiFile psiFile = this.myFixture.getFile();
        Intrinsics.checkNotNull((Object)psiFile);
        PsiFile file2 = psiFile;
        Editor editor = this.myFixture.getEditor();
        InlayProviderPassInfo providerInfo = new InlayProviderPassInfo(provider, "provider.id", enabledOptions);
        PsiElement psiElement = (PsiElement)file2;
        Intrinsics.checkNotNull((Object)editor);
        DeclarativeInlayHintsPass pass = new DeclarativeInlayHintsPass(psiElement, editor, CollectionsKt.listOf((Object)providerInfo), false, false, 16, null);
        this.applyPassAndCheckResult(pass, sourceText, expectedText);
    }

    public static /* synthetic */ void doTestProvider$default(DeclarativeInlayHintsProviderTestCase declarativeInlayHintsProviderTestCase, String string, String string2, InlayHintsProvider inlayHintsProvider, Map map, boolean bl, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: doTestProvider");
        }
        if ((n & 8) != 0) {
            map = MapsKt.emptyMap();
        }
        if ((n & 0x10) != 0) {
            bl = false;
        }
        declarativeInlayHintsProviderTestCase.doTestProvider(string, string2, inlayHintsProvider, map, bl);
    }

    public final void doTestPreview(@Language(value="JAVA") @NotNull String expectedText, @NotNull String providerId, @NotNull InlayHintsProvider provider, @NotNull com.intellij.lang.Language language) {
        Intrinsics.checkNotNullParameter((Object)expectedText, (String)"expectedText");
        Intrinsics.checkNotNullParameter((Object)providerId, (String)"providerId");
        Intrinsics.checkNotNullParameter((Object)provider, (String)"provider");
        Intrinsics.checkNotNullParameter((Object)language, (String)"language");
        String string = DeclarativeHintsPreviewProvider.INSTANCE.getPreview(language, providerId, provider);
        if (string == null) {
            throw new IllegalStateException(("Preview not found for provider: " + providerId).toString());
        }
        String previewText = string;
        Object object = language.getAssociatedFileType();
        if (object == null || (object = object.getDefaultExtension()) == null) {
            throw new IllegalStateException("language must have extension".toString());
        }
        String fileName = "preview." + (String)object;
        this.myFixture.configureByText(fileName, InlayDumpUtil.INSTANCE.removeHints(previewText));
        PsiFile psiFile = this.myFixture.getFile();
        Intrinsics.checkNotNullExpressionValue((Object)psiFile, (String)"getFile(...)");
        Editor editor = this.myFixture.getEditor();
        Intrinsics.checkNotNullExpressionValue((Object)editor, (String)"getEditor(...)");
        DeclarativeInlayHintsPass pass = DeclarativeInlayHintsPassFactory.Companion.createPassForPreview(psiFile, editor, provider, providerId, MapsKt.emptyMap(), false);
        this.applyPassAndCheckResult(pass, previewText, expectedText);
    }

    private final void applyPassAndCheckResult(DeclarativeInlayHintsPass pass, String previewText, String expectedText) {
        pass.doCollectInformation((ProgressIndicator)new EmptyProgressIndicator());
        pass.applyInformationToEditor();
        Function2 function2 = applyPassAndCheckResult.dump.1.INSTANCE;
        PsiFile psiFile = this.myFixture.getFile();
        Intrinsics.checkNotNull((Object)psiFile);
        Editor editor = this.myFixture.getEditor();
        Intrinsics.checkNotNullExpressionValue((Object)editor, (String)"getEditor(...)");
        PsiFile psiFile2 = this.myFixture.getFile();
        Intrinsics.checkNotNull((Object)psiFile2);
        Document document = this.myFixture.getDocument(psiFile2);
        Intrinsics.checkNotNullExpressionValue((Object)document, (String)"getDocument(...)");
        String dump2 = InlayDumpUtil.dumpHintsInternal$default((InlayDumpUtil)InlayDumpUtil.INSTANCE, (String)previewText, null, (Function2)function2, (PsiFile)psiFile, (Editor)editor, (Document)document, (int)0, (int)66, null);
        BasePlatformTestCase.assertEquals((String)((Object)StringsKt.trim((CharSequence)expectedText)).toString(), (String)((Object)StringsKt.trim((CharSequence)dump2)).toString());
    }
}

