/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.platform.uast.testFramework.env;

import com.intellij.codeInspection.ex.InspectionProfileImpl;
import com.intellij.ide.impl.OpenProjectTask;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.project.ex.ProjectManagerEx;
import com.intellij.openapi.projectRoots.JavaSdk;
import com.intellij.openapi.projectRoots.ProjectJdkTable;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.projectRoots.impl.JavaAwareProjectJdkTableImpl;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.roots.libraries.LibraryTable;
import com.intellij.openapi.roots.libraries.LibraryTablesRegistrar;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.ThrowableComputable;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.changes.ChangeListManager;
import com.intellij.openapi.vcs.changes.ChangeListManagerImpl;
import com.intellij.openapi.vcs.impl.ProjectLevelVcsManagerImpl;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.testFramework.TestApplicationManager;
import com.intellij.testFramework.UsefulTestCase;
import java.io.File;
import java.nio.file.Path;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\b&\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J&\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\f2\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\r0\nH\u0002J\u0010\u0010\u001a\u001a\u00020\u00152\u0006\u0010\u001b\u001a\u00020\u001cH\u0002J\b\u0010\u001d\u001a\u00020\u0004H\u0002J\b\u0010\u001e\u001a\u00020\u001fH\u0014J\b\u0010 \u001a\u00020\u0015H\u0014J\b\u0010!\u001a\u00020\u0015H\u0014R\u001a\u0010\u0003\u001a\u00020\u0004X\u0084.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\bR,\u0010\t\u001a\u001a\u0012\u0016\u0012\u0014\u0012\u0004\u0012\u00020\f\u0012\n\u0012\b\u0012\u0004\u0012\u00020\r0\n0\u000b0\n8TX\u0094\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000fR\u0012\u0010\u0010\u001a\u00020\u0011X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0013\u00a8\u0006\""}, d2={"Lcom/intellij/platform/uast/testFramework/env/AbstractLargeProjectTest;", "Lcom/intellij/testFramework/UsefulTestCase;", "()V", "project", "Lcom/intellij/openapi/project/Project;", "getProject", "()Lcom/intellij/openapi/project/Project;", "setProject", "(Lcom/intellij/openapi/project/Project;)V", "projectLibraries", "", "Lkotlin/Pair;", "", "Ljava/io/File;", "getProjectLibraries", "()Ljava/util/List;", "testProjectPath", "Ljava/nio/file/Path;", "getTestProjectPath", "()Ljava/nio/file/Path;", "addLibrary", "", "tableModel", "Lcom/intellij/openapi/roots/libraries/LibraryTable$ModifiableModel;", "libName", "libRoots", "disposeOnTearDownInEdt", "runnable", "Ljava/lang/Runnable;", "openTestProject", "runInDispatchThread", "", "setUp", "tearDown", "intellij.platform.uast.testFramework"})
@SourceDebugExtension(value={"SMAP\nAbstractLargeProjectTest.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AbstractLargeProjectTest.kt\ncom/intellij/platform/uast/testFramework/env/AbstractLargeProjectTest\n+ 2 readWriteActionsInTests.kt\ncom/intellij/openapi/application/ReadWriteActionsInTestsKt\n+ 3 Timing.kt\nkotlin/system/TimingKt\n*L\n1#1,118:1\n11#2:119\n11#2:126\n17#3,6:120\n*S KotlinDebug\n*F\n+ 1 AbstractLargeProjectTest.kt\ncom/intellij/platform/uast/testFramework/env/AbstractLargeProjectTest\n*L\n47#1:119\n76#1:126\n61#1:120,6\n*E\n"})
public abstract class AbstractLargeProjectTest
extends UsefulTestCase {
    protected Project project;

    @NotNull
    public abstract Path getTestProjectPath();

    @NotNull
    protected List<Pair<String, List<File>>> getProjectLibraries() {
        return CollectionsKt.emptyList();
    }

    @NotNull
    protected final Project getProject() {
        Project project2 = this.project;
        if (project2 != null) {
            return project2;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"project");
        return null;
    }

    protected final void setProject(@NotNull Project project2) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"<set-?>");
        this.project = project2;
    }

    @Override
    protected boolean runInDispatchThread() {
        return false;
    }

    @Override
    protected void setUp() {
        super.setUp();
        TestApplicationManager.Companion.getInstance();
        boolean $i$f$runWriteActionAndWait = false;
        WriteAction.computeAndWait((ThrowableComputable)new ThrowableComputable(this){
            final /* synthetic */ AbstractLargeProjectTest this$0;
            {
                this.this$0 = abstractLargeProjectTest;
            }

            public final T compute() {
                boolean bl = false;
                JavaSdk javaSdk = JavaSdk.getInstance();
                String string = JavaAwareProjectJdkTableImpl.getInstanceEx().getInternalJdk().getHomePath();
                Intrinsics.checkNotNull((Object)string);
                Sdk sdk = javaSdk.createJdk("1.8", string, false);
                Intrinsics.checkNotNullExpressionValue((Object)sdk, (String)"createJdk(...)");
                Sdk j8 = sdk;
                ProjectJdkTable.getInstance().addJdk(j8, this.this$0.getTestRootDisposable());
                JavaSdk javaSdk2 = JavaSdk.getInstance();
                String string2 = JavaAwareProjectJdkTableImpl.getInstanceEx().getInternalJdk().getHomePath();
                Intrinsics.checkNotNull((Object)string2);
                Sdk sdk2 = javaSdk2.createJdk("IDEA jdk", string2, false);
                Intrinsics.checkNotNullExpressionValue((Object)sdk2, (String)"createJdk(...)");
                Sdk internal = sdk2;
                ProjectJdkTable.getInstance().addJdk(internal, this.this$0.getTestRootDisposable());
                return (T)Unit.INSTANCE;
            }
        });
        InspectionProfileImpl.INIT_INSPECTIONS = true;
        boolean $i$f$measureTimeMillis = false;
        long start$iv = System.currentTimeMillis();
        boolean bl = false;
        this.setProject(this.openTestProject());
        long projectOpenTime = System.currentTimeMillis() - start$iv;
        UsefulTestCase.LOG.warn("Project has been opened successfully in " + projectOpenTime + " ms");
    }

    @Override
    protected void tearDown() {
        InspectionProfileImpl.INIT_INSPECTIONS = false;
        super.tearDown();
    }

    private final Project openTestProject() {
        Project project2 = ProjectManagerEx.Companion.getInstanceEx().openProject(this.getTestProjectPath(), new OpenProjectTask(false, null, false, false, 15, null));
        Intrinsics.checkNotNull((Object)project2);
        Project project3 = project2;
        this.disposeOnTearDownInEdt(() -> AbstractLargeProjectTest.openTestProject$lambda$2(project3));
        boolean $i$f$runWriteActionAndWait = false;
        WriteAction.computeAndWait((ThrowableComputable)new ThrowableComputable(project3, this){
            final /* synthetic */ Project $project$inlined;
            final /* synthetic */ AbstractLargeProjectTest this$0;
            {
                this.$project$inlined = project2;
                this.this$0 = abstractLargeProjectTest;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public final T compute() {
                boolean bl = false;
                LibraryTable.ModifiableModel modifiableModel = LibraryTablesRegistrar.getInstance().getLibraryTable(this.$project$inlined).getModifiableModel();
                Intrinsics.checkNotNullExpressionValue((Object)modifiableModel, (String)"getModifiableModel(...)");
                LibraryTable.ModifiableModel tableModel = modifiableModel;
                try {
                    for (Pair<String, List<File>> pair : this.this$0.getProjectLibraries()) {
                        String libName = (String)pair.component1();
                        List libRoots = (List)pair.component2();
                        AbstractLargeProjectTest.access$addLibrary(this.this$0, tableModel, libName, libRoots);
                    }
                }
                finally {
                    tableModel.commit();
                }
                return (T)Unit.INSTANCE;
            }
        });
        ApplicationManager.getApplication().invokeAndWait(AbstractLargeProjectTest::openTestProject$lambda$4);
        ProjectLevelVcsManager projectLevelVcsManager = ProjectLevelVcsManager.getInstance((Project)project3);
        Intrinsics.checkNotNull((Object)projectLevelVcsManager, (String)"null cannot be cast to non-null type com.intellij.openapi.vcs.impl.ProjectLevelVcsManagerImpl");
        ((ProjectLevelVcsManagerImpl)projectLevelVcsManager).waitForInitialized();
        ChangeListManager changeListManager = ChangeListManager.getInstance((Project)project3);
        Intrinsics.checkNotNull((Object)changeListManager, (String)"null cannot be cast to non-null type com.intellij.openapi.vcs.changes.ChangeListManagerImpl");
        ((ChangeListManagerImpl)changeListManager).waitUntilRefreshed();
        return project3;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void addLibrary(LibraryTable.ModifiableModel tableModel, String libName, List<? extends File> libRoots) {
        Library library = tableModel.createLibrary(libName, null);
        Intrinsics.checkNotNullExpressionValue((Object)library, (String)"createLibrary(...)");
        Library library2 = library;
        Library.ModifiableModel modifiableModel = library2.getModifiableModel();
        Intrinsics.checkNotNullExpressionValue((Object)modifiableModel, (String)"getModifiableModel(...)");
        Library.ModifiableModel libModel = modifiableModel;
        try {
            for (File file2 : libRoots) {
                libModel.addRoot(VfsUtil.getUrlForLibraryRoot((File)file2), OrderRootType.CLASSES);
            }
        }
        finally {
            libModel.commit();
        }
    }

    private final void disposeOnTearDownInEdt(Runnable runnable) {
        Disposer.register((Disposable)this.getTestRootDisposable(), () -> AbstractLargeProjectTest.disposeOnTearDownInEdt$lambda$5(runnable));
    }

    private static final void openTestProject$lambda$2(Project $project) {
        Intrinsics.checkNotNullParameter((Object)$project, (String)"$project");
        ProjectManager.getInstance().closeAndDispose($project);
    }

    private static final void openTestProject$lambda$4() {
    }

    private static final void disposeOnTearDownInEdt$lambda$5(Runnable $runnable) {
        Intrinsics.checkNotNullParameter((Object)$runnable, (String)"$runnable");
        ApplicationManager.getApplication().invokeAndWait($runnable);
    }

    public static final /* synthetic */ void access$addLibrary(AbstractLargeProjectTest $this, LibraryTable.ModifiableModel tableModel, String libName, List libRoots) {
        $this.addLibrary(tableModel, libName, libRoots);
    }
}

