/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.platform.testFramework.io;

import com.intellij.platform.testFramework.io.DnsMock;
import com.intellij.platform.testFramework.io.DnsMockDelegate;
import com.intellij.platform.testFramework.io.DnsMockJdk17;
import com.intellij.platform.testFramework.io.DnsMockJdk21;
import com.intellij.util.lang.JavaVersion;
import java.io.File;
import java.net.InetAddress;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.io.FilesKt;
import kotlin.jdk7.AutoCloseableKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.InlineMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.junit.rules.ExternalResource;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J'\u0010\u000b\u001a\u00020\u00002\u0006\u0010\f\u001a\u00020\r2\u0012\u0010\u000e\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00100\u000f\"\u00020\u0010\u00a2\u0006\u0002\u0010\u0011J\b\u0010\u0012\u001a\u00020\u0013H\u0016J\b\u0010\u0014\u001a\u00020\u0013H\u0016J+\u0010\u0015\u001a\u0002H\u0016\"\u0004\b\u0000\u0010\u00162\u0012\u0010\u0017\u001a\u000e\u0012\u0004\u0012\u00020\u0000\u0012\u0004\u0012\u0002H\u00160\u0018H\u0086\b\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u0019R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001b\u0010\u0005\u001a\u00020\u00068BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\t\u0010\n\u001a\u0004\b\u0007\u0010\b\u0082\u0002\u0007\n\u0005\b\u009920\u0001\u00a8\u0006\u001a"}, d2={"Lcom/intellij/platform/testFramework/io/DnsMock;", "Lorg/junit/rules/ExternalResource;", "()V", "delegate", "Lcom/intellij/platform/testFramework/io/DnsMockDelegate;", "hostsFile", "Ljava/io/File;", "getHostsFile", "()Ljava/io/File;", "hostsFile$delegate", "Lkotlin/Lazy;", "add", "domain", "", "addresses", "", "Ljava/net/InetAddress;", "(Ljava/lang/String;[Ljava/net/InetAddress;)Lcom/intellij/platform/testFramework/io/DnsMock;", "after", "", "before", "use", "T", "body", "Lkotlin/Function1;", "(Lkotlin/jvm/functions/Function1;)Ljava/lang/Object;", "intellij.platform.testFramework"})
@SourceDebugExtension(value={"SMAP\nDnsMock.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DnsMock.kt\ncom/intellij/platform/testFramework/io/DnsMock\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,127:1\n1#2:128\n*E\n"})
public final class DnsMock
extends ExternalResource {
    @NotNull
    private final Lazy hostsFile$delegate = LazyKt.lazy((Function0)hostsFile.2.INSTANCE);
    @NotNull
    private final DnsMockDelegate delegate = JavaVersion.current().isAtLeast(21) ? (DnsMockDelegate)DnsMockJdk21.INSTANCE : (DnsMockDelegate)DnsMockJdk17.INSTANCE;

    private final File getHostsFile() {
        Lazy lazy = this.hostsFile$delegate;
        return (File)lazy.getValue();
    }

    public void before() {
        this.delegate.setUp(this.getHostsFile());
    }

    public void after() {
        this.delegate.tearDown();
    }

    @NotNull
    public final DnsMock add(@NotNull String domain, InetAddress ... addresses) {
        Intrinsics.checkNotNullParameter((Object)domain, (String)"domain");
        Intrinsics.checkNotNullParameter((Object)addresses, (String)"addresses");
        FilesKt.appendText$default((File)this.getHostsFile(), (String)ArraysKt.joinToString$default((Object[])addresses, (CharSequence)"\n", (CharSequence)"\n", null, (int)0, null, (Function1)((Function1)new Function1<InetAddress, CharSequence>(domain){
            final /* synthetic */ String $domain;
            {
                this.$domain = $domain;
                super(1);
            }

            @NotNull
            public final CharSequence invoke(@NotNull InetAddress it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                return it.getHostAddress() + " " + this.$domain;
            }
        }), (int)28, null), null, (int)2, null);
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final <T> T use(@NotNull Function1<? super DnsMock, ? extends T> body) {
        Object object;
        Intrinsics.checkNotNullParameter(body, (String)"body");
        boolean $i$f$use = false;
        this.before();
        AutoCloseable autoCloseable = this::after;
        Throwable throwable = null;
        try {
            AutoCloseable it = autoCloseable;
            boolean bl = false;
            object = body.invoke((Object)this);
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            InlineMarker.finallyStart((int)1);
            AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
            InlineMarker.finallyEnd((int)1);
        }
        return (T)object;
    }
}

