/*
 * Decompiled with CFR 0.152.
 */
package org.jline.terminal;

import java.io.FileDescriptor;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Method;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.charset.UnsupportedCharsetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.ServiceLoader;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jline.terminal.Attributes;
import org.jline.terminal.Size;
import org.jline.terminal.Terminal;
import org.jline.terminal.impl.AbstractPosixTerminal;
import org.jline.terminal.impl.AbstractTerminal;
import org.jline.terminal.impl.DumbTerminal;
import org.jline.terminal.spi.TerminalProvider;
import org.jline.utils.Log;
import org.jline.utils.OSUtils;

public final class TerminalBuilder {
    public static final String PROP_ENCODING = "org.jline.terminal.encoding";
    public static final String PROP_CODEPAGE = "org.jline.terminal.codepage";
    public static final String PROP_TYPE = "org.jline.terminal.type";
    public static final String PROP_PROVIDERS = "org.jline.terminal.providers";
    public static final String PROP_PROVIDERS_DEFAULT = "jansi,jna,exec";
    public static final String PROP_JNA = "org.jline.terminal.jna";
    public static final String PROP_JANSI = "org.jline.terminal.jansi";
    public static final String PROP_EXEC = "org.jline.terminal.exec";
    public static final String PROP_DUMB = "org.jline.terminal.dumb";
    public static final String PROP_DUMB_COLOR = "org.jline.terminal.dumb.color";
    public static final String PROP_OUTPUT = "org.jline.terminal.output";
    public static final String PROP_OUTPUT_OUT = "out";
    public static final String PROP_OUTPUT_ERR = "err";
    public static final String PROP_OUTPUT_OUT_ERR = "out-err";
    public static final String PROP_OUTPUT_ERR_OUT = "err-out";
    public static final String PROP_NON_BLOCKING_READS = "org.jline.terminal.pty.nonBlockingReads";
    public static final String PROP_COLOR_DISTANCE = "org.jline.utils.colorDistance";
    public static final String PROP_DISABLE_ALTERNATE_CHARSET = "org.jline.utils.disableAlternateCharset";
    public static final String PROP_FILE_DESCRIPTOR_CREATION_MODE = "org.jline.terminal.pty.fileDescriptorCreationMode";
    public static final String PROP_FILE_DESCRIPTOR_CREATION_MODE_NATIVE = "native";
    public static final String PROP_FILE_DESCRIPTOR_CREATION_MODE_REFLECTION = "reflection";
    public static final String PROP_FILE_DESCRIPTOR_CREATION_MODE_DEFAULT = "reflection,native";
    private static final AtomicReference<Terminal> SYSTEM_TERMINAL = new AtomicReference();
    private static final AtomicReference<Terminal> TERMINAL_OVERRIDE = new AtomicReference();
    private String name;
    private InputStream in;
    private OutputStream out;
    private String type;
    private Charset encoding;
    private int codepage;
    private Boolean system;
    private SystemOutput systemOutput;
    private Boolean jna;
    private Boolean jansi;
    private Boolean exec;
    private Boolean dumb;
    private Boolean color;
    private Attributes attributes;
    private Size size;
    private boolean nativeSignals = false;
    private Terminal.SignalHandler signalHandler = Terminal.SignalHandler.SIG_DFL;
    private boolean paused = false;
    private static final int UTF8_CODE_PAGE = 65001;

    public static Terminal terminal() throws IOException {
        return TerminalBuilder.builder().build();
    }

    public static TerminalBuilder builder() {
        return new TerminalBuilder();
    }

    private TerminalBuilder() {
    }

    public TerminalBuilder name(String name) {
        this.name = name;
        return this;
    }

    public TerminalBuilder streams(InputStream in, OutputStream out) {
        this.in = in;
        this.out = out;
        return this;
    }

    public TerminalBuilder system(boolean system) {
        this.system = system;
        return this;
    }

    public TerminalBuilder systemOutput(SystemOutput systemOutput) {
        this.systemOutput = systemOutput;
        return this;
    }

    public TerminalBuilder jna(boolean jna) {
        this.jna = jna;
        return this;
    }

    public TerminalBuilder jansi(boolean jansi) {
        this.jansi = jansi;
        return this;
    }

    public TerminalBuilder exec(boolean exec) {
        this.exec = exec;
        return this;
    }

    public TerminalBuilder dumb(boolean dumb) {
        this.dumb = dumb;
        return this;
    }

    public TerminalBuilder type(String type) {
        this.type = type;
        return this;
    }

    public TerminalBuilder color(boolean color) {
        this.color = color;
        return this;
    }

    public TerminalBuilder encoding(String encoding) throws UnsupportedCharsetException {
        return this.encoding(encoding != null ? Charset.forName(encoding) : null);
    }

    public TerminalBuilder encoding(Charset encoding) {
        this.encoding = encoding;
        return this;
    }

    @Deprecated
    public TerminalBuilder codepage(int codepage) {
        this.codepage = codepage;
        return this;
    }

    public TerminalBuilder attributes(Attributes attributes) {
        this.attributes = attributes;
        return this;
    }

    public TerminalBuilder size(Size size) {
        this.size = size;
        return this;
    }

    public TerminalBuilder nativeSignals(boolean nativeSignals) {
        this.nativeSignals = nativeSignals;
        return this;
    }

    public TerminalBuilder signalHandler(Terminal.SignalHandler signalHandler) {
        this.signalHandler = signalHandler;
        return this;
    }

    public TerminalBuilder paused(boolean paused) {
        this.paused = paused;
        return this;
    }

    public Terminal build() throws IOException {
        Terminal terminal;
        Terminal override = TERMINAL_OVERRIDE.get();
        Terminal terminal2 = terminal = override != null ? override : this.doBuild();
        if (override != null) {
            Log.debug(() -> "Overriding terminal with global value set by TerminalBuilder.setTerminalOverride");
        }
        Log.debug(() -> "Using terminal " + terminal.getClass().getSimpleName());
        if (terminal instanceof AbstractPosixTerminal) {
            Log.debug(() -> "Using pty " + ((AbstractPosixTerminal)terminal).getPty().getClass().getSimpleName());
        }
        return terminal;
    }

    private Terminal doBuild() throws IOException {
        TerminalProvider provider;
        Boolean dumb;
        Boolean exec;
        Boolean jansi;
        Boolean jna;
        String type;
        String charsetName;
        Charset encoding;
        String name = this.name;
        if (name == null) {
            name = "JLine terminal";
        }
        if ((encoding = this.encoding) == null && (charsetName = System.getProperty(PROP_ENCODING)) != null && Charset.isSupported(charsetName)) {
            encoding = Charset.forName(charsetName);
        }
        if (encoding == null) {
            String str;
            int codepage = this.codepage;
            if (codepage <= 0 && (str = System.getProperty(PROP_CODEPAGE)) != null) {
                codepage = Integer.parseInt(str);
            }
            encoding = codepage >= 0 ? TerminalBuilder.getCodepageCharset(codepage) : StandardCharsets.UTF_8;
        }
        if ((type = this.type) == null) {
            type = System.getProperty(PROP_TYPE);
        }
        if (type == null) {
            type = System.getenv("TERM");
        }
        if ((jna = this.jna) == null) {
            jna = TerminalBuilder.getBoolean(PROP_JNA, true);
        }
        if ((jansi = this.jansi) == null) {
            jansi = TerminalBuilder.getBoolean(PROP_JANSI, true);
        }
        if ((exec = this.exec) == null) {
            exec = TerminalBuilder.getBoolean(PROP_EXEC, true);
        }
        if ((dumb = this.dumb) == null) {
            dumb = TerminalBuilder.getBoolean(PROP_DUMB, null);
        }
        IllegalStateException exception = new IllegalStateException("Unable to create a terminal");
        ArrayList<TerminalProvider> providers = new ArrayList<TerminalProvider>();
        if (jna.booleanValue()) {
            try {
                provider = TerminalProvider.load("jna");
                providers.add(provider);
            }
            catch (Throwable t) {
                Log.debug("Unable to load JNA support: ", t);
                exception.addSuppressed(t);
            }
        }
        if (jansi.booleanValue()) {
            try {
                provider = TerminalProvider.load("jansi");
                providers.add(provider);
            }
            catch (Throwable t) {
                Log.debug("Unable to load JANSI support: ", t);
                exception.addSuppressed(t);
            }
        }
        if (exec.booleanValue()) {
            try {
                provider = TerminalProvider.load("exec");
                providers.add(provider);
            }
            catch (Throwable t) {
                Log.debug("Unable to load EXEC support: ", t);
                exception.addSuppressed(t);
            }
        }
        List<String> order = Arrays.asList(System.getProperty(PROP_PROVIDERS, PROP_PROVIDERS_DEFAULT).split(","));
        providers.sort(Comparator.comparing(l -> {
            int idx = order.indexOf(l);
            return idx >= 0 ? idx : Integer.MAX_VALUE;
        }));
        Terminal terminal = null;
        if (this.system != null && this.system.booleanValue() || this.system == null && this.in == null && this.out == null) {
            String str;
            if (this.system != null && (this.in != null && !this.in.equals(System.in) || this.out != null && !this.out.equals(System.out) && !this.out.equals(System.err))) {
                throw new IllegalArgumentException("Cannot create a system terminal using non System streams");
            }
            if (this.attributes != null || this.size != null) {
                Log.warn("Attributes and size fields are ignored when creating a system terminal");
            }
            if (this.out != null) {
                if (this.out.equals(System.out)) {
                    this.systemOutput = SystemOutput.SysOut;
                } else if (this.out.equals(System.err)) {
                    this.systemOutput = SystemOutput.SysErr;
                }
            }
            if (this.systemOutput == null && (str = System.getProperty(PROP_OUTPUT)) != null) {
                switch (str.trim().toLowerCase(Locale.ROOT)) {
                    case "out": {
                        this.systemOutput = SystemOutput.SysOut;
                        break;
                    }
                    case "err": {
                        this.systemOutput = SystemOutput.SysErr;
                        break;
                    }
                    case "out-err": {
                        this.systemOutput = SystemOutput.SysOutOrSysErr;
                        break;
                    }
                    case "err-out": {
                        this.systemOutput = SystemOutput.SysErrOrSysOut;
                        break;
                    }
                    default: {
                        Log.debug("Unsupported value for org.jline.terminal.output: " + str + ". Supported values are: " + String.join((CharSequence)", ", PROP_OUTPUT_OUT, PROP_OUTPUT_ERR, PROP_OUTPUT_OUT_ERR, PROP_OUTPUT_ERR_OUT) + ".");
                    }
                }
            }
            if (this.systemOutput == null) {
                this.systemOutput = SystemOutput.SysOutOrSysErr;
            }
            Map<TerminalProvider.Stream, Boolean> system = Stream.of(TerminalProvider.Stream.values()).collect(Collectors.toMap(stream -> stream, stream -> providers.stream().anyMatch(p -> p.isSystemStream((TerminalProvider.Stream)((Object)stream)))));
            TerminalProvider.Stream console = this.select(system, this.systemOutput);
            if (system.get((Object)TerminalProvider.Stream.Input).booleanValue() && console != null) {
                if (this.attributes != null || this.size != null) {
                    Log.warn("Attributes and size fields are ignored when creating a system terminal");
                }
                boolean ansiPassThrough = OSUtils.IS_CONEMU;
                if ((OSUtils.IS_CYGWIN || OSUtils.IS_MSYSTEM) && "xterm".equals(type) && this.type == null && System.getProperty(PROP_TYPE) == null) {
                    type = "xterm-256color";
                }
                for (TerminalProvider provider2 : providers) {
                    if (terminal != null) continue;
                    try {
                        terminal = provider2.sysTerminal(name, type, ansiPassThrough, encoding, this.nativeSignals, this.signalHandler, this.paused, console);
                    }
                    catch (Throwable t) {
                        Log.debug("Error creating " + provider2.name() + " based terminal: ", t.getMessage(), t);
                        exception.addSuppressed(t);
                    }
                }
                if (!(terminal != null || !OSUtils.IS_WINDOWS || jna.booleanValue() || jansi.booleanValue() || dumb != null && dumb.booleanValue())) {
                    throw new IllegalStateException("Unable to create a system terminal. On windows, either JNA or JANSI library is required.  Make sure to add one of those in the classpath.");
                }
            }
            if (terminal instanceof AbstractTerminal) {
                AbstractTerminal t = (AbstractTerminal)terminal;
                if (SYSTEM_TERMINAL.compareAndSet(null, t)) {
                    t.setOnClose(() -> SYSTEM_TERMINAL.compareAndSet(t, null));
                } else {
                    exception.addSuppressed(new IllegalStateException("A system terminal is already running. Make sure to use the created system Terminal on the LineReaderBuilder if you're using one or that previously created system Terminals have been correctly closed."));
                    terminal.close();
                    terminal = null;
                }
            }
            if (terminal == null && (dumb == null || dumb.booleanValue())) {
                Boolean color = this.color;
                if (color == null) {
                    color = TerminalBuilder.getBoolean(PROP_DUMB_COLOR, null);
                }
                if (dumb == null) {
                    String emacs;
                    if (color == null && (emacs = System.getenv("INSIDE_EMACS")) != null && emacs.contains("comint")) {
                        color = true;
                    }
                    if (color == null) {
                        String ideHome = System.getenv("IDE_HOME");
                        if (ideHome != null) {
                            color = true;
                        } else {
                            String command2 = TerminalBuilder.getParentProcessCommand();
                            if (command2 != null && command2.endsWith("/idea")) {
                                color = true;
                            }
                        }
                    }
                    if (color == null) {
                        color = console != null && System.getenv("TERM") != null;
                    }
                    if (Log.isDebugEnabled()) {
                        Log.warn("input is tty: {}", system.get((Object)TerminalProvider.Stream.Input));
                        Log.warn("output is tty: {}", system.get((Object)TerminalProvider.Stream.Output));
                        Log.warn("error is tty: {}", system.get((Object)TerminalProvider.Stream.Error));
                        Log.warn("Creating a dumb terminal", exception);
                    } else {
                        Log.warn("Unable to create a system terminal, creating a dumb terminal (enable debug logging for more information)");
                    }
                } else if (color == null) {
                    color = false;
                }
                terminal = new DumbTerminal(name, color != false ? "dumb-color" : "dumb", new FileInputStream(FileDescriptor.in), new FileOutputStream(console == TerminalProvider.Stream.Output ? FileDescriptor.out : FileDescriptor.err), encoding, this.signalHandler);
            }
        } else {
            for (TerminalProvider provider3 : providers) {
                if (terminal != null) continue;
                try {
                    terminal = provider3.newTerminal(name, type, this.in, this.out, encoding, this.signalHandler, this.paused, this.attributes, this.size);
                }
                catch (Throwable t) {
                    Log.debug("Error creating " + provider3.name() + " based terminal: ", t.getMessage(), t);
                    exception.addSuppressed(t);
                }
            }
        }
        if (terminal == null) {
            throw exception;
        }
        return terminal;
    }

    private TerminalProvider.Stream select(Map<TerminalProvider.Stream, Boolean> system, SystemOutput systemOutput) {
        switch (systemOutput) {
            case SysOut: {
                return TerminalBuilder.select(system, TerminalProvider.Stream.Output);
            }
            case SysErr: {
                return TerminalBuilder.select(system, TerminalProvider.Stream.Error);
            }
            case SysOutOrSysErr: {
                return TerminalBuilder.select(system, TerminalProvider.Stream.Output, TerminalProvider.Stream.Error);
            }
            case SysErrOrSysOut: {
                return TerminalBuilder.select(system, TerminalProvider.Stream.Error, TerminalProvider.Stream.Output);
            }
        }
        return null;
    }

    private static TerminalProvider.Stream select(Map<TerminalProvider.Stream, Boolean> system, TerminalProvider.Stream ... streams) {
        for (TerminalProvider.Stream s : streams) {
            if (!system.get((Object)s).booleanValue()) continue;
            return s;
        }
        return null;
    }

    private static String getParentProcessCommand() {
        try {
            Class<?> phClass = Class.forName("java.lang.ProcessHandle");
            Object current = phClass.getMethod("current", new Class[0]).invoke(null, new Object[0]);
            Object parent = ((Optional)phClass.getMethod("parent", new Class[0]).invoke(current, new Object[0])).orElse(null);
            Method infoMethod = phClass.getMethod("info", new Class[0]);
            Object info = infoMethod.invoke(parent, new Object[0]);
            Object command2 = ((Optional)infoMethod.getReturnType().getMethod("command", new Class[0]).invoke(info, new Object[0])).orElse(null);
            return command2;
        }
        catch (Throwable t) {
            return null;
        }
    }

    private static Boolean getBoolean(String name, Boolean def) {
        try {
            String str = System.getProperty(name);
            if (str != null) {
                return Boolean.parseBoolean(str);
            }
        }
        catch (IllegalArgumentException | NullPointerException runtimeException) {
            // empty catch block
        }
        return def;
    }

    private static <S> S load(Class<S> clazz) {
        return ServiceLoader.load(clazz, clazz.getClassLoader()).iterator().next();
    }

    private static Charset getCodepageCharset(int codepage) {
        if (codepage == 65001) {
            return StandardCharsets.UTF_8;
        }
        String charsetMS = "ms" + codepage;
        if (Charset.isSupported(charsetMS)) {
            return Charset.forName(charsetMS);
        }
        String charsetCP = "cp" + codepage;
        if (Charset.isSupported(charsetCP)) {
            return Charset.forName(charsetCP);
        }
        return Charset.defaultCharset();
    }

    @Deprecated
    public static void setTerminalOverride(Terminal terminal) {
        TERMINAL_OVERRIDE.set(terminal);
    }

    public static enum SystemOutput {
        SysOut,
        SysErr,
        SysOutOrSysErr,
        SysErrOrSysOut;

    }
}

