/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.qodana.ui.settings;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.options.BoundConfigurable;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.SearchableConfigurable;
import com.intellij.openapi.options.ShowSettingsUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogPanel;
import com.intellij.openapi.util.Disposer;
import com.intellij.ui.dsl.builder.Align;
import com.intellij.ui.dsl.builder.BuilderKt;
import com.intellij.ui.dsl.builder.Panel;
import com.intellij.ui.dsl.builder.Row;
import javax.swing.JComponent;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.qodana.QodanaBundle;
import org.jetbrains.qodana.ui.settings.QodanaCloudSettingsPanel;
import org.jetbrains.qodana.ui.settings.QodanaCloudSettingsView;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\u0018\u0000 \u00132\u00020\u00012\u00020\u00022\u00020\u0003:\u0001\u0013B\r\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\u000b\u001a\u00020\fH\u0016J\b\u0010\r\u001a\u00020\u000eH\u0016J\b\u0010\u000f\u001a\u00020\u0010H\u0016J\b\u0010\u0011\u001a\u00020\u0012H\u0016R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u000e\u0010\t\u001a\u00020\nX\u0082.\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lorg/jetbrains/qodana/ui/settings/QodanaCloudSettingsPanel;", "Lcom/intellij/openapi/options/BoundConfigurable;", "Lcom/intellij/openapi/options/SearchableConfigurable;", "Lcom/intellij/openapi/options/Configurable$NoScroll;", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "getProject", "()Lcom/intellij/openapi/project/Project;", "view", "Lorg/jetbrains/qodana/ui/settings/QodanaCloudSettingsView;", "apply", "", "createPanel", "Lcom/intellij/openapi/ui/DialogPanel;", "getId", "", "isModified", "", "Companion", "intellij.qodana"})
@SourceDebugExtension(value={"SMAP\nQodanaCloudSettingsPanel.kt\nKotlin\n*S Kotlin\n*F\n+ 1 QodanaCloudSettingsPanel.kt\norg/jetbrains/qodana/ui/settings/QodanaCloudSettingsPanel\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,63:1\n8#2:64\n*S KotlinDebug\n*F\n+ 1 QodanaCloudSettingsPanel.kt\norg/jetbrains/qodana/ui/settings/QodanaCloudSettingsPanel\n*L\n37#1:64\n*E\n"})
public final class QodanaCloudSettingsPanel
extends BoundConfigurable
implements SearchableConfigurable,
Configurable.NoScroll {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    private QodanaCloudSettingsView view;

    public QodanaCloudSettingsPanel(@NotNull Project project2) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        String string = QodanaBundle.message("configurable.name", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        super(string, null);
        this.project = project2;
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    public boolean isModified() {
        QodanaCloudSettingsView qodanaCloudSettingsView = this.view;
        if (qodanaCloudSettingsView == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"view");
            qodanaCloudSettingsView = null;
        }
        return qodanaCloudSettingsView.getViewModel().getAreSettingsModified();
    }

    public void apply() {
        QodanaCloudSettingsView qodanaCloudSettingsView = this.view;
        if (qodanaCloudSettingsView == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"view");
            qodanaCloudSettingsView = null;
        }
        qodanaCloudSettingsView.getViewModel().finish();
    }

    @NotNull
    public String getId() {
        return "settings.qodana";
    }

    @NotNull
    public DialogPanel createPanel() {
        Disposable myDisposable = this.getDisposable();
        if (myDisposable == null) {
            QodanaCloudSettingsPanel $this$thisLogger$iv = this;
            boolean $i$f$thisLogger = false;
            Logger logger2 = Logger.getInstance(QodanaCloudSettingsPanel.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger2, (String)"getInstance(...)");
            logger2.error("Can't create Qodana Settings Panel: disposable is `null`");
            return BuilderKt.panel((Function1)createPanel.1.INSTANCE);
        }
        this.view = new QodanaCloudSettingsView(this.project);
        QodanaCloudSettingsView qodanaCloudSettingsView = this.view;
        if (qodanaCloudSettingsView == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"view");
            qodanaCloudSettingsView = null;
        }
        Disposer.register((Disposable)myDisposable, (Disposable)qodanaCloudSettingsView);
        return BuilderKt.panel((Function1)((Function1)new Function1<Panel, Unit>(this){
            final /* synthetic */ QodanaCloudSettingsPanel this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            public final void invoke(@NotNull Panel $this$panel) {
                Intrinsics.checkNotNullParameter((Object)$this$panel, (String)"$this$panel");
                Panel.row$default((Panel)$this$panel, null, (Function1)((Function1)new Function1<Row, Unit>(this.this$0){
                    final /* synthetic */ QodanaCloudSettingsPanel this$0;
                    {
                        this.this$0 = $receiver;
                        super(1);
                    }

                    public final void invoke(@NotNull Row $this$row) {
                        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
                        QodanaCloudSettingsView qodanaCloudSettingsView = QodanaCloudSettingsPanel.access$getView$p(this.this$0);
                        if (qodanaCloudSettingsView == null) {
                            Intrinsics.throwUninitializedPropertyAccessException((String)"view");
                            qodanaCloudSettingsView = null;
                        }
                        $this$row.cell((JComponent)qodanaCloudSettingsView.getView()).align(Align.FILL);
                    }
                }), (int)1, null).resizableRow();
            }
        }));
    }

    public static final /* synthetic */ QodanaCloudSettingsView access$getView$p(QodanaCloudSettingsPanel $this) {
        return $this.view;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u00a8\u0006\u0007"}, d2={"Lorg/jetbrains/qodana/ui/settings/QodanaCloudSettingsPanel$Companion;", "", "()V", "openSettings", "", "project", "Lcom/intellij/openapi/project/Project;", "intellij.qodana"})
    public static final class Companion {
        private Companion() {
        }

        public final void openSettings(@Nullable Project project2) {
            ShowSettingsUtil.getInstance().showSettingsDialog(project2, QodanaCloudSettingsPanel.class);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

