/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.qodana.ui.problemsView.tree.ui;

import com.intellij.ide.projectView.PresentationData;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.pom.Navigatable;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.tree.LeafState;
import com.intellij.util.IconUtil;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.qodana.QodanaBundle;
import org.jetbrains.qodana.stats.QodanaPluginStatsCounterCollector;
import org.jetbrains.qodana.stats.QodanaPluginStatsCounterCollectorKt;
import org.jetbrains.qodana.ui.problemsView.tree.model.QodanaTreeFileNode;
import org.jetbrains.qodana.ui.problemsView.tree.model.QodanaTreeNode;
import org.jetbrains.qodana.ui.problemsView.tree.ui.PresentationKt;
import org.jetbrains.qodana.ui.problemsView.tree.ui.QodanaUiTreeNode;
import org.jetbrains.qodana.ui.problemsView.tree.ui.QodanaUiTreeNodeBase;
import org.jetbrains.qodana.ui.problemsView.tree.ui.QodanaUiTreeNodeBaseKt;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001B\u001d\u0012\u000e\u0010\u0004\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0007J\n\u0010\f\u001a\u0004\u0018\u00010\u0002H\u0016J \u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0002H\u0016J\u000e\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00160\u0015H\u0016J\b\u0010\u0017\u001a\u00020\u0018H\u0016J\b\u0010\u0019\u001a\u00020\u001aH\u0016J\n\u0010\u001b\u001a\u0004\u0018\u00010\u001cH\u0016J\n\u0010\u001d\u001a\u0004\u0018\u00010\u001eH\u0016R\u0016\u0010\b\u001a\u0004\u0018\u00010\t8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u001f"}, d2={"Lorg/jetbrains/qodana/ui/problemsView/tree/ui/QodanaUiTreeFileNode;", "Lorg/jetbrains/qodana/ui/problemsView/tree/ui/QodanaUiTreeNodeBase;", "Lorg/jetbrains/qodana/ui/problemsView/tree/model/QodanaTreeFileNode;", "Lorg/jetbrains/qodana/ui/problemsView/tree/model/QodanaTreeFileNode$PrimaryData;", "parent", "Lorg/jetbrains/qodana/ui/problemsView/tree/ui/QodanaUiTreeNode;", "primaryData", "(Lorg/jetbrains/qodana/ui/problemsView/tree/ui/QodanaUiTreeNode;Lorg/jetbrains/qodana/ui/problemsView/tree/model/QodanaTreeFileNode$PrimaryData;)V", "descriptor", "Lcom/intellij/openapi/fileEditor/OpenFileDescriptor;", "getDescriptor", "()Lcom/intellij/openapi/fileEditor/OpenFileDescriptor;", "computeModelTreeNode", "doUpdate", "", "project", "Lcom/intellij/openapi/project/Project;", "presentation", "Lcom/intellij/ide/projectView/PresentationData;", "modelTreeNode", "getExcludeActionsDescriptors", "", "Lorg/jetbrains/qodana/ui/problemsView/tree/ui/QodanaUiTreeNode$ExcludeActionDescriptor;", "getLeafState", "Lcom/intellij/ui/tree/LeafState;", "getName", "", "getNavigatable", "Lcom/intellij/pom/Navigatable;", "getVirtualFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "intellij.qodana"})
@SourceDebugExtension(value={"SMAP\nQodanaUiTreeFileNode.kt\nKotlin\n*S Kotlin\n*F\n+ 1 QodanaUiTreeFileNode.kt\norg/jetbrains/qodana/ui/problemsView/tree/ui/QodanaUiTreeFileNode\n+ 2 QodanaUiTreeNodeBase.kt\norg/jetbrains/qodana/ui/problemsView/tree/ui/QodanaUiTreeNodeBase\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,95:1\n45#2:96\n1#3:97\n*S KotlinDebug\n*F\n+ 1 QodanaUiTreeFileNode.kt\norg/jetbrains/qodana/ui/problemsView/tree/ui/QodanaUiTreeFileNode\n*L\n56#1:96\n*E\n"})
public final class QodanaUiTreeFileNode
extends QodanaUiTreeNodeBase<QodanaTreeFileNode, QodanaTreeFileNode.PrimaryData> {
    public QodanaUiTreeFileNode(@NotNull QodanaUiTreeNode<?, ?> parent, @NotNull QodanaTreeFileNode.PrimaryData primaryData) {
        Intrinsics.checkNotNullParameter(parent, (String)"parent");
        Intrinsics.checkNotNullParameter((Object)primaryData, (String)"primaryData");
        super(parent, (QodanaTreeNode.PrimaryData)primaryData);
    }

    @Nullable
    public OpenFileDescriptor getDescriptor() {
        Project project2 = this.getProject();
        if (project2 == null) {
            return null;
        }
        Project project3 = project2;
        QodanaTreeFileNode qodanaTreeFileNode = (QodanaTreeFileNode)this.getModelTreeNode();
        if (qodanaTreeFileNode == null) {
            return null;
        }
        QodanaTreeFileNode modelTreeNode = qodanaTreeFileNode;
        return new OpenFileDescriptor(project3, modelTreeNode.getVirtualFile());
    }

    @Nullable
    public Navigatable getNavigatable() {
        Project project2 = this.getProject();
        if (project2 == null) {
            return null;
        }
        Project project3 = project2;
        QodanaTreeFileNode qodanaTreeFileNode = (QodanaTreeFileNode)this.getModelTreeNode();
        if (qodanaTreeFileNode == null) {
            return null;
        }
        QodanaTreeFileNode modelTreeNode = qodanaTreeFileNode;
        Navigatable navigatable2 = super.getNavigatable();
        if (navigatable2 == null) {
            return null;
        }
        Navigatable nodeNavigatable = navigatable2;
        return new Navigatable(nodeNavigatable, project3, modelTreeNode){
            private final /* synthetic */ Navigatable $$delegate_0;
            final /* synthetic */ Navigatable $nodeNavigatable;
            final /* synthetic */ Project $project;
            final /* synthetic */ QodanaTreeFileNode $modelTreeNode;
            {
                this.$nodeNavigatable = $nodeNavigatable;
                this.$project = $project;
                this.$modelTreeNode = $modelTreeNode;
                this.$$delegate_0 = $nodeNavigatable;
            }

            public void navigate(boolean requestFocus) {
                QodanaPluginStatsCounterCollector.PROBLEM_NAVIGATED.log(this.$project, (Object)((Object)QodanaPluginStatsCounterCollectorKt.toSelectedNodeType(this.$modelTreeNode)), (Object)this.$modelTreeNode.getProblemsCount());
                this.$nodeNavigatable.navigate(requestFocus);
            }

            public boolean canNavigateToSource() {
                return this.$nodeNavigatable.canNavigateToSource();
            }

            public boolean canNavigate() {
                return this.$nodeNavigatable.canNavigate();
            }
        };
    }

    @Override
    @Nullable
    public QodanaTreeFileNode computeModelTreeNode() {
        QodanaUiTreeNodeBase this_$iv = this;
        boolean $i$f$computeModelTreeNodeThroughParent = false;
        return (QodanaTreeFileNode)QodanaUiTreeNodeBase.access$computeModelTreeNodeThroughParentViaClazz(this_$iv, QodanaTreeFileNode.class);
    }

    @Override
    @NotNull
    public List<QodanaUiTreeNode.ExcludeActionDescriptor> getExcludeActionsDescriptors() {
        Path file = ((QodanaTreeFileNode.PrimaryData)this.getPrimaryData()).getFile();
        return QodanaUiTreeNodeBaseKt.excludeActionsDescriptorsForPathNode(this, file, (Function0<String>)((Function0)new Function0<String>(file){
            final /* synthetic */ Path $file;
            {
                this.$file = $file;
                super(0);
            }

            @NotNull
            public final String invoke() {
                Object[] objectArray = new Object[]{this.$file.getFileName()};
                String string = QodanaBundle.message("action.Qodana.ProblemTree.ExcludeFile.text", objectArray);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
                return string;
            }
        }), (Function1<? super String, String>)((Function1)new Function1<String, String>(file){
            final /* synthetic */ Path $file;
            {
                this.$file = $file;
                super(1);
            }

            @NotNull
            public final String invoke(@NotNull String inspectionId) {
                Intrinsics.checkNotNullParameter((Object)inspectionId, (String)"inspectionId");
                Object[] objectArray = new Object[]{inspectionId, this.$file.getFileName()};
                String string = QodanaBundle.message("action.Qodana.ProblemTree.ExcludeFileForInspection.text", objectArray);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
                return string;
            }
        }));
    }

    @Nullable
    public VirtualFile getVirtualFile() {
        QodanaTreeFileNode qodanaTreeFileNode = (QodanaTreeFileNode)this.getModelTreeNode();
        return qodanaTreeFileNode != null ? qodanaTreeFileNode.getVirtualFile() : null;
    }

    @Override
    public void doUpdate(@NotNull Project project2, @NotNull PresentationData presentation, @NotNull QodanaTreeFileNode modelTreeNode) {
        Path pathFromParentNodePathToDirectory;
        Path path;
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        Intrinsics.checkNotNullParameter((Object)presentation, (String)"presentation");
        Intrinsics.checkNotNullParameter((Object)modelTreeNode, (String)"modelTreeNode");
        VirtualFile virtualFile2 = modelTreeNode.getVirtualFile();
        presentation.setIcon(IconUtil.getIcon((VirtualFile)virtualFile2, (int)0, (Project)project2));
        if (modelTreeNode.getExcluded()) {
            presentation.addText(virtualFile2.getPresentableName(), SimpleTextAttributes.EXCLUDED_ATTRIBUTES);
            String string = QodanaBundle.message("qodana.TreeNode.excluded", new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
            SimpleTextAttributes simpleTextAttributes = SimpleTextAttributes.GRAYED_BOLD_ATTRIBUTES;
            Intrinsics.checkNotNullExpressionValue((Object)simpleTextAttributes, (String)"GRAYED_BOLD_ATTRIBUTES");
            PresentationKt.appendText(presentation, string, simpleTextAttributes);
            return;
        }
        presentation.addText(virtualFile2.getPresentableName(), SimpleTextAttributes.REGULAR_ATTRIBUTES);
        Path parentDirectoryPath = ((QodanaTreeFileNode.PrimaryData)this.getPrimaryData()).getFile().getParent();
        Path parentNodePath = ((QodanaTreeFileNode.PrimaryData)this.getPrimaryData()).getParentPath();
        Path path2 = parentDirectoryPath;
        if (path2 != null) {
            Path it = path2;
            boolean bl = false;
            v3 = parentNodePath.relativize(it);
        } else {
            v3 = path = null;
        }
        if (path == null) {
            Path path3 = Paths.get("", new String[0]);
            v5 = path3;
            Intrinsics.checkNotNullExpressionValue((Object)path3, (String)"get(...)");
        } else {
            v5 = pathFromParentNodePathToDirectory = path;
        }
        if (pathFromParentNodePathToDirectory.getNameCount() != 0) {
            PresentationKt.appendGrayedText(presentation, ((Object)pathFromParentNodePathToDirectory).toString());
        }
        PresentationKt.appendProblemsCount(presentation, modelTreeNode.getProblemsCount());
    }

    @NotNull
    public String getName() {
        return ((QodanaTreeFileNode.PrimaryData)this.getPrimaryData()).toString();
    }

    @NotNull
    public LeafState getLeafState() {
        return LeafState.NEVER;
    }
}

