/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.qodana.staticAnalysis.inspections.targets;

import com.intellij.codeInspection.ex.Tools;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.PathMacroManager;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.qodana.staticAnalysis.inspections.targets.SingleScopeTestTarget;
import org.jetbrains.qodana.staticAnalysis.inspections.targets.TestTarget;
import org.jetbrains.qodana.staticAnalysis.scopes.QodanaAnalysisScope;

@Service(value={Service.Level.PROJECT})
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0007\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J*\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\u0012\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u00100\u000e2\u0006\u0010\u0002\u001a\u00020\u0003H\u0002J*\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\u0012\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u00100\u000e2\u0006\u0010\u0002\u001a\u00020\u0003H\u0002J \u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\u0012\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u00100\u000eR\u0013\u0010\u0005\u001a\u00070\u0006\u00a2\u0006\u0002\b\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006\u0013"}, d2={"Lorg/jetbrains/qodana/staticAnalysis/inspections/targets/QodanaTargetsService;", "", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "macroManager", "Lcom/intellij/openapi/components/PathMacroManager;", "Lorg/jetbrains/annotations/NotNull;", "getProject", "()Lcom/intellij/openapi/project/Project;", "createEachInspectionTargets", "", "Lorg/jetbrains/qodana/staticAnalysis/inspections/targets/TestTarget;", "tools", "", "", "Lcom/intellij/codeInspection/ex/Tools;", "createModuleInspectionTargets", "getTestTargets", "intellij.qodana"})
@SourceDebugExtension(value={"SMAP\nQodanaTargetsService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 QodanaTargetsService.kt\norg/jetbrains/qodana/staticAnalysis/inspections/targets/QodanaTargetsService\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,38:1\n11065#2:39\n11400#2,3:40\n*S KotlinDebug\n*F\n+ 1 QodanaTargetsService.kt\norg/jetbrains/qodana/staticAnalysis/inspections/targets/QodanaTargetsService\n*L\n33#1:39\n33#1:40,3\n*E\n"})
public final class QodanaTargetsService {
    @NotNull
    private final Project project;
    @NotNull
    private final PathMacroManager macroManager;

    public QodanaTargetsService(@NotNull Project project2) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        this.project = project2;
        PathMacroManager pathMacroManager = PathMacroManager.getInstance((ComponentManager)((ComponentManager)this.project));
        Intrinsics.checkNotNullExpressionValue((Object)pathMacroManager, (String)"getInstance(...)");
        this.macroManager = pathMacroManager;
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    @NotNull
    public final List<TestTarget> getTestTargets(@NotNull Map<String, ? extends Tools> tools) {
        Intrinsics.checkNotNullParameter(tools, (String)"tools");
        return CollectionsKt.plus((Collection)this.createEachInspectionTargets(tools, this.project), (Iterable)this.createModuleInspectionTargets(tools, this.project));
    }

    private final List<TestTarget> createEachInspectionTargets(Map<String, ? extends Tools> tools, Project project2) {
        if (!Boolean.getBoolean("qodana.report.inspection.test")) {
            return CollectionsKt.emptyList();
        }
        Integer threshold = Integer.getInteger("qodana.report.inspection.test.threshold", 100);
        List list2 = CollectionsKt.toList((Iterable)tools.keySet());
        Intrinsics.checkNotNull((Object)threshold);
        return CollectionsKt.listOf((Object)new SingleScopeTestTarget("InspectionTest", list2, threshold, new QodanaAnalysisScope(project2), this.macroManager));
    }

    /*
     * WARNING - void declaration
     */
    private final List<TestTarget> createModuleInspectionTargets(Map<String, ? extends Tools> tools, Project project2) {
        void $this$mapTo$iv$iv;
        Module[] modules;
        if (!Boolean.getBoolean("qodana.report.module.inspection.test")) {
            return CollectionsKt.emptyList();
        }
        Integer threshold = Integer.getInteger("qodana.report.inspection.test.threshold", 100);
        Module[] $this$map$iv = modules = ModuleManager.Companion.getInstance(project2).getModules();
        boolean $i$f$map = false;
        Module[] moduleArray = $this$map$iv;
        Collection destination$iv$iv = new ArrayList($this$map$iv.length);
        boolean $i$f$mapTo = false;
        int n = ((void)$this$mapTo$iv$iv).length;
        for (int i = 0; i < n; ++i) {
            void module2;
            void item$iv$iv;
            void var13_13 = item$iv$iv = $this$mapTo$iv$iv[i];
            Collection collection = destination$iv$iv;
            boolean bl = false;
            String string = "ModuleInspectionTest[" + module2.getName() + "]";
            List list2 = CollectionsKt.toList((Iterable)tools.keySet());
            Intrinsics.checkNotNull((Object)threshold);
            collection.add(new SingleScopeTestTarget(string, list2, threshold, new QodanaAnalysisScope((Module)module2), this.macroManager));
        }
        return (List)destination$iv$iv;
    }
}

