/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.qodana.staticAnalysis.inspections.runner;

import com.intellij.codeHighlighting.HighlightDisplayLevel;
import com.intellij.codeInspection.ex.ToolsImpl;
import com.intellij.openapi.project.Project;
import java.nio.file.Path;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.qodana.QodanaBundle;
import org.jetbrains.qodana.staticAnalysis.inspections.config.InspectScope;
import org.jetbrains.qodana.staticAnalysis.inspections.runner.QodanaScopeModifier;
import org.jetbrains.qodana.staticAnalysis.profile.QodanaInspectionProfile;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J \u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016\u00a8\u0006\r"}, d2={"Lorg/jetbrains/qodana/staticAnalysis/inspections/runner/ExcludeScopeModifier;", "Lorg/jetbrains/qodana/staticAnalysis/inspections/runner/QodanaScopeModifier;", "scope", "Lorg/jetbrains/qodana/staticAnalysis/inspections/config/InspectScope;", "(Lorg/jetbrains/qodana/staticAnalysis/inspections/config/InspectScope;)V", "updateProfileScopes", "", "profile", "Lorg/jetbrains/qodana/staticAnalysis/profile/QodanaInspectionProfile;", "project", "Lcom/intellij/openapi/project/Project;", "projectPath", "Ljava/nio/file/Path;", "intellij.qodana"})
public final class ExcludeScopeModifier
extends QodanaScopeModifier {
    public ExcludeScopeModifier(@NotNull InspectScope scope2) {
        Intrinsics.checkNotNullParameter((Object)scope2, (String)"scope");
        Object[] objectArray = new Object[]{scope2.getName()};
        String string = QodanaBundle.message("qodana.yaml.exclude.scope.name", objectArray);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        super(scope2, string);
    }

    @Override
    public void updateProfileScopes(@NotNull QodanaInspectionProfile profile2, @NotNull Project project2, @NotNull Path projectPath) {
        Intrinsics.checkNotNullParameter((Object)((Object)profile2), (String)"profile");
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        Intrinsics.checkNotNullParameter((Object)projectPath, (String)"projectPath");
        ToolsImpl toolsImpl = profile2.getToolsOrNull(this.getScope().getName(), project2);
        if (toolsImpl == null) {
            return;
        }
        ToolsImpl tools = toolsImpl;
        if (this.disableToolIfEmptyScopes(tools)) {
            return;
        }
        tools.prependTool(this.getProfileScope$intellij_qodana(projectPath), tools.getTool(), false, HighlightDisplayLevel.DO_NOT_SHOW);
    }
}

