/*
 * Decompiled with CFR 0.152.
 */
package com.carrotsearch.hppc;

import com.carrotsearch.hppc.AbstractIntCollection;
import com.carrotsearch.hppc.AbstractIterator;
import com.carrotsearch.hppc.AbstractShortCollection;
import com.carrotsearch.hppc.IntContainer;
import com.carrotsearch.hppc.ShortCollection;
import com.carrotsearch.hppc.ShortContainer;
import com.carrotsearch.hppc.ShortIntAssociativeContainer;
import com.carrotsearch.hppc.ShortIntHashMap;
import com.carrotsearch.hppc.ShortIntMap;
import com.carrotsearch.hppc.ShortLookupContainer;
import com.carrotsearch.hppc.comparators.ShortComparator;
import com.carrotsearch.hppc.comparators.ShortIntComparator;
import com.carrotsearch.hppc.cursors.IntCursor;
import com.carrotsearch.hppc.cursors.ShortCursor;
import com.carrotsearch.hppc.cursors.ShortIntCursor;
import com.carrotsearch.hppc.predicates.IntPredicate;
import com.carrotsearch.hppc.predicates.ShortIntPredicate;
import com.carrotsearch.hppc.predicates.ShortPredicate;
import com.carrotsearch.hppc.procedures.IntProcedure;
import com.carrotsearch.hppc.procedures.ShortIntProcedure;
import com.carrotsearch.hppc.procedures.ShortProcedure;
import com.carrotsearch.hppc.sorting.QuickSort;
import java.util.Iterator;
import java.util.function.IntBinaryOperator;

public class SortedIterationShortIntHashMap
implements ShortIntMap {
    public final ShortIntHashMap delegate;
    public final int[] iterationOrder;

    public SortedIterationShortIntHashMap(ShortIntHashMap delegate, ShortComparator comparator) {
        this.delegate = delegate;
        this.iterationOrder = this.sortIterationOrder(this.createEntryIndexes(), comparator);
    }

    public SortedIterationShortIntHashMap(ShortIntHashMap delegate, ShortIntComparator comparator) {
        this.delegate = delegate;
        this.iterationOrder = this.sortIterationOrder(this.createEntryIndexes(), comparator);
    }

    private int[] createEntryIndexes() {
        short[] keys = this.delegate.keys;
        int size = this.delegate.size();
        int[] entryIndexes = new int[size];
        int entry2 = 0;
        if (this.delegate.hasEmptyKey) {
            entryIndexes[entry2++] = this.delegate.mask + 1;
        }
        int keyIndex = 0;
        while (entry2 < size) {
            if (keys[keyIndex] != 0) {
                entryIndexes[entry2++] = keyIndex;
            }
            ++keyIndex;
        }
        return entryIndexes;
    }

    protected int[] sortIterationOrder(int[] entryIndexes, ShortComparator comparator) {
        QuickSort.sort(entryIndexes, (i, j) -> {
            short[] keys = this.delegate.keys;
            return comparator.compare(keys[entryIndexes[i]], keys[entryIndexes[j]]);
        });
        return entryIndexes;
    }

    protected int[] sortIterationOrder(final int[] entryIndexes, final ShortIntComparator comparator) {
        QuickSort.sort(entryIndexes, new IntBinaryOperator(){
            final short[] keys;
            final int[] values;
            {
                this.keys = SortedIterationShortIntHashMap.this.delegate.keys;
                this.values = SortedIterationShortIntHashMap.this.delegate.values;
            }

            @Override
            public int applyAsInt(int i, int j) {
                int index1 = entryIndexes[i];
                int index2 = entryIndexes[j];
                return comparator.compare(this.keys[index1], this.values[index1], this.keys[index2], this.values[index2]);
            }
        });
        return entryIndexes;
    }

    @Override
    public Iterator<ShortIntCursor> iterator() {
        assert (this.checkUnmodified());
        return new EntryIterator();
    }

    @Override
    public boolean containsKey(short key2) {
        return this.delegate.containsKey(key2);
    }

    @Override
    public int size() {
        assert (this.checkUnmodified());
        return this.delegate.size();
    }

    @Override
    public boolean isEmpty() {
        return this.delegate.isEmpty();
    }

    @Override
    public int removeAll(ShortContainer container) {
        throw SortedIterationShortIntHashMap.readOnlyException();
    }

    @Override
    public int removeAll(ShortPredicate predicate) {
        throw SortedIterationShortIntHashMap.readOnlyException();
    }

    @Override
    public int removeAll(ShortIntPredicate predicate) {
        throw SortedIterationShortIntHashMap.readOnlyException();
    }

    @Override
    public <T extends ShortIntProcedure> T forEach(T procedure) {
        assert (this.checkUnmodified());
        int[] iterationOrder = this.iterationOrder;
        short[] keys = this.delegate.keys;
        int[] values = this.delegate.values;
        int size = this.size();
        for (int i = 0; i < size; ++i) {
            int slot = iterationOrder[i];
            procedure.apply(keys[slot], values[slot]);
        }
        return procedure;
    }

    @Override
    public <T extends ShortIntPredicate> T forEach(T predicate) {
        int slot;
        assert (this.checkUnmodified());
        int[] iterationOrder = this.iterationOrder;
        short[] keys = this.delegate.keys;
        int[] values = this.delegate.values;
        int size = this.size();
        for (int i = 0; i < size && predicate.apply(keys[slot = iterationOrder[i]], values[slot]); ++i) {
        }
        return predicate;
    }

    @Override
    public ShortCollection keys() {
        assert (this.checkUnmodified());
        return new KeysContainer();
    }

    @Override
    public IntContainer values() {
        assert (this.checkUnmodified());
        return new ValuesContainer();
    }

    @Override
    public int get(short key2) {
        return this.delegate.get(key2);
    }

    @Override
    public int getOrDefault(short key2, int defaultValue) {
        return this.delegate.getOrDefault(key2, defaultValue);
    }

    @Override
    public int put(short key2, int value) {
        throw SortedIterationShortIntHashMap.readOnlyException();
    }

    @Override
    public int putAll(ShortIntAssociativeContainer container) {
        throw SortedIterationShortIntHashMap.readOnlyException();
    }

    @Override
    public int putAll(Iterable<? extends ShortIntCursor> iterable) {
        throw SortedIterationShortIntHashMap.readOnlyException();
    }

    @Override
    public int putOrAdd(short key2, int putValue, int incrementValue) {
        throw SortedIterationShortIntHashMap.readOnlyException();
    }

    @Override
    public int addTo(short key2, int additionValue) {
        throw SortedIterationShortIntHashMap.readOnlyException();
    }

    @Override
    public int remove(short key2) {
        throw SortedIterationShortIntHashMap.readOnlyException();
    }

    @Override
    public int indexOf(short key2) {
        return this.delegate.indexOf(key2);
    }

    @Override
    public boolean indexExists(int index) {
        return this.delegate.indexExists(index);
    }

    @Override
    public int indexGet(int index) {
        return this.delegate.indexGet(index);
    }

    @Override
    public int indexReplace(int index, int newValue) {
        throw SortedIterationShortIntHashMap.readOnlyException();
    }

    @Override
    public void indexInsert(int index, short key2, int value) {
        throw SortedIterationShortIntHashMap.readOnlyException();
    }

    @Override
    public int indexRemove(int index) {
        throw SortedIterationShortIntHashMap.readOnlyException();
    }

    @Override
    public void clear() {
        throw SortedIterationShortIntHashMap.readOnlyException();
    }

    @Override
    public void release() {
        throw SortedIterationShortIntHashMap.readOnlyException();
    }

    @Override
    public String visualizeKeyDistribution(int characters) {
        return this.delegate.visualizeKeyDistribution(characters);
    }

    private static RuntimeException readOnlyException() {
        throw new UnsupportedOperationException("Read-only view cannot be modified");
    }

    private boolean checkUnmodified() {
        assert (this.delegate.size() == this.iterationOrder.length) : "The delegate map changed; this is not supported by this read-only view";
        return true;
    }

    private final class EntryIterator
    extends AbstractIterator<ShortIntCursor> {
        private final ShortIntCursor cursor = new ShortIntCursor();
        private int index;

        private EntryIterator() {
        }

        @Override
        protected ShortIntCursor fetch() {
            if (this.index < SortedIterationShortIntHashMap.this.iterationOrder.length) {
                int slot;
                this.cursor.index = slot = SortedIterationShortIntHashMap.this.iterationOrder[this.index++];
                this.cursor.key = SortedIterationShortIntHashMap.this.delegate.keys[slot];
                this.cursor.value = SortedIterationShortIntHashMap.this.delegate.values[slot];
                return this.cursor;
            }
            return (ShortIntCursor)this.done();
        }
    }

    private final class KeysContainer
    extends AbstractShortCollection
    implements ShortLookupContainer {
        private final SortedIterationShortIntHashMap owner;

        private KeysContainer() {
            this.owner = SortedIterationShortIntHashMap.this;
        }

        @Override
        public boolean contains(short e) {
            return this.owner.containsKey(e);
        }

        @Override
        public <T extends ShortProcedure> T forEach(T procedure) {
            this.owner.forEach((k, v) -> procedure.apply(k));
            return procedure;
        }

        @Override
        public <T extends ShortPredicate> T forEach(T predicate) {
            this.owner.forEach((key2, value) -> predicate.apply(key2));
            return predicate;
        }

        @Override
        public boolean isEmpty() {
            return this.owner.isEmpty();
        }

        @Override
        public Iterator<ShortCursor> iterator() {
            return new KeysIterator();
        }

        @Override
        public int size() {
            return this.owner.size();
        }

        @Override
        public void clear() {
            throw SortedIterationShortIntHashMap.readOnlyException();
        }

        @Override
        public void release() {
            throw SortedIterationShortIntHashMap.readOnlyException();
        }

        @Override
        public int removeAll(ShortPredicate predicate) {
            throw SortedIterationShortIntHashMap.readOnlyException();
        }

        @Override
        public int removeAll(short e) {
            throw SortedIterationShortIntHashMap.readOnlyException();
        }
    }

    private final class ValuesContainer
    extends AbstractIntCollection {
        private final SortedIterationShortIntHashMap owner;

        private ValuesContainer() {
            this.owner = SortedIterationShortIntHashMap.this;
        }

        @Override
        public int size() {
            return this.owner.size();
        }

        @Override
        public boolean isEmpty() {
            return this.owner.isEmpty();
        }

        @Override
        public boolean contains(int value) {
            for (ShortIntCursor c : this.owner) {
                if (value != c.value) continue;
                return true;
            }
            return false;
        }

        @Override
        public <T extends IntProcedure> T forEach(T procedure) {
            this.owner.forEach((k, v) -> procedure.apply(v));
            return procedure;
        }

        @Override
        public <T extends IntPredicate> T forEach(T predicate) {
            this.owner.forEach((k, v) -> predicate.apply(v));
            return predicate;
        }

        @Override
        public Iterator<IntCursor> iterator() {
            return new ValuesIterator();
        }

        @Override
        public int removeAll(int e) {
            throw SortedIterationShortIntHashMap.readOnlyException();
        }

        @Override
        public int removeAll(IntPredicate predicate) {
            throw SortedIterationShortIntHashMap.readOnlyException();
        }

        @Override
        public void clear() {
            throw SortedIterationShortIntHashMap.readOnlyException();
        }

        @Override
        public void release() {
            throw SortedIterationShortIntHashMap.readOnlyException();
        }
    }

    private final class ValuesIterator
    extends AbstractIterator<IntCursor> {
        private final IntCursor cursor = new IntCursor();
        private int index;

        private ValuesIterator() {
        }

        @Override
        protected IntCursor fetch() {
            if (this.index < SortedIterationShortIntHashMap.this.iterationOrder.length) {
                int slot;
                this.cursor.index = slot = SortedIterationShortIntHashMap.this.iterationOrder[this.index++];
                this.cursor.value = SortedIterationShortIntHashMap.this.delegate.values[slot];
                return this.cursor;
            }
            return (IntCursor)this.done();
        }
    }

    private final class KeysIterator
    extends AbstractIterator<ShortCursor> {
        private final ShortCursor cursor = new ShortCursor();
        private int index;

        private KeysIterator() {
        }

        @Override
        protected ShortCursor fetch() {
            if (this.index < SortedIterationShortIntHashMap.this.iterationOrder.length) {
                int slot;
                this.cursor.index = slot = SortedIterationShortIntHashMap.this.iterationOrder[this.index++];
                this.cursor.value = SortedIterationShortIntHashMap.this.delegate.keys[slot];
                return this.cursor;
            }
            return (ShortCursor)this.done();
        }
    }
}

